//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Dining set definition type 0.1a010219a include file
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
// table
coordinate_color(330, 0.3, 0.1, 1, 1)
#local Bl=12; 
#local Table_leg =
union {
 box { 0, < 2, Bl, 1 > translate < 8-1, 0, -0.5 > }
 box { 0, < 2, Bl, 1 > translate <-8-1, 0, -0.5 > }
 box { < -8-1, Bl, -0.5 >, < 8+1, Bl+2, 0.5 > }
 box { 0, < 2, 1, 1 > translate < 5-1, Bl+2, -0.5 > } cylinder { < 5, Bl+3, 0 >,< 5, Bl+4, 0 >, 1.5 }
 box { 0, < 2, 1, 1 > translate <-5-1, Bl+2, -0.5 > } cylinder { <-5, Bl+3, 0 >,<-5, Bl+4, 0 >, 1.5 }
 pigment { color < R1, G1, B1 > }
}
//
#local Table_bar = box { < -1, Bl+1, -15 >, < 1, Bl+2, 15 > pigment { color < R1, G1, B1 > } }
//
coordinate_color( 360, 0, 1, 1, 2)
#local Table_board = superellipsoid { < 0.24, 0.24 >
 pigment { color rgbt < R2, G2, B2, 0.5 > }
 scale < 12, 0.5, 22 >
 translate (Bl+4)*y
}
//
#declare Table_seg =
union {
 object { Table_board }
 object { Table_bar }
 object { Table_leg translate -15*z }
 object { Table_leg translate  15*z }
}
//**********************************************************************************
// chair
#local Bl=10;
#local Chair_seat =
union {
 superellipsoid { < 0.24, 0.24 > scale < 6, 1, 6 > rotate -5*z translate < 1, Bl, 0 > } // seat 
 superellipsoid { < 0.24, 0.24 > scale < 0.9, 9-3.7, 6 > rotate -10*z translate < 5+1.7, Bl+3.7, 0 > } // back
 pigment { color < R1, G1, B1 > }
}
//
coordinate_color( 360, 0, 1, 1, 3)
#local T_Chair =
texture {
 pigment { color < R3, G3, B3 > }
 finish { metallic reflection 0.5 brilliance 8 phong 0.75 phong_size 80 }
}
//
#include "Curved_line.mcr.inc"
//
#local Pmax=1+2*4; #local Vp=array[Pmax]
//
#local Vp[0]=<  7.4, Bl+4, -6 >; #local Vp[1]=<  4.4, Bl+5, -6 >;
#local Vp[2]=< -0.6, Bl+5, -6 >; #local Vp[3]=< -4.4, Bl+5, -6 >;
#local Vp[4]=< -4.0, Bl+2, -6 >; #local Vp[5]=< -4.4+2/3, Bl, -6 >;
#local Vp[6]=< -1.6, 0, -6 >;    #local Vp[7]=<  4.4, 1, -6 >;
#local Vp[8]=<  7.4, 0, -6 >;
// contact line (Lw:line width E1:E2:De=pow(E1,2)-4*E2)
#local Chair_arm =
union { Contact_line(0.4, 4, 8)
 sphere { <Vp[0].x,0,Vp[0].y>,0.4 } sphere { <Vp[6].x,0,Vp[6].y>,0.4 } sphere { <Vp[8].x,0,Vp[8].y>,0.4 }
 texture { T_Chair }
}
#local Chair_plate = superellipsoid { <0.2,0.2> texture { T_Chair } scale <1,0.1,6.2> rotate -4*z translate <5,0.5,0> }
//
#declare Chair_seg =
union {
 object { Chair_seat }
 object { Chair_arm rotate -90*x translate -6*z }
 object { Chair_arm rotate -90*x translate  6*z }
 object { Chair_plate }
}
//**********************************************************************************
// sofa
coordinate_color(330, 0.3, 0.1, 1, 1)
#local Leg_seg = cone { 0,1,< 0 ,1, 0 >,1.5 pigment { color rgb < R1, G1, B1 > } }
//----------------------------------------------------------------------------------
coordinate_color(330, 0, 1, 1, 1)
#local P_sofa = pigment { color rgb < R1, G1, B1 > }
#declare Sofa_seg =
union {
 superellipsoid { < 0.24, 0.24 > scale < 10,  2, 7 > translate <-10, 10, 0 > } // cushion
 superellipsoid { < 0.24, 0.24 > scale < 10,  2, 7 > translate < 10, 10, 0 > } // cushion
 superellipsoid { < 0.24, 0.24 > scale < 20, 10, 2 > translate <  0, 11, 8 > } // back
 superellipsoid { < 0.24, 0.24 > scale <  2,  8, 9 > translate <-20,  9, 1 > } // side
 superellipsoid { < 0.24, 0.24 > scale <  2,  8, 9 > translate < 20,  9, 1 > } // side
 superellipsoid { < 0.24, 0.24 > scale < 20,  4, 7 > translate <  0,  5, 0 > } // leg
 object { Leg_seg translate <-20, 0, -5 > }
 object { Leg_seg translate <-20, 0,  6 > }
 object { Leg_seg translate < 20, 0, -5 > }
 object { Leg_seg translate < 20, 0,  6 > }
 pigment { P_sofa }
}
//**********************************************************************************
// stool
#local Lp=5;
#declare Stool_seg =
union {
 superellipsoid { < 0.24, 0.24 > scale < 8, 2, 8 > translate < 0, 10, 0 > }
 superellipsoid { < 0.24, 0.24 > scale < 8, 4, 8 > translate < 0,  5, 0 > }
 object { Leg_seg translate <-Lp, 0, -Lp > }
 object { Leg_seg translate <-Lp, 0,  Lp > }
 object { Leg_seg translate < Lp, 0, -Lp > }
 object { Leg_seg translate < Lp, 0,  Lp > }
 pigment { P_sofa }
}
//**********************************************************************************
/*
union {
 object { Table_seg }
 object { Chair_seg translate < 20, 0, 8 > }
 object { Chair_seg translate < 20, 0,-8 > }
 object { Chair_seg translate < 20, 0,-8 > rotate 180*y }
 object { Chair_seg translate < 20, 0, 8 > rotate 180*y }
 rotate 30*y translate -13*y
}
//
object { Sofa_seg rotate 30*y translate < 15, -13, 80 > }
object { Stool_seg rotate -10*y translate < 0, -13, 50 > }
*/
//**********************************************************************************
// text dollhouse
#local Lw=2; #local Pmax=1+6; #local Vp=array[Pmax]
//
#declare Text_doll =
union {
// d
 union {
 #local Pmax=1+4;
 #local Vp[0]=<0,110>; #local Vp[1]=<6,60>; #local Vp[2]=<30,0>; #local Vp[3]=<2,140>; #local Vp[4]=<-5,0.3>;
 union { Curvature_line(Lw,2) translate 22*x }
 #local Vp[0]=<0,30>; #local Vp[1]=<4,60>; #local Vp[2]=<10,100>; #local Vp[3]=<7,80>; #local Vp[4]=<5,60>;
 union { Curvature_line(Lw,2) translate <15,0,-20> }
 }
// o
 #local Vp[0]=<0,0>; #local Vp[1]=<6,170>; #local Vp[2]=<6,0>; #local Vp[3]=<6,180>; #local Vp[4]=<7.2,0>;
 union { Curvature_line(Lw,0) translate <34,0,-24> }
// l
 #local Vp[0]=<0,60>; #local Vp[1]=<4,-70>; #local Vp[2]=<30,0>; #local Vp[3]=<2,140>; #local Vp[4]=<-5,0.3>;
 union { Curvature_line(Lw,2) translate 40.8*x }
// l
 #local Vp[0]=<0,60>; #local Vp[1]=<4,-70>; #local Vp[2]=<30,0>; #local Vp[3]=<2,140>; #local Vp[4]=<-5,0.3>;
 union { Curvature_line(Lw,2) translate 50.6*x }
}
//
#declare Text_house =
union {
// h
 union {
 #local Pmax=1+4;
 #local Vp[0]=<0,60>; #local Vp[1]=<4,-70>; #local Vp[2]=<30,0>; #local Vp[3]=<6,-20>; #local Vp[4]=<0,0>;
 union { Curvature_line(Lw,2) translate 4*x }
 #local Vp[0]=<0,160>; #local Vp[1]=<5,-168>; #local Vp[2]=<10,0>; #local Vp[3]=<2,140>; #local Vp[4]=<-5,0.3>;
 union { Curvature_line(Lw,2) translate <3,0,-21> }
 }
// o
 #local Vp[0]=<0,0>; #local Vp[1]=<6,170>; #local Vp[2]=<6,0>; #local Vp[3]=<6,180>; #local Vp[4]=<7.2,0>;
 union { Curvature_line(Lw,0) translate <33,0,-24> }
// u
union {
 #local Vp[0]=<0,120>; #local Vp[1]=<2,-130>; #local Vp[2]=<8,0>; #local Vp[3]=<5,180>; #local Vp[4]=<10,0>;
 union { Curvature_line(Lw,2) translate <35.5,0,-20> }
 #local Vp[0]=<0,180>; #local Vp[1]=<1,140>; #local Vp[2]=<-5,0.3>; #local Vp[3]=<0,0>; #local Vp[4]=<0,0>;
 union { Curvature_line(Lw,2) translate <46.5,0,-34> }
}
// s
 #local Vp[0]=<0,10>; #local Vp[1]=<4,230>; #local Vp[2]=<2,0>; #local Vp[3]=<4.4,-225>; #local Vp[4]=<0,0>;
 union { Curvature_line(Lw,2) translate <63,0,-22.5> }
// e
 #local Pmax=1+6;
 #local Vp[0]=<0,270>; #local Vp[1]=<8,0>; #local Vp[2]=<1,80>; #local Vp[3]=<1.2,0>;
 #local Vp[4]=<5,182>; #local Vp[5]=<6,0>; #local Vp[6]=<5.5,150>;
 union { Curvature_line(Lw,2) translate <67,0,-27.5> }
}
//**********************************************************************************
//object { Text_doll pigment { color rgb 1 } rotate <-20,30,0> translate <20,-35,800> }
//object { Text_house pigment { color rgb 1 } rotate <-20,30,0> translate <40,-35,600> }
//**********************************************************************************




