
#include "colors.inc"
#include "woods.inc"    
#include "functions.inc"      

/* Chris Becker aka Topher (c) 2002 */

camera {
 location <40,12.5,0> 
 look_at <0,12.5,0>

}   

#declare FullQuality=1;
#declare FullLights=1; 
#declare AreaLights=1;
//#declare Radiosity=1;  
//#declare LightShadows=1;
#declare Carpet=1;
#declare Painting=1;   

global_settings {      
#ifdef (Radiosity)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35

      nearest_count 5
      error_bound 1.8
      recursion_limit 3

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2
    }    
    #end
  }
  

#declare i=-3;
#while (i<=3)

 light_source {<15,20,-11*i>   White   
 #ifdef (AreaLights)    
 //#if (i=-1 | i=1)       
 area_light <5, 0, 0>, <0, 0, 5>, 10, 10     
  adaptive 1
    jitter  
    circular         
 //#end // if
 #end // fullquality
    }
    sphere { <15,20,-11*i>,.5 pigment {White*100} no_shadow}   
    
    
    // wire
    cylinder {<15,20,-11*i>,<15,50,-11*i>,.05 pigment {Gray30} no_shadow}
  #declare S1=seed(100);
#ifdef (FullLights)
    torus { 1,.1 translate <15,20.3,-11*i> pigment {Gold} finish{reflection .5} }
 #declare j=0; 
 #while (j<5)
  sphere_sweep{b_spline 5 <2,0>,.1,<1,0>,.1,<.5,.5>,.1,<0,8>,.1,<0,9>,.1 rotate<0,j/5*360,0> translate <15,20.3,-11*i>  pigment {Gold} finish{reflection .5}} 
  #declare j=j+1;
 #end // while j
 #declare j=0;
 #while (j<20)
 

  #declare j=j+1;
 #end     
  
 #end // full quality
 #declare i=i+2;
#end

plane { <0,1,0>,0 pigment{Brown}}      

plane { <1,0,0>,0 pigment{Brown}}

#ifdef (FullQuality)
    
#declare S1=seed(1);
union {
#declare i=-5;
#while (i<5)
 #declare j=-15;
 #while (j<15)
   superellipsoid{ <.02,.02> translate <2*i+.1+abs(mod(j,2)),-.9,2*j> texture {T_Wood4 rotate<0,90,0> translate <rand(S1)*3,0,rand(S1)*3> scale <1,1./3,1/.3>} finish{reflection .15}}
  #declare j=j+1;
 #end // while j
 #declare i=i+1;
#end // while i
scale <3,1,1>
rotate <0,45,0> 

}  



// trim
//cylinder {<0,0,-100>,<0,0,100>,.2   texture {T_Wood4 translate <0,0,500>}}
//cylinder {<0,.2,-100>,<0,.2,100>,.1 texture {T_Wood4}}   



// wall
#declare S1=seed(2);
#declare i=-13;
#while (i<=13)
 superellipsoid{ <.02,.02> scale <1,1,13.87> translate <-.9+rand(S1)/20,i*2.1,-13> texture{T_Wood4 }  
 normal{      
     bozo 5.0
    turbulence <0.03, 0.03, 0.1>
    octaves 5
    lambda 3.25         
    scale <0.025, .025, 1.0>
    } 
    rotate<90,0,0> 
    finish {phong .2}  
    }
 #declare i=i+1;
#end // while i

// ceiling

#declare i=-1;
#while (i<3) 
 #declare j=-5;
 #while (j<5)
  union { 
difference{
 box{<1,.9,1>,<-1,0,-1>  }
 prism { linear_spline conic_sweep 1,.7,4 <1,1>,<-1,1>,<-1,-1>,<1,-1> }
  
} 
blob {
threshold .05
cylinder {<1,.9,1>,<-1,.9,1>,.1 1}
cylinder {<1,.9,1>,<1,.9,-1>,.1 1}
cylinder {<-1,.9,-1>,<-1,.9,1>,.1 1}
cylinder {<-1,.9,-1>,<1,.9,-1>,.1 1}     
}

blob {
threshold .05
cylinder {<.7,.7,.7>,<-.7,.7,.7>,.1 1}
cylinder {<.7,.7,.7>,<.7,.7,-.7>,.1 1}
cylinder {<-.7,.7,-.7>,<-.7,.7,.7>,.1 1}
cylinder {<-.7,.7,-.7>,<.7,.7,-.7>,.1 1} 
}

blob {
threshold .05
cylinder {<.5,.7,.5>,<-.5,.7,.5>,.03 1}
cylinder {<.5,.7,.5>,<.5,.7,-.5>,.03 1}
cylinder {<-.5,.7,-.5>,<-.5,.7,.5>,.03 1}
cylinder {<-.5,.7,-.5>,<.5,.7,-.5>,.03 1}    
}

sphere {<1,.9,1>,.1}
sphere {<-1,.9,1>,.1}
sphere {<-1,.9,-1>,.1}
sphere {<1,.9,-1>,.1}    
   #declare Blob_threshold=0.01;

rotate <0,0,180> translate <6*i/3-.9,29.5/3,2*j>  scale 3 
 pigment {Gray60} normal {granite .2 scale 3} 
}
  #declare j=j+1;
 #end // while j
 #declare i=i+1;
#end // while i   


#else // full quality
plane { <0,1,0>,30 pigment {Gray70}}
#end  // full quality


#ifdef (FullQuality)
#declare Blob_threshold=0.01;   
#declare Pillar =
isosurface{ function { (1+Blob_threshold)
                        -Blob_threshold^f_helix1(x,y,z, 3, pi, .2, 1, 1, 1, 45)
                        -Blob_threshold^(x^2+z^2-.8*.8)-Blob_threshold^(f_torus(x,y-.3,z,1.1,.3))-Blob_threshold^(f_torus(x,y-25.7,z,1.1,.3)) }
  contained_by{box{<-1.6,0,-1.6>,<1.6,26,1.6>}} max_gradient 10 texture{T_Wood4}  translate<1,0,0> finish{phong .2}
    
    }  
    
    
// pillars    
object {Pillar scale <1,1,-1> translate <0,0,-22.5>}
object {Pillar translate <0,0,22.5>} 


#else
cylinder {<1,0,-22.5>,<1,30,-22.5>,.9 pigment {Brown}}    
cylinder {<1,0,22.5>,<1,30,22.5>.9 pigment {Brown}}
#end // full quality      


// painting 
#ifdef (Painting)
union {  

// painting
box {<-1,-1,-1,>,<1,1,1>   /*<.2,22.,15>,<-1,2.,-15>*/ pigment {image_map {jpeg  "Painting.jpg" transmit all .3} rotate<0,90,0> scale<1,2,-2> translate<0,1,1>} scale<.2,10,15> normal {granite .05 scale .1} finish {phong 0.25}}      

// frame board
union {                                        
 difference {
  box {<-1,-1,-1,>,<1,1,1> scale<.3,10*1.1,15*1.1> }      
  box {<-1,-1,-1,>,<1,1,1> scale<.4,10,15> }      
  }
 texture{T_Wood32}     
} 
translate<0,2.5+7.5*3/2,0>
} 

#declare Blob_threshold=0.01; 
// frame design   

// right 
isosurface { function{(1+Blob_threshold)

-Blob_threshold^f_helix1(x,y-3,z-(15*1.1+15)/2, 6, pi, .2, .5, 1, 1, 45) 
-Blob_threshold^f_sphere(x,y-2.5,z-(15*1.1+15)/2,1.2)
-Blob_threshold^f_sphere(x,y-20*1.075-3*1.1,z-(15*1.1+15)/2,1.2)
}  max_gradient 4 contained_by {box {<0,-1*10*1.1+2.5+7.5*3/2,1*13*1.1,>,<1.3,10*1.1+2.5+7.5*3/2,15*1.1> }} texture{T_Wood32}  finish{phong .5} }   
 
// left
isosurface { function{(1+Blob_threshold)

-Blob_threshold^f_helix1(x,y-3,z+(15*1.1+15)/2, 6, -pi, .2, .5, 1, 1, 45) 
-Blob_threshold^f_sphere(x,y-2.5,z+(15*1.1+15)/2,1.2)
-Blob_threshold^f_sphere(x,y-20*1.075-3*1.1,z+(15*1.1+15)/2,1.2)
}  max_gradient 4 contained_by {box {<0,-1*10*1.1+2.5+7.5*3/2,-1*13*1.1,>,<1.3,10*1.1+2.5+7.5*3/2,-15*1.1> }} texture{T_Wood32}  finish{phong .5} }   

// bottom 1 
isosurface{ function{(1+Blob_threshold)-Blob_threshold^f_helix1(x,z-(15*1.1+15)/2,y-2.8, 6, pi, .2, .5, 1, 1, 45)
-Blob_threshold^f_sphere(x,y-2.5,z+(15*1.1+15)/2,1.2)
-Blob_threshold^f_sphere(x,y-2.5,z,1.)
} contained_by {box {<0,-1*10*1.1+2.5+7.5*3/2,1*14*1.1,>,<1.3,-9*1.1+2.5+7.5*3/2,-14*1.1> }} max_gradient 4 texture{T_Wood32}  finish{phong .5}}


// bottom 2 
isosurface{ function{(1+Blob_threshold)-Blob_threshold^f_helix1(x,z-(15*1.1+15)/2,y-2.8, 6, -pi, .2, .5, 1, 1, 45)
-Blob_threshold^f_sphere(x,y-2.5,z,1.)
-Blob_threshold^f_sphere(x,y-2.5,z-(15*1.1+15)/2,1.2)
} contained_by {box {<0,-1*10*1.1+2.5+7.5*3/2,1*14*1.1,>,<1.3,-9*1.1+2.5+7.5*3/2,-14*1.1> }} max_gradient 4 texture{T_Wood32}  finish{phong .5}}
  
                    
// top 1
isosurface{ function{(1+Blob_threshold)-Blob_threshold^f_helix1(x,z-(15*1.1+15)/2,y-3*1.1-20*1.075, 6, pi, .2, .5, 1, 1, 45)
-Blob_threshold^f_sphere(x,y-20*1.075-3*1.1,z+(15*1.1+15)/2,1.2)
-Blob_threshold^f_sphere(x,y-20*1.075-3*1.1,z,1.)
} contained_by {box {<0,1*10*1.1+2.5+7.5*3/2,1*14*1.1,>,<1.3,9*1.1+2.5+7.5*3/2,-14*1.1> }} max_gradient 4 texture{T_Wood32}  finish{phong .5}}

// top 2
isosurface{ function{(1+Blob_threshold)-Blob_threshold^f_helix1(x,z-(15*1.1+15)/2,y-3*1.1-20*1.075, 6, -pi, .2, .5, 1, 1, 45)
-Blob_threshold^f_sphere(x,y-20*1.075-3*1.1,z,1.)
-Blob_threshold^f_sphere(x,y-20*1.075-3*1.1,z-(15*1.1+15)/2,1.2)
} contained_by {box {<0,1*10*1.1+2.5+7.5*3/2,1*14*1.1,>,<1.3,9*1.1+2.5+7.5*3/2,-14*1.1> }} max_gradient 4 texture{T_Wood32}  finish{phong .5}}

#else
box {<-1,-1,-1,>,<1,1,1>   pigment {Gray} scale<.2,10,15> translate<0,2.5+7.5*3/2,0> }      
#end 

#ifdef (Carpet) 

// center carpet
union {  
 #declare S1=seed(10593);
 #declare OBJECT=sphere{<0,0,0>,1};
 #include "Carpet1Output.pov"      
 translate <-80,0,-60> // put it right at the origin
 scale <1/160*10,1/20,1/120*20>
 translate <9,.1,0>
} 

// right carpet
union {  
 #declare S1=seed(10594);
 #declare OBJECT=sphere{<0,0,0>,1};
 #include "Carpet2Output.pov"      
 translate <-80,0,-60> // put it right at the origin
 scale <1/160*10,1/20,1/120*20>
 translate <9.2,.1,22>
} 

// left carpet
union {  
 #declare S1=seed(10594);
 #declare OBJECT=sphere{<0,0,0>,1};
 #include "Carpet3Output.pov"      
 translate <-80,0,-60> // put it right at the origin
 scale <1/160*10,1/20,1/120*20>
 translate <9.2,.1,-22>
}  


#end    

// This is kind of a wierd symbol I made for the caption but it didn't really fit in my opinion... 
 /*
difference{
superellipsoid {<1,.01> pigment{Gold} finish{reflection .3} scale <.1,.5,-1.5>*2 translate<-.07,1.3,0> normal{agate 1 scale <1,1,4>/5 rotate<-45,0,0> }}
text {
    ttf "Arial.ttf" "P I P" 1, 0
    pigment { Gold }
    scale 2 
    rotate<0,-90,0>
    translate<.6,1.1,-3.7>/2   
    finish{reflection .3 phong .5}   
    normal{agate .3}    

} 

text {
    ttf "Arial.ttf" "P" 1, 0
    pigment { Gold }
    scale 5.3 
    rotate<0,-90,0>      
    rotate<45,0,0>
    translate<.6,0.70,-3.7>/2   
    finish{reflection .3 phong .5}   
    normal{agate .3}    

}   

  
text {
    ttf "Arial.ttf" "P" 2, 0
    pigment { Gold }
    scale 2.5 
    
    rotate<0,-90,0>      
    rotate<-45,0,0> 
    scale 5*x
    translate<.6,.2,1.0>   
    finish{reflection .3 phong .5}   
    normal{agate .3}    
        
}

text {
    ttf "Arial.ttf" "P" 2, 0
    pigment { Gold }
    scale 1.25
    
    rotate<0,-90,0>      
    rotate<-135,0,0> 
    scale 5*x
    translate<.6,1.8,1>   
    finish{reflection .3 phong .5}   
    normal{agate .3}    
        
}
translate<.3,0,0>
}
*/
//superellipsoid {<.01,.01> pigment{Gray20} finish{reflection .3 phong .5} scale <.1,.7,5>*2 translate<-.07,1.3,0> normal{agate .3}} 

// water
blob{ threshold .65
sphere{<.2,1,9>,.2 1 pigment{White transmit .9} }
sphere{<.2,1.1,9>,.1 1 pigment{Clear transmit .9}}
interior{ior 1.3}
}

blob{ threshold .65
sphere{<.2,0,9/4>,.4 1 pigment{White transmit .95} }
sphere{<.2,0,9.1/4>,.4 1 pigment{White transmit .95}} 
sphere{<.2,.1,8.9/4>,.4 1 pigment{White transmit .95}}
sphere{<.2,0,9.2/4>,.4 1 pigment{White transmit .95}} 
sphere{<.2,0,8.8/4>,.4 1 pigment{White transmit .95}}
sphere{<.2,.1,9.4/4>,.42 1 pigment{White transmit .95}} 
sphere{<.2,0,8.7/4>,.43 1 pigment{White transmit .95}}
sphere{<.3,0,9.1/4>,.4 1 pigment{White transmit .95}}
sphere{<.5,0,9.05/4>,.3 1 pigment{White transmit .95}}   
sphere{<.6,0,9.00/4>,.2 1 pigment{White transmit .95}}
scale<2,1,4>
interior{ior 1.3}
}
  



