#include "colors.inc"        
#include "woods.inc"  
#include "functions.inc"

/* Chris Becker aka Topher (c) 2002 */         

camera {
 location <40,10,0> 
 look_at <0,10,0>

} 

//#declare Radiosity=1;
#declare AreaLights=1;  
#declare Painting=1;
      
light_source{<5,15,30> Gray15 
#ifdef(AreaLights)  

area_light <15, 0, 0>, <0, 0, 15>, 15, 15     
  adaptive 1
    jitter 
    
    #end 
     
    }
    
light_source{<10,7,0> Gray60 spotlight point_at<0,10,0> radius 40 tightness 1  falloff 50 shadowless }

light_source{<10,5,-18> White*1.2



#ifdef(AreaLights)  

area_light <3, 0, 0>, <0, 0, 3>, 15, 15     
  adaptive 1
    jitter 
    
    #end 
     
    }
  
global_settings {        
#ifdef(Radiosity)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35

      nearest_count 5
      error_bound 1.8
      recursion_limit 3

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2
    }   
    #end
  }
#declare f_Agate = function{pigment{ agate color_map{[0 rgb 0][1 rgb 1]} scale <1,5,1>/20 rotate<45,0,0>}}  
// painting  

#ifdef (Painting)
union {
box {<-1,-1,-1,>,<1,1,1>   /*<.2,22.,15>,<-1,2.,-15>*/pigment {image_map {jpeg  "Painting2.jpg"} rotate<0,90,0> scale<1,2,2> translate<0,1,1>}  translate<3,1,0> scale<.2,10,15> }      

 
clipped_by {
isosurface { function{ f_rounded_box(x,y,z,.1,.45,.85,.45)-f_Agate(x*3,y*3,z*3).gray/8} max_gradient 4 translate<.1,1,0> scale<3,10,25>}
}
no_shadow
} 
//box {<-1,-1,-1>,<1,1,1>   /*<.2,22.,15>,<-1,2.,-15>*/ pigment {rgb 1 transmit 1}  interior {ior 20.} normal {agate 100.0 scale <1,5,1>/10 rotate<45,0,0> translate <100,0,100>} translate<.1,1,0> scale<1,10,15>  no_shadow}      
            
// box behind painting
box {<-1,-1,-1,>,<1,1,1>   /*<.2,22.,15>,<-1,2.,-15>*/ pigment {White} translate<2.99,1,0> scale<.2,10,15> normal{agate .02 scale .1}}      
#end
  

// beam 
box {<100,25,-3>,<.01,30,3> pigment {Gray} normal{granite .05}}

// back wall
plane { <0,1,0>,27 pigment{Gray} normal{granite .05}} 

difference {
// wall on right
box {<.01,30,20>,<100,.01,200> pigment {Gray70} normal{agate 0.1 scale <.5,8,.5>}} 
merge {
box {<3,15.5,19>,<8,.01,50> pigment {Gray70} normal{agate 0.1 scale <.5,8,.5>}}
cylinder {<5.5,15.5,19>,<5.5,17.5,50>,2.5 pigment {Gray70} normal{agate 0.1 scale <.5,8,.5>}}
box {<3,21,19>,<8,25,50> pigment {Gray70} normal{agate 0.1 scale <.5,8,.5>}}  
}
}

// vent over archway
difference {        
superellipsoid{ <.1,.1> scale <3.1,2.1,1> translate <5.5,23.,20.9> pigment{White}  }
box {<3.1,21.3,10>,<7.9,24.7,50> pigment {White} }
}

#declare i=0;
#while (i<10)
 box {<3.,21.+(i/10)*4,20>,<8,21.+(i/10)*4+1/20*4,50> pigment {White} }     
 #declare i=i+1;
#end

     
// back wall
plane { <1,0,0>,0 pigment{Gray70} normal{granite .05} } 

// concrete floor
#declare S1=seed(1);
union {
#declare i=-5;
#while (i<5)
 #declare j=-15;
 #while (j<15)
   superellipsoid{ <.02,.02> translate <2*i,-.9,2*j> pigment{agate color_map{[0 White][1 Gray80]} scale 2 translate<rand(S1)*100,0,rand(S1)*100>} normal {agate .05 scale .1}}
  #declare j=j+1;
 #end // while j
 #declare i=i+1;
#end // while i
scale <10,5,10>


} 

#declare M_Wood7A = 
color_map { 
    [0.0, 0.1 color rgb <0.42, 0.42, 0.42>
              color rgb <0.42, 0.42, 0.42>]
    [0.1, 0.9 color rgb <0.42, 0.42, 0.42>
              color rgb <0.65, 0.65, 0.65>]
    [0.9, 1.0 color rgb <0.65, 0.65, 0.65>
              color rgb <0.42, 0.42, 0.42>]
}
#declare M_Wood7B = 
color_map { 
    [0.0, 0.1 color rgbt <0.65, 0.65, 0.65, 0.00>
              color rgbt <0.65, 0.65, 0.65, 0.30>]
    [0.1, 1.0 color rgbt <0.65, 0.65, 0.65, 0.30>
              color rgbt <1.00, 1.00, 1.00, 1.00> ] 
}
#declare T_Wood7   =         
    texture { pigment { P_WoodGrain7A  color_map { M_Wood7A }}} 
    texture { pigment { P_WoodGrain7B  color_map { M_Wood7B }}}
// studs
union {
#declare i=-15;
#while (i<15)
   box{<0,0,2.6*i>,<.5,30,2.6*i+.2> }
   box{<0,27,2.6*i>,<100,25.1,2.6*i+.2> }
   
   // nail
   cylinder {<.25,1,2.6*i+1.3>,<.25,0,2.6*i+1.3>,.05 pigment {Gray20}}
 #declare i=i+1;
#end // while j     
texture{T_Wood7 rotate<90,0,0>}
}

box{<0,0,-30>,<.6,.9,30> texture{T_Wood7}}
box{<0,27,-30>,<.6,26.1,30> texture{T_Wood7}}
box{<0,27,3.4>,<.6,24.5,2.5> texture{T_Wood7 translate <0,0,30>}}
box{<0,25,2.5>,<.6,24.5,-2.5> texture{T_Wood7 translate <0,0,10>}} 
box{<0,24.5,-2.5>,<.6,27,-3.4> texture{T_Wood7 translate <0,0,20>}} 
//box{<0,29.99,-30>,<0,,30> texture{T_Wood7}}                      

// carpet on right   

superellipsoid{ <.3,.3> scale <3,1,5> translate<5.5,-.2,24> pigment{Gray85} normal{agate 1.0 scale .01}}

// lamp
blob {    threshold .65
sphere {<0,.1,0>,.3 1 pigment {White*10} } 
cylinder {<0,.1,0>,<0,-.5,0>,.2 1 pigment {White*10}}   
no_shadow
translate<10,3,-18>
}          

union {
 lathe {cubic_spline 7 <0,.2>,<0,0>,<.5,-.1>,<.2,-2>,<0,-2>,<.4,-2>,<.6,-3> pigment{White}}
 cylinder {<0,0,0>,<0,.2,0>,.1 pigment {Gray} finish{reflection .15}}      
 translate<10,2.5,-18>
}

// wire
sphere_sweep {b_spline 12 <.2,5,-60>,.05,<.2,5.3,-30>,.04,<.2,5.,-20>,.04,<.2,5.1,-15>,.04,<.2,4.7,-10>,.04,
                        <.2,5,0>,.04,<.2,5.3,10>,.04,<.2,5.,15>,.04,<.2,5.3,20>,.04,<.2,4.7,25>,.04,<.2,5,50>,.04,<.2,5,60>,.04 pigment{Gray25}}

// outlet
difference { 
union {                    
 cylinder {<.5,5.,-20.5>,<0,5.,-20.5>,.05 }   
 cylinder {<.5,5.,-19.5>,<0,5.,-20.5>,.05 }
 cylinder {<.5,5.5,-20.>,<0,5.5,-20.>,.05 } 
 cylinder {<.5,4.5,-20.>,<0,4.5,-20.>,.05 }
 box {<0,5.5,-20.5>,<.5,4.5,-19.5> }
}
box {<.1,5.4,-20.4>,<1,4.6,-19.6> } 
pigment {rgb<.3,.3,.3>}
}

box {<.5,5.5,-20.2>,<0,4.5,-19.8> pigment {Gray}}
cylinder {<.6,5.2,-20>,<0,5.3,-20>,.15 pigment {White}} 
cylinder {<.6,4.8,-20>,<0,4.7,-20>,.15 pigment {White}}

cylinder {<.7,5.2,-20>,<0,5.3,-20>,.1 pigment {Gray}} 

// wire to lamp

sphere_sweep{ b_spline 7 <.6,5.2,-20>,.04,<1,5.2,-20>,.04,<.7,5.2,-20>,.04,<1,.6,-19>,.04,<7,.6,-15>,.04,<10,.6,-18>,.04,<13,.6,-18>,.04 pigment {Gray25}}

// pipe  
union {
 cylinder {<.3,25,-22.5>,<.3,0,-22.5>,.3 }
 cylinder {<.3,25,-22.5>,<1,25,-22.5>,.3 }
 sphere {<.3,25,-22.5>,.3 }
 cylinder {<1,25,-22.5>,<1,30,-22.5>,.3}
 sphere {<1,25,-22.5>,.3 }    
 pigment {White}
} 

// copper pipe in cieling

cylinder {<5,27,-60>,<5,27,60>,.15 pigment{Gray40} finish{reflection .1}}       

//chalk sticks 

cylinder {<3,.5,12>,<3,.5,12.5>,.1 pigment{Blue}}
cylinder {<0,0,-.25>,<0,0,.25>,.1 pigment{Green} rotate<0,-32,0> translate<3.8,.5,13> }
cylinder {<0,0,-.25>,<0,0,.25>,.1 pigment{Red} rotate<0,67,0> translate<3.5,.5,12> }
cylinder {<0,0,-.25>,<0,0,.25>,.1 pigment{Yellow} rotate<0,12,0> translate<3.0,.5,14> } 
cylinder {<0,0,-.25>,<0,0,.25>,.1 pigment{Orange} rotate<0,-12,0> translate<2.8,.5,14.5> }


// yellow
#declare sun = pigment{granite color_map{[0 Yellow*3 transmit 1][.2 Yellow*3 transmit 0][1 Yellow*10.]} scale<100,1,1> warp{ turbulence .5 lambda 5}}  
#declare clear = pigment{rgbt 1}
cone {<0,2,0>,4,<30,2,0>,6 scale<1,.1,1> pigment{gradient y pigment_map{ [0 clear][.55 clear][1 sun]} warp{ turbulence .2 lambda 6  } scale<10,1,1>rotate<0,45,0> } translate<0,.15,0> no_shadow} 

// blue
#declare water = pigment{granite color_map{[0 Blue*3 transmit 1][.2 Blue*3 transmit 0][1 Blue*5.]} scale<100,1,1> warp{ turbulence .5 lambda 5}}  
cone {<0,2,0>,10,<30,2,0>,14 scale<1,.06,1> pigment{gradient y pigment_map{ [0 clear][.55 clear][1 water]} warp{ turbulence .2 lambda 6  } scale<10,1,1>rotate<0,45,0>} translate<0,-.1,0> no_shadow} 

// bridge
#declare woods = pigment{granite color_map{[0 Brown*3 transmit 1][.4 Brown*2 transmit 1][.5 Brown*3. transmit 0][1 Brown*3. transmit 0]} scale<100,1,1> warp{ turbulence .5 lambda 5}}  
#declare woodpig=pigment{gradient y pigment_map{ [0 clear][.55 clear][1 woods]} warp{ turbulence .2 lambda 6  } scale<100,1,1>rotate<0,45,0>} 
box{<-1,-1,-1>,<1,1,1> scale<2,1,1> translate<15,-.1,0> pigment{woodpig} no_shadow}
box{<-1,-1,-1>,<1,1,1> scale<2,1,1> translate<15,-.1,-3> pigment{woodpig} no_shadow}
box{<-1,-1,-1>,<1,1,1> scale<2,1,1> translate<15,-.1,3> pigment{woodpig} no_shadow} 
box{<-1,-1,-1>,<1,1,1> scale<2,1,1> translate<15,-.1,-6> pigment{woodpig} no_shadow}
box{<-1,-1,-1>,<1,1,1> scale<2,1,1> translate<15,-.1,6> pigment{woodpig} no_shadow}



difference{
union{
torus{4,.3 pigment{onion pigment_map{ [0 clear][.55 clear][1 Red]} warp{ turbulence .2 lambda 6  } scale<10,1,1> rotate<0,00,90>} rotate<90,0,0>}
torus{4,.3 pigment{onion pigment_map{ [0 clear][.55 clear][1 rgb<.5,0,.5>]} warp{ turbulence .2 lambda 6  } scale<10,1,1> rotate<0,00,90>} rotate<90,0,0> scale <.93,.93,1>}
torus{4,.3 pigment{onion pigment_map{ [0 clear][.55 clear][1 Blue]} warp{ turbulence .2 lambda 6  } scale<10,1,1> rotate<0,00,90>} rotate<90,0,0> scale <.86,.86,1>}
torus{4,.3 pigment{onion pigment_map{ [0 clear][.55 clear][1 Green]} warp{ turbulence .2 lambda 6  } scale<10,1,1> rotate<0,00,90>} rotate<90,0,0> scale <.8,.8,1>}
torus{4,.3 pigment{onion pigment_map{ [0 clear][.55 clear][1 Yellow]} warp{ turbulence .2 lambda 6  } scale<10,1,1> rotate<0,00,90>} rotate<90,0,0> scale <.73,.73,1>}
} 

box{<-5,-10,-5>,<5,0,5> pigment{Clear}}
 
translate<5.5,15.5,20.2> no_shadow
} 
