/* *****************************************
    Gilberto Ficara's IRTC Entry
    "World Construction Kit"
    28/02/2002
    
    (include file)
    
    **************************************** */

#include "metals.inc"
#include "woods.inc"
#include "stones.inc"
#include "colors.inc"
#include "glass.inc"
#include "functions.inc"
#include "transforms.inc"

#include "myTextures.inc" // textures required elsewhere

#include "bacheca.inc"
#include "mySassi.inc"
#include "vassoio.inc"

/*  Rocce  */

#include "transforms.inc"

#declare myBase = union {
    plane { y, 0 }
    object { myVassoio translate <0,0,0> }
}

#declare scatter_land = myBase;
#declare total_objects = 400;
#declare x_accuracy=15;   
#declare z_accuracy=15;
#declare file_name = "scatter_sassi.inc"
#declare RS = seed(7); 
#declare sa_x = seed(123);
#declare sa_y = seed(345);
#declare sa_z = seed(567);


#macro scatter_object_macro (N)
    #switch (N)
        #case (1)
            object { sasso01 texture { T_Stone44 } scale (0.6+(0.2*rand(sa_y))) }
        #break
        
        #case (2)
            object { sasso02 texture { T_Stone44 } scale (0.6+(0.2*rand(sa_y))) }
        #break

        #case (3)
            object { sasso03 texture { T_Stone44 } scale (0.6+(0.2*rand(sa_y))) }
        #break

        #case (4)
            object { sasso00 texture { T_Stone44 } scale (0.6+(0.2*rand(sa_y))) }
        #break

        #case (5)
            object { sasso01 texture { T_Stone15 } scale <(rand(sa_x)*0.5)+0.2,(rand(sa_y)*0.2)+0.1,(rand(sa_z)*0.5)+0.2> }
        #break
        
        #case (6)
            object { sasso02 texture { T_Stone8 } scale <(rand(sa_x)*0.5)+0.2,(rand(sa_y)*0.2)+0.1,(rand(sa_z)*0.5)+0.2> }
        #break

        #case (7)
            object { sasso03 texture { T_Stone44 } scale <(rand(sa_x)*0.5)+0.2,(rand(sa_y)*0.2)+0.1,(rand(sa_z)*0.5)+0.2> }
        #break

        #case (8)
            object { sasso00 texture { T_Stone8 } scale <(rand(sa_x)*0.5)+0.2,(rand(sa_y)*0.2)+0.1,(rand(sa_z)*0.5)+0.2> }
        #break
        
        #case (9)
            object { sasso01 texture { T_Stone7 } scale <(rand(sa_x)*0.8)+0.1,(rand(sa_y)*0.4)+0.1,(rand(sa_z)*0.8)+0.15> }
        #break
        
        #case (10)
            object { sasso02 texture { T_Stone8 } scale <(rand(sa_x)*0.8)+0.1,(rand(sa_y)*0.4)+0.1,(rand(sa_z)*0.8)+0.15> }
        #break

        #case (11)
            object { sasso03 texture { T_Stone44 } scale <(rand(sa_x)*0.8)+0.1,(rand(sa_y)*0.4)+0.1,(rand(sa_z)*0.8)+0.15> }
        #break

        #case (12)
            object { sasso00 texture { T_Stone15 } scale <(rand(sa_x)*0.8)+0.1,(rand(sa_y)*0.4)+0.1,(rand(sa_z)*0.8)+0.15> }
        #break

        #case (13)
            object { sasso01 texture { T_Stone44 } scale <(rand(sa_x)*0.3)+0.1,(rand(sa_y)*0.2)+0.1,(rand(sa_z)*0.3)+0.1> }
        #break
        
        #case (14)
            object { sasso02 texture { T_Stone10 } scale <(rand(sa_x)*0.3)+0.1,(rand(sa_y)*0.2)+0.1,(rand(sa_z)*0.3)+0.1> }
        #break

        #case (15)
            object { sasso03 texture { T_Stone13 } scale <(rand(sa_x)*0.3)+0.1,(rand(sa_y)*0.2)+0.1,(rand(sa_z)*0.3)+0.1> }
        #break

        #case (16)
            object { sasso00 texture { T_Stone22 } scale <(rand(sa_x)*0.3)+0.1,(rand(sa_y)*0.2)+0.1,(rand(sa_z)*0.3)+0.1> }
        #break

        #case (17)
            object { sasso01 texture { T_Stone44 } scale (0.6+(0.2*rand(sa_y))) }
        #break
        
        #case (18)
            object { sasso02 texture { T_Stone44 } scale (0.6+(0.2*rand(sa_y))) }
        #break

        #case (19)
            object { sasso03 texture { T_Stone44 } scale (0.6+(0.2*rand(sa_y))) }
        #break

        #case (20)
            object { sasso00 texture { T_Stone44 } scale (0.6+(0.2*rand(sa_y))) }
        #break

    #end   
#end


#macro position_macro()
<(rand(sa_x)*1.5 - rand(sa_x)*1.5),0,(rand(sa_z)*1.5 - rand(sa_z)*1.5)>
#end  

#declare height_accuracy = 0.01;
#declare max_height = 1;
     
#include "scatter.mcr"

//scatter_multiple (15,file_name)

#declare mySassi = union {
    
    object { #include file_name }    
    object { myVassoio }
    
    scale 0.5
    
}
