// Pov source file jgmcath.pov
// Gary MacKinnon
// 2/12/2002


// This is provided for information only.  I haven't supplied all the components
// particularly the tree macro to recreate the scene.


global_settings { 
   assumed_gamma 1.0 
   ambient_light 0.2 // default is 1.0 with each object at .1
   max_trace_level 10 

}

//=================================================================================================
//  
//=================================================================================================



#include "colors.inc"
#include "functions.inc" 

#declare PH = 10 ;  // plate height
#declare PW = 24 ;  // plate width
#declare FH = 108 ; // floor height
#declare DD = 1 ;   // post diameter

#declare baseStructureColor = color rgb < .45, 0.64, .80 >*1.3 ;
#declare SmudgeColor = baseStructureColor/2 ;
#declare Transparent = color rgbt  <1.0, 1.0, 1.0, 1.0>; 

#declare Smudge =  
  pigment {
     bozo
     turbulence .3
     color_map {
	[0.2 SmudgeColor ]
	[0.7 Transparent ]
	[1.0 Transparent ]
     }
  }

#declare Randomizer = seed( 112 ) ;
#macro metalTexture()
texture { 
   pigment { baseStructureColor }
   finish { phong 0.9 phong_size 300 }
}
   
   #local smudgeSize = ( 1 - .5* rand (Randomizer)); 
   texture { 
      pigment {
	 bozo
	 warp { turbulence 0 }
	 pigment_map {
	    [smudgeSize Smudge]
	    [smudgeSize Transparent]
	    [1.0 Transparent]
	 }
	 scale <3, 1, 1>*5
	 
      }
      finish { phong 0.9 phong_size 300 }
      translate < 1317 * rand(Randomizer), 0, 0>  
   }
#end
   
         

#macro Post() 
cylinder { < 0,0,0 > < 0,FH-PH,0 > DD 
   pigment { baseStructureColor }
   metalTexture ()
}
#end

#macro Side()
cylinder {  < 0,0,0 > < PW,0,0 > DD 
   pigment { baseStructureColor } 
   metalTexture ()
}
#end

#macro Plate()
box { <0,0,0> <PW-.2, PH, 1>
   pigment { baseStructureColor } 
   metalTexture ()
}
#end

#declare SS = 60 ;  //Noise wave length
#declare AA = 0.3 ; //Noise amplitude
#declare Seed = seed(1000) ;

#macro GlassPanel()
#local RR = 10000*rand( Seed ) ;
isosurface { 
   function {  y - f_noise3d( x, y, z )   }
   contained_by  { box { <RR,0,PH/SS> <RR+PW/SS,1,FH/SS> } }
   evaluate 1, 10, 0.99
   max_gradient 5
   translate < -RR, 0, 0 >
   scale < SS, AA, SS > 
   rotate -90*x
   translate < 0, 0, 1 + AA >
   pigment { Black }
   finish {
      ambient 0
      diffuse 0
      reflection .75
      specular 1
      roughness .001
   }
}
#end


#macro Segment ()
union {
   object { Side()}
   object { Plate()}
   object { Side() translate < 0, PH, 0 >}
   object { GlassPanel() }
}
#end



#declare Floor = 0;
#while ( Floor < 5 )
   #declare Section = 0 ;
   #while ( Section < 4 )
      object { Post() translate < -500 + Section*12*PW, Floor*FH + PH, PW > }
      object { Segment()
	 translate < -PW , 0, 0 >
	 scale < sqrt(2), 1, 1 >
	 rotate 45*y
	 translate < -500 + Section*12*PW +PW, Floor*FH, 0 >
      }
      object { Segment() 
	 scale < sqrt(2), 1, 1 >
	 rotate -45*y
	 translate < -500 + Section*12*PW - PW, Floor*FH, 0 >
      }
      #declare CC = 1 ;
      #while ( CC < 12 )
	 object { Post() translate < -500 + Section*12*PW + CC*PW, Floor*FH + PH, 0> }
	 #declare CC = CC + 1 ;
      #end
      #declare CC = 1 ;
      #while ( CC < 11 )
	 object { Segment() translate < -500 + Section*12*PW + CC*PW, Floor*FH, 0 >} 
	 #declare CC = CC + 1 ;
      #end
      #declare Section = Section + 1 ;
   #end
   #declare Floor = Floor + 1 ;
#end


//=================================================================================================
// The Tree
//=================================================================================================
   
#declare initialTrunkDirection = <0,1,0> ;    
#declare initialTrunkPosition = <0,0,0> ;  
#declare trunkRadius = 20 ;

#declare radiusTaperRate = .0005 ;
#declare trunkToMinimumBranchRatio = 12 ; //8
#declare initialBranchingProbability = .25 ;
#declare gnarlFactor = 0.3 ;
#declare pushFactor = .2 ; //0.3 ;
#declare centerOfMassFactor = .5 ;
#declare includeLeaves = true ;

#include "..\..\projects\items\tree\txttree.inc"

#declare txtTree = txtTree_14 ;

#declare pushVector = <0,1,0> ;

#declare segmentLengthMultiple = 5 ;
#declare branchAngleFactor = 1.0 ;
#declare xSeed =  204 ;

#declare leafScale = 2 ;

#include "..\..\projects\items\tree\Garytree.inc"

object { TREE() scale .3 translate < 100, 25, -150 > }


   
//=================================================================================================
// The Image
//=================================================================================================
   

#declare Image = 
  box { <0,0,-.001> <1,1,0> 
     pigment { 
	image_map { png "cimage3.png" once interpolate 2 }
     }
     translate <-.5 , 0 , 0 >
     scale < 1.513, 1, 1 >
     scale 1200*2
     rotate y*180
     translate <200, -200, -700 >*3
  }

object{ Image finish { ambient 3 } }



//=================================================================================================
// The Lens Flare
//=================================================================================================

#declare cam_loc = < -100, 140, -600> ;   
#declare light_loc = < 1700, 1400, 2000 > ; 

#declare lookat = < 90, 250,  0>; 
#declare sky_vect = <0,1,0>  ;

#declare flare_size = 1 ;
#declare flare_brightness = 3 ;

#include "..\..\projects\items\nkflare\35mm.flr"          
#include "..\..\projects\items\nkflare\nkflare.inc"       

//=================================================================================================
// The Scene
//=================================================================================================

#declare Background = color rgb < .20, .32, .65 > ;
background { ( Background *.4 )  }


#declare Angle = 40 ;



camera{ 
   location  cam_loc 
   right     image_width/image_height*x 
   look_at   lookat
   sky sky_vect 
   angle Angle
}

light_source{
    < 1700, 1400, -2000 > 
   color White
   area_light 20*y,20*x,2,2
   jitter
}

// This is just to make the Lens Flare work.
// It is behind the office building.
light_source{
   light_loc
   color White
}

