//// The Observers
//// by John Robinson 
//// Feb 2002


global_settings {
    ambient_light rgb 1
    max_trace_level 20
    adc_bailout 0.125
    }

/////////

#include "textures.inc"

//// helix function

#declare f_helix1 = function { internal(25) }

//// sine wave for straight railings

#macro SineWave(StartX,StartAngle,Radius,WaveLength,Length,Thickness)

#local myPi = pi / 180;
#local numPoints = int(Length/WaveLength)+3;
#local myCounter = 0;

	sphere_sweep {
	b_spline,
	numPoints,
#while ( myCounter < numPoints )
	#local myPointY = (Radius * sin(StartAngle * myPi));

	<StartX-WaveLength, myPointY, 0>, Thickness

	#local StartAngle = StartAngle + 45;
	#local StartX = StartX + WaveLength;
	#local myCounter = myCounter + 1;
#end
	texture { Rails }
	}
#end

///// sine wave for curved railings

#macro CSineWave(StartAngle,Circ,IRadius,ORadius,WaveLength,Thickness)

#local myPi = pi / 180;
#local numPoints = int(Circ/WaveLength)+3;
#local HAngle = 0;
#local Curve = 0;

	sphere_sweep {
	b_spline,
	numPoints,
#while ( Curve < Circ+(WaveLength*3) )
	#local myPointY = (IRadius * sin((HAngle+StartAngle) * myPi));
	#local myPointX = (ORadius * sin(Curve * myPi));
	#local myPointZ = (ORadius * cos(Curve * myPi));

	<myPointX,myPointY,myPointZ>, Thickness

	#local HAngle = HAngle + 45;
	#local Curve = Curve + WaveLength;
#end
	rotate <0,-WaveLength,0>
	}
#end

//// macro for buildings
//// assumes you dont enter daftie values like making windows bigger than building etc etc blah blah

#declare IsVis = seed(8564679);				// need a random number for windows
											// MagicNumber is the percent of UNLIT windows
											// it wants a number 0 - 1
											// we use 0.4 here so 60% are lit

#macro HighRise(Length,Width,Height,WinSize,Spacing,MagicNumber,BlgTex,WinTex)

#local LnumWins = Length / (WinSize + Spacing);
#local WnumWins = Width / (WinSize + Spacing);
#local HnumWins = Height / (WinSize + Spacing);
#local NLength = Length/2;
#local NWidth = Width/2;

union {
	box {<-NLength,0,-NWidth>,<NLength,Height,NWidth> texture { BlgTex }}					// main building

#local hSpacing = Spacing - WinSize - WinSize;
#local HCount = 0;

#while (HCount < HnumWins-1)																// windows
	#local sSpacing = Spacing;
	#local LCount = 0;
	#while(LCount < LnumWins-1)
	  #if (rand(IsVis) > MagicNumber)
		box {<-WinSize/2,0,-NWidth-0.01>,<WinSize/2,WinSize,NWidth+0.01>
			translate <-NLength + sSpacing + (WinSize/2),Spacing + WinSize + hSpacing,0>	// its lit
			no_shadow
			}
	  #end
		#local LCount = LCount + 1;
		#local sSpacing = sSpacing + Spacing + WinSize;
	#end

	#local sSpacing = Spacing;
	#local WCount = 0;
	#while(WCount < WnumWins-1)
	  #if (rand(IsVis) > MagicNumber)
		box {<-NLength-0.01,0,-WinSize/2>,<NLength+0.01,WinSize,WinSize/2>
			translate <0,Spacing + WinSize  + hSpacing,-NWidth + sSpacing + (WinSize/2)>
			no_shadow
			}
	  #end
		#local WCount = WCount + 1;
		#local sSpacing = sSpacing + Spacing + WinSize;
	#end
	#local HCount = HCount + 1;
	#local hSpacing = hSpacing + Spacing + WinSize;
#end
	texture { WinTex }
}
#end

/////////// some lights

#declare bkLight =
	light_source {<0,0,0> rgb <0.7,0.4,0>
		fade_distance 5
		fade_power 3
		}

#declare tkLight =
	light_source {<0,0,0> rgb <0.7,0.4,0>
		fade_distance 8
		fade_power 3
		}

/////////// the main stuff

#include "tower.inc"
#include "column.inc"
#include "bigarch.inc"
#include "stairs.inc"
#include "shields.inc"
#include "statue.inc"

/// helix column

#declare bgHelix =
	isosurface {
	function { f_helix1(x,y,z,3,-0.155,2,5,1.75,1,0) }
	threshold 0.0
	accuracy 0.0005
	max_gradient 1.412
    contained_by { box {<-7,0,-7>, <7,120,7> }}
    rotate <0,40,0>
	translate <0,8,0>
	}

/// seahorse fountain

#include "SeaH.inc"

//////// the city

#include "TheCity.inc"

	object { cBlock scale 1.65 rotate <0,-90,0> translate <-198,8,200> }
	object { glbGlass translate <-203,4,200>}
	object { glbBase translate <-203,4,200>}

#declare CityMedia =
	media {
		method 3
      	emission 0.03
      	intervals 10
      	samples 1, 5
      	confidence 0.9
      	variance 1/128
      	density  {
        spherical
        ramp_wave
        turbulence 0
        colour_map {
        	[0 rgbt <0,0,0,1>]
          	[1 rgbt <0.5,0.3,0,1>]
        		}
      		}
      	scale 0.99
      	}

	sphere {<0,0,0>,1
	pigment { rgbt 1 }
	finish { ambient 0 diffuse 0 }
	interior { media { CityMedia }}
	clipped_by { box {<-1.01,0,-1.01>,<1.01,1.01,1.01>} }
  	hollow
  	scale <1,1.6,1.4>*66
	translate <-203,8,200>
	}

////// back statue light thingy

union {
	lathe {
	cubic_spline
	8,
	<8,0>,<6,1>,<2,2>,<3,6>,<2,8>,<6,12>,<5,14>,<1,15>
		}
	torus {5.8,0.5 translate <0,0.5,0>}
	torus {5,0.25 translate <0,14,0>}
	translate <-493,8,104>
	texture { DarkBlueStone }
	}

#declare Media =
	media {
      	emission 0.5
      	intervals 10
      	samples 1, 20
      	confidence 0.9999
      	variance 1/1000
      	density  {
        spherical
        ramp_wave
        turbulence 2.5
        colour_map {
        	[0 rgbt <0,0,0,1>]
          	[0.25 rgb <1,0,0>]
          	[1 rgb <1,1,0>]
        		}
      		}
      	scale 0.4
      	}

light_source { <0,0,0> rgb <0.5,0.1,0>
	looks_like {
		sphere {<0,0,0>,1
		pigment { rgbt 1 }
		finish { ambient 0 diffuse 0 }
			interior { media { Media }}
  			}
  		hollow
  		scale <8,12,8>*0.75
  		}
	translate <-493,27,104>
	fade_distance 25
	fade_power 2
	area_light <5,0,0>,<0,5,0>,10,10
	adaptive 0
	circular
	orient
	}


//// the towers

#declare twrzCrD = -77;

#declare TwoCastles =
union {
	box {<-4.5,58,-77>,<4.5,60,150>											// top of bridge
		texture {
		average
		texture_map {
			[1 Bricky2 rotate <90,0,0>]
			[0.1 Bljr]
				}
			}
		}

	box {<-3.5,60,-77>,<3.5,60.01,150> texture { WalkCheck rotate <0,-90,0> }}

	cylinder {<4.5,58,-77>,<4.5,58,150>,0.2 texture { vDarkStone }}
	cylinder {<4.5,60,-77>,<4.5,60,150>,0.2 texture { vDarkStone }}

#while (twrzCrD < 150)
	cylinder {<4.5,58,twrzCrD>,<4.5,60,twrzCrD>,0.1 texture { vDarkStone }}
	#local twrzCrD = twrzCrD + 1.25;
#end

	object { Stairs translate <0,22,-40> }								// arched stairs

	object { CastleBigArch translate <0,37,-20> }						// big arches
	object { CastleBigArch translate <0,37,-60> }
	object { CastleBigArch2 translate <0,0,-60> }
	object { CastleBigArch translate <0,37,20> }
	object { CastleBigArch translate <0,37,60> }
	object { CastleBigArch translate <0,37,100> }
	object { CastleBigArch translate <0,37,140> }

    object { Columny }													// arch columns
    object { Columny translate <0,0,40>}
    object { Columny translate <0,0,80>}
    object { Columny translate <0,0,120>}
    object { Columny translate <0,0,160>}

	texture {
	average
	texture_map {
		[1 Bricky2]
		[0.1 Bljr]
			}
		}
	}

	object { TwoCastles translate <0,8,87> }							// place it

	object { ATower rotate <0,-90,0> }									// tower
	object { ATower rotate <0,-90,0> translate <0,0,-70> }

	object { TopRailers }

	light_source { tkLight translate <0,49,0> }							// lights in tower
	light_source { tkLight translate <0,35,0> }
	light_source { tkLight translate <0,5,0> }
	light_source { tkLight translate <0,-25,0> }
	light_source { tkLight translate <0,-55,0> }

	light_source { tkLight translate <0,35,-70> }
	light_source { tkLight translate <0,5,-70> }

#include "Sword.inc"													// sword on tower

	object { Sword scale 0.4 rotate <0,90,0> translate <10.2,-10,0> }
	object { Sword scale 0.4 rotate <0,90,0> translate <10.2,-10,-70> }

/////////

#include "flags.inc"													// flags on big arches

	object { theFlaggies }

////////////// the pool

#include "thepool.inc"

	object { SeaStatue translate <-203,8,100> }							// place fountains
	object { SeaStatue translate <-203,8,300> }

///////// set up wall with turrets

#include "frontwall.inc"

///// grassy bit at back

	object { ArchHelix scale 0.55 rotate <0,-90,0> translate <-344,8,104> }

#declare Stalk1 = torus {1,0.9 scale <1,5,1> translate <0,-3,0> pigment { rgb 1 } finish { Dull }}

#declare FlyAgaric =
union {
	sphere {<0,0,0>,4 clipped_by {box {<-4,0,-4>,<4,4,4>}} scale <1.3,1,1.3>}
	torus {3.5,0.5 scale <1.3,1,1.3>}
	object { Stalk1 }
	translate <0,6.75,0>
	scale 0.3
		}

	box {<-340,7,31>,<-600,8,180> texture { Grassyness }}

#declare rndX = seed(7549);
#declare rndZ = seed(2159);
#declare rndScale = seed(6907124);
#declare rndCount = 0;

#while (rndCount < 10)
	object { FlyAgaric scale 0.6+rand((rndScale)*0.5) translate <rand(rndX)*130,0,rand(rndZ)*55> translate <-340-135,8,42> texture { RedSpot scale 0.25 }}
	#declare rndCount = rndCount + 1;
#end

#declare rndCount = 0;
#while (rndCount < 10)
	object { FlyAgaric scale 0.6+rand((rndScale)*0.5) translate <rand(rndX)*130,0,rand(rndZ)*55> translate <-340-135,8,110> texture { RedSpot scale 0.25 }}
	#declare rndCount = rndCount + 1;
#end

/////// for the tree pots

#declare GrssAng = seed(2312234);
#declare GrssDist = seed(7624325);
#declare GrssCnt = 0;

#declare PotGrass =
union {
#while (GrssCnt < 300)
	cone {<0,0,0>,0.1,<0,0.4,0>,0 translate <rand(GrssDist)*5.7,0,0> rotate <0,rand(GrssAng)*360,0> }
	#declare GrssCnt = GrssCnt + 1;
#end
	pigment { rgb <0,0.4,0> }
	finish { Dull2 }
	}

#declare PlType1 =				// hangy leaves
	bicubic_patch {
   	type 1 flatness 0.001
   	u_steps 4 v_steps 4
   	uv_vectors
   	<0,0>,<1,0>,<1,1>,<0,1>
	<0,0,3> <10,9,3> <20,5,2> <30,-15,1.51>
	<0,0,2> <10,9,2.5> <20,5,1.75> <30,-15,1.5>
	<0,0,1> <10,9,1> <20,5,1.25> <30,-15,1.5>
	<0,0,0> <10,9,0.5> <20,5,1> <30,-15,1.49>
	pigment { rgb <0,0.4,0> }
	finish { Dull2 }
	}

#declare Pl1Cl1 =
union {
	object { PlType1 rotate <0,0,15>}
	object { PlType1 rotate <0,0,10> rotate <0,20,0>}
	object { PlType1 rotate <0,0,10> rotate <0,-20,0>}
	object { PlType1 rotate <0,0,15> rotate <0,40,0>}
	object { PlType1 rotate <0,0,15> rotate <0,-40,0>}

	object { PlType1 scale 0.7 rotate <0,0,35> rotate <0,10,0>}
	object { PlType1 scale 0.7 rotate <0,0,30> rotate <0,-10,0>}
	object { PlType1 scale 0.7 rotate <0,0,35> rotate <0,30,0>}
	object { PlType1 scale 0.7 rotate <0,0,30> rotate <0,-30,0>}
	scale 0.3
	}

#declare xxCCAng = 0;
#declare slAng = seed(54456677);
#declare Pl1Cl2 =
union {
#while (xxCCAng < 360)
	object { PlType1 scale 0.7 scale rand(slAng)*1.5 translate <4,0,0> rotate <0,0,65> rotate <0,0,rand(slAng)*-20> rotate <0,xxCCAng,0>}
	#declare xxCCAng = xxCCAng + 10;
#end
	scale 0.15
	}

	object { Pl1Cl2 translate <5,0,0> rotate <0,35,0> translate <25,13.5,90>}
	object { Pl1Cl2 scale 0.7 translate <3,0,0> rotate <0,-10,0> translate <25,13.5,90>}
	object { Pl1Cl2 scale 0.7 translate <3,0,0> rotate <0,-10,0> translate <20,13.5,87>}
	object { Pl1Cl1 translate <4,0,0> rotate <0,90,0> translate <25,13,90>}
	object { Pl1Cl1 translate <4,0,0> rotate <0,160,0> translate <25,13,90>}
	object { Pl1Cl1 translate <4,0,0> rotate <0,-50,0> translate <25,13,90>}

	object { Pl1Cl1 translate <4,0,0> rotate <0,-50,0> translate <-25,13,90>}
	object { Pl1Cl1 translate <4,0,0> rotate <0,130,0> translate <-25,13,90>}
	object { Pl1Cl2 scale 0.7 translate <3,0,0> rotate <0,-10,0> translate <-23.5,13.5,87>}

	object { Pl1Cl1 translate <4,0,0> rotate <0,20,0> translate <-25,13,170>}
	object { Pl1Cl1 translate <4,0,0> rotate <0,90,0> translate <-25,13,170>}

	object { Pl1Cl1 translate <4,0,0> rotate <0,-20,0> translate <25,13,170>}
	object { Pl1Cl1 translate <4,0,0> rotate <0,40,0> translate <25,13,170>}
	object { Pl1Cl1 translate <4,0,0> rotate <0,120,0> translate <25,13,170>}
	object { Pl1Cl1 translate <4,0,0> rotate <0,200,0> translate <25,13,170>}
	object { Pl1Cl2 scale 0.7 translate <3,0,0> rotate <0,-10,0> translate <24,13.5,167>}
	object { Pl1Cl2 scale 0.7 translate <3,0,0> rotate <0,-10,0> translate <22,13.5,166>}

	object { FlyAgaric translate <26,14,88> texture { RedSpot scale 0.25 }}
	object { FlyAgaric scale 0.7 translate <25,14,93> texture { RedSpot scale 0.25 }}

	object { FlyAgaric scale 0.6 translate <-23,14,92> texture { RedSpot scale 0.25 }}
	object { FlyAgaric scale 0.7 translate <-26,14,87> texture { RedSpot scale 0.25 }}
	object { FlyAgaric scale 0.9 translate <-23.5,14,87.5> texture { RedSpot scale 0.25 }}

	object { FlyAgaric scale 1.1 translate <27.5,14,172> texture { RedSpot scale 0.25 }}

	object { FlyAgaric translate <-27.5,14,168> texture { RedSpot scale 0.25 }}
	object { FlyAgaric scale 0.6 translate <-23.5,14,173> texture { RedSpot scale 0.25 }}

//// some trees at back


#include "meshcone.inc"
#include "meshtree.inc"

#declare Treey = MeshTree (
        9,    // Number_Of_Large_Branches
        7,    // Number_Of_Medium_Branches
        8,    // Number_Of_Small_Branches
        18,   // Number_Of_Leaves
        10,   // Branch_Minimum_Angle
        130,  // Branch_Maximum_Angle
        10,   // Tree_Trunk_Size
        4,    // Large_Branch_Size_Min
        5,    // Large_Branch_Size_Max
        2,    // Medium_Branch_Size_Min
        3,    // Medium_Branch_Size_Max
        1,    // Small_Branch_Size_Min 
        2,    // Small_Branch_Size_Max
        texture { TBark },    // T_Tree_1
        texture { TLeaf },           // T_Tree_2
        378482  // Seed_1
        )

#declare Treey2 = MeshTree (
        8,    // Number_Of_Large_Branches
        7,    // Number_Of_Medium_Branches
        8,    // Number_Of_Small_Branches
        18,   // Number_Of_Leaves
        16,   // Branch_Minimum_Angle
        140,  // Branch_Maximum_Angle
        10,   // Tree_Trunk_Size
        4,    // Large_Branch_Size_Min
        5,    // Large_Branch_Size_Max
        2,    // Medium_Branch_Size_Min
        3,    // Medium_Branch_Size_Max
        1,    // Small_Branch_Size_Min
        2,    // Small_Branch_Size_Max
        texture { TBark },    // T_Tree_1
        texture { TLeaf },           // T_Tree_2
        457042  // Seed_1
        )

#declare Treey3 = MeshTree (
        9,    // Number_Of_Large_Branches
        8,    // Number_Of_Medium_Branches
        8,    // Number_Of_Small_Branches
        18,   // Number_Of_Leaves
        26,   // Branch_Minimum_Angle
        110,  // Branch_Maximum_Angle
        10,   // Tree_Trunk_Size
        4,    // Large_Branch_Size_Min
        5,    // Large_Branch_Size_Max
        2,    // Medium_Branch_Size_Min
        3,    // Medium_Branch_Size_Max
        1,    // Small_Branch_Size_Min
        2,    // Small_Branch_Size_Max
        texture { TBark },    // T_Tree_1
        texture { TLeaf },           // T_Tree_2
        160744  // Seed_1
        )

	object { Treey scale 2 translate <-450,8,50>}
	object { Treey3 scale 1.7 rotate <0,-120,0> translate <-400,8,50>}
	object { Treey2 scale 1.8 translate <-350,8,50>}
	object { Treey2 scale 1.96 rotate <0,90,0> translate <-450,8,155>}
	object { Treey3 scale 1.86 rotate <0,-160,0> translate <-400,8,155>}
	object { Treey scale 1.686 rotate <0,40,0> translate <-350,8,155>}

/////// bottom stairs and floor

#include "bottomstairs.inc"

///////////// the back building

#declare theWall =
	prism {
	0,90,
	13,
	<0,390>,<-340,390>,<-340,180>,<-490,180>,<-490,27>,
	<-1000,27>,<-1000,35>,<-510,35>,<-510,190>,<-350,190>,<-340,391>,<0,391>,<0,390>
	texture {
	gradient <0,1,0>
	texture_map {
		[0.6 Bricky2 scale <1,1/90,1>*2]
		[0.9 cCleary]
			}
		scale <1,90,1>
		}
	}

#declare mLedge1 =
	prism {
	0,2,
	13,
	<0,380>,<-330,380>,<-330,170>,<-480,170>,<-480,16>,
	<-1000,16>,<-1000,36>,<-500,36>,<-500,190>,<-350,190>,<-350,400>,<0,400>,<0,380>
	texture {Bricky2 scale 2}
		}

#declare mLedge2 =
	prism {
	0,3,
	13,
	<0,381>,<-331,381>,<-331,171>,<-481,171>,<-481,17>,
	<-1000,17>,<-1000,36>,<-500,36>,<-500,190>,<-350,190>,<-350,400>,<0,400>,<0,381>
	texture {
		pigment { checker rgb <0.1,0.5,0.1>, rgb <0.15,0.15,0.1> scale <4,1.5,4> }
		finish { Shiny2 }
		}
	}

#declare mWPat =
	prism {
	0,4,
	13,
	<0,389.99>,<-339.99,389.99>,<-339.99,179.99>,<-489.99,179.99>,<-489.99,26.99>,
	<-1000,26.99>,<-1000,30>,<-500,30>,<-500,182>,<-350,182>,<-350,392>,<0,392>,<0,389.99>
	}

#declare orPat =
union {
	object { mWPat translate <0,8,0> }
	object { mWPat translate <0,28,0> }
	object { mWPat translate <0,50,0> }
	texture { OrangeStr }
	}

#declare blPat =
union {
	object { mWPat translate <0,8,0> }
	object { mWPat translate <0,28,0> }
	object { mWPat translate <0,50,0> }
	translate <0,10,0>
	texture { BlueStr }
	}

#declare newWall =
union {
	object { theWall }
	object { mLedge1 translate <0,43,0> }
	object { mLedge2 translate <0,45,0> }
	object { mLedge1 translate <0,48,0> }
	object { orPat }
	object { blPat }
	texture { Bricky2 scale 2}
	}

difference {
	object { newWall }
	cylinder {<0,0,0>,<0,20,0>,20 scale <0.5,1,1> translate <-490,8,104>}
	sphere {<0,0,0>,20 scale <0.5,0.5,1> translate <-490,28,104>}

    box {<-339,-0.00001,205>,<-346,22.1,225>}
    cylinder {<-339,22,215>,<-346,22,215>,10}
 
	box {<-195,-0.1,389>,<-215,22.1,395.5>}
	cylinder {<-205,22,389>,<-205,22,395.5>,10}

	box {<-100,0,-1.5>,<0.1,6,1.5> translate <-490,12,30>}
	cylinder {<-100,6,0>,<0.1,6,0>,1.5 translate <-490,12,30>}

	cutaway_textures
	}

#declare bLiner =
	prism {
	0,0.5,
	9,
	<-490,4>,<50,4>,<66,-5>,<100,-5>,<100,-9>,
	<65,-9>,<49,0>,<-490,0>,<-490,4>
	rotate <-90,0,0>
	translate <0,8,27.49>
	}

	object { bLiner	texture { OrangeStr }}

union {
	box {<-500,-27,26.99>,<100,-23,28>}
	box {<-499.9,-27,-100>,<-500,-23,28>}
	texture { BlueStr }
	}

//doors on back building

	box {<-341,0,205>,<-346,35,225> pigment { rgb <0.35,0.13,0> } finish { Dull2} normal { wrinkles 1 scale 0.5 rotate <0,90,0>}}
	box {<-340.9,0,214.5>,<-342,35,215.5> pigment { rgb 1 } finish { Shiny_Metal }}

#declare BWallDoor =
union {
	box {<-10,0,-0.2>,<0,22,0.2>}
	cylinder {<0,22,-0.2>,<0,22,0.2>,10 clipped_by { box {<-10.1,22,-0.21>,<0,32,0.21>}} }		// open door
	box {<0,0,-0.7>,<-0.5,32,0> pigment { rgb 1 } finish { Shiny_Metal }}
	pigment { rgb <0.35,0.13,0> } finish { Dull2} normal { wrinkles 1 scale 0.5 }
	}

	object { BWallDoor
		translate <10,0,0> rotate <0,-80,0> translate <-10,0,0>
		translate <-205,0,391.2>
		}

	object { BWallDoor rotate <0,180,0>
		translate <-10,0,0> rotate <0,20,0> translate <10,0,0>
		translate <-205,0,391.2>
		}

	light_source { <-205,35,430> rgb <1,0.853,0.521> fade_distance 35 fade_power 1.5 }

/// blue columns

#include "bluecolumn.inc"

/////////// temple at back

#include "backtemp.inc"

	object { SeaHorse scale 1.5 rotate <0,90,0> translate <-570,-10+4,-41.5> }
	object { SeaHorse scale 1.5 rotate <0,-90,0> translate <-570,-10+4,-38.5> }

///// bottom level

// arches

union {
	object { CastleBigArch3 rotate <0,90,0> translate <-390,-160.1,52> }
	object { CastleBigArch3 rotate <0,90,0> translate <-140,-160.1,52> }
	object { CastleBigArch3 rotate <0,90,0> translate <-140+250,-160.1,52> }
	texture { Bricky2 scale 2 }
		}
	cylinder {<0,-160,0>,<0,-34,0>,5 scale <1,1,0.25> translate <-265,0,27> texture { DarkStone }}
	cylinder {<0,-160,0>,<0,-34,0>,5 scale <1,1,0.25> translate <-265+250,0,27> texture { DarkStone }}

/// ledge

union {
	box {<50,-27,35>,<-520,-29,25.5>}
	box {<50,-29,35>,<-520,-32,26.5>}
	box {<50,-32,35>,<-520,-34,25.5>}
	texture { Bricky2 scale 2 }
	}

union {
	box {<-490,-27,-100>,<-1000,-29,25.5>}
	box {<-491,-29,-100>,<-1000,-32,26.5>}
	box {<-490,-32,-100>,<-1000,-34,25.5>}
	texture { Bricky2 scale 2}
	}

// base

	box {<-489,-160,-100>,<-550,-170,200> texture { Bricky2 scale 2}}

// building

union {
	box {<-514.75,-121,-100>,<-515,-127,30>}
	box {<-514.75,-121,-100>,<-515,-127,30> translate <0,30,0>}
	box {<-514.75,-121,-100>,<-515,-127,30> translate <0,60,0>}
	box {<-514.75,-121,-100>,<-515,-127,30> translate <0,90,0>}
	box {<-514.75,-121,-100>,<-515,-127,30> translate <0,-30,0>}
	box {<-510,-160,-100>,<-515,-155,30>}
	box {<-514.75,-155,-39.5>,<-515,-34,-40.5>}
	texture { DarkBrick }
	}

difference {
	box {<-515,-160,-100>,<-1000,-27,30>}
	object { CutTowerDoor rotate <0,-90,0> scale <10,1,1> translate <-522,-140,-30>}
	object { CutTowerDoor rotate <0,-90,0> scale <10,1,1> translate <-522,-140,-50>}
	object { CutTowerDoor rotate <0,-90,0> scale <10,1,1> translate <-522,-110,-30>}
	object { CutTowerDoor rotate <0,-90,0> scale <10,1,1> translate <-522,-110,-50>}
	object { CutTowerDoor rotate <0,-90,0> scale <10,1,1> translate <-522,-80,-30>}
	object { CutTowerDoor rotate <0,-90,0> scale <10,1,1> translate <-522,-80,-50>}
	object { CutTowerDoor rotate <0,-90,0> scale <10,1,1> translate <-522,-50,-30>}
	object { CutTowerDoor rotate <0,-90,0> scale <10,1,1> translate <-522,-50,-50>}
	texture { Bricky2 scale 2}
	}

	box {<-515,-27,-100>,<-2000,-26.99,30> texture { Hexa2 }}

	light_source { bkLight translate <-520,-134,-30> }
	light_source { bkLight translate <-520,-134,-50> }
	light_source { bkLight translate <-520,-104,-30> }
	light_source { bkLight translate <-520,-104,-50> }
	light_source { bkLight translate <-520,-74,-30> }
	light_source { bkLight translate <-520,-74,-50> }
	light_source { bkLight translate <-520,-44,-30> }
	light_source { bkLight translate <-520,-44,-50> }

#declare ezPr =
union {
	object { TDoorRim texture { vDarkStone scale 0.125 finish {Shiny2} normal {granite 0.1 scale 0.5 }}}
	object { TowerRail texture { Bricky2 scale 2 }}
	rotate <0,-90,0>
	translate <-515,0,0>
	}

	object { ezPr translate <0,-140,-30> }
	object { ezPr translate <0,-140,-50> }
	object { ezPr translate <0,-110,-30> }
	object { ezPr translate <0,-110,-50> }
	object { ezPr translate <0,-80,-30> }
	object { ezPr translate <0,-80,-50> }
	object { ezPr translate <0,-50,-30> }
	object { ezPr translate <0,-50,-50> }

////

#declare bgCol =
union {
	object { vColBase scale 2 texture { DarkStone }}
	torus {1,0.2 translate <0,2,0> scale 6.5 texture { ShinyGold }}
	object { bgHelix }
	translate <-502,-160,0>
	}

	object { bgCol translate <0,0,10> texture { BlueMarble } }

	object { bgCol translate <0,0,-10> texture { BlueMarble } }

	object { bgCol translate <0,0,-70> texture { BlueMarble } }

	object { bgCol translate <0,0,-90> texture { BlueMarble } }

	prism {
	-200,100,
	4,
	<0,0>,<20,0>,<0,10>,<0,0>
	rotate <-90,0,0>
	translate <-490,-170,0>
	texture { Bricky2 scale 2 rotate <0,0,90>}
	}

	box {<-470,-170,-200>,<-1000,-250,200>
	texture {
	gradient <0,1,0>
	texture_map {
		[0.5 cCleary]
		[0.9 Bricky2 scale <1,1/80,1>*2]
			}
		translate <0,1,0>
		scale <1, 80,1>
		translate <0,-170,0>
		}
	}

	box {<-20,-183,-20>,<20,-263,20>
	translate <-265,0,52>
	texture {
	gradient <0,1,0>
	texture_map {
		[0.5 cCleary]
		[0.9 Bricky2 scale <1,1/80,1>*2]
			}
		translate <0,1,0>
		scale <1,80 ,1>
		translate <0,-183,0>
		}
	}


///////////// trees at front

#declare thePotty =
	sor {
	6,
	<0,0>,<5,1>,<8,3>,<7.5,5>,<6.2,6>,<6.75,7.2>
	scale <0.25,1,1>
		}

#local pRot = 0;

#declare rottyPots =
union {
#while ( pRot < 360 )
	object { thePotty rotate <0,pRot,0> }
	#declare pRot = pRot + 10;
#end
	}

#declare myPots =
union {
	object { rottyPots }
	torus {6,0.25 translate <0,6.2,0>}
	torus {5.5,0.5 translate <0,0.5,0>}
	cylinder {<0,6,0>,<0,6.1,0>,5.9 pigment { rgb <0.2345,0.1023,0>} finish {Dull2} normal {bumps 0.75 scale 0.5}}
	texture { PottyTex }
	}

#declare ChTree1=
union {
	//cylinder {<0,6,0>,<0,20,0>, 1.4 pigment { rgb <0.5,0.3,0> } finish { Dull }}			// test tree stump to speed it up
	object {Treey scale 2.15 translate <0,6,0> }
	object { PotGrass translate <0,6,0> }
	object { myPots }
	}

#declare ChTree2=
union {
	//cylinder {<0,6,0>,<0,20,0>, 1.4 pigment { rgb <0.5,0.3,0> } finish { Dull }}
	object {Treey2 scale 2 translate <0,6,0>}
	object { PotGrass translate <0,6,0> }
	object { myPots }
	}

#declare ChTree3=
union {
	//cylinder {<0,6,0>,<0,20,0>, 1.4 pigment { rgb <0.5,0.3,0> } finish { Dull }}
	object {Treey3 scale 2.05 translate <0,6,0>}
	object { PotGrass translate <0,6,0> }
	object { myPots }
	}

	object {ChTree1 translate <25,8,90> }
	object {ChTree2 rotate <0,115,0> translate <25,8,170> }

	object {ChTree3 rotate <0,250,0> translate <-25,8,90> }
	object {ChTree1 rotate <0,-215,0> translate <-25,8,170> }
	object {ChTree2 rotate <0,15,0> translate <-25,8,130> }
	object {ChTree1 rotate <0,65,0> translate <-25,8,210> }
	object {ChTree1 rotate <0,125,0> translate <-25,8,250> }

//// base for the man

	object {BStatue translate <25,9,130>}
	object {BStatue translate <25,9,210>}

#include "ManData.inc"

	object { ManMan scale 3 rotate <0,-90,0> translate <23,20.25,130> }
	object { ManMan scale 3 rotate <0,-90,0> translate <23,20.25,210> }

	object { Man2 scale 0.85 scale 1.1 rotate <0,-90,0> translate <14,30,0> texture { WeeManTex }}

	object { Man2 scale 0.85 scale 1.1 rotate <0,-120,0> translate <14,30,-68> texture { WeeManTex }}

union {
	object { Man3 scale 0.85 texture { WeeManTex }}
	object { Telescope scale 0.8 rotate <-105,0,0> translate <0.3,7.55,-0.95>}
		scale 1.1
		rotate <0,-45,0>
		translate <7,67,-7>
		}

	object { Man2 scale 0.85 scale 1.1 rotate <0,-30,0> translate <-350,8,132> texture { WeeManTex }}
	object { Man2 scale 0.85 scale 1.1 rotate <0,-90-30,0> translate <-350,8,125> texture { WeeManTex }}

	object { Man4 scale 0.85 scale 1.1 translate <0,68.5,-9> texture { WeeManTex }}

union {
	object { Man5 scale 0.85 texture { WeeManTex }}
	object { Telescope scale 0.8 rotate <-105,0,0> rotate <-40,0,0> translate <0.3,6.3,-2.7> }
		scale 1.1
		rotate <0,0,0>
		translate <25,13,28>
		}

union {
	object { Man6 scale 0.85 texture { WeeManTex }}
	object { Telescope scale 0.8 rotate <-105,0,0> rotate <-40,0,0> translate <0.3,6.3,-2.7> }
		scale 1.1
		rotate <0,-90,0>
		translate <3,4,-48.5>
		}

union {
	object { Man3 scale 0.85 texture { WeeManTex }	}
	object { Telescope scale 0.8 rotate <-105,0,0> translate <0.3,7.55,-0.95>}
		scale 1.1
		rotate <0,-50,0>
		translate <80,0,110>
		}

	object { Man2 scale 0.85 scale 1.1 rotate <0,-90,0> translate <-511,-110,-30> texture { WeeManTex }}

////////

#include "balloons.inc"

	object { Balloon2 rotate <-25,0,20> rotate <0,-20,0> translate <112,48,45> }
union {
	object { Man3 scale 0.85 texture { WeeManTex }	}
	object { Telescope scale 0.8 rotate <-105,0,0> translate <0.3,7.55,-0.95>}
	scale 1.1
	rotate <-25,0,20>
	rotate <0,-20,0>
	translate <112,48,45>
		}

	object { Balloon1 rotate <0,0,25> rotate <20,0,0> translate <-250,40,300> }
union {
	object { Man3 scale 0.85 texture { WeeManTex }	}
	object { Telescope scale 0.8 rotate <-105,0,0> translate <0.3,7.55,-0.95>}
	scale 1.1
	rotate <0,0,25>
	rotate <20,0,0>
	translate <-250,40,300>
		}

	object { Balloon3 rotate <0,-45,0> rotate <0,0,20> translate <-90,35,-22> }
union {
	object { Man3 scale 0.85 texture { WeeManTex } }
	object { Telescope scale 0.8 rotate <-105,0,0> translate <0.3,7.55,-0.95>}
	scale 1.1
	rotate <0,-45,0>
	rotate <0,0,20>
	translate <-90,35,-22>
		}

///////////// space

	sphere {<0,0,0>,200000
	clipped_by { box {<200001,0,200001>,<-200001,-200001,-200001>} }
	pigment {
      granite
      turbulence 1
      sine_wave
      color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            }
       scale 0.5
       }
	finish { ambient 1 diffuse 0 }
	}

///////

#declare fn_Pigm=function {
    pigment {
    average
	pigment_map {
		[0.26 wrinkles scale 0.1]
		[0.9125 granite scale 0.4]
			}
		scale 5
		}
    }

	isosurface {
	function { sqrt(x^2 + y^2 + z^2) - 1 - (fn_Pigm(x/2,y/2,z/2).y) }
	threshold 0.5
	accuracy 0.0005
	max_gradient 7
    contained_by { sphere {<0,0,0>, 2 }}
    scale 4
	pigment {
        gradient y
        turbulence 0.05
        omega 0.75
        lambda 3
        colour_map {
        [0.0 rgb <0,0.5,0.3>]
        [0.15 rgb <1,0.5,0>]
        [0.2 rgb <0.5,0.3,0.2>]
        [0.225 rgb <0.3,0.1,0>]
        [0.245 rgb <0.8,0.4,0.2>]
        [0.275 rgb <0.5,0.3,0.2>]
        [0.3 rgb <0.2,0.1,0>]
        [0.325 rgb <0.8,0.6,0.25>]
        [0.35 rgb <0.5,0.3,0>]
        [0.4575 rgb <0.8,0.4,0>]
        [0.56 rgb <0.7,0.4,0>]
        [0.6 rgb <0.2,0.1,0>]
        [0.65 rgb <1,0.5,0>]
        [0.675 rgb <1,0.5,0.5>]
        [0.7 rgb <0.7,0.5,0.2>]
        [0.725 rgb <0.5,0.18,0>]
        [0.775 rgb <1,0.5,0.3>]
        [0.8 rgb <1,0.5,0>]
        [0.825 rgb <0.8,0.25,0.02>]
        [0.85 rgb <0.6,0.3,0>]
        [0.875 rgb <0.65,0.35,0.261>]
        [0.9 rgb <1,0.5,0.2>]
        [0.95 rgb <1,1,1>]
        [1.0 rgb <0,0.5,0.3>]
                }
            scale 8
            }
	finish { Pldull }
	rotate <20,0,0>
	translate <25,-10,10>
	}


#include "planet1.inc"

	object { Planet1 scale 1.2 translate <-280,-200,0> } 
	object { Planet7 rotate <-10,0,40> scale 1.4 translate <-300,-100,-50> }
	object { Planet5 rotate <0,0,45> rotate <-20,0,0> scale 1.3 translate <75,-30,125> } 
	object { Planet6 scale 1 translate <-600,-650,0> } 
	object { Planet4 scale 1.5 translate <-1800,-1250,-100> }
	object { Planet9 scale 1.5 translate <-320,48,600> }


#declare Media2 =
	media {
      	emission 0.15
      	intervals 10
      	samples 1, 20
      	confidence 0.9999
      	variance 1/1000
      	density  {
        spherical
        ramp_wave
        turbulence 2
        octaves 6
        lambda 4
        omega 0.3
        colour_map {
        	[0 rgbt <0,0,0,1>]
          	[0.25 rgb <0,0.15,1>]
          	[1 rgb <1,0.5,0>]
        		}
      		}
      	scale 0.4
      	}

	sphere {<0,0,0>,1
		pigment { rgbt 1 }
		finish { ambient 0 diffuse 0 }
		interior { media { Media2 }}
  		hollow
  		scale 15
  		translate <-600,-600,50> 
  		}

///////////

text { ttf "c:/windows/fonts/comic.ttf" "(c) John Robinson" 0.1, 0 no_shadow
    pigment { rgbt <1,1,0,0.65> }
    finish { ambient 1 diffuse 0 }
    scale 3
    rotate <0,0,-15>
    rotate <0,-75,0>
    translate <15,-14,-50>
	}

////////

	sky_sphere {
	pigment {
	wrinkles
	colour_map {
		[0 rgb <0,0.2,0.7>*0.875]
		[1 rgb 1*0.875]
			}
		scale <0.5,0.2,0.5>
		}
	}

//////////

	camera {
	perspective
    location <170,150,-50>
    up <0,1,0>
    right <1.33333,0,0>
    direction <0,0,1.25> 
    look_at <0,46,40>
		}

	light_source { <6000,9000,-7500> rgb 1
	area_light <320,0,0>,<0,320,0>,30,30
	adaptive 0
	circular
	orient
	parallel
		}
