// Persistence of Vision Ray Tracer Scene Description File
// File: worlds.pov
// Vers: 3.5
// Desc: Entry for IRTC comp Worlds within worlds Jan-Feb 2002
// Date: 31/1/02
// Auth: James Taylor

// +H180 +W320
// +H450 +w800
// +H450 +w800 +A0.3
// +H603 +w1072 +A0.3

// +h180 +w400
// +h450 +w1000
// +h540 +w1200 +A0.3
// +h675 +w1500
// +h900 +w2000

#version 3.5;

#declare do_fog = true;
#declare do_photons = false;
#declare do_rad = true; 
#declare lights_on = true;
#declare rad_type = 8;

#declare do_boat_people = true; 

#declare do_man1 = true;
#if(do_man1)
    #declare do_man1_hair = false;
#end 

#declare do_man2 = true; 
#declare do_man3 = true;

#declare cam = 0; // 0 for normal

#declare ROT = <0,0,0>;

#include "rad_def.inc"
#include "colors.inc"
#include "materials.inc"
#include "skies.inc"
#include "torus_arc.inc" 
#include "transforms.inc"
#include "boat.inc"                      

#declare Water_L = -1.5;
//##############################################################
global_settings {   
  adc_bailout 0.003922
  ambient_light 0  
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
 #if (do_photons)
   photons {
     count 20000
     autostop 0
     jitter .4
     //save_file "photon_map.ph"
     //load_file "photon_map.ph"
   }
   #end 
  #if(do_rad) 
   radiosity {
        Rad_Settings(rad_type,0,0) 
   }
  #end   
 }

//##############################################################
// create a point "spotlight" (conical directed) light source 
#if(lights_on)
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color 
  spotlight               // this kind of light source
  translate <40, 40, -40> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
} 
#end

#if(cam=0)
// normal camera --------------------------
        camera {
                right     x*image_width/image_height
                location  <6 , 1 ,-4.5> 
                look_at   <2 , 0.25 , 0.0>} 
#end
#if(cam=1)       
// looking straight down
        camera { 
                right     x*image_width/image_height
                location <1.88/2 , 2 , 3.78/2 >
                look_at  <1.88 , 0 , 3.78/2 >}
                
#end 
#if(cam=2)
// looking at 0,0,0
        camera {
                right x*image_width/image_height
                location <1 , 1 , -3 >
                look_at  <0 , 0 , 0 >
                }
#end
#if(cam=3)
// low - cam
        camera {
                right x*image_width/image_height
                location <-1 , -1.5 , -4 >
                look_at  <0 , -1 , 0 >
                }
#end 
#if(cam=4)
// boat cam
        camera {
            right x*image_width/image_height
            location <-3,Water_L/2,-3.5>
            look_at  <-4,Water_L,-3>
            }
#end  
#if(cam=5)
// man1 cam
        camera {
            right x*image_width/image_height
            location <4.5,1,-2>
            look_at  <3.78,0,-1>
            }
#end
//#######################################
//water plane
plane {y, 0 
         translate Water_L*y
	    material {Water_CH scale 3}
	    } 
plane {y,0 translate (Water_L-5)*y pigment {Black} }

//sky
sky_sphere {S_Cloud4 rotate 45*y}
//################################################ 
#declare legs = true;
#declare do_edges = true;
#include "group.inc"
object {group} 

#declare bolt1 = object {bolt rotate y*90} 

//######################################################

//ladder up from sea
//step ladder
#declare bend =
union { 
    difference {
        torus {0.05,0.02}
        box { <-0.08,-0.03,-0.08> <0.06,0.03,0>}
        box { <-0.08,-0.03,-0.08> <0.08,0.03,0> rotate -90*y}        
        rotate -90*x
    }//end 
    cylinder { <-0.05,0,0> <-0.05,-5,0> 0.02} 
    material {Rust rotate <3245,45,23>} 
}

#declare rung = cylinder { <0,0,-0.15> <0,0,0.15> 0.015 material {Rust rotate <3465,356,12>} }
#declare sea_steps = 
union {
    object {bend translate -0.15*z }
    object {bend translate 0.15*z}
    #declare i=0;
    #declare N=20;
    #while(i<N)
        object {rung translate -0.05*x translate (-i*0.25)*y}
        #declare i=i+1;
    #end
}

object {sea_steps translate (1.88-0.12)*x translate 1.88*z}
//############################################################## 
#local L = 0.5;
#local AY = sin(radians(45))+0.025;
#local BZ = -L*sin(radians(45));

#declare hanger = 
union{
    cylinder {<0,0,-1.05> <0,0,-1.02> 0.05 rotate 45*x}
    cylinder {<0,0,0> <0,0,-1> 0.015 translate AY*y translate BZ*z}
    object {Torus_Arc(0.05,0.015,90,180) rotate 90*z translate AY*y translate (BZ-1)*z}       
    cylinder {<0,0,0> <0,0.02,0> 0.03 translate (AY-0.05)*y translate (BZ-1-0.05)*z}
    material {Rust}
}

object {hanger}
object {hanger translate 3.78*x}
object {hanger rotate 180*y translate 3.78*z}
object {hanger rotate 180*y translate 3.78*z translate 3.78*x}
//############################################################### 
#declare link_texture = Rusty_Iron;

#declare small_cell = 
union {
    #declare link_looseness = 0;
    #include "LINKOBJS.INC"
   
    #declare link_object = Iron_Chain;
    #declare link_count = 15;
    #declare link_twist = 90; 
    #declare link_size_turb = 0.025;
    #declare link_twist_turb = 0.1;
    #declare link_point1 = <0,(AY-0.05-0.03),BZ-1-0.05>;
    #declare link_point2 = <0, 0.25, BZ-1-0.05>;
    #include "LINK.INC" 
    //##############################
    #declare legs = false;
    #declare do_edges = false;
    #include "group.inc"
    object {group Center_Trans(group,x+y+z) scale 0.05 translate 0.25*y translate (BZ-1-0.05)*z}
}

object {small_cell translate 3.78*x} 
//##############################################################
    #declare link_looseness = 2;
    #include "LINKOBJS.INC"
   
    #declare link_object = Iron_Chain;
    #declare link_count = 15;
    #declare link_twist = 90; 
    #declare link_size_turb = 0.025;
    #declare link_twist_turb = 0.1;
    #declare link_point1 = <0,(AY-0.05-0.03),BZ-1-0.05>;
    #declare link_point2 = <-0.25, 0.25, BZ-1-0.05>;
    #include "LINK.INC" 
    //##############################
    #declare legs = false;
    #declare do_edges = false;
    #include "group.inc"
    object {group Center_Trans(group,x+y+z) rotate <5,10,-23> scale 0.05 translate <-0.25, 0.25, BZ-1-0.05>} 
    
//##############################################################
// boat is 12 long, 7 high and 6 wide

#declare boat_pos = <-4,Water_L+0.4,-3>;
#declare boat_rot = <0,80,0>;

//#declare boat_pos = <0,Water_L+0.3,0>; 
#declare boat_scale = 1/5;
#declare boat_people = 
  union {
    object{boat Center_Trans(boat,x+z)}
    
    #if(do_boat_people)
        #include "c:\my documents\field\woman.inc"
        #include "c:\my documents\field\man.inc"
        /*
        #declare woman_min = min_extent(woman);
        #declare woman_max = max_extent(woman);
        #debug concat("\nwoman_min = <",vstr(3,woman_min,",",0,0),">\n") 
        #debug concat("woman_max = <",vstr(3,woman_max,",",0,0),">\n") 
               */
        object {woman rotate 180*y scale 7 translate<1.9,Water_L-2.5,0>}
        object{man scale 7 translate<-3.2,Water_L-2.9,0>}         
    #end
}

#declare b_min = min_extent(boat_people);
#declare b_max = max_extent(boat_people);
#debug concat("\nboat min extent = <",vstr(3,b_min,",",0,0),">\n")
#debug concat("boat max extent = <",vstr(3,b_max,",",0,0),">\n")  

object {boat_people
        rotate boat_rot                
        scale boat_scale 
        translate boat_pos
        }

//############################################################## 

//  (2)----------( )
//   |     |      |
//   |     |      |
//   |     |      |
//  (3)----------(1) 


#if(do_man1)
    #include "man1.inc"
    object {man1 scale 1.5 rotate 90*y translate -1*y translate 3.78*x translate -0.7*z}
#end

#if(do_man2)
    #include "man2.inc"
    object {man2 scale 1.5 rotate 90*y translate -0.1*x translate -1*y translate (-0.7+3.78)*z }
#end

#if(do_man3)
    #include "man3.inc"
    object {man3 scale 1.5 rotate 90*y translate -0.9*y translate -0.8*z} 
#end
//light_source {0*x, color rgb <1,1,1> translate <3.78,0,-1.5>} 
//##########################################
#if(do_fog)
    fog {
        fog_type 2
        fog_offset 1
        fog_alt 0.5
        distance 500 
        color <0.5,0.5,0.8>*0.4
        }
#end
//##########################################