#declare Animate= 0;

#declare CSG007 = union {
  torus { // Torus001
    1.9, 0.1  rotate -x*90
    scale <1.0, 1.0, 0.2>
  }
  torus { // Torus003
    1.9875, 0.0375  rotate -x*90
    scale <1.0, 1.0, 2.0>
  }
}
#declare CSG008 = difference {
  object { CSG007 }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 0.15>
    translate  2.0*x
  }
  rotate 90.0*x
}
#declare RotSweep001 = lathe {
  quadratic_spline
  7  // control points
  <1.5, 0.05>,
  <2.0, 0.0>,
  <2.0, 0.1>,
  <1.164447, 0.448832>,
  <0.725, 0.9925>,
  <0.211565, 1.187959>,
  <0.025, 1.5>
  rotate <90,0,90>
  material {
    tuerca_txt
  }
  scale 0.5
  translate  -2.519575*z
} 
union { // mapamundi
  sphere { // bola del mundo; es la que gira
    <0,0,0>,1
    material {
      bolamundo_txt
    }
    scale 1.6
    #if (Animate)
    rotate 360*z*clock
    #else
    rotate -120.0*z
    #end
  }
  object { CSG008 }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 4.0>
    translate  -2.0*z
  }
  cone { // Cone017
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.2, 0.2, 0.3>
    translate  1.678708*z
  }
  sphere { // Sphere033
    <0,0,0>,1
    material {
      tuerca_txt
    }
    scale <0.2, 0.2, 0.1>
    translate  1.98*z
  }
  cone { // Cone018
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <-0.2, -0.2, -0.3>
    rotate -180.0*z
    translate  -1.67871*z
  }
  object { RotSweep001 }
  material {
    tornillo_txt
  }
  scale 1.25
  translate  <7.611449, 8.983305, 13.406075>
}
