//  Persistence of Vision Raytracer V3.5 beta 11
//  World definition file.
//
//  Contains 4 lights, 96 materials and 408 primitives.
//
//  This file was created by Txemi Jendrix inspiriens 
// http://www.geocities.com/txemijendrix
// tji@euskalnet.net
//

//  Date : 02/27/2002    (27.02.2002)
//


#declare Radiosidad= 1;

#if (Radiosidad)
default {
  texture {
    pigment { rgb <1,0,0> }
  finish {ambient 0.0}}
}
#else
default {
  texture {
    pigment { rgb <1,0,0> }
  }
}
#end

#if (Radiosidad)

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.04
    count 300

    nearest_count 5
    error_bound .5
    recursion_limit 2

    low_error_factor .5
    gray_threshold 0.0
    minimum_reuse 0.015
    brightness 1.1

    adc_bailout 0.01/2

  }
}


#else
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}
#end

background { color <0.000,0.000,0.000> }

camera {  //  Camera SpotCam001
  location  <    -14.000,     -55.000,      18.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.65363,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         45.00000    // Vertical      28.125
  look_at   <      1.400,       7.600,       8.300>
}


//
// *******  L I G H T S *******
//

#if (Radiosidad)

light_source {   // luz lampara
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.7, 0.000>
  translate  <-5.75, 13.67, 14.5>
  fade_power 2
  fade_distance 5
}
/*
light_source {   // luz de relleno
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.850>*0.6
  translate  <-14.0, -55.25, 18.0>
  fade_power 2
  fade_distance 25.0
  shadowless
}
*/
light_source {   // luz techo
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.850> //1.025
  area_light <1.000, 0.000, 0.000>, <0.000, 1.000, 0.000>, 2, 2
  adaptive 2   
  jitter
  circular
 orient
  translate  <0.0, -20.0, 36.5> 
    fade_power 2
  fade_distance 36
}

#else
light_source {   // luz lampara
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.7, 0.000>
  translate  <-5.75, 13.67, 14.5>
  fade_power 2
  fade_distance 5
}

light_source {   // luz de relleno
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.850>*0.6
  translate  <-14.0, -55.25, 18.0>
  fade_power 2
  fade_distance 25.0
  shadowless
}

light_source {   // luz techo
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.850> //1.025
  area_light <1.000, 0.000, 0.000>, <0.000, 1.000, 0.000>, 2, 2
  adaptive 2   
  jitter
  circular
 orient
  translate  <0.0, -20.0, 36.5> 
    fade_power 2
  fade_distance 36
}
#end

//
// ********  MATERIALS  *******
//

#if (Radiosidad)
#include "playingRad.inc"
#else
#include "playing.inc"
#end
//
// **********  OBJECTS  ********
// 

// ********* El chico / The kid ***********

#include "kidsupper.pov"   

object { kid
#declare tam= 25;
scale <-tam,-tam,-tam>
rotate <-90,0,-75>  

translate <-6.0, -10.0, 0.0>  
}

// ************ La habitacion / The room **********
#include "habitacion.inc"

 
// ************ La alfombra / The carpet **********
box { // alfombra_isla
  <-1, -1, -1>, <1, 1, 1>
  material {
    alfombra_isla_txt
  }
  scale <20.0, 13.8, 0.01>
  rotate -180.0*z
  translate  <-0.183014, -11.255375, 0.0>
} 

// ************ El reloj / The clock ********** 
#include "reloj.inc"

// ************ El corcho / The board **********
#include "corcho.inc"

// ************ La mesa / The desk **********
#include "mesa.inc"

// ************ El cuaderno de dibujos / The drawing book **********
#include "revista.inc"

// ************ La taza y los lapices / The jar and the pencils **********
#include "tazaylapices.inc"

// ************ Los libros de comix / The comix books **********
#include "mortadelo.inc"

// ************ El globo terraqueo / The world globe **********
#include "bolamundo.inc"

// ************ La lampara / The lamp **********
#include "lampara.inc"

// ************ Los jerseys / The pullovers **********   
#include "jerseys.inc"

// ************ Las perchas / The hangers **********
#include "perchas.inc"

// ************ Las camisas / The shirts **********
#include "camisas.inc"

// ************ El armario empotrado / The in-built cupboard **********
#include "armario.inc"

// ************ El alien / The alien **********
#include "alien.inc"

// ************ El enchufe / The plug **********  
#include "enchufe.inc"

// ************ La silla / The chair **********
#include "silla.inc"

// ************ El dinosaurio azul / The blue dinosaur **********
#include "gusano.inc"

// ************ El correpasillo / The baby walker **********
#include "correpasillo.inc"

// ************ La papelera / The trash can **********
#include "papelera.inc"

// ************ Bart Simpson / Bart Simpson **********
#include "bart.inc"

// ************ La nave de juguete / The toy spaceship **********
#include "nave_toy.inc"

// ************ Las torres / The towers **********
#include "torre.inc"

// ************ El cohete de Tintin / The Tintin rocket **********
#include "cohete.inc"

// ************ El tablero y las fichas / The chessboard and the pieces **********
#include "damero.inc"

// ************ La pelota / The ball **********
#include "pelota.inc"

// ************ El cojin / The cushion **********
#include "cojin.inc"

// ************ El coche / The car **********
#include "coche.inc"
