//linked worlds within worlds
//by tek


//scene controls

#declare fBmod = 1;

#declare gboClumps = off;
#declare gboGrass = on;
#declare gnTraceLevel = 12;


//includes

#include "rad_def.inc"
#include "functions.inc"

#include "linkship.inc"


//global set up

global_settings {
	max_trace_level gnTraceLevel
	radiosity {
    //Rad_Settings(Radiosity_Default, off, off)
    Rad_Settings(Radiosity_Debug, off, off)
    //Rad_Settings(Radiosity_Fast, off, off)
    //Rad_Settings(Radiosity_Normal, off, off)
    //Rad_Settings(Radiosity_2Bounce, off, off)
    //Rad_Settings(Radiosity_Final, off, off)

    //Rad_Settings(Radiosity_OutdoorLQ, off, off)
    //Rad_Settings(Radiosity_OutdoorHQ, off, off)
    //Rad_Settings(Radiosity_OutdoorLight, off, off)
    //Rad_Settings(Radiosity_IndoorLQ, off, off)
    //Rad_Settings(Radiosity_IndoorHQ, off, off)
	}
}

#default { finish { diffuse 1/fBmod ambient 0 } }


//objects

#declare gfLinkThickness = 500;//0.5;
#declare gnLinksNum = 20;


#declare oHighLODSphere =
	sphere {
		#declare vHighLODSpherePos = <135.5,238.418,-689.500>;
		#declare fHighLODSphereRad = 100;
		vHighLODSpherePos, fHighLODSphereRad
	}
	
//debug: actually draw the sphere, for evaluation purposes
//object {
//	oHighLODSphere
//	
//	hollow on
//	
//	pigment {
//		gradient y
//		scale 2
//		translate -y
//		scale 100
//		translate 238.418*y
//		cubic_wave
//		colour_map {
//			[0.15 rgbt <1,0,0,1>]
//			[0.50 rgbt <1,0,0,0.75>]
//			[0.85 rgbt <1,0,0,1>]
//		}
//	}
//	finish {
//		ambient 1
//	}
//}

//noise function, for adding dispersion to the edges of clumps
#declare f_Noise =
	function {
		pigment {
			spotted
			colour_map {
				[0	rgb -0.5]
				[1	rgb 0.5]
			}
		}
	}

//CLUMPS
#declare CLUMP_PICK_RANDOM	= 0;
#declare CLUMP_PICK_FORMULA	= 1;

#declare gnClumpTypes = 2;
#declare gnClumpObjectTypesMax = 20;
#declare ganClumpObjectAttempts = array[gnClumpTypes];
#declare gafClumpMinElevation = array[gnClumpTypes];
#declare gafClumpMaxElevation = array[gnClumpTypes];
#declare gaf_ClumpFormula = array[gnClumpTypes];
#declare ganObjectsInClump = array[gnClumpTypes];
#declare gaeClumpObjectPickType = array[gnClumpTypes];
#declare gaoClumpObject = array[gnClumpTypes][gnClumpObjectTypesMax];
#declare arsClump = array[gnClumpTypes];

#declare nClump = 0;

//clump 0 - vegetation
#declare 			ganObjectsInClump[nClump] = 1;
#declare gaeClumpObjectPickType[nClump] = CLUMP_PICK_RANDOM;
#declare ganClumpObjectAttempts[nClump] = 50000;
#declare	 gafClumpMinElevation[nClump] = 0.0;
#declare	 gafClumpMaxElevation[nClump] = gfLinkThickness;
#declare f_Func1 =
	function {
		pigment {
			bozo
			scale gfLinkThickness
			pigment_map {
				[0.1		rgb -1]
				[0.55	rgb 0]
				[1		rgb 1]
			}
		}
	}
#declare f_Func2 =
	function {
		pigment {
			bozo
			scale 0.23//0.4
			colour_map {
				[0		rgb ganObjectsInClump[nClump]]
				[0.4	rgb 0]
				[0.5	rgb -ganObjectsInClump[nClump]/5]
				[0.6	rgb 0]
				[1		rgb ganObjectsInClump[nClump]]
			}
		}
	}
#declare gaf_ClumpFormula[nClump] =
	function {
		( f_Func1(x,y,z).red * f_Func2(x,y,z).red )
	}
#declare gaoClumpObject[nClump][0] =
	/*cone {
		0, 2, y*8, 0
		scale 1
		pigment { rgb <0.03,0.6,0.14> }
	}*/
	merge {
		sphere {
			y*6, 2
			pigment {
				crackle
				solid
				scale 0.1
				colour_map {
					[0.0	rgb <0.4,0.3,0.03>]
					[0.7	rgb <0.07,0.4,0.03>]
					[0.7	rgbt <0.07,0.4,0.03,1>]
				}
			}
		}
		cylinder {
			0, y*6, 0.3
			pigment { rgb <0.2,0.04,0.0> }
		}
		scale 1
	}
#declare arsClump[nClump] = seed(2011);


#declare nClump = nClump+1;

//clump 1 - buildings
#declare 			ganObjectsInClump[nClump] = 2;
#declare gaeClumpObjectPickType[nClump] = CLUMP_PICK_FORMULA;
#declare ganClumpObjectAttempts[nClump] = 25000;
#declare	 gafClumpMinElevation[nClump] = 0.0;
#declare	 gafClumpMaxElevation[nClump] = gfLinkThickness;
#declare gaf_ClumpFormula[nClump] =
	#local f_Func =
		function {
			pigment {
				bozo
				scale gfLinkThickness/4
				colour_map {
					[0		rgb ganObjectsInClump[nClump]]
//							[0.4	rgb 0]
					[0.6	rgb 0]
					[1.2	rgb -ganObjectsInClump[nClump]]
//							[1		rgb ganObjectsInClump[nClump]]
				}
			}
		}
	function {
		f_Func(x,y,z).red +
		f_Noise(x,y,z).red*0.3
		//+ 1
	}
#declare gaoClumpObject[nClump][0] =
	box {
		<-4,0,3>, <4,5,3>
		//scale 1
		pigment { rgb <0.9,0.8,0.6> }
	}
#declare gaoClumpObject[nClump][1] =
	box {
		<-3,0,3>, <3,8,3>
		//scale 1
		pigment { rgb <0.9,0.8,0.6> }
	}
#declare arsClump[nClump] = seed(2011);





//macro to rotate something pointing along z to point in a given direction.
#macro m_RotateFromDir(vDir)
	#local fHor = sqrt(vDir.x*vDir.x + vDir.z*vDir.z);
		<
			degrees(atan2(vDir.y,fHor)),
			degrees(atan2(vDir.x,vDir.z)),
			0
		>
#end//macro


//compute a random 3D position on the surface of a torus, with an even distribution across that surface.
#macro m_ComputeRandOnTorus(rsSeed, fMajRad, fMinRad)
	#local fMajAngle = 2*pi*rand(rsSeed); //easy part
	
	//compute min angle so that the probability distribution is even, i.e. weight by inverse of the local surface area.
	//are we confused yet?
	#local fMinAngle = rand(rsSeed)*2 - 1;
	//meaure min angle from pointing inwards to pointing out, so 0 = pointing to centre of majrad
	//#local fMinAngle = fMinAngle + amount based on relative surface areas; //todo. Just can't get my head round it at the moment.

	#local fMinAngle = pi * fMinAngle;
	
	//easy bit, compute position:
	#local vPos = -fMinRad*z;
	#local vPos = vrotate( vPos, degrees(fMinAngle)*x );
	#local vPos = vPos + fMajRad*z;
	#local vPos = vrotate( vPos, degrees(fMajAngle)*y );
	
	#declare vRandOnTorus_Pos = vPos;

	//and normal	
	#local vNorm = -z;
	#local vNorm = vrotate( vNorm, degrees(fMinAngle)*x );
	#local vNorm = vrotate( vNorm, degrees(fMajAngle)*y );
	
	#declare vRandOnTorus_Norm = vNorm;
	
#end

//access functions for the above
#macro m_GetRandOnTorusPos()
	vRandOnTorus_Pos
#end

#macro m_GetRandOnTorusNorm()
	vRandOnTorus_Norm
#end


#declare gfGrassHeight = 0.3;

#declare oLandHighRes =
	//same as land index 0, but with shed loads more stuff!
	intersection {
		object { oHighLODSphere }
		
		#local fRidgeScale = gfLinkThickness * 0.6;
		#local fPeakScale = gfLinkThickness * 0.025;
		#local fLoRidgeScale = fRidgeScale/35;
		#local fLoPeakScale = fPeakScale/40;
		#local nShiftIndex = -1;
		isosurface {
			function {
				f_torus(x,y,z, gfLinkThickness*1.5, gfLinkThickness/2)
				+ //ONLY increase the value, we want to keep it inside the torus.
				fPeakScale * (1.8 - f_ridged_mf((nShiftIndex*gfLinkThickness*8 + x)/fRidgeScale,y/fRidgeScale,z/fRidgeScale, 0.5,2.7, 4 ,1,1.5,0))
				+ //add smaller surface detail.
				fLoPeakScale * (1.8 - f_ridged_mf(x/fLoRidgeScale,y/fLoRidgeScale,z/fLoRidgeScale, 0.3,1.8, 5, 1.2,1.5,0))
				- 1
			}
			max_gradient 2
			all_intersections
			contained_by { sphere { 0, gfLinkThickness*2 } }

			translate -gfGrassHeight*y
		
		} //isosurface
		
	} //intersection
	
#declare oLandHighResT =
	object {
		oLandHighRes

		#if ( gboGrass & false )
			//the foreground is entirely grassy, so just colour the ground as earth.
			texture {
				pigment {
					//placeholder for grass
					rgb <0.1,0.7,0.15>
				}
			} //texture
		#else
			//the foreground is entirely grassy, so just colour the ground as earth.
			texture {
				pigment {
					crackle
					solid
					colour_map {
						[0.1	rgb 0]
						[0.1	rgb <0.42,0.27,0.18>]
						[0.9	rgb <0.42,0.27,0.18>]
						[0.9	rgb 0.7]
					}
				}
			} //texture
		#end
	}


//grass on hires ground
#declare oGrass =
	intersection {
		object { oHighLODSphere }

		//difference {
			object { oLandHighRes translate gfGrassHeight*y }
			//object { oLandHighRes }
		//}
		
		hollow on
		
		material {
			texture {
				pigment { rgbt 1 }
				finish {
					ambient 0
					diffuse 0
					specular 0
					reflection 0
				}
			}
			interior {
				//ior -1
				media {
					scattering {
						1, rgb <0.1,0.7,0.15>
						extinction 0
					}
					absorption 1.0

					//none of this is making it faster => this isn't the slow bit!					
					//aa_level 2 //4
					//aa_threshold 0.3//0.1
					//jitter //off by default
					
					density {
						spotted
						scale <0.03,10,0.03>
						warp {
							turbulence 0.2
							octaves 4
						}
						colour_map {
							[0.4	rgb 5]
							[0.4	rgb 0]
							[0.6	rgb 0]
							[0.6	rgb 5]
						}
					} //density
				} //media
			} //interior
		} //material
	} //intersection
/*
VERY slow and I can't get good coverage!!??
	merge {
		#local rsGrass = seed(63455); //GRASS-63455, it's the closest I could get!
		#local nBlade = 0;
		#while ( nBlade < 100000 )
	
			#local fAng = rand(rsGrass)*pi/2 - pi/4; //just in area in front of cam.
			#local fRad = pow(rand(rsGrass),2);
			#local vPos = fRad * <sin(fAng),0,cos(fAng)>;//<rand(rsGrass)*2 - 1,0,rand(rsGrass)*1.1 - 0.1>;
			#local vPos = vPos * fHighLODSphereRad + vHighLODSpherePos;
			#local vNorm = <0,0,0>;
			
			#local vPos = trace( oLandHighRes, vPos+y*100, -y, vNorm );
			
			#local vWind = <0.2,0.05,0.2>*vturbulence( 2, 0.5, 3, vPos );
			
			#if ( vNorm.y > 0 )
			
				//blade of grass
				triangle {
					<0.05, -0.1, 0>, <-0.05, -0.1, 0>, <0.0, 0.3, 0>+vWind 
					
					translate vPos
					
					pigment {
						rgb <0.2,0.8,0.4>
					}
				}
			
			#end		
		
			#local nBlade = nBlade + 1;
		#end //while
	}
*/



#macro m_LinkWorld(nIndex)
	#local oLand =
		#if ( nIndex = 0 )
			//higher LOD on local ground
			merge {
				object { oLandHighResT }
	
				intersection {
					object { oHighLODSphere inverse }
		#else
			object {
				object {
		#end
					//land
					#local fRidgeScale = gfLinkThickness * 0.6;
					#local fPeakScale = gfLinkThickness * 0.025;
					#local nShiftIndex = nIndex - 1;
					isosurface {
						function {
							f_torus(x,y,z, gfLinkThickness*1.5, gfLinkThickness/2)
							+ //ONLY increase the value, we want to keep it inside the torus.
							fPeakScale * (1.8 - f_ridged_mf((nShiftIndex*gfLinkThickness*8 + x)/fRidgeScale,y/fRidgeScale,z/fRidgeScale, 0.5,2.7, 4 ,1,1.5,0))
						}
						max_gradient 2
						contained_by { sphere { 0, gfLinkThickness*2 } }
			
						texture {
							pigment {
								spotted
								turbulence 0.3
								translate -1
								scale gfLinkThickness
								colour_map {
									[0.3	rgb <0.9,1,0.7>]
									[0.6	rgb <0.2,0.8,0.4>]
									[0.73	rgb <0.01,0.55,0.1>]
									[0.77	rgb <0.15,0.6,0.3>]
									[0.8	rgb <0.9,1,0.7>]
								}
							}
							finish {
								diffuse 1/fBmod
							}
			
							translate nShiftIndex*gfLinkThickness*8*x
						}
					}
				} //intersection
			} //merge
		
	#local oSea =
		torus {
			gfLinkThickness*1.5, gfLinkThickness*0.485

			texture {			
				pigment { rgb <0.05,0.2,0.1> }
				finish {
					diffuse 0.3/fBmod
					reflection { 0.5, 1.0 }
					conserve_energy
				}
				normal {
					crackle 0.1
					turbulence 0.3
					scale gfLinkThickness*0.001
				}
				translate nIndex*gfLinkThickness*8*x
			}
		}

	union {

		object { oLand }	
		
		//sea
		object { oSea }	
		

		#if ( nIndex = 0 & gboGrass )
			//hi-res details
			object { oGrass }
		#end
		

		#if ( nIndex < 2 & gboClumps )
			//Details!

			//Clumped objects.
			union {
				#local nClump = 0;
				#while ( nClump < gnClumpTypes )
				
					#local nLoop = 0;
					#while ( nLoop < ganClumpObjectAttempts[nClump] )
					
						//pick a pos, test if it's inside the clumping formula.
						m_ComputeRandOnTorus(arsClump[nClump], gfLinkThickness*1.5, gfLinkThickness*0.5)
						#local vPos = m_GetRandOnTorusPos();
						#local vNorm = m_GetRandOnTorusNorm();
						
						#if ( gaf_ClumpFormula[nClump](vPos.x+nIndex*gfLinkThickness*8,vPos.y,vPos.z) > 0 )
			
							//fire ray
							#local vLandNorm = <0,0,0>;
							#local vLandPos = trace( oLand, vPos+vNorm*100, -vNorm, vLandNorm );
							#local vSeaNorm = <0,0,0>;
							#local vSeaPos = trace( oSea, vPos+vNorm*100, -vNorm, vSeaNorm );
							
							#local fElevation = vdot(vLandPos,vNorm) - vdot(vSeaPos,vNorm);
							
							//modify this to check a per-clump value that determines whether to sit on the ground or on the sea
							#local vPos = vLandPos;
							#local vNorm = vLandNorm; //may want to use a function of vnorm and vlandnorm.
							
							#if ( ( fElevation >= gafClumpMinElevation[nClump] )
									& ( fElevation <= gafClumpMaxElevation[nClump] ) )
								
								object {
								
									//determine object type
									#switch ( gaeClumpObjectPickType[nClump] )
									 
										#case (CLUMP_PICK_RANDOM)
											//pick an object
											#local nObject = int( rand(arsClump[nClump]) * ganObjectsInClump[nClump] );
	
											//actually make the thing:										
											gaoClumpObject[nClump][nObject]
										#break
										
										#case (CLUMP_PICK_FORMULA)
											//pick an object
											#local nObject = int( gaf_ClumpFormula[nClump](vPos.x,vPos.y,vPos.z) );
											#if ( nObject >= ganObjectsInClump[nClump] )
												#warning concat("Clump ", str(nClump,3,0), " formula returned object out of range")
												#local nObject = ganObjectsInClump[nClump] - 1;
											#end
	
											//actually make the thing:										
											gaoClumpObject[nClump][nObject]
										#break
										
									#end //switch
	
									//point upwards
									rotate rand(arsClump[nClump])*360*y
									rotate <90,0,0>//point along z
									
									//rotate m_RotateFromDir(vNorm)
									//leave it pointing vertically out from ground, not perp to surface (trees and buildings grow upwards!)
									rotate m_RotateFromDir(m_GetRandOnTorusNorm())
																	
									translate vPos
									
								}//object
							
							#end //if it's within clump's elevation band
							
						#end //if it's within the clump
					
						#local nLoop = nLoop + 1;
					#end //object loop
				
					#local nClump = nClump + 1;
				#end //clump loop
				
				clipped_by {
					object { oHighLODSphere inverse }
				}
				
			}//union
			
		#end //if ( nIndex < 2 )


		bounded_by {
			//save poor old pov from having to think too hard
			torus {
				gfLinkThickness*1.5, gfLinkThickness*0.6
			}
		}		
		
	}//union
#end


#declare f_Grav =
	function(d, fScale) {
		fScale/(d*d+1)
	}


#declare oChain =
	union {
		#local vPos = <0,0,0>;
		#local vRot = <0,0,0>;
		#local avPos = array[gnLinksNum];
		#local nLink = 0;
		#while (nLink < gnLinksNum)
		
			object {
				m_LinkWorld(nLink)

				#if (nLink > 0)
					#local vRot = vRot + <0,10,3>/2;
				#end

				rotate <0,0,mod(nLink,4)*90>
				rotate vRot
				translate vPos
				#local avPos[nLink] = vPos;

				#local vRot = vRot + <0,10,3>/2;

				#local vForwards = vrotate( z, vRot );				
				#local vPos = vPos + gfLinkThickness*2*vForwards;
			}
			
			#local nLink = nLink + 1;
		#end //while
		
			
		merge {
			//big enclosing shape
			sphere {
				gfLinkThickness*(gnLinksNum+1)*z, gfLinkThickness*(gnLinksNum+1) + gfLinkThickness*20
			}
			
			hollow on
			
			material {
				texture {
					pigment { rgbt 1 }
				}
				interior {
					media {
						scattering {
							1, rgb <0.4,0.6,1>//*0.3
							extinction 0.5
						}
						//absorption 1

						aa_level 3 //pov default 4
						aa_threshold 0.2 //pov default 0.1
					
						density {
						  function {
								//ATMOSPHERE IDEA: use blob pigment on a media, one centre for each toroid (write above vals into an array, to avoid duplicate code).
								#local nLink = 0;
								#while (nLink < gnLinksNum)
									#local fX = avPos[nLink].x;
									#local fY = avPos[nLink].y;
									#local fZ = avPos[nLink].z;
								
								  f_Grav(f_sphere(x-fX,y-fY,z-fZ,0), gfLinkThickness*4)
								  //needs rotation. could just whack into the definition of link, since the formulas are being added.
								  //f_Grav(f_torus(x-fX,y-fY,z-fZ,gfLinkThickness*1.5, gfLinkThickness/2), gfLinkThickness*1)//gfLinkThickness*4)
								  +
								  
									#local nLink = nLink + 1;
								#end //while
								0.0
							}
							
							density_map {
								[0.0	rgb 0]
								[1.0	rgb 0.1]
							}
						}
					}
				}
			}
		}
	}

//the scene

camera {
	#declare image_dim = sqrt(image_width*image_height); //kind of average dimension
	right			x*image_width/image_dim
	up				y*image_height/image_dim
	direction	z*0.5
	
	location 0//<0,100,-0.1>
	look_at <1,2,5>

//	#declare vCamPos = <gfLinkThickness*0.27,gfLinkThickness*0.51,-gfLinkThickness*1.38>;
	#declare vCamPos = <gfLinkThickness*0.27,gfLinkThickness*0.51,-gfLinkThickness*1.38>;
	#declare vCamPos = trace( oLandHighRes, vCamPos+y*1000, -y );//trace( oChain, vCamPos+y*1000, -y );
	#declare vCamPos = vCamPos + (gfGrassHeight + 0.35)*y;//0.2m above ground
	translate vCamPos

	//high lod plan view
//	location vCamPos + 200*y - 20*z
//	look_at vCamPos
	
	//orbital camera
//	location gfLinkThickness*<30,30,-30>
//	look_at <0,0,gfLinkThickness*20>
}

light_source {
	<-1,3,-2>*10000
	rgb fBmod*1
}

//some fake lights because media are rubbish at giving radiosity.
#declare fAmbience = 0.5;
light_source {
	-x*1000*gfLinkThickness
	rgb <0.4,0.6,1>*0.3*fAmbience
	shadowless
	media_interaction off
}

light_source {
	-z*1000*gfLinkThickness
	rgb <0.4,0.6,1>*0.1*fAmbience
	shadowless
	media_interaction off
}

light_source {
	z*1000*gfLinkThickness
	rgb <0.4,0.6,1>*0.5*fAmbience
	shadowless
	media_interaction off
}

light_source {
	y*1000*gfLinkThickness
	rgb <0.4,0.6,1>*0.4*fAmbience
	shadowless
	media_interaction off
}

light_source {
	x*1000*gfLinkThickness
	rgb <0.4,0.6,1>*0.3*fAmbience
	shadowless
	media_interaction off
}

object { oChain }

object {
	oShip
	rotate <0,0,0>
	scale 0.75
	translate vCamPos + <15,9,12>
}

