// *********************************************************
// FAST GRASS INCLUDE FILE FOR PERSISTENCE OF VISION 3.5
// *********************************************************
// 
// Created by Rune S. Johansen, September 2001
// 
// See "fgrass.txt" for more information.
// 
// *********************************************************
   
   #include "functions.inc"
   #include "strings.inc"
   
   #macro fg_ground (Scale,GroundColor,GrassColor,Map)
      pigment {
         #local CalcMap = (strlen(Map)>0);
         #if (CalcMap) #local FMap = function(x,y,z){Parse_String(Map)(x,y,z)} #end
         function {
            #if (CalcMap)  min(1,max(0,  #end
            0.2-0.4*f_noise3d(x/Scale*5,y/Scale*5,z/Scale*5)
            #if (CalcMap)  +min(1,FMap(x,y,z)) ))  #end
         }
         color_map {
            [0.8, color GroundColor]
            [1.0, color GrassColor ]
         }
      }
   #end
   
   #macro fg_grass (CamLoc,Scale,Color,Turb,Seed,Map)
      pigment {
         #local F = 20;
         #local Vx = CamLoc.x;
         #local Vy = CamLoc.y-Seed*8;
         #local Vz = CamLoc.z;
         #local CalcMap = (strlen(Map)>0);
         #if (CalcMap) #local FMap = function(x,y,z){Parse_String(Map)(x,y,z)} #end
         function {
            #if (CalcMap)  min(1,max(0,  #end
            f_noise3d(
               sin(atan2(x/Scale,z/Scale)*F)*sqrt((x/Scale)^2+(z/Scale)^2)/0.3,
               Seed*8,
               cos(atan2(x/Scale,z/Scale)*F)*sqrt((x/Scale)^2+(z/Scale)^2)/0.3
            )
            #if (CalcMap)  -0.3 +0.3*min(1,FMap(x+Vx,y+Vy,z+Vz)) ))  #end
         }
         warp {turbulence Turb octaves 2}
         translate CamLoc-Seed*8*y
         color_map {
            [0.60, color transmit 1]
            [0.60, color Color*0.5 ]
            [0.70, color Color*0.9 ]
            [0.85, color Color*1.0 ]
            [0.95, color rgb 1     ]
         }
      }
   #end
/*   
   #macro fg_flowers (Scale,Color,Seed,Map)
      pigment {
         #local CalcMap = (strlen(Map)>0);
         #if (CalcMap) #local FMap = function(x,y,z){Parse_String(Map)(x,y,z)} #end
         #local FPat = function{pattern{crackle form x}}
         function {
            #if (CalcMap)  min(1,max(0,  #end
            1-FPat(x/Scale*1.5,y/Scale*1.5+Seed*8,z/Scale*1.5)
            #if (CalcMap)  -0.3 +0.3*min(1,FMap(x,y+Seed*8,z)) ))  #end
         }
         scale 30 warp {turbulence 1} scale 1/30
         translate Seed*8*y
         color_map {
            [0.85, color transmit 1]
            [0.85, color Color*0.6]
            [0.90, color Color*0.9]
            [1.00, color Color*1.0]
         }
      }
   #end
*/   
   #macro fg_quick_grass (CamLoc,Scale,Map)
      #local GrassNormal = normal {bumps 0.5 scale 2 warp{turbulence 2} scale Scale}
      texture {fg_ground(Scale,<0.33,0.25,0.18>,<0.20,0.25,0.15>,Map) normal {bumps 0.5 scale 0.01*Scale}}
      texture {fg_grass(CamLoc,Scale,<0.5,0.7,0.5>,0.2,2,Map) normal {GrassNormal}}
      texture {fg_grass(CamLoc,Scale,<0.6,0.7,0.3>,0.2,3,Map) normal {GrassNormal}}
      texture {fg_grass(CamLoc,Scale,<0.5,0.6,0.4>,0.2,1,Map) normal {GrassNormal}}
      texture {fg_grass(CamLoc,Scale,<0.7,0.7,0.4>,0.2,4,Map) normal {GrassNormal}}
      texture {fg_grass(CamLoc,Scale,<0.6,0.8,0.4>,0.2,5,Map) normal {GrassNormal}}
   #end
   
   #macro fg_quick_grain (CamLoc,Scale,Map)
      #local GrainNormal = normal {bumps 0.5 scale 2 warp{turbulence 2} scale Scale*2}
      texture {fg_ground(2*Scale,<0.33,0.25,0.18>,<0.30,0.30,0.15>,Map) normal {bumps 0.5 scale 0.02*Scale}}
      texture {fg_grass(CamLoc,2*Scale,<0.9,0.7,0.4>,0.03,1,Map) normal {GrainNormal}}
      texture {fg_grass(CamLoc,2*Scale,<0.8,0.8,0.4>,0.03,2,Map) normal {GrainNormal}}
      texture {fg_grass(CamLoc,2*Scale,<0.9,0.8,0.5>,0.03,3,Map) normal {GrainNormal}}
      texture {fg_grass(CamLoc,2*Scale,<0.9,0.8,0.4>,0.03,4,Map) normal {GrainNormal}}
   #end
   