#version 3.5;

camera {
  orthographic
  location <0,10,0>     
  look_at  <0,0,0>
  right 1*x            
  up z             
}

#declare ground = union {
        light_source {
                0*x                   
                color rgb 1000     
                spotlight               
                translate <0,-3.3,-30>
                point_at <0,0.5,8>      
                radius 120               
                tightness 1            
                falloff 0              
        }
        #declare hfscalx = 70;
        #declare hfscaly = 10;
        #declare hfscalz = 70;
        height_field { 
                png "hf6" smooth         
                translate -0.5
                scale <hfscalx,hfscaly,hfscalz>
                texture {
                        pigment {color rgb 1}
                        finish {ambient 0 diffuse 1}
                }
                translate <0,-1.75,0>
        }
}

object {ground scale <1/70,1/70,1/70>}

