/* wire.inc - wire macro for pov
Created:     2002.02.24.11.00
Last edited: 2002.02.24.12.10
By:          William de Beaumont
*/

#macro Wire (points,rad)
 union
 {
  cylinder {points[0],points[1],rad}
  #local pcnt=1;
  #while (pcnt<dimension_size(points,1))
   sphere {points[pcnt-1],rad}
   cylinder {points[pcnt-1],points[pcnt],rad}
   #local pcnt=pcnt+1;
  #end
 }
#end
//array of wire points (to be filled), initial point, initial delta,
// delta x mult, delta y mult, random seed
#macro RandWire(points,cpoint,delta,dxm,dym,rs)
 #local pcnt=0;
 #while (pcnt<dimension_size(points,1))
  #declare points[pcnt]=cpoint;
  #declare delta=delta+<rand(rs)*dxm-dxm/2,rand(rs)*dym-dym/2,0>;
  #declare cpoint=cpoint+delta;
  #local pcnt=pcnt+1;
 #end
#end
