// Persistence of Vision Ray Tracer Scene Description File
// File: ruby_shoe.inc
// Vers: 3.5 
// Desc: Worlds Within Worlds                                  
// Date: Feb 2002
// Auth: Jim Charter  

#declare throat_inner = spline { cubic_spline
                                0, <6, 3.5, 0>
                                .16, <9, 4.5, 0>
                                .40, <15, 6.2, 3>
                                .68, <22, 9.0, 2.5>
                                .92, <28, 11.5, 2.0> 
                                1, <29.5, 12.0, 0>

                        }
#declare break_inner = spline { cubic_spline
                                0, <1, 2, 0>                                 
                                .09, <5, 2, 3>
                                .21, <9,2.8,  4.0>
                                .39, <15, 4.5, 4.5>
                                .66, <22, 6.5, 3.0> 
                                .86, <28, 8.5, 3.0>
                                1, <30.5, 9.5, 0>
                        }                         
#declare sole_inner = spline {  cubic_spline
                                0, <0, 0, 0>                                 
                                .07, <2, 0, 2>
                                .29, <9, 0, 5>
                                .49, <15, 1, 3.1>
                                .72, <22, 3.0, 2.5> 
                                .92, <28, 5.0, 2.5>
                                1, <30, 5.5, 0>
                        } 
#declare bot_inner = spline {  cubic_spline
                                0, <0, -.5, 0>                                
                                .07, <1.5, -.5, 2>
                                .29, <9, -.5, 4.5>
                                .49, <15, .5, 2.6>
                                .72, <22, 2.5, 2.0> 
                                .92, <28, 4.5, 2.0>
                                1, <29.5, 5.0, 0>
                        } 

#declare throat_outer = spline { cubic_spline
                                0, <6, 3.5, 0>
                                .16, <9, 4.5, 0>
                                .40, <15, 6.2, -3>
                                .68, <22, 9.0, -2.5>
                                .92, <28, 11.5, -2.0> 
                                1, <29.5, 12.0, 0>

                        }
#declare break_outer = spline { cubic_spline
                                0, <1, 2, 0>                                 
                                .09, <5, 2, -3>
                                .21, <9,2.8,  -4.0>
                                .39, <15, 4.5, -4.5>
                                .66, <22, 6.5, -3.0> 
                                .86, <28, 8.5, -3.0>
                                1, <30.5, 9.5, 0>
                        }                         
#declare sole_outer = spline {  cubic_spline
                                0, <0, 0, 0>                                 
                                .07, <2, 0, -2>
                                .29, <9, 0, -5>
                                .49, <15, 1, -3.1>
                                .72, <22, 3.0, -2.5> 
                                .92, <28, 5.0, -2.5>
                                1, <30, 5.5, 0>
                        }
#declare bot_outer = spline {  cubic_spline
                                0, <0, -.5, 0>                                
                                .07, <1.5, -.5, -2>
                                .29, <9, -.5, -4.5>
                                .49, <15, .5, -2.6>
                                .72, <22, 2.5, -2.0> 
                                .92, <28, 4.5, -2.0>
                                1, <29.5, 5.0, 0>
                        } 
                                                
#declare heel_top = spline {  cubic_spline
                                0, <24, 4, .8>
                                
                                .15, <24,     4,   3>
                                .35, <28,   5.8,   3>
                                .50, <29.5, 6.0,  .0>
                                .65, <28,   5.8,  -3>           
                                .85, <24,     4,  -3> 
                                
                                1, <24, 4, .8>
                        } 
             
#declare heel_mid = spline { cubic_spline 
                                0, <24, 2, .8> 
                                
                                .15, <24,     2,  2>
                                .35, <26,   2.8,  2>
                                .50, <28.5, 3.0,  0.0>
                                .65, <26,   2.8, -2>           
                                .85, <24,     2, -2>
                                
                                1, <24, 2, .8>
                        }
#declare heel_bot = spline {  cubic_spline
                                0,   <24,     -2,   .8> 
                                
                                .15, <24,     -2,  2.0>
                                .35, <25.5, -2.5,  2.0>
                                .50, <27.5,   -3,  0.0>
                                .65, <25.5, -2.5 ,-2.0>           
                                .85, <24,     -2, -2.0> 
                                
                                1,   <24,     -2,   .8>
                        } 

                        
#declare bow_outer = spline {  cubic_spline
                                0,   <  5,    3.05,   -2.5> 
                                
                               
                                .50, <7.5,    3.45,   -3.0>
                                
                                
                                1,   < 10,    3.85,   -3.5>
                        } 
#declare bow_mid  = spline {  cubic_spline
                                0,   <  6,    4.05,   0> 
                                
                               
                                .50, <7.5,    4.45,   0>
                                
                                
                                1,   < 10,    4.85,   0>
                        }                                                        
#declare bow_inner = spline {  cubic_spline
                                0,   <  5,    3.05,    2.5> 
                                
                               
                                .50, <7.5,    3.45,    3.0>
                                
                                
                                1,   < 10,    3.85,    3.5>
                        }                                 
 
#fopen  slipper "ruby_slipper.inc" write

 
#write ( slipper, "#declare ruby_slipper = \n union { \n" ) 

        #write ( slipper, "\n union { \n" )
        
                #declare Prev_inner = array [ 15 ];     
                #declare Prev_outer = array [ 15 ];               
               #local a=-.5;#while(a<41)
                           
                       #local p0 = <0,0,0>+throat_inner( a/40 );                       
                       #local p1 = <0,0,0>+break_inner ( a/40 );                     
                       #local p2 = <0,0,0>+sole_inner  ( a/40 );
                       #local p3 = <0,0,0>+bot_inner   ( a/40 );                     
                       #local p4 = <0,0,0>+throat_outer( a/40 );                   
                       #local p5 = <0,0,0>+break_outer ( a/40 );                
                       #local p6 = <0,0,0>+sole_outer  ( a/40 );
                       #local p7 = <0,0,0>+bot_outer   ( a/40 );
                       
                       #local sequines_inner = spline {  cubic_spline                
                                                     0, p0
                                                    .5, p1
                                                    .9, p2
                                                    1,  p3
                                         }
                       #local sequines_outer = spline {  cubic_spline                
                                                     0, p4
                                                    .5, p5
                                                    .9, p6
                                                    1,  p7
                                         }
                                         
                           
                       #local b=1;#while(b<12)
      
                               #if ( a=-.5 )
                               
                                       #declare Prev_inner[b] = <0,0,0>+sequines_inner( b/15 ); 
                                       #declare Prev_inner[b-1] = <0,0,0>+sequines_inner( (b-1)/15 );       
                                       #declare Prev_outer[b] = <0,0,0>+sequines_inner( b/15 );  
                                       #declare Prev_outer[b-1] = <0,0,0>+sequines_inner( (b-1)/15 );
                                       
                               #else        
                                      
                                       #local Start = <0,0,0>+sequines_inner( (b-1)/12 );
                                       #local End = <0,0,0>+sequines_inner( b/12 ); 
                                       
                                       #local Prev_Start = Prev_inner[b-1];
                                       #local Prev_End = Prev_inner[b];
                                       
                                       #local Norm = vnormalize (vcross ( Prev_inner[b]-Start, End-Start ));
                                       #local trans = (Start+((End-Start)/2))+Norm/30; 
                                                        
                                                        
                                       #write ( slipper, " \n disc { 0, y, .4, .05 texture {  t_sequines  } rotate rand(R)*1 \n
                                                         Reorient (  y, < ", str(Norm.x,7,7),",",str(Norm.y,7,7),",",str(Norm.z,7,7),"> ) \n  
                                                         translate < ",str(trans.x,7,7),",",str(trans.y,7,7),",",str(trans.z,7,7), "> }" 
                                       ) 
                                       
                                       
                                       #write ( slipper," \n triangle { <", str( Start.x,7,7 ),",",str( Start.y,7,7 ),",",str( Start.z,7,7 ),">,<",
                                                                 str( Prev_End.x,7,7 ),",",str( Prev_End.y,7,7 ),",",str( Prev_End.z,7,7 ),">,<", 
                                                                 str( End.x,7,7 ),",",str( End.y,7,7 ),",",str( End.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining } interior_texture {  it_ruby_lining } }" 
                                       )                          
                                       #write ( slipper," \n triangle { <", str( Start.x,7,7 ),",",str( Start.y,7,7 ),",",str( Start.z,7,7 ),">,<",
                                                                 str( Prev_Start.x,7,7 ),",",str( Prev_Start.y,7,7 ),",",str( Prev_Start.z,7,7 ),">,<", 
                                                                 str( Prev_End.x,7,7 ),",",str( Prev_End.y,7,7 ),",",str( Prev_End.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining } interior_texture {  it_ruby_lining } }" 
                                       )                                                                    
                                       #declare Prev_inner[b-1] = Start; 
                                       
                                       #local Start = <0,0,0>+sequines_outer( (b-1)/12 );
                                       #local End = <0,0,0>+sequines_outer( b/12 ); 
                                       
                                       #local Prev_Start = Prev_outer[b-1];
                                       #local Prev_End = Prev_outer[b];
                                       
                                       
                                       
                                       #local Norm = vnormalize (vcross ( End-Start, Prev_outer[b]-Start ));
                                       #local trans = (Start+((End-Start)/2))+Norm/30;  
                                        
                                       #write ( slipper, "\n disc { 0, y, .4, .05 texture {  t_sequines  } rotate rand(R)*1 \n
                                                         Reorient (  y, < ", str(Norm.x,7,7),",",str(Norm.y,7,7),",",str(Norm.z,7,7),"> ) \n  
                                                         translate < ",str(trans.x,7,7),",",str(trans.y,7,7),",",str(trans.z,7,7), "> }" 
                                       ) 
                                                                              
                                       #write ( slipper,"\n triangle { <", str( Start.x,7,7 ),",",str( Start.y,7,7 ),",",str( Start.z,7,7 ),">,<",
                                                                 str( Prev_End.x,7,7 ),",",str( Prev_End.y,7,7 ),",",str( Prev_End.z,7,7 ),">,<", 
                                                                 str( End.x,7,7 ),",",str( End.y,7,7 ),",",str( End.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining } interior_texture {  it_ruby_lining } }" 
                                       )                          
                                       #write ( slipper,"\n triangle { <", str( Start.x,7,7 ),",",str( Start.y,7,7 ),",",str( Start.z,7,7 ),">,<",
                                                                 str( Prev_Start.x,7,7 ),",",str( Prev_Start.y,7,7 ),",",str( Prev_Start.z,7,7 ),">,<", 
                                                                 str( Prev_End.x,7,7 ),",",str( Prev_End.y,7,7 ),",",str( Prev_End.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining } interior_texture {  it_ruby_lining } }" 
                                       )                                                                    
                                        
                                       #declare Prev_outer[b-1] = Start; 
                               #end 
                        
                       #local b=b+1;#end 
                            
               #local a=a+1;#end 
               
                      
        #write ( slipper, "\n }" )  

 #write ( slipper, "\n union { \n" )
         
                 #declare Prev  = array [ 15 ];     
                  
                 #local a=-.5;#while(a<41)
                        
                           
                        #local h1 = <0,0,0>+heel_top( a/40 );                       
                        #local h2 = <0,0,0>+heel_mid ( a/40 );                     
                        #local h3 = <0,0,0>+heel_bot  ( a/40 );
                      
                        
                        #local sequines_heel = spline {  cubic_spline                
                                                      0, h1
                                                    
                                                     .5, h2
                                                     1,  h3
                                          }
                         
                            
                        #local b=1;#while(b<15)
       
                                #if ( a=-.5 )
                                        #declare Prev[b] = <0,0,0>+sequines_heel( b/15 );    
                                        #declare Prev[b-1] = <0,0,0>+sequines_heel( (b-1)/15 );  
                                        
                                #else
                                       
                                        #local Start = <0,0,0>+sequines_heel( (b-1)/15 );
                                        #local End = <0,0,0>+sequines_heel( b/15 );
                                        
                                        #local Prev_Start = Prev[b-1];     
                                        #local Prev_End = Prev[b];         
                                        
                                        #local Norm = vnormalize ( vcross ( End-Start, Prev[b]-Start ));
                                         
                                       #local trans = (Start+((End-Start)/2))+Norm/30; 
                                       #if ( Norm.x = -1 )
                                       #else
                                               #write ( slipper, "\n disc { 0, y, .4, .05 texture {  t_sequines  } rotate rand(R)*1 \n
                                                                 Reorient (  y, < ", str(Norm.x,7,7),",",str(Norm.y,7,7),",",str(Norm.z,7,7),"> ) \n  
                                                                 translate < ",str(trans.x,7,7),",",str(trans.y,7,7),",",str(trans.z,7,7), "> }" 
                                               ) 
                                       #end                                       
                                       #write ( slipper,"\n triangle { <", str( Start.x,7,7 ),",",str( Start.y,7,7 ),",",str( Start.z,7,7 ),">,<",
                                                                 str( Prev_End.x,7,7 ),",",str( Prev_End.y,7,7 ),",",str( Prev_End.z,7,7 ),">,<", 
                                                                 str( End.x,7,7 ),",",str( End.y,7,7 ),",",str( End.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining } interior_texture {  it_ruby_lining } }" 
                                       )                          
                                       #write ( slipper,"\n triangle { <", str( Start.x,7,7 ),",",str( Start.y,7,7 ),",",str( Start.z,7,7 ),">,<",
                                                                 str( Prev_Start.x,7,7 ),",",str( Prev_Start.y,7,7 ),",",str( Prev_Start.z,7,7 ),">,<", 
                                                                 str( Prev_End.x,7,7 ),",",str( Prev_End.y,7,7 ),",",str( Prev_End.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining } interior_texture {  it_ruby_lining } }" 
                                       )                                                                    
                                                                              
                                        
                                        #declare Prev[b-1] = Start; 
                                        
                                      
                                #end 
                         
                        #local b=b+1;#end 
                             
                #local a=a+1;#end  
                
                     
#write ( slipper, "\n }" )     
//
 #write ( slipper, "\n union { \n" )
       
               
                
               #local a=1;#while(a<41)
                      
                       #if ( a = 1 )
                                             
                               #local Prev_inner = <0,0,0>+sole_inner( a-1 );
                               #local Curr_inner = <0,0,0>+sole_inner( a );
                               
                               #local Prev_outer = <0,0,0>+sole_outer( a-1 );     
                               #local Curr_outer = <0,0,0>+sole_outer( a );       
                               
   
                       #else
                               #local Curr_inner = <0,0,0>+sole_inner( a );
                               #local Curr_outer = <0,0,0>+sole_outer( a );       
                               
                                
                                       #write ( slipper,"\n triangle { <", str( Prev_outer.x,7,7 ),",",str( Prev_outer.y,7,7 ),",",str( Prev_outer.z,7,7 ),">,<",
                                                                 str( Prev_inner.x,7,7 ),",",str( Prev_inner.y,7,7 ),",",str( Prev_inner.z,7,7 ),">,<", 
                                                                 str( Curr_inner.x,7,7 ),",",str( Curr_inner.y,7,7 ),",",str( Curr_inner.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining }  }" 
                                       )                          
                                       #write ( slipper,"\n triangle { <", str( Curr_inner.x,7,7 ),",",str( Curr_inner.y,7,7 ),",",str( Curr_inner.z,7,7 ),">,<",
                                                                 str( Curr_outer.x,7,7 ),",",str( Curr_outer.y,7,7 ),",",str( Curr_outer.z,7,7 ),">,<", 
                                                                 str( Prev_outer.x,7,7 ),",",str( Prev_outer.y,7,7 ),",",str( Prev_outer.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining }  }" 
                                       )                                                                    
                                                                              
  
                               #local Prev_inner = Curr_inner;   
                               #local Prev_outer = Curr_outer;                         
                       #end               
                                  
                           
              #local a=a+1;#end  
              
               
#write ( slipper, "\n }" )  
 #write ( slipper, "\n union { \n" )
       
               #declare Prev  = array [ 15 ];     
                
               #local a=1;#while(a<12)
                      
                         
                      #local b1 = <0,0,0>+bow_inner( a/12 );                       
                      #local b2 = <0,0,0>+bow_mid  ( a/12 );                     
                      #local b3 = <0,0,0>+bow_outer( a/12 );
                    
                      
                      #local sequines_bow = spline {  cubic_spline                
                                                    0, b1
                                                   .5, b2
                                                    1, b3
                                        }
                       
                          
                      #local b=1;#while(b<12)
     
                              #if ( a=1 )
                                      #declare Prev[b] = <0,0,0>+sequines_bow( b/12 );    
                                      #declare Prev[b-1] = <0,0,0>+sequines_bow( (b-1)/12 );  
                                      
                              #else
                                     
                                      #local Start = <0,0,0>+sequines_bow( (b-1)/12 );
                                      #local End = <0,0,0>+sequines_bow( b/12 );
                                      
                                      #local Prev_Start = Prev[b-1];     
                                      #local Prev_End = Prev[b];         
                                      
                                      #local Norm = vnormalize (vcross ( End-Start, Prev[b]-Start )); 
                                      #local trans = (Start+((End-Start)/2))+Norm/30; 
                                       
                                      #if ( a = 2 | a = 11 | b = 1 | b = 11 ) 
                                      
                                              #write ( slipper, "\n sphere { 0, .2 texture {  t_sequines  }  \n
                                                          
                                                         translate < ",str(trans.x,7,7),",",str(trans.y,7,7),",",str(trans.z,7,7), "> }" 
                                              )
                                               
                                      #else
                                       


                                       #write ( slipper, "\n disc { 0, y, .4, .05 texture {  t_sequines  } rotate rand(R)*1 \n
                                                         Reorient (  y, < ", str(Norm.x,7,7),",",str(Norm.y,7,7),",",str(Norm.z,7,7),"> ) \n  
                                                         translate < ",str(trans.x,7,7),",",str(trans.y,7,7),",",str(trans.z,7,7), "> }" 
                                       ) 
                                                                              
                                       #write ( slipper,"\n triangle { <", str( Start.x,7,7 ),",",str( Start.y,7,7 ),",",str( Start.z,7,7 ),">,<",
                                                                 str( Prev_End.x,7,7 ),",",str( Prev_End.y,7,7 ),",",str( Prev_End.z,7,7 ),">,<", 
                                                                 str( End.x,7,7 ),",",str( End.y,7,7 ),",",str( End.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining } interior_texture {  it_ruby_lining } }" 
                                       )                          
                                       #write ( slipper,"\n triangle { <", str( Start.x,7,7 ),",",str( Start.y,7,7 ),",",str( Start.z,7,7 ),">,<",
                                                                 str( Prev_Start.x,7,7 ),",",str( Prev_Start.y,7,7 ),",",str( Prev_Start.z,7,7 ),">,<", 
                                                                 str( Prev_End.x,7,7 ),",",str( Prev_End.y,7,7 ),",",str( Prev_End.z,7,7 ),">", 
                                                                 "texture { t_ruby_lining } interior_texture {  it_ruby_lining } }" 
                                       )                                                                    
                                                                              


                                      
                                      #end
                                       
                                      #declare Prev[b-1] = Start; 
                                      
                                    
                              #end 
                       
                      #local b=b+1;#end 
                           
              #local a=a+1;#end  
              
                 
#write ( slipper, "\n }" )         
 
#write ( slipper, "\n }" )
#fclose slipper                             