// Persistence of Vision Ray Tracer Scene Description File
// File: worlds.pov
// Vers: 3.5 
// Desc: Worlds Within Worlds                                  
// Date: Feb 2002
// Auth: Jim Charter
 
 
#include "palette.inc" 
#include "woods.inc"
#include "metals.inc" 
#include "worlds_textures.inc"
#include "functions.inc" 
#include "Macs.inc"
                                            
 
      
global_settings { assumed_gamma 1 }
global_settings { max_trace_level 150 } 


#declare Camloc =  <  -60,   25,  -20 >*1.2; 
#declare Lookat =  <   20,   20,   0 > ;
                   //< -.5, 8.0, -24  >;
 
camera 
{ 
  location Camloc   
  look_at  Lookat   
  angle 45 
  //angle 25       
}
#declare R = seed(5432334);

#local  use_radiosity           = 0;
#local  render_background       = 1;
#local  area_lights             = 1;   
#local  render_counter          = 1;   
#local  render_buffer           = 1;    
#local  render_mirror           = 1; 
#local  render_painting         = 1;
#local  render_shoes            = 1;

#declare transform_counter = transform { translate x*-30 } 

#if ( use_radiosity ) 
// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}

#end 
#if ( area_lights ) 

        light_source                                                       
        {
          0*x 
          color red 0.5  green 0.5  blue 0.6  
          area_light
          <24, 0, 0> <0, 0, 8>  8, 8 
          orient 
          translate < -20, 50, 12>  
           
        } 
        light_source                                                       
        {
          0*x 
          color red 0.5  green 0.5  blue 0.6 
          area_light
          <24, 0, 0> <0, 0, 8>   8, 8 
          orient        
          translate < -20, 50, -12>  
           
        } 

#else 
        light_source                                                       
        {
          0*x 
          color  1/3   
          translate < -10, 50, 12>  
           
        } 
        light_source                                                       
        {
          0*x 
          color  1/3   
          translate < -10, 50, -12>  
           
        } 
        light_source                                                       
        {
          0*x 
          color  1/3   
          translate < -20, 50, 12>  
           
        } 
        light_source                                                       
        {
          0*x 
          color  1/3   
          translate < -20, 50, -12>  
           
        }         
#end

#if ( render_background ) 
        background { color rgb CHSV2RGB ( <  240, .5, 1 > ) }  
        #include "worlds_back_wall.inc"  //right wall
        union {
                                        
                box { <-80, 0, -80 > <-80.5, 60, 80 > } // left wall
                box { <-80, 0,  80 > < 10, 60, 80.5 > } //back wall
                box { <-80, 0, -80 > < 10, 10,-80.5 > } //front wall bottom 
                box { <-80, 50, -80 > < 10, 60,-80.5 > } //front wall top
                box { <-80, 60, -80 > < 10, 65, 80 > }//ceiling
                box { <-80, -5, -80 > < 10, 0, 80 > }//floor       
                texture { t_walls }
        }        
#else
        background { color Grey50 } 
        union {
              box { < 4.5, 0, -80 > < 5, 60, 80 > pigment { BurntSienna/3 } translate x*5 }  //right wall        
               box { <-80, 0,  -80 > <-80.5,  60, 80 >  }  // left wall
               box { <-80, 0,   80 > < 10,    60, 80.5 >  }  //back wall
               box { <-80, 0,  -80 > < 10,    10,-80.5 >  }  //front wall bottom 
               box { <-80, 50, -80 > < 10,    60,-80.5 > } //front wall top
               box { <-80, 60, -80 > < 10,    65, 80 >   }   //ceiling
               box { <-80, -5, -80 > < 10,     0, 80 >    }    //floor       
               texture { t_walls }
       }  
#end
#if ( render_counter )

        #include "worlds_counter.inc"     
        
#end 


#if ( render_buffer  )

        #include "worlds_buffer.inc"     
     
#end 


#if ( render_mirror  )  

        #include "worlds_mirror.inc"   

#end 

#if ( render_painting  )  

        #include "worlds_painting.inc"   

#end 

#if ( render_shoes  ) 

        #include "shoe4b_heel_upper_sm_o"  
        #include "shoe4b_sole_inside_sm_o" 
        #include "shoe4b_sole_outside_o"
        #include "shoe6sole_o" 
        #include "shoe6upper_o"
        #include "shoe8l_sm_o" 
        #include "shoe8b"
        #include "shoe9b_o"
        #include "shoe9c_o"
        #include "shoe10_o"
        #include "shoe11_o"
        #include "shoe12_o"                 
        //#include "ruby_shoe" //this creates the file: ruby_slipper.inc        
        #include "ruby_slipper.inc"
           
        #local shoe4b =  
        union {

                object { shoe4b_heel_upper  }      
                object { shoe4b_sole_inside  }
                object { shoe4b_sole_outside  }
                
        }

        #local shoe6 =  
        union {

                object { shoe6upper texture { t_shoe6upper }  }      
                object { shoe6sole  }
                                
        }

        object { shoe4b rotate y*-90 translate < 0, 12.9, -14  >  transform transform_counter }
        object { shoe6 rotate y*-120 translate < 0, 12.0, 0  >  transform transform_counter }
        object { shoe9c rotate y*-80 scale .85 translate < 0, 12.0, 9  >  transform transform_counter } 
        object { shoe11 scale .72 rotate y*-90 translate < 0, 12.0, 20  > transform transform_counter }    
        object { ruby_slipper scale <.30,.30,.30> rotate y*40 translate < -1.5, 12.9, -18.5  >  transform transform_counter }    
        object { ruby_slipper scale .30 rotate y*50 translate < -.5, 12.9, -23  > transform transform_counter }
        
        object { shoe10 scale   1 rotate y*90  translate < 0, 6.0, -4  >  transform transform_counter }
        object { shoe11 scale .72 rotate y*120  translate < 0, 6.0,  10  >  transform transform_counter } 
        object { shoe9c scale <.85, .45, .85> rotate y*90  translate < 0, 6.0, -19  >  transform transform_counter } 
        object { shoe8b scale .95 rotate y*90  translate < 1, 6.0, -12  >  transform transform_counter } 
        object { shoe8b scale .95 rotate y*90  translate < 1, 6.0, -9  >  transform transform_counter } 
        object { shoe12 scale .95 rotate y*90  translate < 1, 6.0, 16  >  transform transform_counter }

        object { shoe8 rotate y*-45 scale .9 rotate y*-90 rotate z*20 translate < 2.4, 26.4,-10  > } 
        object { shoe8 rotate y*-45 scale .9 rotate y*-90 rotate z*20 translate < 2.4, 26.6,-14  >  } 
        object { shoe9b scale .85 rotate y*-90 rotate z*15 translate < 2.4, 26.4, 10  > }
        object { shoe10 scale .90 rotate y*-90 rotate z*20 translate < 2.4, 26.6, 0  >  }
        object { shoe12 scale .85 rotate y*-90 rotate z*20 translate < 2.4, 26.6, -20  >  }
        
#end 


                                                  