// Persistence of Vision Ray Tracer Scene Description File
// File: worlds_textures.inc
// Vers: 3.5 
// Desc: Worlds Within Worlds                                  
// Date: Feb 2002
// Auth: Jim Charter

//shoe textures
 
#declare t_shoe4b_heel_upper = 
texture 
{
	pigment { rgbt <0.8, 0.5, 0.2, 0> } 
	finish
        {
        	ambient 0.01
        	diffuse 0.8
        	specular .2       	 
        	roughness 0.022        	 
        } 
}  
#declare t_shoe4b_sole_outside = 
texture 
{
	pigment { rgbt <0.6, 0.4, 0.0, 0> } 
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .4       	 
        	roughness 0.0002        	 
        } 
}
#declare t_shoe4b_sole_inside = 
texture 
{
	pigment { rgbt <0.4, 0.1, 0.2, 0> } 
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .4       	 
        	roughness 0.0002        	 
        } 
}  
#declare t_shoe6sole = 
texture 
{
	pigment { rgbt <0.1, 0.05, 0.0, 0> } 
	finish
        {
        	ambient 0.05
        	diffuse 0.3
        	specular .2       	 
        	roughness 0.0002        	 
        } 
}
#declare t_shoe6upper = 
texture 
{
	pigment { spotted  scale .035 
	          pigment_map {
	           
	                [ 0 rgb CHSV2RGB ( <  40, .4, 1 > ) ] 
	                [ .5 rgb CHSV2RGB ( <  40, .4, 1 > ) ]                       
	                [ 1 rgb CHSV2RGB ( <  240, .4, .1 > ) ]
	          }
	
	
	}
	normal { spotted  scale .035  }
	finish
        {
        	ambient 0.05
        	diffuse 0.5
        	specular .2       	 
        	roughness 0.0002        	 
        }
         
}

#declare t_shoe8 = 
texture 
{
	pigment { rgb CHSV2RGB ( < 15, .8, .3 > ) }
	normal { leopard scale .10 }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .2       	 
        	roughness 0.0002        	 
        } 
}
#declare t_shoe8b = 
texture 
{
	pigment { rgb CHSV2RGB ( < 0, 0, 0 > ) }
	normal { leopard scale .10 }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .2       	 
        	roughness 0.0022        	 
        } 
}  
#declare t_shoe9b = 
//texture 
//{
//	pigment { rgb CHSV2RGB ( < 0, .9, .6 > ) }
//	normal { leopard scale .10 }
//	finish
//        {
//        	ambient 0.05
//        	diffuse 0.6
//        	specular .4       	 
//        	roughness 0.0022        	 
//        } 
//}
texture 
{
	pigment { spotted  scale .005 
	          pigment_map {
	           
	                [ 0 rgb CHSV2RGB ( < 0, .9, .8 > ) ] 
	                [ .80 rgb CHSV2RGB ( < 0, .9, .8 > ) ]
	                [ .86 rgb CHSV2RGB ( <  15, .4, .2 > ) ]                      
	                [ 1 rgb CHSV2RGB ( <  15, .4, .2 > ) ]
	          }
	
	
	}
	normal { spotted  scale .05  }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .4       	 
        	roughness 0.0022        	 
        }
         
} 
#declare t_shoe9c = 
texture 
{
	pigment { rgb CHSV2RGB ( < 240, .1, .01 > ) }
	normal { crackle scale .20 }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .4       	 
        	roughness 0.002        	 
        } 
}
#declare t_shoe10 = 
texture 
{
	pigment { rgb CHSV2RGB ( < 240, .1, .01 > ) }
	normal { leopard scale .020 }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .4       	 
        	roughness 0.002        	 
        } 
} 
#declare t_shoe11 = 
texture 
{
	pigment { rgb CHSV2RGB ( < 0, 0, 0 > ) }
	normal { bumps 1 scale .20 }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .4       	 
        	roughness 0.0002        	 
        } 
} 
#declare t_shoe12 = 
texture 
{
	pigment { rgb CHSV2RGB ( < 0, 0, 0 > ) }
	normal { bumps 1 scale .20 }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular .4       	 
        	roughness 0.0002        	 
        } 
}
#declare t_sequines = 
texture 
{
	pigment { rgb CHSV2RGB ( < 350, 1, .70 > ) }
	finish
        {
        	ambient 0.05
        	diffuse 0.7
        	specular .4       	 
        	roughness 0.0002 
        	reflection .15       	 
        } 
}
#declare t_ruby_lining = 
texture 
{
	pigment { rgb CHSV2RGB ( < 350, .9, .5 > ) }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular 0       	 
        	roughness 0.02 
        	  	 
        }
        normal { leopard .5 scale .5 } 
}           
#declare it_ruby_lining = 
texture 
{
	pigment { rgb CHSV2RGB ( < 20, .6, 1 > ) }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular 0       	 
        	roughness 0.02 
        	  	 
        } 
}
#declare t_ruby_bow = 
texture 
{
	pigment { rgb CHSV2RGB ( < 0, .95, .95 > ) }
	finish
        {
        	ambient 0.05
        	diffuse 0.6
        	specular 0       	 
        	roughness 0.02 
        	  	 
        }
        normal { leopard .5 scale .5 } 
}              
#declare t_walls =
texture {
        pigment { rgb CHSV2RGB ( < 40, .2, .9 > ) }
}
#declare t_counter =
texture {
        pigment { rgb CHSV2RGB ( < 30, .7, .5 > ) }
}
#declare t_counter_top =
texture {                                                   
        pigment { rgb CHSV2RGB ( < 300, .2, .9 > ) }
}  

#declare t_metal_frame =
texture {
        pigment { rgb CHSV2RGB ( < 150, .8, .1 > ) } 
        finish { ambient 0 diffuse .4  specular  .6 roughness .01 }
}

#declare p_minmax_y =
pigment { function { min(1,max(0,y/1.5))}
                        turbulence 0.050 lambda 3 poly_wave 2 scale 5
                        pigment_map { [ 0 rgb CHSV2RGB ( < 150, .8, .05 > ) ][.5 rgb CHSV2RGB ( < 200, .8, .1 > ) ][1 rgb CHSV2RGB ( < 150, .8, .05 > )] }
}

#declare t_metal_frame_back =

texture {
        pigment { p_minmax_y } 
        finish { ambient 0 diffuse .4  specular  .6  roughness .01 }
} 
     

#declare t_metal_chest =
texture {
         pigment { slope x pigment_map { 
         
                                        [ 0 rgb CHSV2RGB ( < 95, .6, .5 > ) ]                                      
                                        [ .5 rgb CHSV2RGB ( < 15, .6, .4 > ) ]                                      
                                        [ 1 rgb CHSV2RGB ( < 95, .6, .5 > ) ]
                         }  
         } 
               
        finish { ambient 0 diffuse .5  specular  .5 roughness .05 }
}
#declare t_metal_axle =
texture {
        pigment { rgb CHSV2RGB ( < 240, .1, .2 > ) } 
        finish { ambient 0 diffuse 0 specular 1 roughness .001 reflection .2 }
}
#declare t_metal_exhaust =
texture {
        pigment { rgb CHSV2RGB ( < 240, .1, .2 > ) } 
        finish { ambient 0 diffuse .4 specular .6 roughness .01 }
}
#declare p_minmax_z =
pigment { function { min(1,max(0,z/45))}
                turbulence .55 lambda 3 poly_wave 2  
                frequency 1 
                pigment_map {   
                                [  0 YellowOchre/2 ]           //BurntSienna                                                      
                                [  .25 Clear  ]    
                                [ .50 YellowOchre/4  ]  //BurntSienna/2                          
                                [  .75 Clear  ]  
                                [  1 YellowOchre/2   ]     //BurntSienna
                } 
} 
               
#declare t_wood_shelf = 
texture { T_Wood34 }       //pigment { rgb CHSV2RGB ( < 55, .50, .55 > ) }
texture {
         pigment { slope x pigment_map { 
         
                                        [ 0 Clear ]              //rgb CHSV2RGB ( < 65, .4, .30 > )                        
                                        [ .5 p_minmax_z ]  //rgb CHSV2RGB ( < 15, .90, .35 > )                                    
                                        [ 1 Clear ]  //rgb CHSV2RGB ( < 65, .4, .30 > )
                         }  
         } 
        finish { ambient 0 diffuse .9 specular .1 roughness .1 }
}
#declare t_wood_counter = 
//texture { T_Wood34 }       //pigment { rgb CHSV2RGB ( < 55, .50, .55 > ) }
texture {
         pigment { slope y pigment_map { 
         
                                        [ 0 Clear ]              //rgb CHSV2RGB ( < 65, .4, .30 > )                        
                                        [ .5 rgb CHSV2RGB ( <  15, .7, .7 > ) ]  //rgb CHSV2RGB ( < 15, .90, .35 > )                                    
                                        [ 1 Clear ]  //rgb CHSV2RGB ( < 65, .4, .30 > )
                         }  
         } 
        finish { ambient 0 diffuse .9 specular .1 roughness .1 }
}
#declare p_minmax_z2 =
pigment { function { min(1,max(0,z/45))}
                turbulence .55 lambda 3 poly_wave 2  
                frequency 1 
                pigment_map {   
                                                                                   
                                [  0 Clear  ]    
                                                       
                                
                                [  1 rgb CHSV2RGB ( <  15, .7, .7 > )    ]      
                } 
} 
#declare t_wood_mirror =
texture {
        pigment { rgb CHSV2RGB ( < 15, .85, .35 > ) } 
        finish { ambient 0 diffuse .9 specular .1 roughness .1 }
}
#declare t_mirror =
texture {
        pigment { rgb CHSV2RGB ( < 0, 0, 0 > ) } 
        finish { ambient 0 diffuse 0 specular 1 roughness .0001 reflection 1 }
}     
#declare t_buffer2 =
texture {
        //pigment { radial frequency 144 turbulence .125  
        //pigment { gradient y frequency 72 turbulence 0 
        pigment { cylindrical   frequency 3 turbulence 0 
                        pigment_map {   [  0 rgb CHSV2RGB ( <  15, .5, .2 > ) ]
                                        [ .5 rgb CHSV2RGB ( <   0, .1, .0 > ) ] 
                                        [  1 rgb CHSV2RGB ( <  15, .5, .2 > ) ] 
                        }
        }
        finish { ambient 0 diffuse .8 specular .1 roughness .1 }
}
 
#declare t_buffer2t =
texture {
        pigment { cylindrical   frequency 3 turbulence 0 
                        pigment_map {   [  0 rgb CHSV2RGB ( <  15, .5, .2 > ) transmit .65]
                                        [ .5 rgb CHSV2RGB ( <   0, .1, .0 > ) transmit .65] 
                                        [  1 rgb CHSV2RGB ( <  15, .5, .2 > ) transmit .65] 
                        }
        }
        finish { ambient 0 diffuse .8 specular .1 roughness .1 }
}
#declare t_buffer3 =
texture {
        //pigment { radial frequency 144 turbulence .125 
        //pigment { gradient y frequency 72 turbulence 0  
        pigment { cylindrical   frequency 2 turbulence 0 
                        pigment_map {   [  0 rgb CHSV2RGB ( <  15, .8, .5 > ) ]
                                        [ .5 rgb CHSV2RGB ( <   0, .1, .1 > ) ] 
                                        [  1 rgb CHSV2RGB ( <  15, .8, .5 > ) ] 
                        }
        }
        finish { ambient 0 diffuse .8 specular .1 roughness .1 }
}
#declare t_buffer3t =
texture {
        pigment { cylindrical   frequency 2 turbulence 0 
                        pigment_map {   [  0 rgb CHSV2RGB ( <  15, .8, .5 > ) transmit .65]
                                        [ .5 rgb CHSV2RGB ( <   0, .1, .1 > ) transmit .65] 
                                        [  1 rgb CHSV2RGB ( <  15, .8, .5 > ) transmit .65] 
                        }
        }
        finish { ambient 0 diffuse .8 specular .1 roughness .1 }
}  
#declare t_buffer4 =
texture {
        //pigment { radial frequency 144 turbulence .325 
        //pigment { gradient y frequency 72 turbulence 0  
        pigment { cylindrical   frequency 2 turbulence 0 
                        pigment_map {   [  0 rgb CHSV2RGB ( <  180, .8, .8 > ) ]
                                        [ .5 rgb CHSV2RGB ( <    0, .1, .1 > ) ] 
                                        [  1 rgb CHSV2RGB ( <  180, .8, .8 > ) ] 
                        }
        }
        finish { ambient 0 diffuse .8 specular .1 roughness .1 }
} 
#declare t_buffer4t =
texture {
        pigment { cylindrical   frequency 2 turbulence 0 
                        pigment_map {   [  0 rgb CHSV2RGB ( <  180, .8, .8 > ) transmit .65]
                                        [ .5 rgb CHSV2RGB ( <    0, .1, .1 > ) transmit .65] 
                                        [  1 rgb CHSV2RGB ( <  180, .8, .8 > ) transmit .65] 
                        }
        }
        finish { ambient 0 diffuse .8 specular .1 roughness .1 }
} 
#declare t_buffer5 =
texture {
        //pigment { radial frequency 144 turbulence .125
        //pigment { gradient y frequency 72 turbulence 0 
        pigment { cylindrical   frequency 2 turbulence 0  
                        pigment_map {   [  0 rgb CHSV2RGB ( <  20, .5, .8 > ) ]
                                        [ .5 rgb CHSV2RGB ( <   0, .1, .1 > ) ] 
                                        [  1 rgb CHSV2RGB ( <  20, .5, .8 > ) ] 
                        }
        }
        finish { ambient 0 diffuse .8 specular .1 roughness .1 }
}  
#declare t_buffer5t =
texture {
        pigment { cylindrical   frequency 2 turbulence 0  
                        pigment_map {   [  0 rgb CHSV2RGB ( <  20, .5, .8 > ) transmit .65]
                                        [ .5 rgb CHSV2RGB ( <   0, .1, .1 > ) transmit .65] 
                                        [  1 rgb CHSV2RGB ( <  20, .5, .8 > ) transmit .65] 
                        }
        }
        finish { ambient 0 diffuse .8 specular .1 roughness .1 }
}
#declare pig1 = pigment { rgb CHSV2RGB ( < 0, .1, .2 > ) transmit .8 } 
#declare pig2 = pigment { bozo scale < .25, 2, .25 >
                          turbulence < 1, 1.75, 1 > 
                          pigment_map { [ 0 Clear][ .5 pig1 ][ 1 Clear ] } 
                }              
#declare pig3 = pigment { bozo scale < .25, 2, .25 >*1.5
                          turbulence < 1.5, 1.75, 1.5 > 
                          pigment_map { [ 0 Clear][ .5 pig1 ][ 1 Clear ] } 
                }
#declare pig4 = pigment { average pigment_map { [.5 pig2][.5 pig3] } }  


#declare t_switchbox =
texture {
        T_Chrome_1A
} 
texture { pigment { slope x
                    pigment_map {
                        [ 0 pig4 scale 1.4 ]           
                        [ .5 Gray10   ] 
                        [ 1 pig4 scale 1.4 ]  
                    }
          }
} 


              
#declare t_metalbox =

texture {
        T_Chrome_5B  //3B
}
 
texture { pigment { slope y
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig4 scale 5   ] 
                        [ 1 Clear ]  
                    }
          }
}

texture { pigment { slope z
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig4  rotate x*90 scale 1   ] 
                        [ 1 Clear ]  
                    }
          }
}  
texture { pigment { slope z
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig4 transmit .15 rotate x*90 scale 1.1  ] 
                        [ 1 Clear ]  
                    }
          }
}

texture { pigment { slope x
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig4 rotate x*90 scale 2  ] 
                        [ 1 Clear ]  
                    }
          }
}
texture { pigment { slope x
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig4 transmit .60 rotate x*90 scale 2.1  ] 
                        [ 1 Clear ]  
                    }
          }
}

#declare pig5 = pigment { rgb CHSV2RGB ( <  20, .4, 1 > ) transmit .8 } 
#declare pig6 = pigment { bozo scale < 1, 2, 1 >
                          turbulence < 1, 1.75, 1 > 
                          pigment_map { [ 0 Clear][ .5 pig5 ][ 1 Clear ] } 
                }              
#declare pig7 = pigment { bozo scale < 1, 2, 1 >*1.5
                          turbulence < 1.5, 1.75, 1.75 > 
                          pigment_map { [ 0 Clear][ .5 pig5 ][ 1 Clear ] } 
                }
#declare pig8 = pigment { average pigment_map { [.5 pig6][.5 pig7] } }  




#declare t_cardbox =

texture {
        pigment { rgb CHSV2RGB ( <  20, .8, .75 > ) }
}
 
texture { pigment { slope y
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig8 scale 5   ] 
                        [ 1 Clear ]  
                    }
          }
}

texture { pigment { slope z
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig8  rotate x*90 scale 1   ] 
                        [ 1 Clear ]  
                    }
          }
}  
texture { pigment { slope z
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig8 transmit .15 rotate x*90 scale 1.1  ] 
                        [ 1 Clear ]  
                    }
          }
}

texture { pigment { slope x
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig8 rotate x*90 scale 2  ] 
                        [ 1 Clear ]  
                    }
          }
}
texture { pigment { slope x
                    pigment_map {
                        [ 0 Clear ]           
                        [ .5 pig8 transmit .60 rotate x*90 scale 2.1  ] 
                        [ 1 Clear ]  
                    }
          }
}