// Persistence of Vision Ray Tracer Include File
// File: SKS_Beer.inc
// Vers: 3.1g for Windows
// Desc: Cool, refreshing beer for "Intestinal Parasites Playing Poker"
// Date: 02/02/2002
// Auth: Copyright  2002 by Sherry K. Shaw

// If the transparent beer inside the transparent mug turns black, try adding
// the following to the top of the scene file (uncommented, of course):

//global_settings {
//  max_trace_level 8
//}

//**********************************************************
//                Declarations
//**********************************************************

//**********************************************************
// Texture for beer mugs
//**********************************************************
#declare BEER_GLASS_TEX =
texture {
  pigment {
    color rgbft < 0.98, 0.98, 0.98, 0.45, 0.45 >
  }
  finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1
  }
}

#declare BEER_GLASS_INT =
interior {
  ior 1.3
}

//**********************************************************
// Texture for beer bottles
//**********************************************************
#declare BEER_BOTTLE_TEX =
texture {
  pigment {
    color rgbf < 0.44, 0.22, 0.11, 0.70 >
  }
  finish {
    specular 1
    roughness 0.01
    ambient 0
    diffuse 0
    reflection 0.05
    brilliance 2
  }
}

#declare BEER_BOTTLE_INT =
interior {
  ior 1.15
}

//**********************************************************
// Texture for beer bottle label
//**********************************************************
#declare BEER_LABEL_TEX =
texture {
  pigment {
    image_map {
      ppm "SKS_BeerLabel.ppm"
      once
      map_type 2        // Cylindrical mapping
    }
  }
  finish {
    ambient 0.35
    diffuse 0.65
  }
  normal {
    granite 0.2
    scale 0.1
  }
}

//**********************************************************
// Textures for Old Gastro-Enteritis
//**********************************************************
#declare BEER_TEX =
texture {
  pigment {
    color rgbft < 1.0, 0.9, 0.0, 0.6, 0.1 >
  }
  finish {
    ambient 0.35
    diffuse 0.65
  }
}

#declare BEER_INT =
interior {
  media {
    absorption 0.65
    emission 0.65
    density {
      leopard
      turbulence 3
      color_map {
        [ 0.00 0.95 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.0, 0.0, 0.0 > ]
        [ 0.95 1.00 color rgb < 1.0, 1.0, 1.0 > color rgb < 1.0, 1.0, 1.0 > ]
      }
      scale 0.15
    }
  }
}

// Close up, this head stikes me as being a little, well, ethereal.  Non-transparent
// versions had a tendency to look like a chunk of Styrofoam.  Suggestions for an
// Improved Beer Foam Texture are welcome at tenmoons@aol.com.  Thanks!
#declare HEAD_TEX =
texture {
  pigment {
    color rgbt < 1.0, 1.0, 1.0, 1.0 >
  }
  finish {
    ambient 0.0
    diffuse 0.0
  }
}

#declare HEAD_INT =
interior {
  media {
    absorption 0.65
    emission 0.65
    density {
      //leopard         // Pick one...
      bozo
      turbulence 2
      color_map {
        [ 0.00 0.95 color rgb < 1.0, 1.0, 1.0 > color rgb < 1.0, 1.0, 1.0 > ]
        [ 0.95 1.00 color rgb < 0.0, 0.0, 0.0 > color rgb < 0.0, 0.0, 0.0 > ]
      }
      scale 0.1
    }
  }
}

//**********************************************************
// Beer mug
//**********************************************************
// If you were showing this close-up, it would be improved by
// having a torus laid on top of the rim to round the top edge...
#declare BEER_GLASS_OBJ =
union {
  difference {
    cylinder {
      < 0, 0, 0 > < 0, 5, 0 > 2
    }
    cylinder {
      < 0, 0.75, 0 > < 0, 5.01, 0 > 1.5
    }
  }
  difference {
    torus {
      1, 0.25
      rotate < 90, 0, 0 >
    }
    box {
      < -1.26, -1.26, -0.26 > < 0, 1.26, 0.26 >
    }
    scale < 1, 1.3, 1 >
    translate < 1.98, 2.8, 0 >
  }
  texture {
    BEER_GLASS_TEX
  }
  interior {
    BEER_GLASS_INT
  }
}

//**********************************************************
// A few pours of Old Gastro-Enteritis...
//**********************************************************
#declare BEER_01_OBJ =  // Papa beer
union {
  cylinder {
    < 0, 0.75, 0 > < 0, 3.75, 0 > 1.5
    texture {
      BEER_TEX
    }
    hollow
    interior {
      BEER_INT
    }
  }
  cylinder {
    < 0, 3.75, 0 > < 0, 4.75, 0 > 1.5
    texture {
      HEAD_TEX
    }
    hollow
    interior {
      HEAD_INT
    }
  }
  scale 0.999
}

#declare BEER_02_OBJ =  // Mama beer
union {
  cylinder {
    < 0, 0.75, 0 > < 0, 3.0, 0 > 1.5
    texture {
      BEER_TEX
    }
    hollow
    interior {
      BEER_INT
    }
  }
  cylinder {
    < 0, 3.0, 0 > < 0, 3.75, 0 > 1.5
    texture {
      HEAD_TEX
    }
    hollow
    interior {
      HEAD_INT
    }
  }
  scale 0.999
}

#declare BEER_03_OBJ =  // Baby beer
union {
  cylinder {
    < 0, 0.75, 0 > < 0, 2.0, 0 > 1.5
    texture {
      BEER_TEX
    }
    hollow
    interior {
      BEER_INT
    }
  }
  cylinder {
    < 0, 2.0, 0 > < 0, 2.75, 0 > 1.5
    texture {
      HEAD_TEX
    }
    hollow
    interior {
      HEAD_INT
    }
  }
  scale 0.999
}

//**********************************************************
// The finished mugs-o-beer
//**********************************************************
// These were each scaled to 1.4 just to make them satisfyingly
// visible in the scene; scale'em however you like.
#declare BEER_MUG_01_OBJ =
union {
  object {
    BEER_GLASS_OBJ
  }
  object {
    BEER_01_OBJ
  }
  scale 1.4
}

#declare BEER_MUG_02_OBJ =
union {
  object {
    BEER_GLASS_OBJ
  }
  object {
    BEER_02_OBJ
  }
  scale 1.4
}

#declare BEER_MUG_03_OBJ =
union {
  object {
    BEER_GLASS_OBJ
  }
  object {
    BEER_03_OBJ
  }
  scale 1.4
}

//**********************************************************
// Beer bottle
//**********************************************************
#declare BEER_BOTTLE_BOTTOM_OBJ =
difference {
  cylinder {
    < 0, 0, 0 > < 0, 5, 0 > 1.5
  }
  cylinder {
    < 0, 0.5, 0 > < 0, 5.01, 0 > 1.25
  }
}

#declare BEER_BOTTLE_MIDDLE_OBJ =
difference {
  difference {
    sphere {
      < 0, 0, 0 > 1.5
    }
    sphere {
      < 0, 0, 0 > 1.2
    }
  }
  union {
    box {
      < -1.51, 0, -1.51 > < 1.51, -1.51, 1.51 >
    }
    cylinder {
      < 0, 1.24, 0 > < 0, 1.51, 0 > 0.74
    }
  }
}

#declare BEER_BOTTLE_NECK_OBJ =
difference {
  cylinder {
    < 0, 0, 0 > < 0, 4, 0 > 0.75
  }
  cylinder {
    < 0, -0.01, 0 > < 0, 4.01, 0 > 0.5
  }
}

#declare BEER_BOTTLE_RIM_OBJ =
torus {
  0.625, 0.2
}

#declare BEER_BOTTLE_LABEL_OBJ =
difference {
  difference {
    difference {
      cylinder {
        < 0, 0, 0 > < 0, 4, 0 > 1.52
      }
      difference {
        box {
          < -1.61, 3.2, -1.61 > < 1.61, 4.01, 1.61 >
        }
        cylinder {
          < 0, 3.1, -1.62 > < 0, 3.1, 1.62 > 0.9
          scale < 1.325, 1, 1 >
        }
      }
    }
    box {
      < -1.61, -0.01, 0 > < 1.61, 4.01, 1.61 >
    }
  }
  cylinder {
    < 0, -0.01, 0 > < 0, 4.01, 0 > 1.5
  }
  texture {
    BEER_LABEL_TEX
    scale 4
    rotate y*-90
  }
}

#declare BEER_BOTTLE_OBJ =
union {
  union {
    object {
      BEER_BOTTLE_BOTTOM_OBJ
    }
    object {
      BEER_BOTTLE_MIDDLE_OBJ
      translate < 0, 4.99, 0 >
    }
    object {
      BEER_BOTTLE_NECK_OBJ
      translate < 0, 5.48, 0 >
    }
    object {
      BEER_BOTTLE_RIM_OBJ
      translate < 0, 9.48, 0 >
    }
    texture {
      BEER_BOTTLE_TEX
    }
    interior {
      BEER_BOTTLE_INT
    }
  }
  object {
    BEER_BOTTLE_LABEL_OBJ
    translate < 0, 1, 0 >
  }
}