#if (POV35) 
#else
#version unofficial MegaPov 0.7;
#end


// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=50;               // size of patch
#declare nBlade=20;                // number of blades per line (there will be nBlade x nBlade blades)
//#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 10;            // number of blade segments
#declare lBlade = 24;             // length of blade
#declare wBlade = 1.6;            // width of blade at start
#declare wBladeEnd = .1;         // width of blade at the end   .6
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,1,0>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 4;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale
#declare stdBend = 3;            // standard deviation of blade bending
#declare dofold = true;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "fgrass2.inc"     // name of the mesh file to create

/*#declare lPatch=50;               // size of patch
#declare nBlade=15;                // number of blades per line (there will be nBlade x nBlade blades)
//#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 10;            // number of blade segments
#declare lBlade = 10;             // length of blade
#declare wBlade = 0.8;            // width of blade at start
#declare wBladeEnd = 0.3;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,1,0>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 4;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale
#declare stdBend = 3;            // standard deviation of blade bending
#declare dofold = true;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "fgrass2.inc"     // name of the mesh file to create
*/
// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=3;             // number of patches for the first line
#declare addPatches=1;            // number of patches to add at each line
#declare nzPrairie=5;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

// --------------------------------------
// Create the patch and the prairie
// --------------------------------------
/*#if (dofile=true) // if the patch is already created, turn off the next line
        MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        

object {objectPatch
	texture{txtGrass scale 40}
	}
*/
#if (dofile=true) // if the patch is already created, turn off the next line
        //MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        


#declare deltax=(hfx2_h-hfx1_h)/(PATCHESPERSIDE*2);

#declare xpatchseparation=(hfx2_h-hfx1_h)/PATCHESPERSIDE;
#declare zpatchseparation=(hfz2_h-hfz1_h)/PATCHESPERSIDE;

#declare HENRY=seed(444);
#declare zpatch=0;
#while (zpatch<PATCHESPERSIDE)
#declare xpatch=0;
#while (xpatch<PATCHESPERSIDE)
object {objectPatch
	texture{txtGrass scale 40}
  photons {
    target
    refraction on
    reflection on
    pass_through off
  }
#declare hf_normal=<0,0,0>;

#declare hf_pos=  trace (ground_h,<(xpatch*xpatchseparation+xpatchseparation/2)+hfx1_h,2000,(zpatch*zpatchseparation+zpatchseparation/2)+hfz1_h>,<0,-1,0>);
#declare hf_plusx=  trace (ground_h,<(xpatch*xpatchseparation+xpatchseparation/2)+hfx1_h+deltax,2000,(zpatch*zpatchseparation+zpatchseparation/2)+hfz1_h>,<0,-1,0>);
#declare hf_minusx=  trace (ground_h,<(xpatch*xpatchseparation+xpatchseparation/2)+hfx1_h-deltax,2000,(zpatch*zpatchseparation+zpatchseparation/2)+hfz1_h>,<0,-1,0>);
#declare hf_plusz=  trace (ground_h,<(xpatch*xpatchseparation+xpatchseparation/2)+hfx1_h,2000,(zpatch*zpatchseparation+zpatchseparation/2)+hfz1_h+deltax>,<0,-1,0>);
#declare hf_minusz=  trace (ground_h,<(xpatch*xpatchseparation+xpatchseparation/2)+hfx1_h,2000,(zpatch*zpatchseparation+zpatchseparation/2)+hfz1_h-deltax>,<0,-1,0>);

//#debug concat("Normal=", str(hf_normal.x,5,5),", ", str(hf_normal.y,5,5),", ", str(hf_normal.z,5,5),"\n")

#declare randrot=floor(rand(HENRY)*4.0);
//#debug concat("Random number=",str(randrot,5,5),"\n")
	rotate y*90*randrot//	rotate y*90*(xpatch+zpatch)	// Randomise rotation of patch

#declare zangle=degrees(tan((-hf_minusx.y+hf_plusx.y)/(2*deltax)));
#declare xangle=degrees(tan((hf_minusz.y-hf_plusz.y)/(2*deltax)));
/*#if (hf_normal.y!=0)
	#declare xangle=degrees(tan(hf_normal.z/hf_normal.y));
	#declare zangle=-degrees(tan(hf_normal.x/hf_normal.y));
#else
	#declare xangle=degrees(tan(hf_normal.z/.0000000000001));
	#declare zangle=-degrees(tan(hf_normal.x/.0000000000001));
#end*/
//#debug concat("Rotation angles=", str(xangle,5,5),", ", str(zangle,5,5),"\n\n")
	rotate <xangle,0,zangle>
//	translate <25,0,25>		
	scale (xpatchseparation/50)	// Scale from 50 units across to correct size

/*	#declare ypos=hf_height_at((xpatch*xpatchseparation+xpatchseparation/2)/(xpatchseparation*PATCHESPERSIDE),(zpatch*zpatchseparation+zpatchseparation/2)/(zpatchseparation*PATCHESPERSIDE),ground_h)*(hfy2_h-hfy1_h);
	#declare xpos=hfx1_h+(xpatch*xpatchseparation);
// 	#debug concat("hfz1_h=",str(hfz1_h,2,2),"\n")
	#declare zpos=hfz1_h+(zpatch*zpatchseparation);
	translate <xpos, ypos, zpos>*/
	translate hf_pos 
	
	}
#declare xpatch=xpatch+1;
#end 
#declare zpatch=zpatch+1;
#end 



//#end // doing grass if statement
