// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1 ;

#include "colors.inc"
#include "skies.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
//  location  <-4.0, 0.5, .0>*1.3
//location  <-0, 0, -10>*2.3
//location  <-0, 3, -10>*2.3 //Tux Rules!
  location  <-0, 2, -7>*3.3 //world wi world
//  location  <-0, -10, -0>*2.3
//  location  <-10, 0, 0>*2.3

//location  <2, 3, -7>*3.3 //sitting

  direction 1.5*z
//  right     4/3*x
right 16/9*x
//  look_at   <0.0, 0.0,  0.0>//rules!
//look_at <0,2,0>//sitting

look_at <0,3,0>
}

sky_sphere {S_Cloud1}

light_source{0*x color rgb<1,1,1> translate<30, 30, -30>}

// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}
//sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} }

#declare Tux_Tex =                            
   texture{pigment{color White}
           normal {bumps 0.4 scale 0.01}
           finish {ambient 0.45 diffuse 0.55 phong 0.1}}

#declare Tux_Tex1 =                            
   texture{pigment{color Black}
           normal {bumps 0.4 scale 0.01}
           finish {ambient 0.45 diffuse 0.55 phong 0.1}}

#declare Tux_Tex2 =                            
   texture{pigment{color Yellow}
           normal {bumps 0.4 scale 0.005}
           finish {ambient 0.45 diffuse 0.55 phong 0.1}}

#declare beak = union {
difference{
height_field {tga "beak1a.tga" smooth
texture {Tux_Tex2} }// scale<4,.75,4> }
box {<0,-1,0><1,0.2,1> 
pigment {color rgbt<0,0,0,1>}}
scale<5,.5,3.5>
}//diff beak
difference{
height_field {tga "beak1a.tga" smooth
texture {Tux_Tex2} }// scale<4,.05,4> }
box {<0,-1,0><1,0.2,1> 
pigment {color rgbt<0,0,0,1>}}
scale<5,.5,3.5>
}//diff beak
}//union

#declare beak2 = union {
difference{
height_field {tga "beak1a.tga" smooth
texture {Tux_Tex2} }// scale<4,.75,4> }
box {<0,-1,0><1,0.2,1> 
pigment {color rgbt<0,0,0,1>}}
scale<5,.5,3.5> rotate 180*x
}//diff beak2
difference{
height_field {tga "beak1a.tga" smooth
texture {Tux_Tex2} }// scale<4,.05,4> }
box {<0,-1,0><1,0.2,1> 
pigment {color rgbt<0,0,0,1>}}
scale<5,.5,3.5> rotate 180*x //rotate -25*z //-5*x 
}//diff beak2
}//union

#declare footl = union {
//sphere {0 , 1 scale<.4,2,.4> texture {Tux_Tex1} translate <2.5,2.1,1.5>}

difference {
height_field { tga "footl.tga" smooth
texture {Tux_Tex2} scale <5,.5,5> translate 0*x}
box {<0,-1,0><1,0,1> 
pigment {color rgbt<0,0,0,1>}
scale 5 translate 0.05*y}
}//diff
difference {
height_field { tga "footl.tga" smooth
texture {Tux_Tex2} scale <5,.1,5> translate 0*x}
box {<0,-1,0><1,0,1> 
pigment {color rgbt<0,0,0,1>}
scale 5 translate 0.05*y}
}//diff

}//union

#declare footr = union {
//sphere {0 , 1 scale<.4,2,.4> texture {Tux_Tex1} translate <2.5,2.1,1.5>}
difference {
height_field { tga "footr.tga" smooth
texture {Tux_Tex2} scale <5,.5,5> translate 0*x}
box {<0,-1,0><1,0,1> 
pigment {color rgbt<0,0,0,1>}
scale 5 translate 0.05*y}
}//diff

difference {
height_field { tga "footr.tga" smooth
texture {Tux_Tex2} scale <5,.1,5> translate 0*x}
box {<0,-1,0><1,0,1> 
pigment {color rgbt<0,0,0,1>}
scale 5 translate 0.05*y}
}//diff
}//union

#declare Tux_upperpart = 
intersection{                      
 sphere{<0,0,0>,1 scale<1,1.75,1>} 
 box{<-1,0,-1>,<1,1.75,1>}         
 }

#declare Tux_lowerpart =                
intersection{                      
 sphere{<0,0,0>,1 scale<1,1,1>}    
 box{<-1,-1,-1>,<1,0,1>}           
 }

#declare Tux = //belly
union{ object{Tux_upperpart}
       object{Tux_lowerpart}
       texture{Tux_Tex}
}

#declare Tux1 = //back
union{ object{Tux_upperpart}
       object{Tux_lowerpart}
       texture{Tux_Tex1}
}


#declare Tux_Head = union {

object {Tux1 rotate 180*z scale <1.5,1,1.5> 
scale 1.5 translate<0,6.,0>}

sphere {0.0 , 1 texture{Tux_Tex} // left eye
scale <.5,.8,.5>
translate<-.7,4.7,-1.9> }

sphere {0.0 , 1 texture{Tux_Tex1} // left eye
scale <.5,.8,.5>*.5
translate<-.7,4.7,-2.3> }

sphere {0.0 , 1 texture{Tux_Tex} // right eye
scale <.5,.8,.5>
translate<.7,4.7,-1.9> }

sphere {0.0 , 1 texture{Tux_Tex1} // left eye
scale <.5,.8,.5>*.5
translate<.7,4.7,-2.3> }

}

#declare feet = union {
object {footl rotate <0,-0,0> translate <-4,-2,0>} //on right from front
object {footr rotate <0,+0,0> translate <-1,-2,0>} 
}

/*
#declare Tux_Bod = union {
object {Tux scale <1.25,1,1.25>*2.5 translate<0,0,-0.5>}
object {Tux1 scale <1.25,1,1.25>*2.5 
scale 1.1
translate<0,0,0>}
}
*/

//object {feet rotate <0,180,0> translate<0,-.5,0>} // feet below rules!

//object {feet rotate <0,180,0> rotate <90,0,0> translate<0,-3.5,-3>}//sitting

//Tux_Bod

//Tux_Head

#declare beak3 = union {
object {beak rotate<0,90,0> translate <-1.75,4,0>}
object {beak2 rotate<0,90,0> translate <1.75,4,0>}
}
//beak3

#declare tux_top = union {
//object {Tux scale <1.25,1,1.25>*2.5 translate<0,0,-0.5>}
object{Tux_Head}
object{beak3}
object{Tux_upperpart 
scale <1.25,1,1.25>*2.5 translate<0,0,-0.5> texture{Tux_Tex} 
/*
clipped_by{ object{Tux_upperpart 
scale <1.25,1,1.25>*2.5 translate <0,0,.5> scale 1.1 scale .99}
}//clipped_by
*/
}
object{Tux_upperpart 
scale <1.25,1,1.25>*2.5 translate<0,0,0> scale 1.1 texture{Tux_Tex1} 
}
}

#declare tux_bot = union{
//object {Tux1 scale <1.25,1,1.25>*2.5  scale 1.1 translate<0,0,0>}
//object {feet rotate <0,180,0> translate<0,-.5,0>} // feet below rules!
object {feet rotate <0,180,0> rotate <90,0,0> translate<0,-3.5,-3.5>}//sitting
object{Tux_lowerpart scale <1.25,1,1.25>*2.5  scale 1.1 translate<0,0,0>
texture{Tux_Tex1}
/*
clipped_by{object{Tux_lowerpart 
scale <1.25,1,1.25>*2.5  scale 1.1 translate<0,0,.5>}
}//clipped
*/
}//lowerpart


object{Tux_lowerpart scale <1.25,1,1.25>*2.5  scale 1 translate<0,0,-.5>
texture{Tux_Tex}}

}

#declare tttop= object{
object{tux_top clipped_by {plane{-y,0}}
}}

#declare ttbot=object{
object{tux_bot clipped_by {plane{y,0}}
}}

object{tttop rotate <10,0,45> translate<-2.5,3.0,0>}
object{ttbot rotate <0,0,0>}

sphere {0, 1 pigment{ image_map {tga "earth.tga" map_type 1}rotate 180*y} 
finish{ambient .6} no_shadow scale 3}

sphere {0, 1 pigment{ image_map {tga "earth.tga" map_type 1}rotate 0*y} 
finish{ambient .6} no_shadow scale 15
clipped_by{plane{y,0}}
}
sphere {0, 1 pigment{ image_map {tga "earth.tga" map_type 1}rotate 0*y} 
finish{ambient .6} no_shadow scale 15 translate -15*z rotate 90*x 
translate 15*z
clipped_by{plane{-y,0}}
}

