// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "cart.inc"

global_settings {assumed_gamma 2.2}

// ----------------------------------------
camera{
//  location  <-8.0, 0.0, 0.0>
//  location  <0.0, 0.0, -18.0>
//  location  <0.0, 18.0, 0.0>
  location  <0.0, 5.0, -24.0>//-18 -24
//  location <0,4,-44>
//  location <0,12,0>
  direction 1.5*z  right 16/9*x // 4/3*x
  look_at   <-0, -.0,  0.0>
}

//sky_sphere{  pigment  { gradient y color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }}}
sky_sphere{  pigment  { gradient y color_map { [0.0 color rgb 1] [1.0 color rgb .3] }}}

//light_source{0*x color <1,1,1>*.75 translate <-0, 40, -30>}
light_source{0*x color <1,1,1>*.75 translate <0, 5, -24>}

// ----------------------------------------

#declare ddd = -1;

#declare fam = .6; //ambient
#declare merd = ddd*.9;//-1
#declare vend = ddd *1.8;//-2
#declare eard = ddd*2.7;//-3;
#declare mard = ddd*3.6;//-4;
#declare jupd = ddd*4.9;//-5;
#declare satd = ddd*6.5;//-6.5;
#declare urad = ddd*7.8;//-8;
#declare nepd = ddd*8.9;//-9;
#declare ttex = T_Gold_2A //T_Brass_2A
#declare ttex2 = T_Silver_2A //T_Brass_2A


//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

// one clock = 1 day
// clockm to change rate *x /x

#declare clockm = clock + 100 ;

#declare ss=union{
//SUN
#declare base =union{
cylinder{<0,-4,0>,<0,-.25,0> 0.1 texture{ttex}}
torus{.2,.1 translate -2.8*y texture{ttex}}
torus{.3,.2 scale<1,.8,1> translate -2.95*y texture{ttex}}
torus{.4,.3 translate -3.3*y texture{ttex}}
torus{.6,.5 scale<1.5,1,1.5> translate -3.8*y texture{ttex}}
torus{1,.5 scale<2,.5,2> translate -4.2*y texture{ttex}}
cylinder{<0,-4.2,0>,<0,-10,0> 1.5 texture{ttex}}
}
object{base}

#declare sun=union{
sphere {0,1}
light_source { 0*x color <1,1,1> translate <-.20,+.2,+.3> 
 shadowless fade_distance 3 fade_power 2 }// 1 1
        texture {
                pigment {color rgbft <1,1,.7,1,0>}
                finish {
                        roughness 11
                        reflection .5
                        diffuse 1
                        brilliance 1
                        phong .50 phong_size .01
                }
        }        
        interior {ior 1.33 
        }
       scale .3
}
object {sun translate <0,0,0> }


#declare mag1 = 1.1;

//MERCURY 1
#declare merarm=union{
cylinder{<0,-1.2,0>,<0,-1.1,0> 0.15 texture{ttex}}
cylinder{<0,-1.15,0>,<merd,-1.15,0> 0.05 texture{ttex}}
cylinder{<merd,-1.15,0>,<merd,0,0> 0.05 texture{ttex}}
cylinder{<0,-1.2,0>,<0,-1.1,0> 0.1 texture{ttex}translate<merd,0,0>}
}
#declare mercury=union{
sphere{0,.2*mag1 pigment{color Gray} finish{ambient fam} translate<merd,0,0>}
object{merarm}}
object{mercury rotate -y*(360/87.97)*clockm}

//VENUS 2
#declare venarm = union{
cylinder{<0,-1.4,0>,<0,-1.3,0> 0.15 texture{ttex}}//main
cylinder{<0,-1.35,0>,<vend,-1.35,0> 0.05 texture{ttex}}//arm
cylinder{<vend,-1.35,0>,<vend,0,0> 0.05 texture{ttex}}//up
cylinder{<0,-1.4,0>,<0,-1.3,0> 0.1 texture{ttex}translate<vend,0,0>}//main
}
#declare venus=union{
sphere{0,.28*mag1 pigment{ image_map {png "venus-mine.png" map_type 1}} translate<vend,0,0>
finish{ambient fam}}
object{venarm}}
object {venus rotate -y*(360/224.7)*clockm}

//EARTH 3
#declare eararm=union{
cylinder{<0,-1.6,0>,<0,-1.5,0> 0.15 texture{ttex}}//main
cylinder{<0,-1.55,0>,<eard,-1.55,0> 0.05 texture{ttex}}//arm
cylinder{<eard,-1.55,0>,<eard,0,0> 0.05 texture{ttex}}//up
cylinder{<0,-1.6,0>,<0,-1.5,0> 0.1 texture{ttex}translate<eard,0,0>}//main
}
#declare earth=union{
sphere{0,.3*mag1
pigment{ image_map {tga "earth-comp.tga" map_type 1} } 
rotate 180*y translate<eard,0,0> finish{ambient .6}
finish {ambient fam}}
object{eararm}
}
object {earth rotate -y*(360/365.25)*clockm}

//MARS 4
#declare mararm=union{
cylinder{<0,-1.8,0>,<0,-1.7,0> 0.15 texture{ttex}}//main
cylinder{<0,-1.75,0>,<mard,-1.75,0> 0.05 texture{ttex}}//arm
cylinder{<mard,-1.75,0>,<mard,0,0> 0.05 texture{ttex}}//up
cylinder{<0,-1.8,0>,<0,-1.7,0> 0.1 texture{ttex}translate<mard,0,0>}//main
}
#declare mars=union{
sphere{0,.275*mag1 //.25
pigment{image_map {png "mars.png" map_type 1 }} 
translate<mard,0,0> finish{ambient fam} }
object{mararm}}
object{mars rotate -y*(360/686.98)*clockm}

//JUPITER 5
#declare juparm=union{
cylinder{<0,-2,0>,<0,-1.9,0> 0.15 texture{ttex}}//main
cylinder{<0,-1.95,0>,<jupd,-1.95,0> 0.05 texture{ttex}}//arm
cylinder{<jupd,-1.95,0>,<jupd,0,0> 0.05 texture{ttex}}//up
cylinder{<0,-2,0>,<0,-1.9,0> 0.1 texture{ttex}translate<jupd,0,0>}//main
}
#declare jupiter=union{
sphere{0,.5 
pigment{ image_map {png "jupiter.png" map_type 1} }
finish {ambient fam} 
translate <jupd,0,0>}
object{juparm}}
object{jupiter rotate -y*(360/4332.71)*clockm}

//SATURN 6
#declare satarm=union{
cylinder{<0,-2.2,0>,<0,-2.1,0> 0.15 texture{ttex}}//main
cylinder{<0,-2.15,0>,<satd,-2.15,0> 0.05 texture{ttex}}//arm
cylinder{<satd,-2.15,0>,<satd,0,0> 0.05 texture{ttex}}//up
cylinder{<0,-2.2,0>,<0,-2.1,0> 0.1 texture{ttex}translate<satd,0,0>}//main
}
#declare saturn=union{
sphere{0,.45 
pigment{image_map {png "saturn.png" map_type 1}}
finish {ambient fam}
translate<satd,0,0>}

disc{<0,0,0> y,.9,.81 pigment{color<1,.9,.50>} finish{ambient .6} translate<satd,0,0> }
disc{<0,0,0> y,.8,.71 pigment{color<1,.8,.50>}finish{ambient .6} translate<satd,0,0> }
disc{<0,0,0> y,.7,.61 pigment{color<1,.9,.50>}finish{ambient .6} translate<satd,0,0> }
object{satarm}}
object {saturn rotate -y*(360/10759.5)*clockm}

//URANUS 7
#declare uraarm=union{
cylinder{<0,-2.4,0>,<0,-2.3,0> 0.15 texture{ttex}}//main
cylinder{<0,-2.35,0>,<urad,-2.35,0> 0.05 texture{ttex}}//arm
cylinder{<urad,-2.35,0>,<urad,0,0> 0.05 texture{ttex}}//up
cylinder{<0,-2.4,0>,<0,-2.3,0> 0.1 texture{ttex}translate<urad,0,0>}//main
}
#declare uranus=union{
sphere{0,.32*mag1 
pigment{image_map {png "uranus.png" map_type 1}}
finish {ambient fam} 
translate<urad,0,0>}
object{uraarm}}
object {uranus rotate -y*(360/30685)*clockm}

//NEPTUNE 8
#declare neparm=union{
cylinder{<0,-2.6,0>,<0,-2.5,0> 0.15 texture{ttex}}//main
cylinder{<0,-2.55,0>,<nepd,-2.55,0> 0.05 texture{ttex}}//arm
cylinder{<nepd,-2.55,0>,<nepd,0,0> 0.05 texture{ttex}}//up
cylinder{<0,-2.6,0>,<0,-2.5,0> 0.1 texture{ttex}translate<nepd,0,0>}//main
}
#declare neptune= union{
sphere{0,.3*mag1
pigment{image_map {tga "neptune.tga" map_type 1}}
finish{ambient fam}
translate<nepd,0,0>}
object{neparm}}
object{neptune rotate -y*(360/60190)*clockm}

//PLUTO 9

}
object {ss rotate 180*y}

#declare stop = union {
sphere {0, 1 
//pigment{ image_map {tga "sfieldc.tga" map_type 1}rotate 0*y } 
//starsk1.tga
pigment{ image_map {tga "/mnt/vfat/images/stars.tga" map_type 1}rotate 0*y } 
finish{ambient .9 reflection .1} no_shadow 
scale 12
clipped_by{plane{y,0}}
}
torus{12.1, .1 sturm texture{ttex}
}
sphere{0,1.0001 scale 12 texture{ttex2}clipped_by{plane{y,0}}}
}
stop

#declare sbot = union {
sphere {0, 1 
//pigment{ image_map {tga "sfieldc.tga" map_type 1}rotate 0*y } 
pigment{ image_map {tga "/mnt/vfat/images/stars.tga" map_type 1}rotate 0*y } 
finish{ambient .9 reflection .1} no_shadow 
scale 12 
clipped_by{plane{-y,0}
}
//translate <12,12,-12>*.5 /*.707*/ rotate <70,-70,0> translate <-12,0,12>*.707
}
torus{12.1, .1 sturm texture{ttex}
//translate <12,12,-12>*.5 /*.707*/ rotate <70,-70,0> translate <-12,0,12>*.707
}
sphere{0,1.0001 scale 12 texture{ttex2}clipped_by{plane{-y,0}}}
}
object{sbot translate <12,12,-12>*.5 /*.707*/ rotate <70,-70,0> translate
<-12,0,12>*.707}
 

object{headhat scale<1,ratioh,1> rotate -20*x rotate 20*y scale 10 
translate <12,1,40>
}

#declare room = union{
plane { z, 300 // pigment {color White}}
//texture {pigment {image_map{tga "/home/matt/images/hitl/ahwp.tga"}
texture {pigment {image_map{tga "ahwp.tga"}
}}}
plane { z, -30 texture{ pigment {color White}
			finish { ambient .5 specular 1}}}
plane { y, 100 texture{ pigment {color White}
			finish { ambient .5 specular 1}}}
plane { y, -40 texture{ pigment {color White}
			finish { ambient .5 specular 1}}}
plane { x, 100 pigment {color White}}
plane { x, -200 texture{ pigment {color White}
			finish { ambient .5 specular 1}}}
}//union room
room
