// Persistence of Vision Ray Tracer Scene Description File
// File: CelticCross.inc
// Vers: 3.5
// Desc: A Celtic Cross monument
// Date: 04/30/02
// Auth: Jeff M. Thomas
//

#declare CCrossTexture=
  texture
  {
    T_Grnt5
    normal
    {
      wrinkles
      scale .1
    }
    scale .70
  }          

#declare CCross=
union
{
  difference
  {
    cylinder
    {
      <0,0,-.1>, <0,0,.1> .25
      texture{ CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .175
      texture{ CCrossTexture }
    }
  }
  difference
  {
    box
    { 
      <-.2,-.1,-.1>, <.2,.1,.1>
      texture { CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .35 
      scale <1,.8,1>
      translate <.15,.325,0>
      texture{ CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .35 
      scale <1,.8,1>
      translate <.15,-.325,0>
      texture{ CCrossTexture }
    }
    translate <-.3,0,0>
  }
  difference
  {
    box
    { 
      <-.2,-.1,-.1>, <.2,.1,.1>
      texture { CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .35 
      scale <1,.8,1>
      translate <.15,.325,0>
      texture{ CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .35 
      scale <1,.8,1>
      translate <.15,-.325,0>
      texture{ CCrossTexture }
    }
    rotate <0,0,-90>
    translate <0,.3,0>
  }
  difference
  {
    box
    { 
      <-.2,-.1,-.1>, <.2,.1,.1>
      texture { CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .35 
      scale <1,.8,1>
      translate <.15,.325,0>
      texture{ CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .35 
      scale <1,.8,1>
      translate <.15,-.325,0>
      texture{ CCrossTexture }
    }
    rotate <0,0,180>
    translate <.3,0,0>
  }
  difference
  {
    box
    { 
      <-.2,-.1,-.1>, <.2,.1,.1>
      texture { CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .35 
      scale <1,.8,1>
      translate <.15,.325,0>
      texture{ CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .35 
      scale <1,.8,1>
      translate <.15,-.325,0>
      texture{ CCrossTexture }
    }
    rotate <0,0,90>
    translate <0,-.3,0>
  }
  difference
  {
    box
    {
      //<-.25,-.3,-.101>, <.25,.3,.101>
      <-.5,-.3,-.101>, <.5,.3,.101>
      translate <0,-.75,0>
      texture{ CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .25 
      scale <1,.8,1>
      translate <-.5,-.3,0>
      translate <0,-.225,0>
      texture{ CCrossTexture }
    }
    cylinder
    {
      <0,0,-.11>, <0,0,.11> .25 
      //scale <0,.8,0>
      translate <.5,-.3,0>
      translate <0,-.225,0>
      texture{ CCrossTexture }
    }
  }
}
/*
sphere {
  0.0, 1
  texture {
    pigment {
      radial
      frequency 8
      color_map {
        [0.00 color rgb <1.0,0.4,0.2> ]
        [0.33 color rgb <0.2,0.4,1.0> ]
        [0.66 color rgb <0.4,1.0,0.2> ]
        [1.00 color rgb <1.0,0.4,0.2> ]
      }
    }
    finish{
      specular 0.6
    }
  }
}
*/
