/*
Leaf definition file - contains declarations of all leaf objects used in the examples.

Leaves should be about 1 unit wide, and their stem should begin at the origin.
The leaf should extent in the +y direction, or whatever direction you'd like 
with respect to a vertical stem.
*/

/* // I'm not using any leaves
#declare maple1 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "maple1.tga"
				once
			}
		}
		finish {
			ambient 0.5
			diffuse 0.5
		}
		normal {
			bump_map {
				tga "maple1.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*50
	translate <0, -0.43, 0.9>
}

#declare maple2 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "maple2.tga"
				once
			}
		}
		finish {
			ambient 0.5
			diffuse 0.5
		}
		normal {
			bump_map {
				tga "maple2.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*50
	translate <0, -0.43, 0.9>
}

#declare maple3 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "maple3.tga"
				once
			}
		}
		finish {
			ambient 0.5
			diffuse 0.5
		}
		normal {
			bump_map {
				tga "maple3.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*50
	translate <0, -0.43, 0.9>
}

#declare fallmaple1 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "fallmaple1.tga"
				once
			}
		}
		finish {
			ambient 0.7
			diffuse 0.5
		}
		normal {
			bump_map {
				tga "fallmaple1.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*50
	translate <0, -0.43, 0.9>
}

#declare fallmaple2 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "fallmaple2.tga"
				once
			}
		}
		finish {
			ambient 0.7
			diffuse 0.5
		}
		normal {
			bump_map {
				tga "fallmaple2.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*50
	translate <0, -0.43, 0.9>
}

#declare fallmaple3 = sphere {
	0, 1
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -1>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "fallmaple3.tga"
				once
			}
		}
		finish {
			ambient 0.7
			diffuse 0.5
		}
		normal {
			bump_map {
				tga "fallmaple3.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*50
	translate <0, -0.43, 0.9>
}

#declare orange1 = blob {
	threshold 0.6
	sphere {
		<0,-0.2,0>,0.5,1
	}
	sphere {
		<0,0.2,0>,0.2,-1
	}
	sphere {
		<0,-0.6,0>,0.2,-1
	}
	texture {
		pigment {
			color rgb <1,0.6,0.2>
		}
		finish {
			ambient 0.5
			diffuse 0.5
			specular 1
			roughness 0.01
		}
		normal {
			crackle 2
			turbulence 0.5
			scale 0.1
		}
	}
}

#declare orange2 = blob {
	threshold 0.6
	sphere {
		<0,-0.2,0>,0.5,1
	}
	sphere {
		<0,0.2,0>,0.2,-1
	}
	sphere {
		<0,-0.6,0>,0.2,-1
	}
	texture {
		pigment {
			color rgb <0.95,0.65,0.2>
		}
		finish {
			ambient 0.5
			diffuse 0.5
			specular 1
			roughness 0.01
		}
		normal {
			crackle 2
			turbulence 0.5
			scale 0.1
		}
	}
}

#declare pinkpetal = sphere {
	0, 0.7
	scale <2, 1, 1>
	clipped_by {
		sphere {
			<0, 0, -0.7>, 0.5
		}
	}
	texture {
		pigment {
			image_map {
				tga "pinkpetal.tga"
				once
			}
		}
		finish {
			ambient 0.5
			diffuse 0.5
		}
		normal {
			bump_map {
				tga "pinkpetal.tga"
				once
				bump_size -10
			}
		}
		translate <-0.5, -0.5, -0.5>
	}
	hollow
	rotate x*100
	translate <0, -0.6, 0.4>
}

#declare pinkflower = union {
	object { pinkpetal }
	object { pinkpetal rotate y*90 }
	object { pinkpetal rotate y*180 }
	object { pinkpetal rotate y*270 }
	sphere {
		<0, 0.1, 0>, 0.1
		scale <1, 0.3, 1>
		pigment {
			color rgb <0.8, 0.8, 0.8>
		}
		finish {
			ambient 0.5
			diffuse 0.5
			specular 0.3
			roughness 0.1
		}
		normal {
			granite 0.05
			scale 0.1
		}
	}
	scale 0.4
}

#declare berries = union {
	sphere {
		<0.5,-0.5,-0.3>,0.45
	}
	sphere {
		<-0.5,-0.5,-0.3>,0.45
	}
	sphere {
		<0,-0.5,0.3>,0.45
	}
	texture {
		pigment {
			color rgb <1,0.2,0.15>
		}
		finish {
			ambient 0.3
			diffuse 0.7
			specular 0.3
			roughness 0.1
		}
		normal {
			bumps 1
			turbulence 0.5
			scale 0.1
		}
	}
}
*/
#declare standard_branch = texture {
	pigment {
		bozo
		color_map {
			[ 0 rgb <0.75, 0.75, 0.7>*0.2 ]
			[ 0.5 rgb <0.75, 0.75, 0.7>*0.2 ]
			[ 0.5 rgb <0.75, 0.70, 0.65>*0.5 ]
			[ 1 rgb <0.75, 0.70, 0.65>*0.5 ]
		}
		scale <1,4,1>*0.02
	}
	finish {
		ambient 0.0
		diffuse 0.8
		metallic
		specular 0.3
		roughness 0.1
	}
	normal {
		crackle 3
		turbulence 0.5
		scale <1,4,1>*0.02
	}
}

#declare light_branch = texture {
	pigment {
		bozo
		color_map {
			[ 0 rgb <0.75, 0.75, 0.7>*0.5 ]
			[ 0.5 rgb <0.75, 0.75, 0.7>*0.5 ]
			[ 0.5 rgb <0.75, 0.70, 0.65>*0.7 ]
			[ 1 rgb <0.75, 0.70, 0.65>*0.7 ]
		}
		scale <1,4,1>*0.02
	}
	finish {
		ambient 0.0
		diffuse 0.8
		metallic
		specular 0.3
		roughness 0.1
	}
	normal {
		crackle 3
		turbulence 0.5
		scale <1,4,1>*0.02
	}
}
