
// Centre of bauble loop is <0,0,0>, with x axis going through it.

#local LoopRad=.30;
//#local StringRad=.02;
#local StringRad=.005;
#local Length=2.5;
#local BaubRad=1;

#local ThirdSide=sqrt(Length*Length-LoopRad*LoopRad);
#local StringAngle=degrees(asin(LoopRad/Length));

#debug concat("Angle=",str(StringAngle,3,3), "\n")

#local StringText=texture {
	pigment {
		colour Gray10
	}
}

#local AttachText=texture {
	pigment {
		colour Gray60
	}
}

#local BaubText=texture {
	pigment {
		colour rgbf <.1,.1,1,.2>
	}
	normal {
		bumps .02
		scale .2
	}
	finish {
		diffuse .1
		specular .8
		roughness .001
		reflection {
			.8
			metallic
		}
	}
}


#declare HBBauble=union {


union {	// String
	difference {
		torus {
	  		LoopRad,
			StringRad
			rotate z*90
		}
		sphere {
			<0,-Length,0>
			ThirdSide
		}
	}
	union {
		cylinder {
			<0,0,0>
			<0,ThirdSide,0>
			StringRad
			rotate x*StringAngle
		}
		cylinder {
			<0,0,0>
			<0,ThirdSide,0>
			StringRad
			rotate x*-StringAngle
		}
		translate -y*Length
	}
		
	texture {StringText}
}	// End of String

#local AttachLoopRad=.1;
#local AttachRad=.05;

union {
	torus {
		AttachLoopRad
		AttachRad
		rotate x*90
		translate <0,-(Length+AttachLoopRad-AttachRad*2),0>
	}
	texture {AttachText}
}

sphere {
	<0,0,0>
	BaubRad
	texture {
		BaubText
	}
	translate -y*(Length+BaubRad)

}
	

}