#include "sampletextures.inc"

/*
Makes a house: one unit = one metre
The plot of land is 10 metres by ten metres, centred on the origin.
House size depends on type: A non-terraced house is one metre from edge of plot of land.
Front door of house is on the negative z side

*/

#declare HBInteriorScale=.97;
#include "windowframe.inc"

#macro HBMakeHouse()
#debug "\n\n\nI'm making a house!\n\n"


#ifndef (HBTerrace)	// 0 - not a terraced house, 1 - left terrace, 2- mid-terrace, 3- right-terrace
#local HBTerrace=0;
#debug "\nHBTerrace not set: using default value\n"
#end

#ifndef (HBRoofAngle)
#local HBRoofAngle=30;
#debug "\nHBRoofAngle not set: using default value\n"
#end

#local HBRoofAngleRadians=radians(HBRoofAngle);

#ifndef (HBRoofOrient)
#local HBRoofOrient=1;	//0 - slope is side-to-side, 1-slope is front to back
#debug "\nHBRoofOrient not set: using default value\n"
#end

#ifndef (HBDoorPos)
#local HBDoorPos=0;	//0 - left, 1-centre, 2-right
#debug "\nHBDoorPos not set: using default value\n"
#end

#ifndef (HBGutterHeight)
#local HBGutterHeight=5;	//NB: House height is determined by both this and roof angle
#debug "\nHBGutterHeight not set: using default value\n"
#end

#ifndef (HBNumFloors)
#local HBNumFloors=2;
#debug "\nHBNumFloors not set: using default value\n"
#end

#ifndef (HBFloorHeight)
#local HBFloorHeight=2.5;
#debug "\nHBFloorHeight not set: using default value\n"
#end

#ifndef (HBWindowAmount)
#local HBWindowAmount=2;		// 0: none, 1: few, 2: normal, 3: lots
#debug "\nHBWindowAmount not set: using default value\n"
#end

#ifndef (HBNumFloors)
#local HBNumFloors=2;
#debug "\nHBNumFloors not set: using default value\n"
#end

#ifndef (HBFloorStart)
#local HBFloorStart=0;			// The y value of the base of the ground floor
#debug "\nHBFloorStart not set: using default value\n"
#end

#ifndef (HBWindowYStart)
#local HBWindowYStart=.8;			// Lowest point of the windows
#debug "\nHBWindowYStart not set: using default value\n"
#end

#ifndef (HBNumChimneys)
#local HBNumChimneys=1;
#debug "\nHBNumChimneys not set: using default value\n"
#end

#local tempcount=1;

box {			// Plot of land - debugging really
	<-5,0,-5>
	<5,-0.0001,5>
	texture {
		HBPLotLandT
	}
}

#local HBHouseBody=intersection {
	box {
		<-4,0,-4>
		<4,HBGutterHeight*2,4>		// Up to roof is 5m, + 5m "spare" above that
//		hollow
	}
	plane {
		y,0
		rotate z*HBRoofAngle
		translate <-4,HBGutterHeight,0>
		#if (HBRoofOrient) rotate y*90 #end
	}
	plane {
		y,0
		rotate z*-HBRoofAngle
		translate <4,HBGutterHeight,0>
		#if (HBRoofOrient) rotate y*90 #end
	}
}
#local HBDoorWidth=1;
#local HBDoorDepth=1;	//Weird huh?
#local HBDoorHeight=2;

#local HBDoorThickness=.05;
#local HBDoorSunk=.1;

#local HBLeftDoor=-1.5;
#local HBCentreDoor=0;
#local HBRightDoor=1.5;

#local HBDoorZ=-4;

#switch (HBDoorPos)
#case (0)
#local HBDoorX=HBLeftDoor;
#break
#case (1)
#local HBDoorX=HBCentreDoor;
#break
#case (2)
#local HBDoorX=HBRightDoor;
#break
#end

#local HBDoorGap=box {
	<HBDoorX-.5*HBDoorWidth,0,HBDoorZ-.5*HBDoorDepth>
	<HBDoorX+.5*HBDoorWidth,HBDoorHeight,HBDoorZ+.5*HBDoorDepth>
}

#local HBDoor=union {
	difference {
		box {
			<HBDoorX-.5*HBDoorWidth,0,HBDoorZ-.5*HBDoorThickness+HBDoorSunk>
			<HBDoorX+.5*HBDoorWidth,HBDoorHeight,HBDoorZ+.5*HBDoorThickness+HBDoorSunk>
		}
		box {
			<HBDoorX-.35*HBDoorWidth,HBDoorHeight*.1,HBDoorZ-.2*HBDoorThickness+HBDoorSunk>
			<HBDoorX-.05*HBDoorWidth,HBDoorHeight*.4,HBDoorZ-HBDoorThickness+HBDoorSunk>
		}
		box {
			<HBDoorX+.35*HBDoorWidth,HBDoorHeight*.1,HBDoorZ-.2*HBDoorThickness+HBDoorSunk>
			<HBDoorX+.05*HBDoorWidth,HBDoorHeight*.4,HBDoorZ-HBDoorThickness+HBDoorSunk>
		}
		box {
			<HBDoorX+.05*HBDoorWidth,HBDoorHeight*.5,HBDoorZ-.2*HBDoorThickness+HBDoorSunk>
			<HBDoorX+.35*HBDoorWidth,HBDoorHeight*.9,HBDoorZ-HBDoorThickness+HBDoorSunk>
		}
		box {
			<HBDoorX-.05*HBDoorWidth,HBDoorHeight*.5,HBDoorZ-.2*HBDoorThickness+HBDoorSunk>
			<HBDoorX-.35*HBDoorWidth,HBDoorHeight*.9,HBDoorZ-HBDoorThickness+HBDoorSunk>
		}
		cylinder {
			<HBDoorX-.4*HBDoorWidth,HBDoorHeight*.41,HBDoorZ+.2+HBDoorSunk>
			<HBDoorX-.4*HBDoorWidth,HBDoorHeight*.41,HBDoorZ-.04+HBDoorSunk>
			.01
		}
		box {
			<HBDoorX-.405*HBDoorWidth,HBDoorHeight*.41,HBDoorZ+.2+HBDoorSunk>
			<HBDoorX-.395*HBDoorWidth,HBDoorHeight*.39,HBDoorZ-.04+HBDoorSunk>
		}
		texture {
			HBDoor1T
		}
	}
	union {
		cylinder {
			<HBDoorX-.4*HBDoorWidth,HBDoorHeight*.45,HBDoorZ+.2+HBDoorSunk>
			<HBDoorX-.4*HBDoorWidth,HBDoorHeight*.45,HBDoorZ-.04+HBDoorSunk>
			.02
		}
		sphere {
			<HBDoorX-.4*HBDoorWidth,HBDoorHeight*.45,HBDoorZ-.03+HBDoorSunk>
			.04
		}
		texture {
			HBDoorKnobT
		}
	}	
}


#include "roofandchimneys.inc"
#include "windows.inc"

#local tempcount1=0;

#local HBInsideWalls = union {
#while (tempcount1<HBNumFloors)
	box {
		<3.9,tempcount1*HBFloorHeight+.05,3.9>
		<-3.9,tempcount1*HBFloorHeight-.05,-3.9>
	}
#local tempcount1=tempcount1+1;
#end
	texture {
		HBCarpetT
	}
}

#local HBHouseWithGaps=difference {
	difference {
		object {
			HBHouseBody
			texture {
				HBMainHouse1T
			}
		}
		object {
			HBHouseBody
			scale <HBInteriorScale,1,HBInteriorScale>
			texture {
				HBInteriorWallsT
			}
		}
//		pigment {rgb 1}
	}
	union {
		object {
			HBDoorGap
		}
		object {
			HBWindowGaps
		}
		texture {
			HBMainHouse1T
		}
		
	}
}

#local HBFinalHouse=union {
	object {
		HBHouseWithGaps
	}
	object {
		HBRoof
	}
	object {
		HBGuttering
	}
	object {
		HBChimneys
	}
	object {
		HBDoor
	}
	object {
		HBInsideWalls
	}
	object {
		HBWindows
	}
}

object {HBFinalHouse}

#debug "\n"

#end	// End Macro