
#local HBRoofOverhang1=.1;	//Pointy bit overhang
#local HBRoofOverhang2=.3;	//Slopey bit overhang
#local HBRoofThickness=.08;
#local HBGutterRad=.04;

#declare HBRoof=union {
	box {
		<0,-HBRoofThickness/2,-4-HBRoofOverhang1>
		<-4/cos(HBRoofAngleRadians)-HBRoofOverhang2,HBRoofThickness/2,4+HBRoofOverhang1>
		texture {
			HBRoof1T
		}
		rotate z*HBRoofAngle
		translate y*(HBGutterHeight+4*tan(radians(HBRoofAngle)))
	}
	box {
		<0,-HBRoofThickness/2,-4-HBRoofOverhang1>
		<4/cos(HBRoofAngleRadians)+HBRoofOverhang2,HBRoofThickness/2,4+HBRoofOverhang1>
		texture {
			HBRoof1T
		}
		rotate -z*HBRoofAngle
		translate y*(HBGutterHeight+4*tan(HBRoofAngleRadians))
	}
	#if (HBRoofOrient) rotate y*90 #end
}

#local HBChimneyHeight=1;
#local HBChimneyWidth=.4;
#local HBChimneyPos=2.5;

#local HBSingleChimney = union {
	box {
		<-HBChimneyWidth,-HBChimneyHeight*.6, -HBChimneyWidth>
		<HBChimneyWidth,HBChimneyHeight*.6,HBChimneyWidth>
		texture {
			HBMainHouse1T
		}
	}
	cylinder {
		<0,HBChimneyHeight*.6,0>
		<0,HBChimneyHeight,0>
		HBChimneyWidth*.6
		texture {
			HBChimPotT
		}
	}	
}

		

#if (HBNumChimneys=1)
#declare HBChimneys=object {
	HBSingleChimney
	translate <-HBChimneyPos, (HBGutterHeight+4*tan(radians(HBRoofAngle))), 0>
	#if (HBRoofOrient=0) rotate y*90 #end
}
#else
#if (HBNumChimneys=2)
#declare HBChimneys= union {
	object {
		HBSingleChimney
		translate <-HBChimneyPos, (HBGutterHeight+4*tan(HBRoofAngleRadians)), 0>
	}
	object {
		HBSingleChimney
		translate <HBChimneyPos, (HBGutterHeight+4*tan(HBRoofAngleRadians)), 0>
	}
	#if (HBRoofOrient=0) rotate y*90 #end
}
#else
#declare HBChimneys=sphere {0,0}
#end
#end


#local HBGutterOneSide = union {
	intersection {
		cylinder {
			<0,0,4>
			<0,0,-4>
			HBGutterRad
	//		open
			hollow
		}
		plane {
			y
			0
			pigment {rgbf 1}
		}
		translate <4+HBGutterRad+HBRoofOverhang2*cos(HBRoofAngleRadians),HBGutterHeight-HBRoofOverhang2*sin(HBRoofAngleRadians),0>
	}
	cylinder {
		<4+HBGutterRad+.01,-1,-3.5>
		<4+HBGutterRad+.01,HBGutterHeight-HBRoofOverhang2*sin(HBRoofAngleRadians)-.2,-3.5>
		HBGutterRad
	}
	cylinder {
		<4+HBGutterRad+.01,HBGutterHeight-HBRoofOverhang2*sin(HBRoofAngleRadians)-.2,-3.5>
		<4+HBGutterRad+HBRoofOverhang2*cos(HBRoofAngleRadians),HBGutterHeight-HBRoofOverhang2*sin(HBRoofAngleRadians),-3.5>
		HBGutterRad
		open
	}
	texture {
		HBGutterT
	}
}	

#declare HBGuttering=union {
	object {
		HBGutterOneSide
	}
	object {
		HBGutterOneSide
		scale <-1,1,1>
	}
	#if (HBRoofOrient) rotate y*90 #end
}