/**
 * Back Mountain Road
 *
 * By the Lamere family
 */
#include "textures.inc"
#include "shapes.inc"
#include "colors.inc"
#include "golds.inc"
#include "stones2.inc"
#include "woods.inc"

#include "mailbox.pov"

#declare WANT_TREES = 0;
camera {
      location <8, 5, 22>
      // right <2.133, 0,0>
      look_at <2, 4,1 >
    }

light_source { <8, 5, 22> color Gray75 }		// a fill
light_source { <3000, 1000, 202> color White }
light_source { <3000, 1000, 201> color White }
light_source { <1000, 1000, 200> color White }


// Create the fence, piece by piece

#declare R1 = seed(0);
#declare boardWidth =  .25;

#declare staff = union {
	box { <0,0,0>, <boardWidth, 4, .05> // pigment { color White }
		texture { T_Wood4  rotate x * 90}
	       pigment { rgbf <.8,.8,.9, .8>}
	}
	superellipsoid {
	      <.95, boardWidth>  // pigment { color Green } 
	      scale <.125, .10, .025>
	      translate <.125, 4, .025>
		texture { T_Wood4  rotate x * 90  }
	       pigment { rgbf <.8,.8,.9, .8>}
	}
}

#declare board = union {
    object { staff } 
}

#declare connector = union {
    box { <.2,0,0>, <.55, .05, .02>  
	   pigment { color Black }
	   translate <0, 3.2, -.05>
    }
    box { <.2,0,0>, <.55, .05, .02>  
	   pigment { color Black }
	   translate <0, 1.2, -.05>
    }
}

// Build the fence

#declare Count = 0;
#declare Total = 100;
#declare Start = 0;
// near fence should look a bit neater.
#declare ynoise = .15;
#declare spaceNoise = .1;

#declare ZOffset = Start;
#while (Count <= Total) 
    #declare boardSpacing = rand(R1) * spaceNoise - spaceNoise/2;
    #declare ZOffset = ZOffset + (.4 + boardSpacing);
    #declare YOffset = rand(R1) * ynoise - ynoise/2;
    object {board rotate y * 90 translate <-1, YOffset, ZOffset> }
    object {connector rotate y * 90 translate <-1, 0, ZOffset> }
    #declare Count = Count + 1;
#end

#declare spaceNoise = .3;
#declare ynoise = .3;

#declare Count = 0;
#declare Total = 300;
#declare Start = -2;

#declare XOffset = Start;
#while (Count <= Total) 
    #declare boardSpacing = rand(R1) * spaceNoise - spaceNoise/2;
    #declare XOffset = XOffset - (.4 + boardSpacing);
    #declare YOffset = rand(R1) * ynoise - ynoise/2;
    #declare ZOffset = -55;
    object {board  translate <XOffset, YOffset, ZOffset> }
    object {connector  translate <XOffset, 0, ZOffset> }
    #declare Count = Count + 1;
#end

#declare Count = 0;
#declare Total = 100;
#declare Start = -15;
#declare ZOffset = Start;
#while (Count <= Total) 
    #declare boardSpacing = rand(R1) * spaceNoise - spaceNoise/2;
    #declare ZOffset = ZOffset - (.4 + boardSpacing);
    #declare YOffset = rand(R1) * ynoise - ynoise/2;
    object {board rotate y * 90 translate <-1, YOffset, ZOffset> }
    object {connector rotate y * 90 translate <-1, 0, ZOffset> }
    #declare Count = Count + 1;
#end

#declare Count = 0;
#declare Total = 1900;
#declare Start = -900;

#declare ZOffset = Start;
#while (Count <= Total) 
    #declare boardSpacing = rand(R1) * spaceNoise - spaceNoise/2;
    #declare ZOffset = ZOffset + (.6 + boardSpacing);
    #declare YOffset = rand(R1) * ynoise - ynoise/2;
    object {board rotate y * 90 translate <15, YOffset, ZOffset> }
    object {connector rotate y * 90 translate <15, 0, ZOffset> }
    #declare Count = Count + 1;
#end


	

#declare mbox = union {
    object { mailbox  rotate y * 180 translate <1.1, 4.0, 0> }
    cylinder { 
	    <.5, 0, 0>, <.5, 4.0, 0>, .1
	   texture { T_Wood4  rotate x * 90}
	   pigment { rgbf <.2,.2,.2, .2>}
    }
    		
}

#declare mboxDown = union {
    object { mailboxFlagDown  rotate y * 180 translate <1.1, 4.0, 0> }
    cylinder { 
	    <.5, 0, 0>, <.5, 4.0, 0>, .05
	   texture { T_Wood4  rotate x * 90}
	   pigment { rgbf <.2,.2,.2, .2>}
    }
    		
}
object { mbox  }
object { mboxDown  rotate z * 2 translate <-.1, -.2, 2> }


// carve out tire tracks
difference {
    box { <-1000, 0, -1000>, <1000, 0.8, 1000>
	    texture {
		pigment { color White }
		finish { ambient .4 }
	    }

	    normal {
		crackle 0.5
	    }
    }

    box {
        <1, .5, 100>, <1.5, 1, -600>
	pigment { color White }
	finish {
		ambient .4
	}
    }

    box {
        <5, .5, 100>, <5.5, 1, -600>
	pigment { color White }
	finish {
		ambient .4
	}
    }
}



plane {
 	y, 0
	pigment { color White }
	finish {
		ambient .4
	}
}


// Some mountains.

#declare mound = lathe {
	cubic_spline
	9,
	 <.0, 1>,
	 <.1, 1.5>,
	 <.2, 2>,
	 <.4, 3>,
	 <.8, 4>,
	 <.4, 5>,
	 <.2, 6>,
	 <.1, 7>,
	 <.0, 8>
	 sturm
     pigment { color White }
     rotate <0, 0, 90>
}

#declare hill = object  {
    mound 
     scale < 1000, 1300, 1000>
     translate <3000, -200, -3000>
     pigment {
         bozo
	 turbulence .5
	color_map {
		[ 0 rgb <.50, .50, .55> ]
		//[ .5 rgb <.55, .55, .60> ]
		// [ .8 rgb <.25, .25, .30> ]
		[ 1 Gray75]
//		[0 rgb <.3, .3, .4> ]
//		[.8  rgb <.8, .8, .9> ]
	    }
     	rotate x * 90
	scale <1.1, .1, .1>
     }
}

#declare hill2 = object  {
    mound 
     scale < 1300, 1500, 1000>
     translate <5000, -200, -4000>
}

#declare hill3 = object  {
    mound 
     scale < 1000, 1200, 1000>
     translate <6000, -200, -500>
}

#declare hill4 = object  {
    mound 
     scale < 1000, 1200, 1000>
     translate <1850, -200, -200>
}

object { hill }
object { hill2 }
object { hill3 }
object { hill4 }


#include "Sky2.inc"
#ifdef (WANT_TREES)
#include "leafdefs.inc"
#include "splinetree.inc"


#declare recursionmax = 6; // Defines the complexity of the tree
#declare divisions = array[6] {6,4,4,3,2,2}
init_rand (89,158,157)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.4, 0.8, 0.9)
init_rdev (70, 40, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (3.4, 0.2, 0.6)
init_branchw (0.35, 0.005, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.3,0.5)	// Use: init_splinedev (min_dev, max_dev)
//init_splinedev (0.1,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
// #declare tendancy = <-0.1,-0.5,0>;
#declare tendancy = <-0.0,-0.0,0>;

// Assign the branch texture
#declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <2,2,2>
	rotate <0,0,0>
}

// Provide feedback in the first 2 recursion levels
#declare feedback = 1;

#declare TallTree = union {
    splinetree(0,0)
}


object { TallTree 
	rotate <0, -49, 0>
	translate <-6,0.3,-30> 
}

object { TallTree 
	rotate <0, 45, 0>
	translate <-20,0.3,-30> 
}

object { TallTree 
	rotate <0, 90, 0>
	translate <-60,0.3,-30> 
}


object { TallTree 
	rotate <0, 140, 0>
	// translate <-10,0.3, 5> 
	translate <-8,0.3, 5> 
}


#declare recursionmax = 6; // Defines the complexity of the tree
#declare divisions = array[6] {6,4,4,3,2,2}
init_rand (89,158,157)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.4, 0.8, 0.9)
init_rdev (40, 20, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (5.4, 0.2, 0.6)
init_branchw (0.35, 0.005, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.1,0.3)	// Use: init_splinedev (min_dev, max_dev)
//init_splinedev (0.1,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
// #declare tendancy = <-0.1,-0.5,0>;
#declare tendancy = <-0.0,-0.0,0>;

// Assign the branch texture
#declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <2,2,2>
	rotate <0,0,0>
}

// Provide feedback in the first 2 recursion levels
#declare feedback = 1;

#declare TallTree2 = union {
    splinetree(0,0)
}

object { TallTree2  scale <1,1,1> rotate <0, 90, 0> translate <20, 45, -490> }
object { TallTree2  scale <1,1.1> rotate <0, -0, 0> translate <50, 50, -490> }
object { TallTree2  scale <1,1,1> rotate <0, -77, 0> translate <90, 57, -490> }

object { TallTree2  translate <25, 0, 0> }
object { TallTree2  rotate <0, 40, 0> translate <25, 0, -40> }
object { TallTree2  rotate <0, -60, 0> translate <25, 0, -90> }
object { TallTree2  rotate <0, -80, 0> translate <25, 0, -140> }
object { TallTree2  rotate <0, -20, 0> translate <25, 0, -190> }
object { TallTree2  rotate <0, -0, 0> translate <25, 0, -240> }
object { TallTree2  rotate <0, 90, 0> translate <25, 0, -290> }
object { TallTree2  rotate <0, -120, 0> translate <25, 0, -340> }
object { TallTree2  rotate <0, 120, 0> translate <25, 0, -390> }

#end

