/*
By: John VanSickle

    From time to time you will have something lying along a certain axis,
and you'll want to turn it so that it points along another. This macro will do that.
Like all the other forms of rotation, it presumes that the object is at the origin;
if the object away from the origin, the usual consequences will follow.<br><br> 
object { MyObject
  Reorient(y,<1,-2,1.5>)
}
*/



#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end
