#declare GrassTex =
texture {
        pigment { 
                wrinkles 
                color_map {
                        [0.25 color rgb <0.5+0.1,0.9-0.4,0.2>*0.3]
                        [0.5 color rgb <0.3+0.1,0.8-0.4,0.1>*0.3]
                        [0.85 color rgb <0.5+0.1,1-0.4,0>*0.3]
                }
        }
        finish {ambient 0 diffuse 0.4 specular 90 roughness 0.005}
}

#declare R = seed(343);

#declare XP = -2.5;
#declare ZP = -2.5;

#declare blade = 
mesh {
        #declare No_Segs = 15;
        #declare C = 0;
        #declare Seg_length = 0.25;
        #declare Rot = 90-15;
        #declare Ox = 0;
        #declare Oy = 0;
        #declare Nx = Seg_length;
        #declare Ny = Seg_length;
        #declare Z = 0.15;
        #while (C<No_Segs)
                #declare xdist = sin(radians(90-Rot))*Seg_length;
                #declare ydist = cos(radians(90-Rot))*Seg_length;
                #declare No_Segs = 15+(rand(R)*10);
                #declare Nx = Ox+xdist;
                #declare Ny = Oy+ydist;
                #if (C<(No_Segs-1))
                        triangle {<Ox,Oy,Z><Ox,Oy,-Z><Nx,Ny,Z>}
                        triangle {<Ox,Oy,-Z><Nx,Ny,Z><Nx,Ny,-Z>}
                #else
                        triangle {<Ox,Oy,Z><Ox,Oy,-Z><Nx,Ny,0>}
                #end
                #declare Rot = Rot-pow((2+rand(R)*1.5),2);
                #declare Ox = Nx;
                #declare Oy = Ny;
                #declare Z = Z-0.012;
                #declare Seg_length = Seg_length+0.01;
                #declare C = C+1;
        #end
}

#declare Patch = 
union{
        #declare Inc = 0.05;
        #declare Angle = 0;
        #declare CT = 0;
        #while (CT < 15)
                object {
                        blade
                        rotate y*pow((2+rand(R)*180),2)
                        scale .5+(rand(R)/2)
                        translate<0,0,Inc+(rand(R)/3) >
                        rotate y*Angle
                        texture{GrassTex}
                        double_illuminate
                }
                #declare CT = CT+1;
                #declare Inc = Inc+0.025;
                #if (CT > 150)
                        #declare Angle = Angle+7.5;
                #else
                        #declare Angle = Angle+15;
                #end
        #end
}

#declare veg31 = object {Patch scale <0.4,0.3,0.4>*0.8}