global_settings {noise_generator 2}        
        
#declare ftname = "veg41.inc"
#warning concat (ftname," veg41 file creation start\n")
#fopen filehandle ftname write

#declare amb = 0;

#declare default_normal =
normal {
	average 
	normal_map {
                [bumps 1.4 warp {turbulence 1} scale 0.03]
                [bumps 1 warp {turbulence 0.5} scale 0.0003]
        }
}  

#declare hfscalx = 80;
#declare hfscaly = 5;
#declare hfscalz = 80;

#declare hftranx = 0;
#declare hftrany = -1.9;
#declare hftranz = 30;

#include "grass3.inc" 

#declare Pigmap1  = function {pigment {image_map {png "hf_lake4"} rotate x*90 translate -0.5 scale <hfscalx,hfscaly,hfscalz>}}
#declare Land = height_field {png "hf_lake4" smooth translate -0.5 scale <hfscalx,hfscaly,hfscalz>}

#local rfac = 97698*41;
#local eR = seed(60410+rfac*3);  
#local eR2 = seed(30195+rfac*565);
#local eR3 = seed(27419+rfac*9);

#macro veg_macro (G1,G2,Gnum,Maxheight,DispObject,NormMaxAngle)

#local V = 0;

union
{
 #local GW = G2.x-G1.x;
 #local GD = G2.y-G1.y;
 #while(V < Gnum)
  #local X = rand(eR)*GW;
  #local Z = rand(eR)*GD;
  #local CMap = (Pigmap1(X,0,Z));                      
  #local Norm = <X+G1.x,0,Z+G1.y>;
  #local Start = <X+G1.x,Maxheight,Z+G1.y>;
  #local Inter = trace(DispObject,Start,Norm-Start,Norm);
  #if (Norm.x != 0|Norm.y != 0|Norm.z != 0)
   #local NormTest = acos(vdot(Norm,y));
   #if (NormTest < NormMaxAngle) 
    #if ((CMap.x*.3333+CMap.y*.3333+CMap.z*.3333) > 0.02)                                  
     #local ab = (1+rand(eR3))/1.5;
     #local ac = 360*rand(eR);
     #local ad = degrees(atan2(Norm.z,Norm.y));
     #local ae = degrees(atan2(Norm.x,Norm.y));
     #local af = X+G1.x;
     #local ag = Inter.y;
     #local ah = Z+G1.y;
     object {veg31
        scale ab
        rotate y*ac
        rotate z*ad
        rotate x*ae
        translate <af,ag,ah>
        //#debug concat("<",vstr(3,<X+G1.x,Inter.y,Z+G1.y>,",",5,3),"> "\n")
        #debug concat(str(V,0,0)," veg placed.\n")
        #write (filehandle,"object {veg31 scale ",ab," rotate y*",ac," rotate <",ad,",0,",ae,"> translate <",af+hftranx,",",ag+hftrany,",",ah+hftranz,"> } // ",V+1,"\n")
     }
   #else
    #local V = V-1; 
   #end
    #local V = V+1;
/*
    #if(mod(V,1)=0)
     #debug concat(str(V,0,0)," veg30 placed.\n")
    #end
*/
   #end     //NormTest
  #end  
 #end
}
#end  


veg_macro (<hfscalx*-1,hfscalz*-1>,<hfscalx,hfscalz>,400,hfscaly+hftrany+0.01,Land,360)

#undef Pigmap1
#declare Pigmap1  = function {pigment {image_map {png "hf_lake4"} rotate x*90 translate -0.5 scale <-hfscalx,hfscaly,hfscalz>}}
#declare hftranx = 80;

veg_macro (<hfscalx*-1,hfscalz*-1>,<hfscalx,hfscalz>,400,hfscaly+hftrany+0.01,Land,360)

#declare hftranx = -80;

veg_macro (<hfscalx*-1,hfscalz*-1>,<hfscalx,hfscalz>,400,hfscaly+hftrany+0.01,Land,360)