// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc" 
#include "STONES.INC"   // Binding include-file for STONES1 and STONES2
#include "STONES1.INC"  // Great stone-textures created by Mike Miller
#include "STONES2.INC"  // More, done by Dan Farmer and Paul Novak

global_settings {
  assumed_gamma 2
}

// ----------------------------------------




#declare LICHT=1;

camera {
  location  <0, 5, -22.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 1.2,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.,0,0.05>]
      [0.5 rgb <0.02,0,0.1>]
      [1 rgb   <0,0,0.05>]
    }
  }
}

 
 
 

#if (LICHT=0)
union { 
     
light_source {
  <0, 0, 0>            
  color rgb <1, 0.8, 0.3>  
  translate <0, 0.79, 0>
 media_interaction 0

} 
#end   

#if (LICHT=1)
light_source {
  0*x                 
  color rgb <1, 0.8, 0.3>*4       
  area_light
  <0.1, 0.1, -0.1> <-0.1, -0.1, 0.1> 
  3, 3                
  adaptive 2          
  jitter             
  circular            
  orient              
  translate <0, 0.75, 0>   
} 
#end




#declare Halbkugel=
difference {          
 sphere {0,1}
 sphere {0,0.9}
 plane {y,0}
}
  
  
  
// Iglu   
difference{
 union {          
 //oberster Stein
 intersection {
 object {Halbkugel}
 cone {0,0,<0,2,0>,0.5}
 translate <0,0.025,0>
 }                
 //1. Ring
 
 intersection {
 object {Halbkugel}
 cone {0,0,<0,2,0>,0.55 inverse}
 cone {0,0,<0,2,0>,1} 
 box {<0.005,0,-2><-0.005,2,2> inverse}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,90,0>}
 translate <0,0.02,0>
 }                
 //2. Ring
                     
                     
 intersection {
 object {Halbkugel}
 cone {0,0,<0,2,0>,1.7 }
 cone {0,0,<0,2,0>,1.05 inverse}
 box {<0.005,0,-2><-0.005,2,2> inverse}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,60,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,120,0>}
 translate <0,0.0055,0>
 rotate <0,25,0> 
 }     
 //3. Ring
 
 intersection {
 object {Halbkugel}
 cone {0,0,<0,2,0>,1.75 inverse}
 cone {0,0,<0,1.5,0>,2.2 }
 box {<0.005,0,-2><-0.005,2,2> inverse}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,45,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,90,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,135,0>}
 rotate <0,0,0>
 translate <0,0.005,0>
 }
       
 //4. Ring
 intersection {
 object {Halbkugel}
 cone {0,0,<0,1,0>,3 }
 cone {0,0,<0,1.5,0>,2.25 inverse}
 box {<0.005,0,-2><-0.005,2,2> inverse}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,30,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,60,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,90,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,120,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,150,0>}
 rotate <0,-25,0>
 translate <0,0.005,0>
 } 
           
 //5. Ring
 intersection {
 object {Halbkugel}
 cone {0,0,<0,1,0>,3.05 inverse}
  box {<0.005,0,-2><-0.005,2,2> inverse}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,30,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,60,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,90,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,120,0>}
 box {<0.005,0,-2><-0.005,2,2> inverse rotate <0,150,0>}
 rotate <0,45,0>
 }
 
 }
 // eingang
 cylinder {<0,-0.3,0>,<0,-0.3,-2>,0.4}
 
 texture {
  pigment {
  color rgbft <0.9,0.94,1,0.7,0.1>
  } 
  finish {phong 0.2 reflection 0.15 roughness 0.3}
  normal {bumps 0.5 turbulence 0.5 scale 0.2 }
 }  
 
 interior {ior 1.5}
 
rotate <0,-55,0> 
scale 2
translate <0,-0.08,0>
}


//Langschaft

height_field {
 tga "Height-field.tga"
 smooth
 translate <-0.5,0,-0.5>
 scale <50,4,50>
 translate <0,-2,0>  
  
 texture {
  pigment { color rgb 0.3 }
  finish {phong 0.5}
  normal {bumps 0.2 turbulence 0.2 scale 0.1}
  finish {reflection 0.1 phong 0.3} 
  }
}     

//mond     
union {
 sphere {
  0,1000 
  no_shadow
  texture {
   pigment {
    image_map{
     tga "mond.tga"
     map_type 1  
    }          
   } 
   finish {ambient 0.6}
  }  
  translate <0,0,5000> 
 }

 light_source {
  0 color rgb <0.6,0.6,1>
  media_interaction 0
 }
 translate <0,0,20000>
 rotate <-3,10,0>
}   

// Licht
light_source {
 0 
 color rgb <0.4,0.4,0.8>
 media_interaction 0
 translate <0,100,0>
}

// Kste 

height_field {
 tga "rand.tga"
 translate <-0.5,0,0>
 scale <400,2,200>
 translate <0,-6,20>
 
 texture {
  pigment {
  color rgb 0.3 
 
  }
  finish {phong 0.5}
  normal {bumps 0.2 scale 0.1}
  finish {reflection 0.1 phong 0.3} 
 } 
}


//wasser
disc {<0,-5.5,0>,y,800  
 texture {
  pigment {color rgbf <0,0.1,0.2,0.3>} 
  finish {reflection 0.2}
  normal {waves 0.3 scale 10 translate <0,0,100>}
 }
}
   
      
fog {
 fog_type 2 
 turbulence 0.3
 scale <15,1,15>
 distance 0.3
 fog_offset -7 
 fog_alt 0.2 
 color rgbft <0.1,0.2,0.4,0.4,0.7>
 }

 

//skier
#declare Ski=
merge {
 box {<0,0,0><8,100,0.5>}
 difference {
  cylinder {<0,100,20><8,100,20>20.5}
  cylinder {<-0.5,100,20><8.5,100,20>20}
  plane {y,100} 
  cylinder {<0,100,-30><0,100,30>,18 inverse}  
  cylinder {<8,100,-30><8,100,30>,18 inverse}  
 } 
  texture {
   pigment {color rgb <0.4,0.3,0.25>} 
   normal {bumps 0.1 scale 0.05}
  }
  scale 1/60 
 } 
 
union {
 object {Ski rotate <0,0,20>}
 object {Ski rotate <0,0,-15> translate <-0.7,0.1,0>}
 rotate <4,35,4>
 translate <-1,-0.25,-3.5>
 
}
                                                                                         
//wolken                              
sphere {
 <0,-100000,0>,100300
 inverse
 texture {
  pigment {
   bozo   
   turbulence 0.5
   color_map
   {
     [0 color rgbf <0.6,0.6,1,0.5>]
     [0.5 color rgbf 1]
     [1 color rgbf 1 ]
   }
   scale 800
  }
 }
}                              
                              

// Stein

#declare fn_Pigm2=function {
 pigment {
  dents 
  turbulence 0.2           
  omega 0.3
  lambda 0.3
  scale  0.5
  translate <0,15*clock,0>   
 }
}

#declare Stein=
isosurface {
 function { 
  sqrt (x*x/2+y*y+z*z)-2 +2*fn_Pigm2(x,y,z).gray*0.5  
 }
 contained_by {
  sphere{ 0, 2.25} 
 }  
 accuracy 0.001                      
 max_gradient 4                                   

}                                 



union {
object {
Stein 
 texture {
 T_Stone31 
 scale 2 
 finish {roughness 0.7  phong 0}
 normal {crackle 1 scale 0.5}
 } 
}
object {
Stein   
translate <0,0.25,0>
 texture {
  pigment { color rgb 0.3 }
  finish {phong 0.5}
  normal {bumps 0.2 turbulence 0.2 scale 0.1}
  finish {reflection 0.1 phong 0.3} 
  }
scale 0.9
} 
scale <0.9,0.45,0.55>
rotate <0,65,0>
translate <-4.5,-0.25,-3>

}                           