#include "colors.inc"
#include "metals.inc"
#include "textures.inc"

global_settings { max_trace_level 10 }

camera {
   location <0,0,0.0050>
   look_at <0,0,1>
}

light_source { <0,0,0> color White*2 }

#declare yShift=(6-sqrt(12))/3;
#declare sph1=<-2,-2+yShift,0>;
#declare sph2=<2,-2+yShift,0>;
#declare sph3=<0,(sqrt(12)-2)+yShift,0>;
#declare sph4=<0,0,4*sqrt(2/3)>;

#declare sphereTex=texture { finish { ambient 0 diffuse 0.0 reflection 1 } pigment { color White quick_color Red } } 

sphere { sph1, 2 texture { sphereTex } }
sphere { sph2, 2 texture { sphereTex } }
sphere { sph3, 2 texture { sphereTex } }
sphere { sph4, 2 texture { sphereTex } }

triangle { sph1, sph2, sph3 texture { finish { ambient 0 diffuse 0.50 reflection 1}  pigment { color White quick_color Green } } }
triangle { sph4, sph2, sph3 texture { finish { ambient 0 diffuse 0.50 reflection 1}  pigment { color White quick_color Green } } }
triangle { sph1, sph4, sph3 texture { finish { ambient 0 diffuse 0.50 reflection 1}  pigment { color White quick_color Green } } }
triangle { sph1, sph2, sph4 texture { finish { ambient 0 diffuse 0.50 reflection 1}  pigment { color White quick_color Green } } }
