#version unofficial MegaPov 0.7;
#include "colors.inc"
#include "bird.inc"
#include "metals.inc" 
#include "dude1.pov" 
#include "dude2.pov"
#include "dude3.pov"
#include "dude4.pov"
#include "dude5.pov"
#include "dude6.pov"
#default {
   finish {
      ambient .2
   }
}
/*global_settings{
  photons{
    count 20000
    autostop 0
    jitter .4
  }
} */



#declare AlienShip=
union{
   difference{
      torus{
         3.5,.4
         pigment{color P_Chrome2}
         finish{F_MetalA}   
         scale <2,.4,1>      
      }
      sphere{
         <-1,0,0>,3
         pigment{color LimeGreen}
         finish{
            F_MetalA
            ambient .7
         }
         scale <2,.8,1>
      }
      translate <-1,0,0>
   }
   difference{
      torus{
         3.5,.4
         pigment{color rgb <0.41, 0.45, 0.50>}
         finish{F_MetalC ambient .3}   
         scale <2,.5,1>      
      }
      sphere{
         <-1,0,0>,3
         pigment{color LimeGreen}
         finish{
            F_MetalD 
            ambient 1
         }
         scale <2,.8,1>
      }
      scale .3
      translate <-4,0,0>
   }
   difference{
      torus{
         3.5,.4
         pigment{color rgb <0.41, 0.45, 0.50>}
         finish{
            F_MetalC 
            ambient .3
         }   
         scale <2,.5,1>      
      }
      sphere{
         <-1,0,0>,3
         pigment{color LimeGreen}
         finish{
            F_MetalD 
            ambient 1
         }
         scale <2,.8,1>
      }
      scale .3
      translate <-4,0,0>
      rotate <90,0,0>
   }
   difference{
      torus{
         3,.4
         pigment{color P_Copper4}
         finish{F_MetalC}   
         scale <2,4,1>
         scale .6
      }
      sphere{
         <-2.7,0,0>,1
         pigment{
            bozo
            color_map{
               [0 color rgb<1,0,1>]
               [1 color rgb<0,0,0>]
            }
            scale .2
         }
         scale <2,1,1>
         finish{ambient .8}
      }
   }         
   torus{
      .5,.07
      pigment{color rgbf<1,1,.9,0>}
      finish{
         F_MetalB
         ambient .5
      }
      scale <2,0,0>
      translate <4.5,0,0>
   }
   torus{
      .5,.07
      pigment{color rgbf<1,1,.9,0>}
      finish{
         F_MetalB
         ambient .5
      }
      scale <0,0,1.9>
      translate <0,0,2.75>
   }
   torus{
      .5,.07
      pigment{color rgbf<1,1,.9,0>}
      finish{
         F_MetalB
         ambient .5
      }
      scale <0,0,1.9>
      translate <0,0,-2.75>
   }   
   cylinder{
      <-3.5,0,0>,<3.5,0,0>,.4
      pigment{
         gradient x
         color_map{
            [0 color rgbf<0.90, 0.70, 0.05,0>]
            [1 color rgbf<0.70, 0.20, 0.15,0>]
         }
         translate <-5,0,0>
      }
      finish{
         F_MetalA
         ambient .7
      }   
   }
   torus{
      .5,.05
      pigment{color rgbf<1,1,0,0>}
      finish{F_MetalC ambient .5}   
      rotate z*90
   }
   torus{
      .5,.05
      pigment{color rgbf<1,1,0,0>}
      finish{F_MetalC ambient .5}   
      rotate z*90
      translate <-1,0,0>
   }
   torus{
      .5,.05
      pigment{color rgbf<1,1,0,0>}
      finish{F_MetalC ambient .5}   
      rotate z*90
      translate <1,0,0>
   }
   torus{
      .5,.05
      pigment{color rgbf<1,1,0,0>}
      finish{F_MetalC ambient .5}   
      rotate z*90
      translate <-2,0,0>
   }
   torus{
      .5,.05
      pigment{color rgbf<1,1,0,0>}
      finish{F_MetalC ambient .5}   
      rotate z*90
      translate <2,0,0>
   }
   difference{
      sphere{                                  //green trail
         <0,0,0>,3.5 
         scale<1,.1,1>
         pigment {
            onion        
            pigment_map {
               [0.0 color rgbt<1,1,1,1>]               
               [1.0 color rgbft<0,1,0,.8,1>]                  
            }
            translate <0,1,0>
            scale 3.5
         }
         
         finish{ambient .5}
         hollow on
      }
      box{
         <10,-10,-10>,<0,10,10>
         pigment{ rgbf<1,1,1,1>}
      }
      scale <10,.4,1>
      no_shadow
   } 
                     
}
#declare flyer=
union{
   difference{
      sphere{
         <0,0,0>,2
         pigment{
            granite
            color_map{
               [0 P_Chrome3]
               [1 P_Chrome1]
            }
         }
         finish{
            F_MetalA
         }
         scale <1,1,.1>         
      }
      sphere{
         <.7,0,0>,1.2
         pigment{color LimeGreen}
         finish{ambient .5}
         scale <2,1,1>
      }
      translate <0,0,1>
   }
   difference{
      sphere{
         <0,0,0>,2
         pigment{
            granite
            color_map{
               [0 P_Chrome3]
               [1 P_Chrome1]
            }
         }
         finish{
            F_MetalA
         }
         scale <1,1,.1>         
      }
      sphere{
         <.7,0,0>,1.2
         pigment{color LimeGreen}
         finish{ambient .5}
         scale <2,1,1>
      }
      translate <0,0,-1>
   }
   cylinder{
      <-.87,0,-1>,<-.87,0,1>,.3
      pigment{color P_Copper3}
      finish{
         F_MetalD      
      }      
      scale <1.7,1,1>   
   } 
   difference{
      cylinder{
         <-2,0,0>,<-.5,0,0>,.7
         pigment{
            cylindrical 
            color_map{
               [0 color rgbf<0.39, 0.41, 0.43,0>]
               [.3 color rgbf<0.39, 0.41, 0.43,0>]
               [.6 color rgbf<.3,2,.3>]
               [1 color rgbf<2.1,2.1,.4,.5>]
            }
            rotate z*90
            scale .5 
         }
         finish{F_MetalB}
         scale <1,.5,1>
      }
      sphere{
         <-1.1,0,0>,1
         scale <5,1,1>
         pigment{color P_Copper5}
         finish{F_MetalC}
         inverse
      }
      }   
} 
#declare building_short=
union{
box{
   <-20,0,-15>,<20,40,15>
   pigment{color Silver}
   finish{ F_MetalC}
}
torus{
   15,2
   pigment{color BrightGold}
   rotate x*90
   translate <0,30,0>
   finish{ F_MetalC}
}
}
#declare spire=
cone{
   <0,0,0>,10,<0,130>,0
   pigment{color P_Silver4}
   finish{ F_MetalC}
}

#declare building_medium=
union{
box{
   <-20,0,-17.5>,<20,60,17.5>
   pigment{color rgb<.8,.8,.8>}
   finish{ F_MetalC}
}
cone{
   <5,60,0>,3,<5,85,0>,0
   pigment{color Gold}
   finish{
      phong .5
   }
}
cone{
   <-10,60,0>,3,<-10,95,0>,0
   pigment{color BrightGold}
   finish{
      phong .5
   }
}
}

#declare building_tall=
union{
box{
   <-25,0,-25>,<25,100,25>
   pigment{color P_Chrome4}
   finish{ F_MetalC}
}
sphere{
   <0,100,0>,25
   pigment{color BrightGold}
   finish{
      phong .5
      reflection .2
   }
}
}

#declare building_shiny=
union{
   cylinder{     //column
      <35,0,0>,<35,130,0>,5
      pigment{color rgbf<.8,.8,1,0>}
   }
   cylinder{     //column
      <-35,0,0>,<-35,130,0>,5
      pigment{color rgbf<.8,.8,1,0>}
   }
   cone{         //main column
      <0,0,0>,25,<0,130,0>,10
      pigment{color rgb<.8,.8,.8>}
      finish {
         reflection .5
         phong .5
      }
   }
   cylinder{     //main body
      <0,130,0>,<0,160,0>,50
      pigment{color rgbf<.7,.7,1,.7>}
      finish{phong .7
         reflection .5
      }      
   }
   torus{        //surrounds main column
      15,2
      pigment{color BrightGold}
      finish{
         phong .5
      }
      translate<0,100,0>
   }
   torus{        //surrounds main column
      30,2
      pigment{color Goldenrod}
      finish{
         phong .5
      }
      translate<0,50,0>
   }
}

#declare city=
union{
object{
   spire
   translate<200,10,-80>
}
object{
   spire
   translate<180,10,-80>
}
  
object {
   building_shiny
   rotate <0,0,0>
   translate <0,0,0>
}

object {
   building_short
   rotate <0,0,0>
   scale y*1.6
   translate <-50,0,75>
}

object {
   building_short
   rotate <0,0,0>
   translate <-35,0,-75>
}

object {
   building_short
   rotate <0,0,0>
   translate <70,0,-120>
}

object {
   building_short
   rotate <0,0,0>
   translate <190,50,-50>
}

object {
   building_medium
   rotate <0,10,0>
   translate <50,0,-60>
}

object {
   building_medium
   rotate <0,10,0>
   translate <-100,0,-50>
}

object {
   building_medium
   scale y*1.2
   rotate <0,30,0>
   translate <-140,23,-50>
}

object {
   building_medium
   rotate <0,10,0>
   scale y*1.2
   translate <10,0,60>
}

object {
   building_tall
   rotate <0,0,0>
   translate <-80,0,10>
}
object{
   spire
   scale y*1.2
   translate<-100,0,-20>
}
object {
   building_tall
   rotate <0,0,0>
   scale y*.9
   translate <110,0,-10>
}
}
#declare window_box=
box{
   <-.35,-.2,-10>,<.35,.4,10>
   pigment{color rgbf<.4,.7,1>}
}

#declare railcar=
union{
   difference{
                  blob{
         cylinder{                //main body
            <-5,0,0>,<5,0,0>,3,2
            pigment{color White}
            finish{
                  phong .5
            }
         }
         cylinder{                //squeezer objects
            <-5,0,-5>,<5,0,-5>,4.75,-4
            pigment{color Red}
         }
         cylinder{                //squeezer objects
            <-5,0,5>,<5,0,5>,4.75,-4
            pigment{color Red}
         }
         cylinder{                //squeezer objects
            <-5,-7,0>,<5,-7,0>,4.75,-4
            pigment{color Red}
         }
         cylinder{                //squeezer objects
            <-5,7,0>,<5,7,0>,4.75,-4
            pigment{color Red}
         }
         cylinder{                //stretches out the front
            <-6.2,-1,-.7>,<-6.2,-1,.7>,1,2
            pigment{color Blue}
         }
         cylinder{                //stretches out the front
            <6.2,-1,-.7>,<6.2,-1,.7>,1,2
            pigment{color Blue}
         }  
      }                                        
      object{
         window_box
         translate<4,0,0>
      }
      object{
         window_box
         translate<2,0,0>
      }
      object{
         window_box
         translate<0,0,0>
      }
      object{
         window_box
         translate<-2,0,0>
      }
      object{
         window_box
         translate<-4,0,0>
      }
      object{                 //windshield hole
         window_box
         translate<6.2,.5,0>
      }
      object{                 //windshield hole
         window_box           
         translate<-6.2,.5,0>
      }
   }
   blob{
      cylinder{                //main body
         <-5,0,0>,<5,0,0>,3,2     
      }
      cylinder{                //squeezer objects
         <-5,0,-5>,<5,0,-5>,4.75,-4      
      }
      cylinder{                //squeezer objects
         <-5,0,5>,<5,0,5>,4.75,-4      
      }
      cylinder{                //squeezer objects
         <-5,-7,0>,<5,-7,0>,4.75,-4      
      }
      cylinder{                //squeezer objects
         <-5,7,0>,<5,7,0>,4.75,-4      
      }
      pigment{color rgbf<.4,.7,1,.8>}
      finish{
         phong 1
         reflection.6
      }
      scale .9999
   }     
   finish{
      phong 1
      reflection .5
   }
}


camera{
   location <1,2,-10>                                       //Camera
   
   look_at <0,.5,0>
} 


fog{
   color rgbt<.4,.4,.9,.5>
   //turbulence 1


   distance 600
}

  fog {
    distance 1500
    color rgbt<1, 1, 1, .6>
    fog_type 2
    fog_offset -35
    fog_alt 50
  } 

sky_sphere {
    pigment {
      gradient y
      color_map {
        [0 color rgb<.7,.7,1>]
        [1 color rgb<.2,.2,.7>]
      }
      //scale 2
      //translate <0,-.5,0>
    }
}
   

height_field {
   png "hfield.png"
   smooth
   water_level .6
   scale <1000,100,3000>
   translate<-400,-85,0>
   pigment {rgb <0.98, 0.98, 1>}
  normal {bumps 0.25 scale 0.005}
  finish {
    ambient 0.5 
    phong 1 
    phong_size 200
  } 
   /*pigment{
      bozo
      color_map{               //snow
         [0.0 color rgb<1,1,1>]
         [0.2 color rgb<.95,.91,.99>]
         [0.7 color rgb<.91,.95,1>]
         [1.0 color rgb<.9,.9,.9>]
      } */
      /*color_map{               //green
         [0.0 color rgb<0,1,0>]
         [0.2 color rgb<.1,1,.1>]
         [0.7 color rgb<0,.95,0>]
         [1.0 color rgb<0,.9,0>]
      }  */
      /*scale 6      
   }
   normal{ bumps .2
      scale 2
   }
   finish{ambient.6}  */
   /*photons {
    target

    reflection on
    
  }  */

}

   union{
      plane{
         y,-22
         pigment{color rgb<.3,.3,1>}
 //        normal{bumps 1     
 //        }
         finish{phong .4
            reflection .8
         }
      }
      plane{
         y,-21.75
         pigment{color LightBlue filter .9}
 //        normal{bumps 1
 //           rotate y*37
 //           translate <16,0,-4>
 //        } 
         finish{phong .4
            reflection .8
         }
      }
      clipped_by{
         box{
            <-100,-50,-30>,<300,100,600>   
         }
      } 
   }



difference{
   torus{
      100,.6
      pigment{color rgbf<.3,0,.2,0>}
      translate <90,-10,0>
      normal{wrinkles 1}   
   }                      
   torus{
      99,.42
      pigment{color rgbf<0,1,0,0>}
      scale <1,1,1>
      translate <90,-10,0>
      finish{ambient .5}

   }
} 

object{
   railcar   
   rotate<15,108,0>
   translate<-4,-8,30>
}

object{
   railcar   
   rotate<-15,-50,0>
   translate<12,-8,60>
}
object{
   city
   scale .6
   translate<100,-40,600>
}

object {
   flyer
   scale .5
   rotate <30,160,0>
   translate <0,0,60>
}
object {
   flyer
   scale .5
   rotate <30,160,0>
   translate <5,5,64>
}
object{
   AlienShip
   scale 2
   rotate<80,100,35>
   translate<-50,20,120>   
} 
object{
   dude1                 //str omkring
   rotate <-90,135,0>
  scale .75
   translate<-30,-3,60>
}
object{
   dude2                //kastar boll
   rotate <-90,0,0>
  scale .75
   translate<-27,-4,50>
}
object{
   dude3                //AJ!
   rotate <-90,270,0>
   rotate<0,20,-30>
  scale .75
   translate<-20,-9,73>
}
object{
   dude4                //hukar sig fr att ta sn
   rotate <-90,160,0>
  scale .75
   translate<-35,-5.5,90>
}
object{
   dude5                //packar sn till en boll
   rotate <-90,330,0>
  scale .75
   translate<-17,-9.5,47>
} 
object{                 //skridskor nra
   dude6
   rotate<-90,270,0>
   scale .75
   translate <17,-22,60>
}


object{                 //skridskor  
   dude6
   rotate<-90,70,0>
   scale .75
   translate <110,-22,330>
}
object{                 //skridskor 
   dude6
   rotate<-90,120,0>
   scale .75
   translate <115,-22,325>
}
object{                 //skridskor 
   dude6
   rotate<-90,180,0>
   scale .75
   translate <105,-22,328>
}


/*union{
cylinder{
   <0,-100,0>,<0,100,0>,.2
   pigment{color rgb<1.2,.8,0>}
   finish{ambient 1}                                     //--------position pinpointer-------
}
cylinder{
   <-100,00,0>,<100,00,0>,.2
   pigment{color rgb<1.2,.8,0>}
   finish{ambient 1}   
}
cylinder{
   <0,00,-100>,<0,00,100>,.2
   pigment{color rgb<1.2,.8,0>}
   finish{ambient 1}   
} 
translate<110,-22,330>
}  */
/*camera{
   location <80,200,350>                                       //Camera
   
   look_at <115,-22,365>
} */

light_source{
   <20, 100,-20> color rgb<1,1,.7>
} 


#declare Snowflake=
/*union{
   cylinder{
      <-.1,0,0>,<.1,0,0>,.01
   }
   cylinder{
      <-.1,0,0>,<.1,0,0>,.01
      rotate<0,0,60>
   }
   cylinder{
      <-.1,0,0>,<.1,0,0>,.01
      rotate<0,0,120>
   }   
   pigment{color rgb<1,1,1>}
   finish{ambient .7}
   no_shadow 
} */
/*disc{                                    //close-up snowflake  
   <0,0,0>,z,.1
   pigment{color rgbf<1,1,1,0>}
   finish{ambient .7}
   no_shadow   
} */
disc{
   <0,0,0>,z,1
   pigment{
      image_map{
         png "snowflake.png"
         filter all 0           //make background transparent
         
      }
      
      scale 2
      translate <1,-1,0>
   }                    
   finish{ambient 1}
   scale .2
   hollow on
   no_shadow
}

#declare Count=0;
#declare Rgand=seed(tick_count);

#while (Count<60000)                      // scene flakes 60000 or less for 11 min render

   #declare Xrand=rand(Rgand)*600 -300;
   #declare Yrand=rand(Rgand)*150-40 ;
   #declare Zrand=rand(Rgand)*630;
   #declare Rgand=seed(tick_count*Count-12);

   #declare Count=Count+1;  
   #if (Zrand>50) 
      disc{                                    //shoddy snowflake  
         <0,0,0>,z,.2
         pigment{color rgbf<1,1,1,0>}
         finish{ambient .7}
         no_shadow   
         translate <Xrand,Yrand,Zrand>
      }
   #else
      object{Snowflake rotate <0,0,Rgand*90> translate <Xrand,Yrand,Zrand>}
   #end
#end

/*plane{
   z,50
   pigment{color Green}
} */

#declare Count=0;
#declare Rgand=seed(tick_count+13);
#while (Count<50000)                      // closer flakes  50000 or less for 11 min render

   #declare Xrand=rand(Rgand)*200 -100;
   #declare Yrand=rand(Rgand)*90-40 ;
   #declare Zrand=rand(Rgand)*100;
   #declare Rgand=seed(tick_count*Count-12);

   #declare Count=Count+1;  
   #declare Snowsize=rand(Rgand)*.5+.5;
   object{Snowflake scale Snowsize rotate <0,0,90*Rgand>translate <Xrand,Yrand,Zrand> finish{ambient .95}}
#end 
  

//                                           *******************TREES!
object {
	#include "treedefaults.inc"
	#declare SD1=seed(16);  
	#declare BaseLen=.75
	#declare Tip=0;
	#declare LeafShape=9     ;  
	//#declare LeafTexture=2   ;
	#declare BarkTexture=5   ;
	#include "trees.inc"     
	
	translate <-50,-1,70>	
}
object {
	#include "treedefaults.inc"
	#declare SD1=seed(18);
	#declare BaseLen=.85
	#declare Tip=0;
	#declare LeafShape=9     ;  
	//#declare LeafTexture=2   ;
	#declare BarkTexture=5   ;
	#include "trees.inc"     	
	translate <-60,-1,110>	
} 
object {
	#include "treedefaults.inc"
	#declare SD1=seed(23);
	#declare BaseLen=.85
	#declare Tip=0;
	#declare LeafShape=9     ;  
	//#declare LeafTexture=2   ;
	#declare BarkTexture=5   ;
	#include "trees.inc"     	
	translate <-30,-5,30>	
}       

/*cylinder{
   <-50,0,50>,<0,0,50>, .2
   pigment{color Red}
} 
cylinder{
   <-50,-300,50>,<-50,300,50>, .2
   pigment{color Blue}
} 
cylinder{
   <-50,0,-500>,<-50,0,600>, .2
   pigment{color Green}
} */
    
/*box{
   <-100,-50,-30>,<300,100,600>
   pigment{color rgbf<1,1,1,1>}
   finish{reflection .5} //hehe trippy
} */