#include "colors.inc"

#declare water_det = 1;
#declare tree_det = 1;
#declare ship = 1;


global_settings{
	max_trace_level 5
	ambient_light 0.01
	radiosity { normal on recursion_limit 3}
}

camera { location <0,2,-8> look_at <0,2,0> angle 50 }
//camera { location <-1.9,5,9>*<0,.5,.4> look_at <-1.9,0,9>*<.6,1,.6> }
//camera { location <0,20,0> look_at 0 }

//background { <.8,.8,1> }
sky_sphere {
	pigment {
		gradient y
		color_map {
			[0 rgb <.6,.6,.8>]
			[.5 rgb <.2,.3,.4>]
			[1 rgb <.2,.3,.4>]
		}
	}
}

light_source { 0 rgb 1 translate <100,350,-500> }
light_source { 0 rgb .4 translate <100,-350,-500> shadowless }

#if(water_det=0)
cylinder { 
	<0,-10,0> <0,0,0> 10000
	pigment {rgb <.8,.8,1>}
	finish {diffuse .8}
}
#else

// waterbed

cylinder { 
	<0,-9,0> <0,-11,0> 10001
	pigment { rgb .5 } 
}

// the water itself
cylinder { 
	<0,-10,0> <0,0,0> 10000 
	material {water_m}
	hollow
	no_shadow
}

#end

// ground

#if(tree_det=0)
	#declare tree =
		box {<-.2,0,-.2><.2,2,.2>pigment {rgb <.1,.5,.125>}}
#else
	#include "tree.inc"

#end

#declare tree = object { tree scale .09 }

#declare ground_y_scale = 30;
#declare gf = function{pigment{spherical turbulence .4}}

#declare ground =
union {
	
	#declare i=0;
	#declare n=500;
	#declare rs=seed(2907);
	
	#while(i<n)
		#declare xx=rand(rs);
		#declare zz=rand(rs);
		#declare yy=.2*gf(xx,0,zz).y;
		#declare ss=.9+.4*(rand(rs)-rand(rs));
		#declare rv=rand(rs);
		#if(yy>.04 & rv < .4)
			object {tree rotate y*90*rand(rs) scale ss translate <xx,yy,zz> }
		#end
		#declare i=i+1;
	#end
	isosurface {
		function {y-.2*gf(x,0,z).y}
		contained_by { box { <0,.03,0> <1.5,1,1.5> } }
		texture { snow_t }
	}
}
object { ground
	rotate y*180
	scale 30 translate <25,-1,50>
}
object { ground
	rotate y*90
	scale 30 translate <-50,-1,100>
}
object { ground
	rotate y*-45
	scale 30 translate <1,-1,-32>
}


#if(ship=0)
#else
#declare ship =
	#include "lapuri.pov"
object { 
	ship 
	scale .5
	rotate y*-25
	translate <-7,-.6,30>
}
#end

