#ifndef(ship)
#include "colors.inc"

light_source { <8,-8,0> rgb 1 }
light_source { <-18,10,-10> rgb 1 }
camera { location <-20,5,-20> look_at <0,5,0> }
#end

#declare zarr = array[7] {-9,-6,-4,0,4,6,9}
#declare hull =
union {


// outer parts
	// lauta 1
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<3.0,2.0,zarr[3]><3.0,2.0,zarr[4]><2.7,2.1,zarr[5]><.1,3.2,zarr[6]+1.6>
		<2.9,1.8,zarr[3]><2.9,2.0,zarr[4]><2.65,2.1,zarr[5]><.1,3.0,zarr[6]+1.6>
		<2.8,1.55,zarr[3]><2.8,1.35,zarr[4]><2.55,1.6,zarr[5]><.1,2.9,zarr[6]+1.45>
		<2.7,1.35,zarr[3]><2.7,1.35,zarr[4]><2.5,1.6,zarr[5]><.1,2.7,zarr[6]+1.45>
		uv_mapping 
	}
	
	// lauta 1, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<2.7,1.35,zarr[3]><2.7,1.35,zarr[4]><2.5,1.6,zarr[5]><.1,2.7,zarr[6]+1.45>
		<2.69,1.35,zarr[3]><2.69,1.35,zarr[4]><2.47,1.6,zarr[5]><.1,2.7,zarr[6]+1.43>
		<2.66,1.35,zarr[3]><2.66,1.35,zarr[4]><2.43,1.6,zarr[5]><.1,2.7,zarr[6]+1.42>
		<2.65,1.35,zarr[3]><2.65,1.35,zarr[4]><2.4,1.6,zarr[5]><.1,2.7,zarr[6]+1.4>
	}

	// lauta 2
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<2.65,1.35,zarr[3]><2.65,1.35,zarr[4]><2.4,1.6,zarr[5]><.1,2.7,zarr[6]+1.4>
		<2.45,1.15,zarr[3]><2.45,1.15,zarr[4]><2.2,1.4,zarr[5]><.1,2.5,zarr[6]+1.33>
		<2.2,.85,zarr[3]><2.2,.85,zarr[4]><2.00,1.2,zarr[5]><.1,2.3,zarr[6]+1.27>
		<2.1,.65,zarr[3]><2.0,.65,zarr[4]><1.85,1.0,zarr[5]><.1,2.1,zarr[6]+1.2>
		uv_mapping
	}
	
	// lauta 2, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<2.1,.65,zarr[3]><2.0,.65,zarr[4]><1.85,1.0,zarr[5]><.1,2.1,zarr[6]+1.2>
		<2.1,.65,zarr[3]><2.0,.65,zarr[4]><1.85,1.0,zarr[5]><.1,2.1,zarr[6]+1.2>
		<2.0,.65,zarr[3]><1.9,.65,zarr[4]><1.75,1.0,zarr[5]><.1,2.1,zarr[6]+1.15>
		<2.0,.65,zarr[3]><1.9,.65,zarr[4]><1.75,1.0,zarr[5]><.1,2.1,zarr[6]+1.15>
	}
	
	// lauta 3
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<2.0,.65,zarr[3]><1.9,.65,zarr[4]><1.75,1.0,zarr[5]><.1,2.1,zarr[6]+1.15>
		<1.9,.57,zarr[3]><1.8,.57,zarr[4]><1.65,.9,zarr[5]><.1,1.9,zarr[6]+1.15>
		<1.7,0.53,zarr[3]><1.7,0.53,zarr[4]><1.55,0.8,zarr[5]><.1,1.8,zarr[6]+.9>
		<1.6,0.5,zarr[3]><1.6,0.5,zarr[4]><1.45,0.7,zarr[5]><.1,1.7,zarr[6]+.9>
		uv_mapping
	}
	
	// lauta 3, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<1.6,0.5,zarr[3]><1.6,0.5,zarr[4]><1.45,0.7,zarr[5]><.1,1.7,zarr[6]+.9>
		<1.6,0.5,zarr[3]><1.6,0.5,zarr[4]><1.45,0.7,zarr[5]><.1,1.7,zarr[6]+.9>
		<1.5,0.5,zarr[3]><1.5,0.5,zarr[4]><1.35,0.7,zarr[5]><.1,1.7,zarr[6]+.85>
		<1.5,0.5,zarr[3]><1.5,0.5,zarr[4]><1.35,0.7,zarr[5]><.1,1.7,zarr[6]+.85>
		uv_mapping
	}
	
	// lauta 4
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<1.5,0.5,zarr[3]><1.5,0.5,zarr[4]><1.35,0.7,zarr[5]><.1,1.7,zarr[6]+.85>
		<1.4,0.47,zarr[3]><1.4,0.47,zarr[4]><1.25,0.63,zarr[5]><.1,1.6,zarr[6]+.75>
		<1.2,0.43,zarr[3]><1.2,0.43,zarr[4]><1.15,0.57,zarr[5]><.1,1.5,zarr[6]+.65>
		<1.1,0.4,zarr[3]><1.1,0.4,zarr[4]><1.05,0.5,zarr[5]><.1,1.4,zarr[6]+.55>
		uv_mapping
	}
	
	// lauta 4, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<1.1,0.4,zarr[3]><1.1,0.4,zarr[4]><1.05,0.5,zarr[5]><.1,1.4,zarr[6]+.55>
		<1.1,0.4,zarr[3]><1.1,0.4,zarr[4]><1.05,0.5,zarr[5]><.1,1.4,zarr[6]+.55>
		<1.0,0.4,zarr[3]><1.0,0.4,zarr[4]><.95,0.5,zarr[5]><.1,1.4,zarr[6]+.5>
		<1.0,0.4,zarr[3]><1.0,0.4,zarr[4]><.95,0.5,zarr[5]><.1,1.4,zarr[6]+.5>
		uv_mapping
	}
	
	// lauta 5
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<1.0,0.4,zarr[3]><1.0,0.4,zarr[4]><.95,0.5,zarr[5]><.1,1.4,zarr[6]+.5>
		<0.9,0.37,zarr[3]><.9,0.37,zarr[4]><.85,0.47,zarr[5]><.1,1.33,zarr[6]+.5>
		<0.8,0.33,zarr[3]><0.8,0.33,zarr[4]><0.7,0.43,zarr[5]><.1,1.27,zarr[6]+.05>
		<0.7,0.3,zarr[3]><0.7,0.3,zarr[4]><0.6,0.4,zarr[5]><.1,1.2,zarr[6]+.05>
		uv_mapping 
	}
	
	// lauta 5, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<0.7,0.3,zarr[3]><0.7,0.3,zarr[4]><0.6,0.4,zarr[5]><.1,1.2,zarr[6]+.05>
		<0.7,0.3,zarr[3]><0.7,0.3,zarr[4]><0.6,0.4,zarr[5]><.1,1.2,zarr[6]+.05>
		<0.6,0.3,zarr[3]><0.6,0.3,zarr[4]><0.5,0.4,zarr[5]><.1,1.2,zarr[6]>
		<0.6,0.3,zarr[3]><0.6,0.3,zarr[4]><0.5,0.4,zarr[5]><.1,1.2,zarr[6]>
	}

	// lauta 6
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<0.6,.3,zarr[3]><0.6,.3,zarr[4]><0.5,.4,zarr[5]><.1,1.2,zarr[6]>
		<0.4,.27,zarr[3]><0.4,.27,zarr[4]><0.4,.35,zarr[5]><.1,1.1,zarr[6]>
		<0.3,.23,zarr[3]><0.3,.23,zarr[4]><0.2,.3,zarr[5]><.1,1,zarr[6]-.5>
		<0.1,.2,zarr[3]><0.1,.2,zarr[4]><0.1,.25,zarr[5]><.1,.9,zarr[6]-.5>
		uv_mapping 
	}


// inner parts (outer +/-.2 in appropriate axis)
	// lauta 1
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<2.8,2.0,zarr[3]><2.8,2.0,zarr[4]><2.5,2.1,zarr[5]><.1,3.2,zarr[6]+1.4>
		<2.8,2.0,zarr[3]><2.8,2.0,zarr[4]><2.5,2.1,zarr[5]><.1,3.2,zarr[6]+1.4>
		<2.5,1.35,zarr[3]><2.5,1.35,zarr[4]><2.3,1.6,zarr[5]><.1,2.7,zarr[6]+1.25>
		<2.5,1.35,zarr[3]><2.5,1.35,zarr[4]><2.3,1.6,zarr[5]><.1,2.7,zarr[6]+1.25>
		uv_mapping 
	}
	
	// lauta 1, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<2.5,1.35,zarr[3]><2.5,1.35,zarr[4]><2.3,1.6,zarr[5]><.1,2.7,zarr[6]+1.25>
		<2.5,1.35,zarr[3]><2.5,1.35,zarr[4]><2.3,1.6,zarr[5]><.1,2.7,zarr[6]+1.25>
		<2.4,1.35,zarr[3]><2.4,1.35,zarr[4]><2.2,1.6,zarr[5]><.1,2.7,zarr[6]+1.2>
		<2.4,1.35,zarr[3]><2.4,1.35,zarr[4]><2.2,1.6,zarr[5]><.1,2.7,zarr[6]+1.2>
	}

	// lauta 2
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<2.4,1.35,zarr[3]><2.4,1.35,zarr[4]><2.2,1.6,zarr[5]><.1,2.7,zarr[6]+1.2>
		<2.4,1.35,zarr[3]><2.4,1.35,zarr[4]><2.2,1.6,zarr[5]><.1,2.7,zarr[6]+1.2>
		<1.9,.65,zarr[3]><1.8,.65,zarr[4]><1.65,1.0,zarr[5]><.1,2.1,zarr[6]+1>
		<1.9,.65,zarr[3]><1.8,.65,zarr[4]><1.65,1.0,zarr[5]><.1,2.1,zarr[6]+1>
		uv_mapping 
	}
	
	// lauta 2, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<1.9,.65,zarr[3]><1.8,.65,zarr[4]><1.65,1.0,zarr[5]><.1,2.1,zarr[6]+1>
		<1.9,.65,zarr[3]><1.8,.65,zarr[4]><1.65,1.0,zarr[5]><.1,2.1,zarr[6]+1>
		<1.8,.65,zarr[3]><1.7,.65,zarr[4]><1.55,1.0,zarr[5]><.1,2.1,zarr[6]+.95>
		<1.8,.65,zarr[3]><1.7,.65,zarr[4]><1.55,1.0,zarr[5]><.1,2.1,zarr[6]+.95>
	}
	
	// lauta 3
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<1.8,.65,zarr[3]><1.7,.65,zarr[4]><1.55,1.0,zarr[5]><.1,2.1,zarr[6]+.95>
		<1.8,.65,zarr[3]><1.7,.65,zarr[4]><1.55,1.0,zarr[5]><.1,2.1,zarr[6]+.95>
		<1.4,0.5,zarr[3]><1.4,0.5,zarr[4]><1.25,0.7,zarr[5]><.1,1.7,zarr[6]+.7>
		<1.4,0.5,zarr[3]><1.4,0.5,zarr[4]><1.25,0.7,zarr[5]><.1,1.7,zarr[6]+.7>
		uv_mapping 
	}
	
	// lauta 3, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<1.4,0.5,zarr[3]><1.4,0.5,zarr[4]><1.25,0.7,zarr[5]><.1,1.7,zarr[6]+.7>
		<1.4,0.5,zarr[3]><1.4,0.5,zarr[4]><1.25,0.7,zarr[5]><.1,1.7,zarr[6]+.7>
		<1.3,0.5,zarr[3]><1.3,0.5,zarr[4]><1.15,0.7,zarr[5]><.1,1.7,zarr[6]+.65>
		<1.3,0.5,zarr[3]><1.3,0.5,zarr[4]><1.15,0.7,zarr[5]><.1,1.7,zarr[6]+.65>
	}
	
	// lauta 4
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<1.3,0.5,zarr[3]><1.3,0.5,zarr[4]><1.15,0.7,zarr[5]><.1,1.7,zarr[6]+.65>
		<1.3,0.5,zarr[3]><1.3,0.5,zarr[4]><1.15,0.7,zarr[5]><.1,1.7,zarr[6]+.65>
		<0.9,0.4,zarr[3]><0.9,0.4,zarr[4]><0.85,0.5,zarr[5]><.1,1.4,zarr[6]+.35>
		<0.9,0.4,zarr[3]><0.9,0.4,zarr[4]><0.85,0.5,zarr[5]><.1,1.4,zarr[6]+.35>
		uv_mapping 
	}
	
	// lauta 4, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<0.9,0.4,zarr[3]><0.9,0.4,zarr[4]><0.85,0.5,zarr[5]><.1,1.4,zarr[6]+.35>
		<0.9,0.4,zarr[3]><0.9,0.4,zarr[4]><0.85,0.5,zarr[5]><.1,1.4,zarr[6]+.35>
		<0.8,0.4,zarr[3]><0.8,0.4,zarr[4]><.75,0.5,zarr[5]><.1,1.4,zarr[6]+.3>
		<0.8,0.4,zarr[3]><0.8,0.4,zarr[4]><.75,0.5,zarr[5]><.1,1.4,zarr[6]+.3>
	}
	
	// lauta 5
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<0.8,0.4,zarr[3]><0.8,0.4,zarr[4]><.75,0.5,zarr[5]><.1,1.4,zarr[6]+.3>
		<0.8,0.4,zarr[3]><0.8,0.4,zarr[4]><.75,0.5,zarr[5]><.1,1.4,zarr[6]+.3>
		<0.5,0.3,zarr[3]><0.5,0.3,zarr[4]><0.4,0.4,zarr[5]><.1,1.2,zarr[6]-.15>
		<0.5,0.3,zarr[3]><0.5,0.3,zarr[4]><0.4,0.4,zarr[5]><.1,1.2,zarr[6]-.15>
		uv_mapping 
	}
	
	// lauta 5, alaosa
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<0.5,0.3,zarr[3]><0.5,0.3,zarr[4]><0.4,0.4,zarr[5]><.1,1.2,zarr[6]-.15>
		<0.5,0.3,zarr[3]><0.5,0.3,zarr[4]><0.4,0.4,zarr[5]><.1,1.2,zarr[6]-.15>
		<0.4,0.3,zarr[3]><0.4,0.3,zarr[4]><0.3,0.4,zarr[5]><.1,1.2,zarr[6]-.2>
		<0.4,0.3,zarr[3]><0.4,0.3,zarr[4]><0.3,0.4,zarr[5]><.1,1.2,zarr[6]-.2>
	}

	// lauta 6
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<0.4,0.3,zarr[3]><0.4,0.3,zarr[4]><0.3,0.4,zarr[5]><.1,1.2,zarr[6]-.2>
		<0.4,0.3,zarr[3]><0.4,0.3,zarr[4]><0.3,0.4,zarr[5]><.1,1.2,zarr[6]-.2>
		<0.1,.2,zarr[3]><0.1,.2,zarr[4]><0.1,.25,zarr[5]><.1,.9,zarr[6]-.7>
		<0.1,.2,zarr[3]><0.1,.2,zarr[4]><0.1,.25,zarr[5]><.1,.9,zarr[6]-.7>
		uv_mapping 
	}
	
// keel
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<.1,4.5,zarr[6]+1.2><.1,.4,zarr[6]+2.2><.1,.4,zarr[5]+.4><0.1,.4,zarr[3]>
		<.1,4.5,zarr[6]+1.3><.1,.4,zarr[6]+2.3><.1,.3,zarr[5]+.4><0.1,.3,zarr[3]>
		<.1,4.5,zarr[6]+1.5><.1,0,zarr[6]+2.5><.1,.1,zarr[5]+.4><0.1,.1,zarr[3]>
		<.1,4.5,zarr[6]+1.6><.1,0,zarr[6]+2.6><.1,0,zarr[5]+.4><0.1,0,zarr[3]>
		uv_mapping 
	}
	
// railing
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<3.0,2.0,zarr[3]><3.0,2.0,zarr[4]><2.7,2.1,zarr[5]><.1,3.2,zarr[6]+1.6>
		<2.95,2.0,zarr[3]><2.95,2.0,zarr[4]><2.65,2.1,zarr[5]><.1,3.2,zarr[6]+1.55>
		<2.85,2.0,zarr[3]><2.85,2.0,zarr[4]><2.55,2.1,zarr[5]><.1,3.2,zarr[6]+1.45>
		<2.8,2.0,zarr[3]><2.8,2.0,zarr[4]><2.5,2.1,zarr[5]><.1,3.2,zarr[6]+1.4>
		uv_mapping 
	}

}

/*
		<.1,4.5,zarr[6]+1.2><.1,.4,zarr[6]+2.2><.1,.4,zarr[5]+.4><0.1,.4,zarr[3]>
		<.1,4.5,zarr[6]+1.6><.1,0,zarr[6]+2.6><.1,0,zarr[5]+.4><0.1,0,zarr[3]>
*/
#declare asym_hull =
union {
// keel, bottom
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<.1,4.5,zarr[6]+1.2><.1,.4,zarr[6]+2.2><.1,.4,zarr[5]+.4><0.1,0,zarr[3]>
		<.05,4.5,zarr[6]+1.2><.05,.4,zarr[6]+2.2><.05,.4,zarr[5]+.4><0.05,0,zarr[3]>
		<-.05,4.5,zarr[6]+1.2><-.05,.4,zarr[6]+2.2><-.05,.4,zarr[5]+.4><-.05,0,zarr[3]>
		<-.1,4.5,zarr[6]+1.2><-.1,.4,zarr[6]+2.2><-.1,.4,zarr[5]+.4><-.1,0,zarr[3]>
		uv_mapping 
	}
	
// keel, top
	bicubic_patch {
		type 1 u_steps 0 v_steps 4
		<.1,4.5,zarr[6]+1.6><.1,0,zarr[6]+2.6><.1,0,zarr[5]+.4><0.1,0,zarr[3]>
		<.05,4.5,zarr[6]+1.6><.05,0,zarr[6]+2.6><.05,0,zarr[5]+.4><0.05,0,zarr[3]>
		<-.05,4.5,zarr[6]+1.6><-.05,0,zarr[6]+2.6><-.05,0,zarr[5]+.4><-.05,0,zarr[3]>
		<-.1,4.5,zarr[6]+1.6><-.1,0,zarr[6]+2.6><-.1,0,zarr[5]+.4><-.1,0,zarr[3]>
		uv_mapping 
	}
}

union {
	union {
		object { hull }
		object { hull matrix <1,0,0,0,1,0,0,0,-1,0,0,0> }
		object { hull matrix <-1,0,0,0,1,0,0,0,1,0,0,0> }
		object { hull matrix <-1,0,0,0,1,0,0,0,-1,0,0,0> }
		
		texture {
			pigment { p_hull }
			normal { granite .025 scale <1,.1,1> }
			finish { diffuse .6 specular .2 }
		}

	}
	union {
		object { asym_hull }
		object { asym_hull matrix <1,0,0,0,1,0,0,0,-1,0,0,0> }
		texture {
			pigment { p_hull }
			normal { granite .025 scale <1,.1,1> }
			finish { diffuse .6 specular .2 }
		}
	}
	
	// masto
	union {
		cylinder {<0,.5,0> <0,5,0> .2 }
		cone {<0,5,0> .2 <0,12,0> .1 }

		// raaka
		union {
			cylinder { <-3,10.1,.2> <3,10.1,.2> .1 }
			cone { <-3,10.1,.2> .1 <-4.2,10.1,.2> .075 } 
			cone { <3,10.1,.2> .1 <4.2,10.1,.2> .075 }

			torus { .12 .02 rotate <0,0,90> translate <0,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <1,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <2,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <3,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <3.94,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <4,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <-1,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <-2,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <-3,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <-3.94,10.1,.2> }
			torus { .12 .02 rotate <0,0,90> translate <-4,10.1,.2> }

			// purje
			bicubic_patch {
				type 1 u_steps 4 v_steps 4
				<-4,10,.2><-2,10,.2><2,10,.2><4,10,.2>
				<-3.825,8,1><-2,8,1.2><2,8,1.2><3.825,8,1>
				<-3.75,6,1.5><-1.75,6,1.75><1.75,6,1.75><3.75,6,1.5>
				<-3.5,2.5,1><-1.5,2.5,1.5><1.5,2.5,1.5><3.5,2.5,1>

				uv_mapping
				//double_illuminate
				texture {
					pigment { p_sail }
					normal { bumps .1 scale .1}
					finish { diffuse .6 specular .2 }
				}
				#declare f_line = function {select (abs(x)-.006,.3,0)}
				#declare f_salm = 
						function { 
							f_line(x+y,y,z)+ 
							f_line(x+y-.2,y,z)+
							f_line(x+y-.4,y,z)+
							f_line(x+y-.6,y,z)+
							f_line(x+y-.8,y,z)+
							f_line(x+y-1,y,z)+
							f_line(x+y-1.2,y,z)+
							f_line(x+y-1.4,y,z)+
							f_line(x+y-1.6,y,z)+
							f_line(x+y-1.8,y,z)+
							f_line(x+y-2,y,z)+
							
							f_line(-x+y,y,z)+ 
							f_line(-x+y-.2,y,z)+
							f_line(-x+y-.4,y,z)+
							f_line(-x+y-.6,y,z)+
							f_line(-x+y-.8,y,z)+
							f_line(-x+y+.2,y,z)+
							f_line(-x+y+.4,y,z)+
							f_line(-x+y+.6,y,z)+
							f_line(-x+y+.8,y,z)
						} 
				texture {
					pigment { 
						function { f_salm(x,y,z) }
						pigment_map {
							[0 p_trans][.2 p_hull]} 
						}
					}
					normal { function { .4* ceil (.5*f_salm(x,y,z)) } }
					finish { diffuse .6 }
				}
		
		}
		translate <0,0,1>
	}

	cylinder { <-3.5,2.5,2> <-2.5,2,-4> .025 }
	cylinder { <3.5,2.5,2> <2.5,2,-4> .025 }

	cylinder { <-3.75,6,2.25> <-2.5,2,4> .025 }
	cylinder { <3.75,6,2.25> <2.5,2,4> .025 }

	cylinder { <-3.75,7,2> <-2.25,2,5> .025 }
	cylinder { <3.75,7,2> <2.25,2,5> .025 }

	// ropes
	cylinder { <0,11.5,1> <0,3,10> .025 }
	cylinder { <0,11.5,1> <0,3,-10> .025 }
	
	// raa-an nokkiin
	cylinder { <4,10.1,1.2> <0,3,-10> .025 }
	cylinder { <-4,10.1,1.2> <0,3,-10> .025 }
	
	// raa-an neljnneksiin
	cylinder { <2,10.1,1.2> <0,3,10> .025 }
	cylinder { <-2,10.1,1.2> <0,3,10> .025 }
	
	cylinder { <0,11,1> <2.5,2,0> .025 }
	cylinder { <0,11,1> <2.5,2,-1> .025 }
	
	cylinder { <0,11,1> <-2.5,2,0> .025 }
	cylinder { <0,11,1> <-2.5,2,-1> .025 }
	
	texture {
		pigment { p_hull }
		normal { granite .025 scale <1,.1,1> }
		finish { diffuse .6 specular .2 }
	}
	rotate y*180
}
