/* Batiment (batiment.inc)
Part of skistation.pov
Copyright (c) 2002 Cyrille Berger
http://www.cberger.net/ */
#declare boisbatiment = texture {
        #if(usetexture)
                T_Wood26
        #else
                pigment { Brown }
        #end
}
#if(usetexture)
#declare metalbatiment = texture {
        pigment { color White*0.6 }       
        finish {
                ambient 0.1
                brilliance .6
                metallic
                specular 0.80
                roughness 1/80 
        }
}
texture {
        pigment {
                bozo
                turbulence 1
                color_map {
                        [ 0.0 color <1.0,1.0,1.0,1.0> ]
                        [ 0.2 color <1.0,1.0,1.0,1.0> ]
                        [ 1.0 color Red*.9 ]
                }
        }
}
#else
#declare metalbatiment = texture { pigment { color White*0.6 } }
#end        
#declare pierrebatiment = texture {
        #if(usetexture)
                pigment { brick color White*0.4, color White*0.6 scale .1 }
                normal { bumps 0.3 scale .01 }
        #else
                pigment { color White*0.6 }
        #end
}


#declare batiment = merge {
        #declare i=0;
        difference {
                union {
                //murs
                #while(i<6)
                        //face latral 1
                        cylinder { < 0.0, 0.0, 2.3>, < 0.0, 0.0,-2.3>, 0.2
                                texture { boisbatiment }
                                translate <-4.0, 0.2+.399*i, 0.0> }
                        //face latral 2
                        cylinder { < 0.0, 0.0, 2.3>, < 0.0, 0.0,-2.3>, 0.2
                                texture { boisbatiment }
                                translate < 4.0, 0.2+.399*i, 0.0> }
                        //face arrire
                        cylinder { < 4.3, 0.0, 0.0>, <-4.3, 0.0, 0.0>, 0.2
                                texture { boisbatiment rotate <0.0, 90, 0.0> }
                                translate < 0.0, 0.2+.399*i,-2.0> }
                        //face avant
                        cylinder { < 4.3, 0.0, 0.0>, <-4.3, 0.0, 0.0>, 0.2
                                texture { boisbatiment rotate <0,90,0> }
                                translate < 0.0, 0.2+.399*i, 2.0>}
                        #declare i=i+1;
                #end   
                #if(full)
                //Partie du haut des faces latrales entre le mur et le toit
                        union {
                                #declare i=0;
                                #while(i<3)
                                        cylinder { < 0.0, 0.0, 2.0-.8*i>, < 0.0, 0.0, -2.0+.8*i>, 0.2
                                        texture { boisbatiment }
                                                translate <-4.0,2.594+i*.399,0.0> }
                                        cylinder { < 0.0, 0.0, 2.0-.8*i>, < 0.0, 0.0, -2.0+.8*i>, 0.2
                                        texture { boisbatiment }
                                                translate < 4.0,2.594+i*.399,0.0> }
                                        #declare i=i+1;
                                #end
                        }
                //Bordure des fentres et portes
                        union {
                                box { < 1.75, 2.05, 1.8>, < 3.05,-1.0, 2.2> } //porte
                                box { < 4.2, 0.85,-1.05>, < 3.8, 1.95, 1.05> } //fentre latrale
                                box { < 0.05, 0.85, 1.8>, <-2.05, 1.95, 2.2> } //fentre avant/arrire
                                box { < 0.05, 0.85,-1.8>, <-2.05, 1.95,-2.2> } //fentre avant/arrire
                                texture { metalbatiment }
                        }
                #end
                }
                #if(full)
                       union {
                                box { < 1.81, 2.0, 1.0>, < 2.99,-1.0, 3.0> } //porte
                                box { < 5.00, .89,-.99>, < 3.00, 1.89, .99> } //fentres latrale
                                box { < 0.01, .89, 3.0>, <-1.99, 1.89,-3.0> } //fentre avant/arrire
                                texture { metalbatiment }
                        }
                        box { <-4.31,.4,-.8>,<-3,1.5,.8> texture { pierrebatiment } } // Trou de la chemine
                #end
        }
        #if(full)
                #declare i=0;
                #while(i<6)
                        cylinder { <0,0,-.3>, <0,0,.3>,.2 texture { boisbatiment }
                                translate < 3.25, 0.2+.399*i, 2.0> }
                        cylinder { <0,0,-.3>, <0,0,.3>,.2 texture { boisbatiment }
                                translate < 1.55, 0.2+.399*i, 2.0> }
                        #declare i=i+1;
                #end
        //Rondins qui bordent la porte
                
        //toit
                #declare Rondain = cylinder { < 0.0,-0.6, -1.2>, < 0.0, 0.6, 1.2>, 0.2
                        texture { boisbatiment rotate <-26.56,0,0>} }
                difference {
                        union {
                                #declare i=0;
                                #while(i<22)
                                        #object { Rondain rotate <0,180,0> translate <-4.2+.399*i, 3.0, 1.2>  } //face avant
                                        #object { Rondain translate <-4.2+.399*i, 3.0,-1.2>  } //face arrire
                                        #declare i=i+1;
                                #end
                                cylinder { < 4.4, 0.0, 0.0>, <-4.4, 0.0, 0.0>, 0.2
                                texture { boisbatiment rotate <0,90,0> }
                                translate < 0.0, 3.6, 0.0> }
                        }
                        box { <-0.39,0,-2>,<-2.0,1,2> rotate <0,0,80> translate <-4.199,4.46,0> } //Supprime l'panchement de la fume
                }
        //porte
                #declare latte = prism {
                        linear_sweep linear_spline
                        -1, 2.01, 7,
                        <1.8,2>, <1.9,2.05>, <2.0,2.05>, <2.11,2>, <2.0,1.95>, <1.9,1.95>, <1.8,2>
                        texture { boisbatiment } }
                #declare i=0;
                #while(i<4)
                        object { latte translate <i*.3,0,0> }
                        #declare i=i+1;
                #end
                union { //poigne
                        cylinder { <2.8,1,2.05>, <2.6,1,2.05> .03 }
                        cylinder { <2.8,1,1.99>, <2.8,1,2.05> .03 }
                        sphere { <2.8,1,2.05> .03 }
                        #if(usetexture)
                                texture { T_Silver_2B }
                        #else
                                pigment { Silver }
                        #end
                }
                #declare fenetre = merge {
                        #declare i=1;
                        #while(i<4)
                                cylinder { <-1,.25*i,0>, <1,.25*i,0>, .05 }
                                #declare i=i+1;
                        #end
                        #declare i=0;
                        #while(i<4)
                                cylinder { <-.75+.5*i, 0.0, 0.0>, <-.75+.5*i, 1.0, 0.0>, 0.05 }
                                #declare i=i+1;
                        #end
                        box { <-1.0, 1.0, -0.02>,< 1.0, 0.0, 0.02> texture {
                                #if(usetexture)
                                        pigment { rgbf<1.0, 1.0, 1.0, 1.0> }
                                        finish { specular 1
                                                roughness 0.001
                                                ambient 0
                                                diffuse 0.3
                                                reflection 0.2 }
                                #else pigment { Blue } #end
                                }
                                interior { ior 1.5 }
                        }
                        #if(usetexture) texture { T_Silver_2B } #else pigment { Silver } #end
                }
                object { fenetre translate <-1.0, 0.9, 2.0> }
                object { fenetre translate <-1.0, 0.9,-2.0> }
                object { fenetre rotate <0,90,0> translate < 4.0, 0.9, 0.0> }
        //Cheminee
                difference {
                        box { <-3.5,-1,-1>,<-4.5,5,1> }
                        box { <-3,0,3>,<-5,2,.5> rotate <60,0,0> translate <0,4.5,0> }
                        box { <-3,0,-3>,<-5,2,-.5> rotate <-60,0,0> translate <0,4.5,0> }
                        box { <-0.39,0,-2>,<-2.0,1,2> rotate <0,0,80> translate <-4.2,4.46,0> }
                        box { <-3,4.05,-2>, <-5,6,-.26> }
                        box { <-3,4.05,2>, <-5,6,.26> }
                        box { <-4.27,4.05,-2>,<-5,6,2> }
                        box { <-4.31,.4,-.8>,<-3,1.5,.8> } // Trou de la chemine
                        texture { pierrebatiment }
                }
                box { <-3.4,4.9,.36>,<-4.37,5.2,-.36> texture { pierrebatiment } }
        #end
        //lumire
        #if(uselumiere)
                //feu de la chemine
                light_source { <-4, .95, 0> color 3*Yellow }
                #declare lampe = union {
                        difference { 
                                sphere { <0,0,0>, .2 texture { T_Silver_3A } }
                                sphere { <0,-.2,0>, .35 texture { T_Silver_3E } }
                        }
                        light_source { <0,0,0> color White }
                }
                object { lampe translate <-3,2.8,0> }
                object { lampe translate < 3,2.8,0> }
        #end

}

//----------------------------------------------- Tables ------------------------------------------------//

#declare boistable = texture {
        #if(usetexture)
                T_Wood17
        #else
                pigment { Brown }
        #end
}
#declare table = union {
        #declare tasseau = union {
                cylinder { <0,0,-.7>,<0,0,.7>, .1 texture { boistable } rotate <45,0,0> translate .4*y }
                cylinder { <0,0,-.7>,<0,0,.7>, .1 texture { boistable } rotate <-45,0,0> translate .4*y }
                cylinder { <0,0,0.7>,<0,0,0>, .1 texture { boistable } rotate <-45,0,0> translate .4*z }
                cylinder { <0,0,-0.7>,<0,0,0>, .1 texture { boistable } rotate <45,0,0> translate -.4*z }
        }
        object { tasseau translate -1*x }
        object { tasseau translate 1*x }
        #declare plancherondain = difference {
                cylinder { <0,0,-1.1>, <0,0,1.1>, .1 }
                box { <-10,.05,-.85>,<10,1,.85> }
                texture { boistable }
        }
                        
        object { plancherondain rotate <0,90,0> translate <0,.5,.9> }
        object { plancherondain rotate <0,90,0> translate <0,.5,-.9> }
        #declare i=0;
        #while(i<6)
                object { plancherondain rotate <0,90,0> translate <0,.9,.5-.2*i> }
                #declare i=i+1;
        #end
        cylinder { <0,0,-.9>, <0,0,.9>, .1 translate <1.0,0.5,0> }
        cylinder { <0,0,-.9>, <0,0,.9>, .1 translate <-1.0,0.5,0> }

}


