/* Station De Ski (skiresort.pov)
Copyright (c) 2002 Cyrille Berger
http://www.cberger.net/ */

#debug " Station De Ski - skiresort.pov \nCopyright (c) 2002 Cyrille Berger \nWeb:www.cberger.net"

#include "colors.inc"
#include "textures.inc"
/*#include "stones.inc"
#include "shapes.inc"
#include "glass.inc"*/
#include "metals.inc"
#include "woods.inc"

#declare usetexture = 0;
#declare useathmo = 1;
#declare full = 0;
#declare sol = 1;
#declare showarbre = 0;
#declare showtelesiege = 1;
#declare showbatiment = 1;
#declare showdameuse = 1;
#declare uselumiere = 0;
#declare usecamerafinale = 1;

#declare vuefinal=1;

#if(vuefinal)//<-20, 2, 20>, <0,4,0>
        #declare usetexture = 1;
        #declare useathmo = 1;
        #declare full = 1;
        #declare sol = 1;
        #declare showarbre = 1;
        #declare showtelesiege = 1;
        #declare showbatiment = 1;
        #declare uselumiere = 1;
        #declare usecamerafinale = 1;
#end

#include "telesieg.inc"
#include "batiment.inc"
#include "objets.inc"
#include "dameuse.inc"
//Objets de base
camera {
#if(usecamerafinale)  
	location <-20, 2, 20> //Vu finale <-20,2,20>
	look_at <0,4,0> //Vu final <0,2,0>
#else
	location <-8,3,7>
	look_at <0, 1, 0>
#end
	angle 40
}

#if(usetexture)
        #declare Neige = pigment { bozo
                turbulence 12
                color_map { [0.0 White ] [1.0 Gray55 ] }
        }
#else
        #declare Neige = pigment { White }
#end

#if(sol)
        plane { <0, 1, 0>, 0
	        pigment {
	                #if(usetexture)
	                        Neige
                        #else
        		        checker color White, color Blue
        		#end
	        }
        }
#end

#if(useathmo)
        fog {
                distance 40
                color Gray70
        }
#end

light_source { <-700, 500,300> color 3*White }

/*
light_source { <-1000, 1000, -1000> color White } //gauche
light_source { <1000, 1000, -1000> color .25*White } //droite
light_source { <0, 1000, 1000> color 2*White } //derrire
*/

sky_sphere {
	pigment {
		gradient y
		color_map {
			[0 color rgb <0,0.75,1>]
			[1 color Blue ]
		}
		scale 2
		translate -1
	}
} 


//-------------------------------------------------------------------------------------------------------//
//----------------------------------------------- Paysage -----------------------------------------------//
//-------------------------------------------------------------------------------------------------------//
#include "paysage.inc"

//-------------------------------------------------------------------------------------------------------//
//--------------------------------------------- Batiment ------------------------------------------------//
//-------------------------------------------------------------------------------------------------------//
#if(showbatiment)
        object { batiment translate < 30, 0.0,-8.0> }
        #if(full)
                object { table translate < 39, 0.0,-8.0> }
                object { table rotate < 0.0,-50, 0.0> translate < 20, 0.0,-2.5> }
                object { table rotate < 0.0, 90, 0.0> translate < 22, 0.0,-8.0> }
                object { table rotate < 0.0, 10, 0.0> translate < 26, 0.0,-1.5> }
        #end
        object { tasdeneige rotate <0,-20,0> translate <25.5,0,-5.5> }

#end


//-------------------------------------------------------------------------------------------------------//
//------------------------------------------------ Dameuse ----------------------------------------------//
//-------------------------------------------------------------------------------------------------------//

#if(showdameuse)
        object { dameuse
                rotate <0,90,0>
                rotate <30,0,0>
                translate <60,0.577*(38-12),-38>////y=tan(30)*z=0.577*z
        }
        object { dameuse
                rotate <0,-90,0>
                rotate <30,0,0>
                translate <90,0.577*(88-12),-88>////y=tan(30)*z=0.577*z
        }
#end

//-------------------------------------------------------------------------------------------------------//
//---------------------------------------------- Tlsige ----------------------------------------------//
//-------------------------------------------------------------------------------------------------------//

#if(showtelesiege)
#if(full)
        object { tasdeneige rotate <0,-60,0> translate <-5,0,-5> }
        object { poteauentree translate < -1.54,0,3> }
        object { poteauentree translate < -.46,0,3> }
        object { barriere translate <-2,0,5> } //Barrires latralles
        object { barriere translate <-2,0,7.2> }
        object { barriere translate <-2,0,9.4> }
        object { barriere translate <-2,0,11.6> }
        object { barriere translate <0,0,5> } //Barrire d'accs au tlsige
        object { barriere translate <-1,0,5> } //Barrire sparant les deux skieurs
        object { barriere rotate <0,90,0> translate <1,0,6> } //Barrires entre les skieurs et le tlsige
        object { barriere rotate <0,90,0> translate <3.2,0,6> }
        object { barriere rotate <0,90,0> translate <5.4,0,6> }
        object { barriere rotate <0,90,0> translate <7.6,0,6> }
        object { barriere rotate <0,90,0> translate <-1,0,12.6> } //Barrires de fond
        object { barriere rotate <0,90,0> translate <1.2,0,12.6> }
        object { barriere rotate <0,90,0> translate <3.4,0,12.6> }
        object { barriere rotate <0,90,0> translate <5.6,0,12.6> }
        object { barriere rotate <0,90,0> translate <7,0,12.6> }
        object { moteur translate <0,3,0> }
        object { echelle translate < 4, 0.0, 0.0> }
#end


object { poteau1 translate <0,0.1,-12> }
object { cable translate <0,2.7,0> }
object { siege translate <-1,.6,0> }
object { siege rotate 180*y translate <1,.6,-6> }
object { siege rotate 180*y translate <1,3.35,-16> }
object { siege rotate 180*y translate <1,10.1,-26> }
object { siege translate <-1,.6,-10> }
object { siege translate <-1,5.65,-20> }
object { siege translate <-1,12.35,-30> }
object { bureau translate <4,0,-8> }
object { roue translate <0,3,0> }
object { corpsprincipal translate <0,3.04,0>}
object { pilier translate <-5,0,-3.3> }
object { pilier translate <5,0,-3.3>}
#end
