/* Tlsige (telesiege.inc)
Part of skistation.pov
Copyright (c) 2002 Cyrille Berger
http://www.cberger.net/ */


//---------- Textures ----------//
#declare Pilier_Metal = 
texture {
        pigment { Gray40 }
#if(usetexture)
        finish {
                ambient 0.3
                diffuse 0.8
                reflection 0.05
                brilliance 8
                specular 0.8
                roughness 0.1
                metallic
        }
        normal {
                bumps -0.25
                scale .05 //<.2, 0.001, 0.001>
        }
#end
}
#declare Siege_Metal = 
texture {
        pigment { Gray80 }
#if(usetexture)
        finish {
                ambient 0.3
                diffuse 0.8
                reflection 0.05
                brilliance 8
                specular 0.8
                roughness 0.1
                metallic
        }
        normal {
                bumps -0.1
                scale .05
        }
#end
}
#declare blueglass = texture {
#if(usetexture)
        pigment { rgbf<.6, .6, 1.0, 0.7> }
        finish {
                specular 1
                roughness 0.001
                ambient 0
                diffuse 0.3
                reflection 0.2
        }
#else
        pigment { Blue }
#end
}
#declare verretransparant = texture {
#if(usetexture)
        pigment { rgbf<1.0, 1.0, 1.0, 0.7> }
        finish {
                specular 1
                roughness 0.001
                ambient 0
                diffuse 0.3
                reflection 0.2
        }
#else
        pigment { Blue }
#end
}
#declare plastiqueblanc = texture {
        pigment { White }
#if(usetexture)
        finish {
                specular 1
                roughness .0001
                ambient .1
                diffuse .2
                reflection .05
                phong 1
                phong_size .2
        }
#end
}
 

//---------------------------------------------- Morceaux -----------------------------------------------//

//----------------------------------------------- Pilier ------------------------------------------------//
#declare pilier = union {
        cylinder { <0,-2,-2>, <0,3,4>, .4 }
        cylinder { <0,-2,8>, <0,3,4>, .4 }
        difference {
                cylinder { <0,3,-.1>,<0,3,7.1>,.4 }
                #if(full)
//                        box { <-1,0,0>, <1,2,2> rotate <45,0,0> translate <0,2.5,-2> pigment { Blue } }
//                        box { <-1,0,2>, <1,2,0> rotate <-45,0,0> translate <0,2.5,7.2> pigment { Blue } }
                        sphere { <0,3,-.1>,.4 pigment { Blue } }
                        sphere { <0,3,7.1>,.4 pigment { Blue } }
                #end
        }
        texture { Pilier_Metal }
}

//------------------------------------------- Corps Principal -------------------------------------------//
#declare boite = difference {
        box { <-5,0,-3>,<5,3,3> }
        box { <-9,0,0>,<9,6,2> rotate <20,0,0> translate <0,0,-5.5> }
        box { <-9,0,0>,<9,6,-2> rotate <-45,0,0> translate <0,0,-2> }
        box { <-9,0,0>,<9,6,-2> rotate <-20,0,0> translate <0,0,5.5> }
        box { <-9,0,0>,<9,6,2> rotate <45,0,0> translate <0,0,2> }
}

#declare corpsprincipal = merge {
        difference {
                object { boite }
                #if(full)
                object { boite scale .95 }
                        #declare i=0;
                        #while (i<3)
                                box { <-4+3*i,1.2,-4>,<-2+3*i,2.6,4> }
                                box { <-4+3*i,.6,-4>,<-2+3*i,.9,4> }
                                #declare i=i+1;
                        #end
                #end
                texture { plastiqueblanc }
        }
#if(full)
        difference { //Vitre
                object { boite scale .99 }
                object { boite scale .96}
                texture { blueglass }
                interior { ior 1.5 }
        }
        difference { //Entourage mtallique des fentre
                object { boite scale 1.01 }
                object { boite scale .949 }
                #declare i=0;
                #while (i<3)
                        box { <-3.99+3*i,2.8,-4>,<-2.01+3*i,4,4> }
                        box { <-3.99+3*i,1.2,-4>,<-2.01+3*i,2.6,4> }
                        box { <-3.99+3*i,.6,-4>,<-2.01+3*i,.9,4> }
                        box { <-3.99+3*i,.4,-4>,<-2.01+3*i,-1,4> }
                        #declare i=i+1;
                #end
                box { <-6,-1,-4>,<-4.2,4,4> }
                box { <6,-1,-4>,<4.2,4,4> }
                box { <-6,.96,-4>,<6,1.04,4> }
                #declare i=0;
                #while (i<2)
                        box { <-1.8+3*i,-1,-4>,<-1.2+3*i,4,4> }
                        #declare i=i+1;
                #end
                #if(usetexture)
                        texture {
                                pigment { Gray30 }
                                finish { Metal }
                        }
                #else
                        pigment { Gray65 }
                #end
        }
#end
}

//-------------------------------------------- roue -----------------------------------------------------//

#declare roue = union {
        cylinder { <0,0,0>,<0,.4,0>,1 }
        #if(full)
                cylinder { <0,0,0>,<0,.55,0>,.51 }
        #end
        #if(usetexture)
                texture { Chrome_Metal }
        #else
                pigment { Gray65 }
        #end
}

//------------------------------------------- cable -----------------------------------------------------//
         
#declare cable = union {
        difference {
                torus { 1,.05 }
                box { <-3,-.3,-3>,<3,.3,0> }
        }
        cylinder { <-1,0,0>,<-1,0,-12.2>,.05 }
        cylinder { <1,0,0>,<1,0,-12.2>,.05 }
        cylinder { < 1, 0.0,-12>,< 1,12,-30>,.05 }
        cylinder { <-1, 0.0,-12>,<-1,12,-30>,.05 }
        #if(usetexture)
        pigment { gradient z frequency 15 color_map { [0 color Black] [1 color Gray40 ] } rotate <45,0,0> }
        #end
}

//------------------------------------------ bureau -----------------------------------------------------//

#declare bureau = merge {
        //baraque
        difference {
                merge {
                        box { <0,.3,0>, <2,2.3,3>  }
                        #if(full)
                                box { <-.1,.2,1.45>,<2.1,2.4,1.55> pigment { Blue } }
                                box { <-.1,.2,.05>,<2.1,2.4,.15> pigment { Blue } }
                                box { <-.1,.2,2.85>,<2.1,2.4,2.95> pigment { Blue } }
                        #end
                }
                #if(full)
                        box { <.05,.35,.05>, <1.95,2.25,2.95> } //cavit
                        box { <-1,1.3,.2>, <3,2.1,1.4> } //perce les fe^netre
                        box { <-1,1.3,1.6>, <3,2.1,2.8> }
                        box { <0.4,.4,.06>,<1.6,2.2,-.1> } // perce le pas de la porte
                #end
                texture { plastiqueblanc }
        }
        #if(full)
                difference { //vitres
                        box { <0.01,.301,0.01>, <1.99,2.29,2.99>  }
                        box { <.04,.34,.04>, <1.96,2.26,2.96> }
                        box { <0.4,.4,.06>,<1.6,2.2,-.1> } // perce le pas de la porte
                        texture { verretransparant }
                        interior { ior 1.5 }
                }
                box { <0.4,.4,.03>,<1.6,2.2,.01> pigment { // porte
                        gradient x turbulence 1
                        color_map { [ 0.4 color Brown*.5 ] [ 1.0 color Brown ] } } }
                //Pilier
                merge {
                        box { <.1,-0.1,.1>,<.3,.31,.3> }
                        box { <.1,-0.1,2.7>,<.3,.31,2.9> }
                        box { <1.7,-0.1,.1>,<1.9,.31,.3> }
                        box { <1.7,-0.1,2.7>,<1.9,.31,2.9> }
                        #if(usetexture)
                                texture { Chrome_Metal }
                        #else
                                pigment { Gray65 }
                        #end        
                }
                //escalier
                merge {
                        box { <0.2, .3, .01>,<1.8, .35, -.5> }
                        box { <0.2, .1, -.4>,<1.8, .15, -.9> }
                        box { <0.1, 0, 0>,<0.2, .2, -2.0> rotate <-25, 0, 0> translate <0, 0.4, 0.2>}
                        box { <1.8, 0, 0>,<1.9, .2, -2.0> rotate <-25, 0, 0> translate <0, 0.4, 0.2>}
                        texture { Pilier_Metal }
                }
        #end
}

//---------------------------------------- coussinnoir --------------------------------------------------//

//Sige coussin noire
#declare coussinnoir = merge { 
        //Bordure
        cylinder { <-.25,0,.25>, <.25,0,.25> .1 }
        cylinder { <.25,0,.25>, <.25,0,-.25> .1 }
        cylinder { <.25,0,-.25>, <-.25,0,-.25> .1 }
        cylinder { <-.25,0,-.25>, <-.25,0,.25> .1 }
        //Coin
        sphere { <-.25,0,.25> .1 }
        sphere { <.25,0,.25> .1 }
        sphere { <.25,0,-.25> .1 }
        sphere { <-.25,0,-.25> .1 }
        //corps
        box { <-.25,-.1,-.25>, <.25,.1,.25> }
        pigment { Black }
        #if(usetexture)
                finish { phong 1 phong_size 150 }
        #end
}
//Sige de tlsige
//Petite roue de support des cables
#declare petiteroue = union {
        difference {
                cylinder { <-.08,0,0>,<.08,0,0>, .12 }
                torus { .12, .05 rotate <0,0,90> }
        }
        cylinder { <-.082,0,0>,<.2,0,0>, .05 }
        #if(usetexture)
                texture { Chrome_Metal }
        #else
                pigment { Gray65 }
        #end       
}
#declare rateauderoue = union {
        box { <-.05,-0.2,-0.4>, <.05, 0.2, 0.4> }
        #if(full)
                cylinder { <0,-0.2,-0.4>, <0, 0.2,-0.4>, .05 }
                cylinder { <0,-0.2, 0.4>, <0, 0.2, 0.4>, .05 }
                #declare i=0;
                #while(i<3)
                        object { petiteroue translate <-0.15, 0.0,-0.3+0.3*i> }
                        #declare i=i+1;
                #end
        #end
}
#declare poteau1 = union {
        object { rateauderoue  translate <-.85, 2.7, 0.5> }
        object { rateauderoue rotate <35,0,0> translate <-.85, 3,-0.5> }
        object { rateauderoue rotate 180*y translate < .85, 2.7, 0.5> }
        object { rateauderoue rotate <-35,180,0> translate < .85, 3,-0.5> }
        union {
                cylinder { < 0.0,-0.1, 0.0>, < 0.0,-3.0, 0.0>,.2 } //Bas du Poteau
                #if(full)
                        cone { < 0.0,-0.1, 0.0>,.2 < 0.0,.1, 0.0>, .1 } //Rtrcissement 
                        cylinder { < 0.0, 0.1, 0.0>, < 0.0,.5, 0.0>, .1 } //Haut du poteau
                        sphere { < 0.0, 0.5, 0.0>, .1 } //Chapeau du poteau
                        cylinder {< 0.0, 0.5, 0.0>, <-.85, 0.0, 0.5>, .05 } //Attache rateau au haut du poteau
                        cylinder {< 0.0, 0.5, 0.0>, < .85, 0.0, 0.5>, .05 } //Attache rateau au haut du poteau
                        cylinder {< 0.0, 0.5, 0.0>, <-.85, 0.1,-0.5>, .05 } //Attache rateau au haut du poteau
                        cylinder {< 0.0, 0.5, 0.0>, < .85, 0.1,-0.5>, .05 } //Attache rateau au haut du poteau
                        cylinder {< .85, 0.1,-0.5>, <-.85, 0.0, 0.5>, .05 } //Attache rateau au haut du poteau
                        cylinder {<-.85, 0.1,-0.5>, < .85, 0.0, 0.5>, .05 } //Attache rateau au haut du poteau
                        cylinder {< .85, 0.0, 0.5>, <-.85, 0.0, 0.5>, .05 } //Attache rateau au haut du poteau
                        cylinder {<-.85, 0.1,-0.5>, < .85, 0.1,-0.5>, .05 } //Attache rateau au haut du poteau
                #end
                rotate <10,0,0> translate <0,2.7,0>
        }
        texture { Pilier_Metal }
}

//-------------------------------------------- Barrire -------------------------------------------------//
#declare barriere = merge {
        cylinder { < 0.0, 0.0, 1.0>, < 0.0, 1.0, 1.0>, .03 }
        cylinder { < 0.0, 0.0,-1.0>, < 0.0, 1.0,-1.0>, .03 }
        cylinder { < 0.0, 0.5,-1.0>, < 0.0, 0.5, 1.0>, .03 }
        cylinder { < 0.0, 1.1,-0.9>, < 0.0, 1.1, 0.9>, .03 }
        difference {
                torus { .1,.03 }
                box { < 0,1,-1>,<-1,-1,1> }
                box { < 1,1,0>,<-1,-1,1> }
                rotate <0,0,90>
                translate <0,1,-.9>
        }
        difference {
                torus { .1,.03 }
                box { < 0,1,-1>,<-1,-1,1> }
                box { < 1,1,-1>,<-1,-1,0> }
                rotate <0,0,90>
                translate <0,1,.9>
        }
        #if(usetexture)
                texture { Silver_Metal }
        #else
                pigment { Gray65 }
        #end        
}

//------------------------------------------------ Sige ------------------------------------------------//

#declare siege = union {
        #if(full)
                object { coussinnoir translate <-.4,0,0>}
                object { coussinnoir scale <1.0, 1.0, 0.7> rotate <-80,0,0> translate <-.4,.4,.5> }
                object { coussinnoir translate <.4,0,0> }
                object { coussinnoir scale <1.0, 1.0, 0.7> rotate <-80,0,0> translate <.4,.4,.5> }
        #end
        union {
                //Support des coussins
                box { <-0.4, -0.05, -0.1>, <0.4, -0.15, 0.1> }
                box { <-0.4, -0.05, -0.1>, <0.4, -0.15, 0.1> rotate <-80, 0, 0> translate <0, 0.4, 0.5> }
                box { <-0.1, -0.05, 0>, <0.1, -0.1, 0.5> }
                box { <-0.1, -0.05, 0>, <0.1, -0.1, 0.5> rotate <-80, 0, 0> translate <0, 0, 0.5> }
                box { <-0.1, -0.05, -0.05>,<0.1,-0.1, 0.11 > rotate <-48, 0, 0> translate <0, 0, 0.47> }
                #if(full)
                        //Armature
                        cylinder { <-0.8, 0.4, 0.6>, < 0.8, 0.4, 0.6>, .05 } //Transversalle arrire milieu
                        cylinder { <-0.8, 0.4, 0.6>, <-0.8,-0.1, 0.1>, .05 } //Diagonal gauche
                        cylinder { < 0.8, 0.4, 0.6>, < 0.8,-0.1, 0.1>, .05 } //Diagonal Bas
                        cylinder { <-0.8,-0.1, 0.1>, < 0.8,-0.1, 0.1>, .05 } //Transversalle milieu en-dessous
                        cylinder { <-0.8, 0.3, 0.5>, <-0.8, 0.3, 0.0>, .05 } //horizontal gauche
                        cylinder { < 0.8, 0.3, 0.5>, < 0.8, 0.3, 0.0>, .05 } //horizontal droite
                        cylinder { <-0.8, 0.3, 0.0>, <-0.8,-0.1, 0.1>, .05 } //vertical bas gauche
                        cylinder { < 0.8, 0.3, 0.0>, < 0.8,-0.1, 0.1>, .05 } //vertical bas droite
                        //Arceau de raccord au cable
                        cylinder { <-0.8, 0.3, 0.3>, <-0.8, 0.6, 0.3>, .05 } //vertical haut gauche milieu
                        cylinder { < 0.8, 0.3, 0.3>, < 0.8, 0.6, 0.3>, .05 } //vertical haut droite milieu
                #end
                difference {
                        torus { 0.8, 0.05 }
                        box { <-1,2,0>,<1,-2,3> }
                        rotate 90*x translate <0,.6,.3>
                }
                cylinder { <-.2,1.4,.3>, <-.2,2.1,.3>, .05 } //Tige vers le haut d'attache
                #if(full)
                        sphere { <-.2,2.1,.3>, .07 }
                        difference {
                                box { < 0.2, 0.2, .03>, <-0.2,-0.2,-.03> rotate 45*z }
                                box { < 0.0,-.05,-1.0>,< 1.0,.05, 1.0> }
                                translate <-0.07, 2.12, 0.3>
                        }
                        //Raccords
                        sphere { <-0.8,-0.1, 0.1>, .05 } //extrmit bas milieu gauche
                        sphere { < 0.8,-0.1, 0.1>, .05 } //extrmit bas milieu droite
                        sphere { <-0.8, 0.3, 0.0>, .05 } //extrmit milieu avant gauche
                        sphere { < 0.8, 0.3, 0.0>, .05 } //extrmit milieu avant droite
                        sphere { <-0.8, 0.4, 0.6>, .05 } //extrmit milieu arrire gauche
                        sphere { < 0.8, 0.4, 0.6>, .05 } //extrmit milieu arrire droite
                 #end
                texture { Siege_Metal }
        }
        #if(full)
                union {
                        cylinder { <-0.85, 0.0, 0.0>, <-0.85, 0.0,-0.8>, .05 } //Barre latral gauche
                        cylinder { < 0.85, 0.0, 0.0>, < 0.85, 0.0,-0.8>, .05 } //Barre latral droite
                        cylinder { <-0.85, 0.0,-0.8>, < 0.85, 0.0,-0.8>, .05 } //Barre avant
                        cylinder { <-0.20, 0.0,-0.8>, < 0.20, 0.0,-0.8>, .06 pigment { Yellow } } //Barre de pub
                        cylinder { < 0.00, 0.0,-0.8>, < 0.00,-0.3,-0.5>, .05 } //soutient du centre
                        sphere { <-0.85, 0.0,-0.8>, .05 }
                        sphere { < 0.85, 0.0,-0.8>, .05 }
                        sphere { <-0.85, 0.0, 0.0>, .05 }
                        sphere { < 0.85, 0.0, 0.0>, .05 } 
                        sphere { < 0.00,-0.3,-0.5>, .05 } //Repose sur le sige
                        //Repose ski
                        cylinder { < 0.00, 0.0,-0.8>, < 0.00, -0.8,-0.8>, .05 }
                        cylinder { <-0.40,-0.8,-0.8>, < 0.40, -0.8,-0.8>, .05 }
                        sphere { <-0.40,-0.8,-0.8>, .05 } 
                        sphere { < 0.40,-0.8,-0.8>, .05 } 
                        rotate <68,0,0>
                        translate < 0.0, 0.3, 0.5>
                        texture { Siege_Metal }
                }
        #end
}        

//------------------------------------------ Poteau entre ----------------------------------------------//

#declare poteauentree = union {
        cylinder { <-0.5, 0.0, 0.0>, <-0.5, 2.5, 0.0>, .03 }
        sphere { <-0.5, 2.5, 0.0>, .03 }
        cylinder { < 0.5, 0.0, 0.0>, < 0.5, 2.5, 0.0>, .03 }
        sphere { < 0.5, 2.5, 0.0>, .03 }
        cylinder { < 0.5, 2.5, 0.0>, <-0.5, 2.5, 0.0>, .03 }
        sphere { < 0.5, 1.4, 0.0>, .05 }
        sphere { < 0.5, 1.6, 0.0>, .05 }
        cylinder { < 0.5, 1.4, 0.0>, < 0.5, 1.6, 0.0>, .05 }
        box { < 0.5, 1.4,-.04>,<-0.3, 1.6,.04> }
        #if(usetexture)
                texture { Silver_Metal }
        #else
                pigment { Gray65 }
        #end        
}       
//----------------------------------------------- Moteur ------------------------------------------------//
#declare moteur = union {
        box { <-2.0, 0.0,-1.5>, < 3.0, 2.0, 1.5> pigment { Gray35 } }
        cylinder { < 1.0, 1.9, 0.0>, < 1.0, 2.2, 0.0>, 0.5 pigment { Gray55 } }
        cylinder { < 1.0, 2.1, 0.0>, < 1.0, 2.3, 0.0>, 1.0 pigment { Gray75 } }
        cylinder { <-2.1, 1.0, 0.0>, <-2.3, 1.0, 0.0>, 0.9 pigment { Gray80 } }
        #if(uselumiere)
                light_source { <0,2.7,0> color White }
                light_source { <-2.0, 2.0,-1.5> color .4*Green }
                light_source { <-2.0, 2.0, 1.5> color .6*Red }
        #end
}
//----------------------------------------------- Echelle -----------------------------------------------//
#declare echelle = union {
        cylinder { < 0.0, 0.0,-0.5>, < 0.0, 4.0,-0.5>, .05 }
        cylinder { < 0.0, 0.0, 0.5>, < 0.0, 4.0, 0.5>, .05 }
        #declare i=0;
        #while(i<10)
                cylinder { < 0.0,.4*i,-0.5>, < 0.0,.4*i, 0.5>, .05 }
                #declare i=i+1;
        #end
        texture { Pilier_Metal }
}
