
#version 3.1;

#include "colors.inc"   
#include "glass.inc" 
#include "woods.inc" 
#include "skies.inc"  
#include "penguin.pov"

global_settings
{
  assumed_gamma 1.0
}    


//==================== een aantal variabelen om te spelen met de scene ... ==========
#declare lichtsnoerstrength = 0.5 ;   
#declare binnenlichtstrength = 0;  
#declare buitenlichtstrength = 0;   
#declare suncolor = White*1.5+Yellow*0.3;    

#declare sneeuwtext = finish{ambient 0.4 diffuse 0.3} 

   
  camera
{
  location  <1,-0.6, -4.9>
  direction 1.5*z
  right     4/3*x
  look_at   <0, 0.2, 0>
}            

/*camera
{
  location  <0,10, 20>
  direction 1.5*z
  right     4/3*x
  look_at   <0, 0.4, 0>
}      */

       
//===================================================================================   
#declare frulpart =
cylinder
{
  0*z,  0.1*z,  0.3 
  texture { T_Wood8 rotate y*90}
  // open
}           
 
 
#declare frul =
union
{ 
 object{frulpart translate<-0.52,0,0>}
 object{frulpart translate<-1.04,0,0>}
 object{frulpart translate<-1.56,0,0>}
 object{frulpart translate<-2.08,0,0>} 
 object{frulpart translate<-2.60,0,0>}
 object{frulpart translate<-3.12,0,0>}
 object{frulpart translate<-3.64,0,0>}
 object{frulpart} 
 object{frulpart translate<0.52,0,0>}
 object{frulpart translate<1.04,0,0>}
 object{frulpart translate<1.56,0,0>}
 object{frulpart translate<2.08,0,0>}
 object{frulpart translate<2.60,0,0>}
 object{frulpart translate<3.12,0,0>}
 
 }   
 
#declare Dakbalk = 
box
{
  <-3.4, -0.5, 0>  
  < 3.4,  0.3,  0.1>  
}
 



#declare Dak =
union {
        union {
                box
                {
                <-3.5, -0.1, 1>  
                < 3,  0.1, -5.2> 
                }      
                object {frul translate<0.15,0,0.95> clipped_by{ box {
                <-3.5, -0.3, -0.05>  
                < 3,  0, 1.5>  
                }  }  }    
                object {Dakbalk translate<0.15,0,-0.5> clipped_by{ box {
                <-3.5, -0.5, -0>  
                < 3,  0, -1>  
                }  }  }   
                object {Dakbalk translate<0.15,0,-1> clipped_by{ box {
                <-3.5, -0.5, -0.5>  
                < 3,  0, -1.5>  
                }  }  }  
                object {Dakbalk translate<0.15,0,-1.5> clipped_by{ box {
                <-3.5, -0.5, -1>  
                < 3,  0, -2>  
                }  }  }  
        texture { T_Wood8 rotate y*90} 
        rotate<0,0,25>
        translate<0.5,2.5,0> 
        clipped_by { 
                box
                {
                <3, -2, -6>  
                <-6,  6,  1.1> 
                }
                }   
        }   
        union {
                box
                {
                <-3, -0.1, 1>  
                < 3.5,  0.1, -5.2> 
                }
                object {frul translate<0.15,0,0.95> clipped_by{ box {
                <-3, -0.3, -0.05>  
                < 3.5,  0, 1.5>  
                }  }  }  
        texture { T_Wood8 rotate y*90} 
        rotate<0,0,-25>
        translate<5.5,2.5,0> 
        clipped_by { 
                box
                {
                <3, -2, -6>  
                <10,  6,  1.1> 
                }
                }   
        }   

        
         
}         




#declare Plank =
union {   

        box
        {
        <-1.3, 0, -0.1>  
        < 1.3, 0.3, 0.1>  
        }

        cylinder
                {
                -1.3*x,  1.3*x,  0.05
                }
        }   

#declare Spijl =
union {
      cylinder
                {
                -1.3*x,  1.3*x,  0.05  
                texture { T_Wood8 rotate y*90}   
                translate<0,0,-0.05>
                }      
      cylinder
                {
                -1.3*x,  1.3*x,  0.05  
                texture { T_Wood8 rotate y*90}   
                translate<0,0,0.05>
                }            
}   

#declare huisprism =

prism {
  linear_sweep 
  linear_spline 
  0,        // height 1
  5.5,        // height 2
  6,          // number of points
  // the <u,v> points
  < -2, 0>, < -2,  3.16>, < 3, 5.5>, < 8,  3.16>, < 8,  0>, 
  <-2,  0>   

}  

 //====================== sneeuwman ===============================================  
#declare kleur_oogjes    = color rgb <0.0, 0.0, 0.0>;
#declare oogjes = texture { pigment { kleur_oogjes } } 
 
#declare sneeuwman =  
union{
blob
{
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  sphere { <0, 0, 0> 1.2, strength 3.5 }
  sphere { <0, 1.5, 0>, 1.1, strength 2.5 }
  sphere { <0, 2.8, -0.5>, 1, strength 1.5}   
  
  sphere { <-0, 2.7, -1.2>, 0.2, strength 0.6 pigment {color rgb <2, 0, 0>    }}
  sphere { <-0.3, 2.9, -1.15>, 0.2, strength -0.6} 
  sphere { <0.3, 2.9, -1.15>, 0.2, strength -0.6} 
    
  //rechterarm  
  sphere { <-0.65, 1.5, -2.8>, 0.35, strength 1.5 scale<1,1.4,0.6>}  
  sphere { <0, 0, 0>, 0.4, strength 1.3 scale<1,2.5,1> rotate<60,0,0> translate<-0.65,1.8,-0.5>}  
  sphere { <0, 0, 0>, 0.4, strength 1.3 scale<1,2.5,1> rotate<-60,0,0> translate<-0.65,1.6,-1.1>} 
   
  //linkerarm      
  sphere { <0.65, 1.5, -2.8>, 0.35, strength 1.5 scale<1,1.4,0.6>}  
  sphere { <0, 0, 0>, 0.4, strength 1.3 scale<1,2.5,1> rotate<60,0,0> translate<0.65,1.8,-0.5>}  
  sphere { <0, 0, 0>, 0.4, strength 1.3 scale<1,2.5,1> rotate<-60,0,0> translate<0.65,1.6,-1.1>}        

  texture{ pigment {color rgb <1,1,1>}   
  finish{ambient 0.5} } 
  normal { wrinkles 0.5 scale 0.5 } 
} 

// create a sphere shape
sphere
{
  <-0.25, 2.9, -1> 
  0.05       
  pigment {color rgb <0.1, 0.1, 0.1>    }
  finish{metallic    }
}
 sphere
{
  <0.25, 2.9, -1> 
  0.05       
  pigment {color rgb <0.1, 0.1, 0.1>    }
} 

lathe {
  linear_spline
    4, // # of points
    <0.000000, 0.000000> 
    <1,0>
    <0.75, 1.6>
    <0, 1.6>     
    pigment { Blue } 
    finish{ ambient 0.1
        phong 2    
        phong_size 20

}   
scale<0.5,0.5,0.5>   
rotate<15,0,5>
translate <0, 3.2, -0.35>   
}
}  


object{sneeuwman scale<0.75,0.75,0.7> translate<-0.5,-1.7,1.40>  }  

object{penguin scale<0.6,0.6,0.6> rotate<0,-60,0> translate<0.7,-0.8,1.2>} 

//=========================== lichtjes ... =========================================
  
  #declare lightbulb =
union{     

cylinder
{
  -0.8*y,  0*y,  0.5 
   pigment {color rgb <0.2, 0.4, 0.2>    }

}    

sphere
{
  <0, -1.5, 0> 
  1       
}  
    scale<0.06,0.12,0.06>     
}  

#declare lightpart =

sphere
{
  <0, 0, 0> 
  1       
}
   

      
#declare white_lightbulb =
union{     

cylinder
{
  -0.8*y,  0*y,  0.5 
   pigment {color rgb <0.2, 0.4, 0.2>    }

}    

light_source
{    
  <0,-1.5,0> // light's position (translated below) 
  color White*lichtsnoerstrength  // light's color   
  fade_distance 1     
  fade_power 1
  looks_like {lightpart  texture{T_Glass2 finish{ambient 0.8}} interior{I_Glass}}
  
}              
    scale<0.06,0.12,0.06>     
}         


#declare yellow_lightbulb =
union{     

cylinder
{
  -0.8*y,  0*y,  0.5 
   pigment {color rgb <0.2, 0.4, 0.2>    }

}  


light_source
{
  <0,-1.5,0> // light's position (translated below)
  color Yellow*lichtsnoerstrength  // light's color    
  fade_distance 1  
  fade_power 1
  looks_like {lightpart  texture{T_Yellow_Glass finish{ambient 0.8}} interior{I_Glass}}   
}            
    scale<0.06,0.12,0.06>     
}   


#declare green_lightbulb =
union{     

cylinder
{
  -0.8*y,  0*y,  0.5 
   pigment {color rgb <0.2, 0.4, 0.2>    }

}     


light_source
{
  <0,-1.5,0> // light's position (translated below)
  color Green*lichtsnoerstrength  // light's color     
  fade_distance 1   
  fade_power 1
  looks_like {lightpart  texture{T_Winebottle_Glass finish{ambient 0.8}} interior{I_Glass}}    
}  
          
    scale<0.06,0.12,0.06>     
}  

#declare red_lightbulb =
union{     

cylinder
{
  -0.8*y,  0*y,  0.5 
   pigment {color rgb <0.2, 0.4, 0.2>    }

}  


light_source
{
  <0,-1.5,0> // light's position (translated below)
  color Red*lichtsnoerstrength // light's color 
  fade_distance 1 
  fade_power 1
  looks_like {lightpart  texture{T_Ruby_Glass finish{ambient 0.8}} interior{I_Glass}}
}             
    scale<0.06,0.12,0.06>     
}    

//=================== de lucht .... ======================================
#declare wolken =
pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <1, 1, 1>
                   color rgb <0.85, 0.85, 0.90>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.85>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>    
      rotate<0,0,-90>
    }  
 
 #declare nachtwolken =
pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.05, 0.05, 0.05>
                   color rgb <0.1, 0.1, 0.1>]
          [0.1 0.5 color rgb <0.1, 0.1, 0.1>
                   color rgbt <0.2, 0.2, 0.2, 1>]
          [0.5 1.0 color rgbt <0.2, 0.2, 0.2, 1>
                   color rgbt <0.3, 0.3, 0.3, 1>]
      }
      scale <0.2, 0.5, 0.2>    
      rotate<0,90,-90>  
      translate<50,0,0>
    }   
  
  
/*sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.5 color rgb <0.55, 0.65, 1>
                     color rgb <0.35, 0.45, 1>]
        [0.5 1.00 color rgb <0.35, 0.45, 1>
                     color rgb <0.3, 0.3, 1>]
      }
      scale 2
      translate -1
    }  
    pigment{wolken}
    
  }   */
      
      
sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.1 color rgb <0.4, 0.4, 0.45>
                     color rgb <0.1, 0.1, 0.2>]
        [0.1 1.00 color rgb <0.1,0.1,0.2>
                     color rgb <0, 0, 0.05>]
      }
      scale 2
      translate -1
    }
    pigment{nachtwolken}      
  }        
 /*fog {
    distance 20
    color rgbt<0.5, 0.5, 0.5,0.5>
  }      */
    
// ================== het licht buiten ...  ==========================  
light_source
{
  0*x // light's position (translated below)
  color suncolor*buitenlichtstrength  // light's color
  translate <30, 10, 10>
}         
   
// ================== het licht binnen...  ============================ 
light_source
{
  0*x // light's position (translated below)
  color White*binnenlichtstrength  // light's color
  translate <2, 3, -3>  
 // fade_distance 1
 // fade_power 1
}    

// ===================== sneeuwvlakte =============================


plane { y, -2 texture{ pigment {color rgb <1,1,1>}   
finish{sneeuwtext} }

  normal { wrinkles 0.5 scale 0.5 } 
  normal { wrinkles 2 scale 10 }
}    

//====================== iglo ====================================
#declare voegsel = Grey*0.5 + Black*0.5;       
      
#declare iglo =
difference{ 
sphere
{
  <0, 0, 0> 
  2       
  }
  
sphere
{
 <0,0,0>
 1.6
 }
 
 
cylinder
{
  -3*z,  0*z,  0.6
  scale<1,1.2,1>
  
} 

texture { pigment{
    brick      color voegsel, color White
    brick_size <0.6,0.3,0.6>   
    mortar     0.03       
  } finish{ambient 0.5}  }
}

object {iglo rotate<0,30,0> translate<0,-2,20>    }    

//object {iglo rotate<0,-135,0> translate<-10,-2,3>    }  

//=============== bergen op de achtergrond ============================
#declare lastiggeval =
height_field
{
  gif "pog3rel.gif"
  texture
  {
    pigment
    {
      image_map { gif "pog3opp.gif" map_type 0 interpolate 2 once }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    } 
    finish{  ambient 0.2 diffuse 0.3}
  }        
  rotate<0,135,0> 
  translate<0,-0.3,0>
  scale<1000,200,1000>
  
}   

object{lastiggeval translate<-100,-2,1250>  }

//sphere{<0, 0, 0> 10 translate<-480,0,-178> pigment{color Red} finish{ambient 0.5} } 
//object{lastiggeval rotate<0,-180,0> translate<-400,-70,-350>  }


// ===================== Dit is het raam ===============================     
#declare F_glasraam =
   finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.2
  } 
  
#declare T_glasraam =
texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 1.0> }
    finish  { F_Glass1 }
}     
 

#declare raam =
union{
box
{
  <-1, -1, -0.05>  
  < 1,  1,  0.05>    
  texture{T_glasraam 
} interior{I_Glass}
}    
object { Plank texture { T_Wood8 rotate y*90} rotate<0,0,180> translate<0,-1,0> }     
object { Plank texture { T_Wood8 rotate y*90} translate<0,1,0> }
object { Plank texture { T_Wood8 rotate y*90} rotate<0,0,90> translate<-1,0,0>}     
object { Plank texture { T_Wood8 rotate y*90} rotate<0,0,-90> translate<1,0,0>}
object {Spijl}   
object {Spijl rotate<0,0,90>}  
}   

object{raam}  
object{raam translate<6,0,0>}



//===================== Opschrift op het raam =========================== 

height_field
{
  gif               
  "nj2.gif"     
  water_level 0.03 
  scale <2,0.5,2>
 rotate<-90,0,0>    
 translate<-1,-1.2,0>
 texture{ pigment {color rgb <2,2,2>}   
  finish{diffuse 0.4 } }
}   




//=============== achterwand ==============================================
box
{
  <-2, -2, -5.2>  
  < 8,  4,  -5> 
  texture { T_Wood8 rotate y*90} 
  
clipped_by { huisprism rotate<-90,0,0> translate<0,-2,0>  }

}    

//================ dak ======================================================
object {Dak}  
  
//=============== rechterwand ===============================================
  
box
{
  <-1.6, -2, 0>  
  < -2.2,  1.16,  -5.2> 
  texture { T_Wood8} 
}   
        
//=============== linkerwand ===============================================
  
box
{
  <8, -2, 0>  
  < 7.8,  1.16,  -5.2> 
  texture { T_Wood8} 
}    
            


//============== De vloer ====================================================
 
 
box
{
  <-2, -2, 0>  
  < 8,  -1.8,  -5> 
  texture { T_Wood8 rotate y*90} 
}

         
//============== Dit is het vlak waar het raam in komt...   ===================  





difference
{
        
        box
        {
        <-2, -2, -0.001>  
        < 8,  4, 0.001> 
        clipped_by { huisprism rotate<-90,0,0> translate<0,-2,0>  } 
        }

   
        box
        {
        <-1, -1, -1>  
        < 1,  1,  1>  
        }  
        
        box
        {
        <-1, -1, -1>  
        < 1,  1,  1> 
        translate<6,0,0> 
        }
        
texture { T_Wood8 rotate y*90}             
}    

#declare draad =                                      

lathe {
  cubic_spline // linear_spline | quadratic_spline | cubic_spline
  11, // number of points
  <1.8,-1.2><1.5,-1.2>,<1.1,-1>, <1.15,-0.6>, <1,-0.4>, <1.1,-0.2>, <0.9,0.2>,
  <1.1,0.5>,<1,0.8> ,<1.5,1.2>,<1.8,1.2>  
  pigment {color rgb <0.2, 0.4, 0.2>    }    
  hollow off 
  rotate<0,0,-90>
   }
 



#declare snoer =
union
{   

object { white_lightbulb  rotate<0,0,10> translate<-1,1.1,0>  } 
object { red_lightbulb  rotate<0,0,-20> translate<-0.6,1.15,0>  }
object { green_lightbulb rotate<0,0,20> translate<-0.4,1,0>   }
object { yellow_lightbulb rotate<0,0,60> translate<-0.2,1.1,0>   }
object { white_lightbulb  rotate<0,0,0> translate<0.2,0.9,0>   }
object { red_lightbulb  rotate<0,0,-10> translate<0.5,1.1,0>   }
object { green_lightbulb  rotate<0,0,-20> translate<0.8,1,0>   } 
object {draad
 clipped_by{  
        box
                {
                <-2, 0, -0.02>  // one corner position <X1 Y1 Z1>
                < 2,  2, 0.02>  // other corner position <X2 Y2 Z2>
                }
            }  
        }
  }
  
object { snoer translate<0,0,-0.2>}    



                                                                      
                                                                      