/***********************************
*                                  *  
*        by Egala                  *
*                                  *
************************************/

global_settings {
  adc_bailout 0.003922
  ambient_light <0.91,0.91,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0,0,0> }

camera {
  location  <0,-0.001,-3>
  sky       <0,0,1>
  up        <0,0,1>
  right     <1.35836,0.0,0.0>
  angle     40
  look_at   0
} 

#declare NLIGHTS=7;

light_source {
  0
  color rgb 1
  area_light <2,0,0>, <0,2,0>, NLIGHTS, NLIGHTS
  adaptive 2
  rotate -90.0*x
  translate  <0,-3,1.2>
}

#include "materials.inc"

//////////////////////////////////////////////////////////  TERRENO
bicubic_patch
        {
        type 1 flatness 0.00001 u_steps 4 v_steps 4,
        <-2.400000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, 0.000000>, <2.400000, 0.000000, 0.000000>, 
        <-2.400000, 0.100000, 1.300000>, <-0.500000, 0.115539, 1.334344>, <0.500000, 0.115539, 1.334344>, <2.400000, 0.100000, 1.300000>, 
        <-2.400000, 3.600000, 1.500000>, <-0.500000, 3.617312, 1.470929>, <0.500000, 3.617312, 1.470929>, <2.400000, 3.600000, 1.500000>, 
        <-2.400000, 2.500000, 2.200000>, <-0.500000, 2.817312, 2.370929>, <0.500000, 2.817312, 2.370929>, <2.400000, 2.500000, 2.200000>
        material { texture{NeveTerreno} }
        rotate <-8.0, -0.0, 180.0>
        translate  <0.0, 0.9, 1.4>
        }

bicubic_patch
        {
        type 1 flatness 0.00001 u_steps 6 v_steps 6,
        <-1.500000, 0.000000, 0.000000>, <-0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, 0.000000>, <1.500000, 0.000000, 0.000000>, 
        <-1.500000, 0.100000, 0.200000>, <-0.500000, 0.100000, 0.200000>, <0.500000, 0.100000, 0.200000>, <1.500000, 0.100000, 0.200000>, 
        <-1.500000, 1.100000, 1.300000>, <-0.500000, 1.100000, 1.300000>, <0.500000, 1.100000, 1.300000>, <1.500000, 1.100000, 1.300000>, 
        <-1.500000, 0.000000, 2.000000>, <-0.500000, 0.300000, 2.200000>, <0.500000, 0.300000, 2.200000>, <1.500000, 0.000000, 2.000000>
        material { texture{NeveTerreno} }
        rotate <-8.0, -0.0, 180.0>
        translate  <0.0, 0.8, -0.4>
        }

//////////////////////////////////////////////////////////  ALBERO
// Include the leaf definition and splinetree files
#include "splinetree.inc"

#declare recursionmax = 7; // Defines the complexity of the tree
#declare divisions = array[7] {7,3,3,2,2,1,0}
init_rand (9,11,1967)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.5, 0.8, 0.9)
init_rdev (70, 40, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (3.4, 0.2, 0.6)
init_branchw (0.35, 0.004, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.15,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
#declare tendancy = <-0.05,0.2,0.05>;

// Assign the branch texture
#declare branchtexture = texture { AlberoTexture } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <0.075,0.075,0.075>
	rotate <0,0,180>
	translate <0.4,0.1,0.75>
}

// Provide feedback in the first 3 recursion levels
#declare feedback = 2;

splinetree(0,0)


init_rand (9,11,1967)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.5, 0.8, 0.9)
init_rdev (70, 40, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (3.4, 0.2, 0.6)
init_branchw (0.35, 0.004, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.15,0.3)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Assign the branch texture
#declare branchtexture = texture { NeveTerreno } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <0.0745,0.075,0.0745>
	rotate <0,0,180>
	translate <0.4,0.1-0.002,0.75>
}
	
splinetree(0,0)


//////////////////////////////////////////////////////////  CASA
#include "casa.inc"
#include "tetto.inc"
#include "nevetetto.inc"

union {
  object { CASA_ material { CasaTexture scale 0.03} }
  object { TETTO_ material { TettoTexture }}
  object { NEVETETTO_ material { texture {NeveTerreno} }}
  scale 0.27
  rotate <0, 14, 180>
  translate  <0.75,2.43, 1>
}


////////////////////////////////////////////////////////// FIOCCHI DI NEVE

#declare Box_min = <-1,-2,-1.5>;
#declare Box_max = <1,2,1.5>;
#declare SIZEmin = 0.001;
#declare SIZEmax = 0.005;
#declare Nflakes = 20000;
#declare RANDOMseed = seed(8);
#declare Fiocco = sphere {0,1 material {Neve} no_shadow}

#declare I = 0;
#declare Kscala = SIZEmax-SIZEmin;
#declare KX = Box_max.x - Box_min.x;
#declare KY = Box_max.y - Box_min.y;
#declare KZ = Box_max.z - Box_min.z;
#while (I<Nflakes)
        #declare scala = Kscala*rand(RANDOMseed)+SIZEmin;
        #declare c_x = KX*rand(RANDOMseed) + Box_min.x;
        #declare c_z = KZ*rand(RANDOMseed) + Box_min.z;
        #declare c_y = KY*rand(RANDOMseed) + Box_min.y;
        object {
                Fiocco
                scale scala
                translate <c_x,c_y,c_z>
               }
        #declare I = I+1;
#end