// Persistence Of Vision raytracer version 3.1 sample file.
// Use copies of this file for starting your own scenes.

global_settings { assumed_gamma 2.2 }


#declare tex=texture{
   pigment {rgb 2.1}           
   normal {granite 0.5 scale 7}
   finish {ambient 0.2}
   }




//Base
#declare base= union{
sphere { <0, 0, 0>, 2.4
texture {tex}
translate y*2
}                 
}



//Body
#declare two=union{
            
            
sphere { <0, 0, 0>, 1.7
texture {tex}
   
}                  
}


#declare arm=
merge{
  cylinder { 0*x,  2.5*x,  0.6}              
  sphere { <0, 0, 0>, 0.6  translate x*2.5}
  sphere { <0, 0, 0>, 0.6}
  texture {tex}
}     


#declare body=
union{
object {two}      
//object {arm rotate y*45  rotate x*20  translate <1,5,0> }
//object {arm rotate y*135 rotate x*-10 translate <-1,5,0>}
}


#declare message=merge{
        text
        {
        ttf             
        "crystal.ttf",  
        "Merry Xmas!",      
        0.2,0
        translate x*-2.7
        }
        
        box {<-3,-0.3,0.1>,<3,0.7,0.4>}

        scale 1.4
        pigment {color rgbt <1,1,1,0.4>}
        normal {granite 0.02 scale 0.1}
        finish {reflection 0.3 phong 10 phong_size 5 brilliance 10}
        interior {ior 1.5}
}
         
//Head
#declare three=sphere { <0, 0, 0>, 1.2
                texture {tex}
               }
 
#declare nose=
        merge{
                cone {x*-1,0.3,x*-2.4,0.1}
                sphere {<-2.35,0,0>,0.1}
                pigment {color rgb<1,0.5,0>}
                normal  {bozo 0.2 turbulence 2 scale <0.1,1,1>}   
                rotate y*-90
        }



#declare face1=union{
                //eyes
                sphere {<-0.5,0.3,-1>,0.22}
                sphere {< 0.5,0.3,-1>,0.22}
                //mouth
                union{
                        sphere {<-0.65,-0.3 ,-0.88>,0.15}
                        sphere {< 0.65,-0.3 ,-0.88>,0.15}
                        sphere {<-0.35,-0.52,-0.95>,0.15}
                        sphere {< 0.35,-0.52,-0.95>,0.15}
                        sphere {< 0   ,-0.58,-1   >,0.15}
                        
                     }
                
                pigment {color rgb 0.3}
                normal {granite 0.2 scale 0.01}
                finish {phong 10}
                }
           

#declare face=union{
                //eyes
                sphere {<-0.5,0.3,-1>,0.22}
                sphere {< 0.5,0.3,-1>,0.22}
                //mouth
                
                #declare wo=70;
                #declare wy=-30;
                #declare wr=-50;
                #declare wa=wo/5;
                #declare wr2=wr/5;
                #declare coal=sphere {<0,0 ,-1.2>,0.12}
                union{
                        object {coal rotate y*-wa*2 rotate z*wr2*2}
                        object {coal rotate y*-wa rotate z*wr2}
                        object {coal rotate y*0}
                        object {coal rotate y*wa rotate z*-wr2}
                        object {coal rotate y*wa*2 rotate z*-wr2*2}
                        rotate x*wy
                        }
                
                pigment {color rgb 0.3}
                normal {granite 0.2 scale 0.01}
                finish {phong 10}
                }
      

#declare cyl=
merge{
  cylinder { 0*y,  2*y,  1.5}              
              
  
  union{
        cylinder { 0*y,  0.1*y,  2}
        torus    { 2,0.1}
        torus    { 1.4,0.1 translate y*2}
        cylinder { 2*y,  2.1*y,  1.4}
        pigment{color rgb 0.4}
        normal{crackle 0.02 turbulence 0.3 scale <2,0.01,2>}
        finish {phong 1.2 phong_size 5 brilliance 30}
        }              
              
  pigment{color rgb 0.4}
  normal{bozo 0.05 turbulence 1 scale <10,0.01,10>}
  finish {phong 1.2 phong_size 5 brilliance 30}
  //translate y*0.6
  //rotate <20,0,-4>
  scale 0.75

}



#declare head=union{
                object{three}

                object{nose}
                object{face}
                
                rotate <5,10,3>

                                    
                    }




//Snowman





#declare snowman1= 
union{
        object{base}
        object{body translate y*4.6}
        
        //left
        object{arm
                rotate z*10                             
                rotate y*045
                translate <1.4,5,0>
                }
        //right 
        object{arm 
                
                rotate z*-20
                rotate y*045                
                translate <1.4,5,0>
                scale x*-1
                }  
        
        //head
        union{
                object{head}
        
                object{
                        cyl
                        rotate <20,0,-4>
                        translate y*0.6
                        }
                 rotate x*00
                 translate y*7
                 }
                
        
        //object{message rotate <5,-1,9> translate <0,5.8,-1.9>}
        rotate y*00
        scale 0.25
     }
     
      

#declare snowman2= 
union{
        object{base}
        object{body translate y*4.6}
        
        
        //left
        object{arm
                rotate z*-10                             
                rotate y*045
                translate <1.4,5,0>
                }
        
        //right hand hat
        
        union{
                object{
                        cyl
                        rotate z*-95
                        rotate y*-10
                        translate <2.5,1.5,0>
                        }
                        
                object{arm}
                
                rotate z*10
                rotate y*10                
                translate <1.4,5,0>
                scale x*-1
                }                          
        
        //head
        union{
                object{head}
        

                 rotate x*00
                 translate y*7
                 }
                
        
        //object{message rotate <5,-1,9> translate <0,5.8,-1.9>}
        rotate y*00
        scale 0.25
     }      
     
     
     
     
#macro snowman (leftup,leftdir,rightup,rightdir,headup,headdir,mouthpos,mouthwidth,mouthround) 
#declare coal=sphere {<0,0 ,-1.2>,0.12}
union{ 
        
        object{base}
        object{two translate y*4.6}
        

        
        //left
        object{arm
                rotate z*leftup                             
                rotate y*leftdir 
                translate <1.4,5,0>
                }
        //right 
        object{arm 
                
                rotate z*rightup
                rotate y*rightdir                
                translate <1.4,5,0>
                scale x*-1
                }  
        
        //head
        union{
                //head only
                union{
                        object{three}
                        object{nose}
                        
                        union{
                                //eyes
                                sphere {<-0.5,0.3,-1>,0.22}
                                sphere {< 0.5,0.3,-1>,0.22}
                                //mouth
                
                                #declare wo=mouthwidth;
                                #declare wy=mouthpos;
                                #declare wr=mouthround;
                                #declare wa=wo/5;
                                #declare wr2=wr/5;
                                #declare coal=sphere {<0,0 ,-1.2>,0.12}
                                union{
                                        object {coal rotate y*-wa*2 rotate z*wr2*2}
                                        object {coal rotate y*-wa rotate z*wr2}
                                        object {coal rotate y*0}
                                        object {coal rotate y*wa rotate z*-wr2}
                                        object {coal rotate y*wa*2 rotate z*-wr2*2}
                                        rotate x*wy
                                        }
                
                                pigment {color rgb 0.3}
                                normal {granite 0.2 scale 0.01}
                                finish {phong 10}
                                }
                        rotate <5,10,3>
                        }
                
                //cylinder
                object{
                        cyl
                        
                        translate y*0.6
                        rotate <18,0,-4>
                        }
                 rotate x*headup
                 rotate y*headdir
                 translate y*7
                 }
        
        //object{message rotate <5,-1,9> translate <0,5.8,-1.9>}
        rotate y*00
        scale 0.25
     }
     
#end         