//  Buildings
//  build1b.inc
//  June, 1999
//  Robert J Becraft
//
//------------------------------------------------------ ROOF101 Textures
    #declare P_Roof101A = pigment { 
      bozo
      pigment_map {
        [0.00 colour rgb <0.60,0.10,0.10>]
        [0.20 colour rgb <0.40,0.05,0.00>]
        [0.80 colour rgb <0.75,0.25,0.10>]
        [1.00 colour rgb <0.60,0.10,0.10>]
      }
      scale 100
    }
 
    #declare P_Roof101B = pigment {P_Roof101A  warp { repeat x*8 offset <0,45,0> } }
    #declare P_Roof101C = pigment {P_Roof101B  warp { repeat y*3 offset <60,0,0> } }

    #declare T_Roof101 = texture {
      pigment { P_Roof101C }   //turbulence 0.075 }
      normal { granite 0.2 }
    }
#declare RoofText101=texture{T_Roof101 scale .05}
//------------------------------------------------------- ROOF102 Textures 
    #declare P_Roof102A = pigment { 
      bozo
      pigment_map {
        [0.00 colour rgb <0.20,0.10,0.10>]
        [0.30 colour rgb <0.30,0.15,0.00>]
        [0.60 colour rgb <0.45,0.25,0.10>]
        [1.00 colour rgb <0.25,0.10,0.10>]
      }
      scale 100
    }
 
    #declare P_Roof102B = pigment {P_Roof102A  warp { repeat x*8 offset <0,45,0> } }
    #declare P_Roof102C = pigment {P_Roof102B  warp { repeat y*3 offset <60,0,0> } }

    #declare T_Roof102 = texture {
      pigment { P_Roof102C }   //turbulence 0.075 }
      normal { granite 0.2 }
    }
#declare RoofText102=texture{T_Roof102 scale .05}
//------------------------------------------------------- ROOF103 Textures 
    #declare P_Roof103A = pigment { 
      bozo
      pigment_map {
        [0.00 colour  Brown]
        [0.30 colour  Tan]
        [0.60 colour  Gray80]
        [1.00 colour  Tan]
      }
      scale 100
    }
 
    #declare P_Roof103B = pigment {P_Roof103A  warp { repeat x*8 offset <0,45,0> } }
    #declare P_Roof103C = pigment {P_Roof103B  warp { repeat y*3 offset <60,0,0> } }

    #declare T_Roof103 = texture {
      pigment { P_Roof103C }   //turbulence 0.075 }
      normal { granite 0.2 }
    }
#declare RoofText103=texture{T_Roof103 scale .05}

//------------------------------------- Brick Textures
#declare BrickText101=texture{T_RedBrick scale .03125}  //texture{pigment{brick Gray10,Tan brick_size <.25,.10,.10> mortar .01}}
#declare BrickText102=texture{T_GrayBrick scale .03125} //texture{pigment{brick Gray10,Gray brick_size <.75,.35,.35> mortar .02}}
#declare BrickText103=texture{T_MixBrick scale .0625}   //texture{pigment{brick Gray10,White brick_size <1.,.15,.15> mortar .02}}
#declare BrickText104=texture{T_MixBrick scale .03125}  //texture{pigment{brick Gray10,Brown brick_size <.25,.10,.10> mortar .01}}
#declare BrickText105=texture{T_TanBrick scale .03125}  //texture{pigment{brick Gray10,Wheat brick_size <.25,.10,.10> mortar .01}}
#declare BrickText106=texture{pigment{brick Gray10,Gray50 brick_size <.75,.35,.35> mortar .02}}

#declare BlackText=texture{pigment{color Black}}

#declare WoodSide101=texture{
       gradient x
       texture_map{
         [0.0 T_Wood18]
         [0.995 BlackText]
       }
       scale .5
}


// Buildings ----------------------------------------------------
#declare Build1=union{
    box{<-5,0,-4><5,6,4> texture{BrickText101}}
    box{<-5.01,0,-4.01><5.01,3,4.01> texture{BrickText105}}
    box{<-5.1,3,-4.1><5.1,3.1,4.1> texture{BrickText105}}
    
    box{<-5.2,6,-4.2><5.2,6.3,4.2> texture{BrickText104}}
    box{<-5.2,6.5,-4.2><5.2,7,4.2> texture{BrickText101}}
    box{<-5,7,-4><5,7.5,-3.95> texture{BrickText101}}
    box{<-5,7,4><5,7.5,3.95> texture{BrickText101}}
    box{<-5,7,-4><-4.95,7.5,4> texture{BrickText101}}
    box{<4.95,7,-2><5,7.5,4> texture{BrickText101}}
    box{<-1.5,7,-1.5><1.5,7.2,1.7> texture{BrickText102}}
    
    object{Chim1b translate<-3,8,-3> texture{BrickText104}}

    object{Door1 translate<-5,0,0>}
    object{Window2 translate<-5,.4,-3>}
    object{Window2 translate<-5,.4,3>}
    object{Window2 translate<-5,3.7,-3>}
    object{Window2 translate<-5,3.7,3>}
    object{Window2 translate<-5,3.7,0>}

    object{Window1 rotate<0,90,0> translate<-3,.4,-4>}
    object{Window1 rotate<0,90,0> translate<-3,3.7,-4>}
    object{Window1 rotate<0,90,0> translate<3,3.7,-4>}

}

#declare Timber1=box{<-.1,-1.5,-.1><.1,1.5,.1> texture{pigment{color DarkBrown}}}
#declare Floor1=union{
    box{<-6,0,-4.2><5.5,3,4.2> }
    box{<-6.1,2.8,-4.3><5.6,3.1,4.3> texture{pigment{color DarkBrown}}}
    box{<-6.1,0,-4.3><5.6,0.2,4.3> texture{pigment{color DarkBrown}}}
    #declare II=-6;
    #while (II<5)
       object{Timber1 translate<II,1.5,-4.2>}
       object{Timber1 translate<II,1.5,4.2>}
       #if((II>=-4)&(II<=4))
         object{Timber1 translate<-6,1.5,II>}
         object{Timber1 translate<5.5,1.5,II>}
       #end 
       
       object{Timber1 rotate<0,0,32> translate<II+1,1.5,4.15>}
       object{Timber1 rotate<0,0,32> translate<II+1,1.5,-4.15>}
       object{Timber1 rotate<0,0,-32> translate<II+1,1.5,4.15>}
       object{Timber1 rotate<0,0,-32> translate<II+1,1.5,-4.15>}
              
       #declare II=II+2;
    #end
    object{Window2 translate<-6,0.4,-3>}  // top front windows
    object{Window2 translate<-6,0.4,-1>}
    object{Window2 translate<-6,0.4,1>}
    object{Window2 translate<-6,0.4,3>}

    object{Window2 translate<5.5,0.4,-3>}  // top back windows
    object{Window2 translate<5.5,0.4,-1>}
    object{Window2 translate<5.5,0.4,1>}
    object{Window2 translate<5.5,0.4,3>}
} 

#declare Build2=union{
    box{<-5,0,-4><5,3,4> texture{BrickText101}}
    object{Floor1 translate<0,3,0> texture{BrickText105}}
    
    object{Chim1b translate<-3,8,-3> texture{BrickText104}}

    object{Door1 translate<-5,0,0>}
    object{Window2 translate<-5,.4,-3>}
    object{Window2 translate<-5,.4,3>}
}

#declare Build3=union{               // Build2 w/ red/orange roof
   object{Build2}
   triangle{<-6,6.1,-4><-6,6.1,4><-4,10,0> texture{RoofText101}}
   triangle{<5.6,6.1,-4><5.6,6.1,4><3.6,10,0> texture{RoofText101}}
   triangle{<-6,6.1,-4><3.6,10,0><5.6,6.1,-4> texture{RoofText101 rotate<0,90,0>}}
   triangle{<-6,6.1,-4><-4,10,0><3.6,10,0> texture{RoofText101 rotate<0,90,0>}}
   triangle{<-6,6.1,4><3.6,10,0><5.6,6.1,4> texture{RoofText101 rotate<0,90,0>}}
   triangle{<-6,6.1,4><-4,10,0><3.6,10,0> texture{RoofText101 rotate<0,90,0>}}
} 

#declare Build4=union{               // Build2 w/ brown roof
   object{Build2}
   triangle{<-6,6.1,-4><-6,6.1,4><-4,10,0> texture{RoofText102}}
   triangle{<5.6,6.1,-4><5.6,6.1,4><3.6,10,0> texture{RoofText102}}
   triangle{<-6,6.1,-4><3.6,10,0><5.6,6.1,-4> texture{RoofText102 rotate<0,90,0>}}
   triangle{<-6,6.1,-4><-4,10,0><3.6,10,0> texture{RoofText102 rotate<0,90,0>}}
   triangle{<-6,6.1,4><3.6,10,0><5.6,6.1,4> texture{RoofText102 rotate<0,90,0>}}
   triangle{<-6,6.1,4><-4,10,0><3.6,10,0> texture{RoofText102 rotate<0,90,0>}}
}

#declare Build5=union{
    box{<-3.3,0,-4><5,3,4> texture{BrickText101}}

    object{Floor1 translate<0,3,0> texture{BrickText105}}

    difference{
       box{<-6,0,-4><-3,3,4>}
       box{<-5.5,-.1,-4.1><-3.5,2,4.1>}
       cylinder{<-4.5,2,-4.1><-4.5,2,4.1>1}
       #declare Count=-3;
       #while(Count<=3)
         box{<-6.1,-.1,Count-.75><-2.9,2,Count+.75>}
         cylinder{<-6.1,2,Count><-2.9,2,Count>.75}
         #declare Count=Count+2;
       #end
       
       texture{BrickText105}
     }
           
    object{Chim1b translate<-3,8,-3> texture{BrickText104}}

    object{Door1 translate<-3.3,0,-3>}
    object{Window2 translate<-3.3,.4,-1>}
    object{Window2 translate<-3.3,.4,1>}
    object{Window2 translate<-3.3,.4,3>}
        
}     

#declare Build6=union{               // Build5 w/ red/orange roof
   object{Build5}
   triangle{<-6,6.1,-4><-6,6.1,4><-4,10,0> texture{RoofText101}}
   triangle{<5.6,6.1,-4><5.6,6.1,4><3.6,10,0> texture{RoofText101}}
   triangle{<-6,6.1,-4><3.6,10,0><5.6,6.1,-4> texture{RoofText101 rotate<0,90,0>}}
   triangle{<-6,6.1,-4><-4,10,0><3.6,10,0> texture{RoofText101 rotate<0,90,0>}}
   triangle{<-6,6.1,4><3.6,10,0><5.6,6.1,4> texture{RoofText101 rotate<0,90,0>}}
   triangle{<-6,6.1,4><-4,10,0><3.6,10,0> texture{RoofText101 rotate<0,90,0>}}
} 

#declare Build7=union{               // Build5 w/ brown roof
   object{Build5}
   triangle{<-6,6.1,-4><-6,6.1,4><-4,10,0> texture{RoofText102}}
   triangle{<5.6,6.1,-4><5.6,6.1,4><3.6,10,0> texture{RoofText102}}
   triangle{<-6,6.1,-4><3.6,10,0><5.6,6.1,-4> texture{RoofText102 rotate<0,90,0>}}
   triangle{<-6,6.1,-4><-4,10,0><3.6,10,0> texture{RoofText102 rotate<0,90,0>}}
   triangle{<-6,6.1,4><3.6,10,0><5.6,6.1,4> texture{RoofText102 rotate<0,90,0>}}
   triangle{<-6,6.1,4><-4,10,0><3.6,10,0> texture{RoofText102 rotate<0,90,0>}}
}
               
              
#declare Build8=union{
    box{<-3.3,0,-4><5,3,4> texture{BrickText101}}       
    
    difference{
       box{<-6,0,-4><-3,3,4>}
       box{<-5.5,-.1,-4.1><-3.5,2,4.1>}
       cylinder{<-4.5,2,-4.1><-4.5,2,4.1>1}
       #declare Count=-3;
       #while(Count<=3)
         box{<-6.1,-.1,Count-.75><-2.9,2,Count+.75>}
         cylinder{<-6.1,2,Count><-2.9,2,Count>.75}
         #declare Count=Count+2;
       #end
       
       texture{BrickText105}
     }
    
    object{Floor1 translate<0,3,0> texture{BrickText105}}
    object{Floor1 translate<0,6,0> texture{BrickText105}}
           
    object{Chim1b translate<-3,11,-3> texture{BrickText104}}
    object{Chim2a translate<3,11,-3> texture{BrickText105}}

    object{Door1 translate<-3.3,0,-3>}
    object{Window2 translate<-3.3,.4,-1>}
    object{Window2 translate<-3.3,.4,1>}
    object{Window2 translate<-3.3,.4,3>}
        
}     
#declare Roof1=union{
   triangle{<-6,0.1,-4><-6,0.1,4><-4,4,0> }
   triangle{<5.6,0.1,-4><5.6,0.1,4><3.6,4,0> }
   triangle{<-6,0.1,-4><3.6,4,0><5.6,0.1,-4> }
   triangle{<-6,0.1,-4><-4,4,0><3.6,4,0> }
   triangle{<-6,0.1,4><3.6,4,0><5.6,0.1,4> }
   triangle{<-6,0.1,4><-4,4,0><3.6,4,0> }
}

#declare Build9=union{               // Build8 w/ red/orange roof
   object{Build8}                       
   object{Roof1 translate<0,9,0> texture{RoofText101}}
} 

#declare Build10=union{               // Build8 w/ brown roof
   object{Build8}
   object{Roof1 translate<0,9,0> texture{RoofText102}}
}

#declare Build11=union{
   box{<-5,0,-5><5,3.5,-1> texture{BrickText104}}
   box{<-5.2,3.5,-5.2><5.2,7,-.8> texture{pigment{color Wheat}}}
   
   triangle{<-5.4,7,-5.4><-5.4,7,-.6><-4,12,-3> texture{RoofText102}}
   triangle{<-5.4,7,-.6><-4,12,-3><5.4,7,-.6> texture{RoofText102}}
   triangle{<-4,12,-3><5.4,7,-.6><4,12,-3> texture{RoofText102}}
   triangle{<5.4,7,-5.4><5.4,7,-.6><-4,12,-3> texture{RoofText102}}
   triangle{<-5.4,7,-5.4><-4,12,-3><5.4,7,-5.4> texture{RoofText102}}
   triangle{<-4,12,-3><5.4,7,-5.4><4,12,-3> texture{RoofText102}}   
      
   box{<-5,0,1><5,3.5,5> texture{BrickText105}}
   box{<-5,3.5,.8><5,7,5.2> texture{WoodSide101}}
   box{<-5.2,3.5,.8><5.2,7,5.2> texture{WoodSide101 rotate<0,90,0>}}   
   
   triangle{<-5.4,7,5.4><-5.4,7,.6><-4,12,3> texture{RoofText102}}
   triangle{<-5.4,7,.6><-4,12,3><5.4,7,.6> texture{RoofText102}}
   triangle{<-4,12,3><5.4,7,.6><4,12,3> texture{RoofText102}}
   triangle{<5.4,7,5.4><5.4,7,.6><-4,12,3> texture{RoofText102}}
   triangle{<-5.4,7,5.4><-4,12,3><5.4,7,5.4> texture{RoofText102}}
   triangle{<-4,12,3><5.4,7,5.4><4,12,3> texture{RoofText102}}      
}