//======================================================
//      WINTER KAYAKING
//======================================================
//
// SWITCHES
//
#declare yakfar=1;
#declare yaknear=1;
#declare bergs=1;

#version unofficial MegaPov 0.7;

global_settings {
  post_process { soft_glow { 0.2,3 } }
  post_process { focal_blur { 19,575,22,1 } }
}

//======================================================
//      CAMERA
//======================================================

camera {
  location  <0,3,-20>
  direction z
  right     6/3*x
  look_at   <0,1.3,0>
}

//======================================================
//      LIGHTS
//======================================================

//ambient light
light_source { <0,200,-100> color rgb <0.20,0.24,0.30> }
//sun
#declare A=2.9;
light_source { <800,600,190> color rgb <3,3.3,3.4>/A }
light_source { <800,610,199> color rgb <3,3.3,3.4>/A }
light_source { <800,590,181> color rgb <3,3.3,3.4>/A }
//berglight
///*
light_source {
  //<-127,400,190>
  <-500,180,50>
  color rgb 25
  spotlight
  radius 30
  falloff 10
  tightness 20
  point_at <-100,0,200>
}
//*/

//======================================================
//      WATER
//======================================================

plane { -z,0
  texture {
    pigment {
      gradient y
      color_map { 
        [0.0 
        color rgb <1,1,1>]
        [0.460
        color rgb <0.8,0.85,0.95>]
        [0.566
        color rgb <0,0.10,0.18>]
        [1.0 
        color rgb <1,1,1>]
      }
      scale <500,1500,1500>
      translate 800*y
      turbulence 0.1
    }
    normal {
      average
      normal_map {
        [0.5 ripples 0.215 scale <1,1,1> translate <0,0,-21>]
        [0.5 ripples 0.315 scale <1,1,1> translate <-2,0,0>]
      }
      turbulence 0.75
    }
    finish {
      ambient 0.05
      reflection 0.45
    }
  }
  rotate 90*x
}

//======================================================
//      SKY
//======================================================

sky_sphere
{
  pigment
  {
    gradient y
    color_map { 
      [0.00 color rgb <1.0,1.0,1.0>]
      [0.02 color rgb <1.0,1.0,1.0>]
      [0.60 color rgb <0,0.35,0.6>]
      [1.00 color rgb <0,0.2,0.3>]
    }
    turbulence 0.05
  }
}

//======================================================
//      Icebergs
//======================================================

#if (bergs)
#declare C=0.95;
#declare bergpig = <0.80/C,0.95/C,1.05/C,0.025>;
#declare bergamb = 0.70;
#declare bergdif = 0.17;
height_field {
  tga
  "berg3.tga"
  smooth
  texture {
    pigment { color rgbf bergpig }
    finish { 
      ambient bergamb 
      diffuse bergdif
    }
  }
  translate <-0.5,0,-0.5> scale <1,0.2,1>
  scale 250
  translate <-127,-10,190>
}

height_field {
  tga
  "berg1.tga"
  smooth
  texture {
    pigment { color rgbf bergpig }
    finish { 
      ambient bergamb 
      diffuse bergdif 
    }
  }
  translate <-0.5,0,-0.5> scale <1,0.20,1>
  rotate 177*y
  scale 90
  translate <47,-2,432>
}

height_field {
  tga
  "pieces.tga"
  //smooth
  texture {
    pigment { color rgbf bergpig }
    finish { 
      ambient bergamb 
      diffuse bergdif 
    }
  }
  translate <-0.5,0,0> scale <1,0.005,1>
  scale 100
  translate <0,-0.001,-1>
}

height_field {
  tga
  "pieces.tga"
  //smooth
  texture {
    pigment { color rgbf bergpig }
    finish { 
      ambient bergamb 
      diffuse bergdif 
    }
  }
  translate <-0.5,0,0> scale <1,0.005,1>
  scale 100
  translate <-100,-0.001,9>
}

height_field {
  tga
  "pieces.tga"
  //smooth
  texture {
    pigment { color rgbf bergpig }
    finish { 
      ambient bergamb 
      diffuse bergdif 
    }
  }
  translate <-0.5,0,0> scale <1,0.005,1>
  scale 100
  translate <100,-0.001,9>
}

height_field {
  tga
  "pieces.tga"
  //smooth
  texture {
    pigment { color rgbf bergpig }
    finish { 
      ambient bergamb 
      diffuse bergdif 
    }
  }
  translate <-0.5,0,0> scale <1,0.005,1>
  scale 100
  translate <60,-0.001,109>
}
#end

//======================================================
//      KAYAKs
//======================================================

#if (yakfar | yaknear)
#include "yak_acc5.inc"
#include "yak_main3.inc"
#include "yak_main4.inc"
#include "yak_pack2.inc"
#include "yak_man2.inc"
#include "yak_oar2.inc"
#include "yak_safe2.inc"
#end

#if (yakfar)
#declare yak=
union {
  object { yak_acc scale <0.99,1,1> }
  object { yak_main }
  object { yak_pack }
  object { yak_man rotate -12*y translate z*0.13 }
  object { yak_oar rotate -12*y translate z*0.13 }
  object { yak_safe rotate -12*y translate z*0.13 }
}

object { yak
  scale 5
  rotate -120*y
  translate <-2,-0.05,0>
  texture {
    finish {
      ambient 0.2
    }
  }
}
#end

#if (yaknear)
//#include "yak2.inc"
#declare yak2=
union {
  object { yak_acc scale <0.85,1,1> translate 0.005*x }
  object { yak_main4 }
}

object { yak2
  texture {
    finish {
      reflection 0.08
      specular 0.7
      roughness 0.001
      ambient 0.20
    }
  }
  scale <7,5,5>
  rotate -177*y
  translate <0,-0.05,-21.3>
}
#end

//======================================================
//      ORCAS
//======================================================

box { 0,1
  texture {
    pigment {
      image_map {
        png "orca"
        map_type 0
        once
      }
    } 
    finish {
      reflection 0.0
      specular 0.01
      roughness 0.01
      ambient 0.65
    }
  }
  scale <11,11,1>
  rotate 13*y
  translate <45,-2.5,55>
}

box { 0,1
  texture {
    pigment {
      image_map {
        png "orca"
        map_type 0
        once
      }
    } 
    finish {
      reflection 0.0
      specular 0.01
      roughness 0.01
      ambient 0.65
    }
  }
  scale <10,10,1>
  rotate -4*z
  rotate 13*y
  translate <59,-2.5,58>
}

