#include "colors.inc"
#include "metals.inc"
#include "stars.inc"
#include "finish.inc"
#include "woods.inc"
#include "textures.inc"

global_settings {
	max_trace_level 75
	radiosity {
		media on
		normal on
		//brightness 2
	}
	ambient_light <2, 2, 2>
}

camera {
	location <0, 1.5, -8>
	look_at <0, 2, 0>
}

light_source {<-2, 5, -3> color White}

sphere {<0, 0, 0>, 400 hollow
	texture {Starfield1 scale 400}
}

#declare lt=
sphere {<0, 0, 0>, 0.025
	pigment {rgb <0, 0, 1>}
	finish {Luminous}
}

union {	
	union {
		sphere {<0, 0, 0>, 1 scale <1, 0.1, 1> texture {T_Chrome_5B}}
    	sphere {<0, 0, 0>, 0.2 scale <1.4, 0.9, 1.4>
    		clipped_by {plane {y, 0 inverse}}
    		texture {T_Chrome_5B}
    	}
    	sphere {<0, 0, 0>, 0.2 scale <1.4, 0.9, 1.4>
    		clipped_by {plane {y, 0}}
    		texture {Lightning2 scale 0.3} 
    	}
    	sphere {<0, 0, 0>, 0.19 scale <1.4, 0.9, 1.4>
    		clipped_by {plane {y, 0}}
    		pigment {rgb <0, 0, 1>}
    	}
	}
	object {lt translate <-0.985, 0, 0> rotate y*0}
	object {lt translate <-0.985, 0, 0> rotate y*30}
	object {lt translate <-0.985, 0, 0> rotate y*60}
	object {lt translate <-0.985, 0, 0> rotate y*90}
	object {lt translate <-0.985, 0, 0> rotate y*120}
	object {lt translate <-0.985, 0, 0> rotate y*150}
	object {lt translate <-0.985, 0, 0> rotate y*180}
	object {lt translate <-0.985, 0, 0> rotate y*210}
	object {lt translate <-0.985, 0, 0> rotate y*240}
	object {lt translate <-0.985, 0, 0> rotate y*270}
	object {lt translate <-0.985, 0, 0> rotate y*300}
	object {lt translate <-0.985, 0, 0> rotate y*330}
	scale 2.5
	rotate <-20, 18, -10>
	translate <1, 4.5, 0>
}

plane {y, 0
	pigment {rgb <0.2, 0.6, 0.3>}
	normal {wrinkles}
	finish {Dull}
}

#declare tree=
union {
	cylinder {<0, 0, 0>, <0, 0.5, 0>, 0.05 texture {T_Wood2}}
	sphere {<0, 0.75, 0>, 0.4
		scale <1.2, 1, 1.2>
		pigment {rgb <0, 0.5, 0>}
		normal {bumps turbulence 3 scale 0.1 bump_size 2}
		finish {Dull}
	}
	scale 2.25
}

#declare c=1;
#declare r1=seed(11);
#declare r2=seed(100);

#while (c<100)
	#declare xx=(20*rand(r1))-10;
	#declare zz=(20*rand(r2))-3; 
	object {tree translate <xx, 0, zz>}
	#declare c=c+1;
#end

