#declare image_width_factor = 2;
#declare pixelation_fac  = 6;

global_settings {assumed_gamma 2.2}

camera {
        orthographic
        location <0,0,-2>
        look_at 0
        right x*image_width
        up y*image_height
}

#declare image_width_Old = image_width*image_width_factor;
#declare image_ratio = image_width/image_height;
#declare image_height_Old = image_width_Old/image_ratio;
#declare mosaic_pixel = image_width_factor;
#declare pixels = mosaic_pixel*mosaic_pixel;
#declare whole_pixels = image_width*image_height;

#declare pig_map1 = function {pigment {image_map {png "a1"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}    //  terragen 
#declare pig_map2 = function {pigment {image_map {png "a2"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}    //  obj + land noimage +ua
#declare pig_map3 = function {pigment {image_map {png "a3"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}    //  land
#declare pig_map4 = function {pigment {image_map {png "a4"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}    //  land + obj noimage
#declare pig_map5 = function {pigment {image_map {png "a5"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}    //  mask obj

#declare rndx = seed(0);
#declare rndy = seed(1);
#declare rndz = seed(2);    

#declare pixelation = pixelation_fac/256;

#declare nx = 0;
#while (nx < image_width)
        #declare ny = 0;
        #while (ny < image_height)
                #declare color_sum = 0;
                #declare mx = 0;
                #while (mx < mosaic_pixel)                        
                        #declare my = 0;
                        #while (my < mosaic_pixel)                
                                #declare X = mx+nx*mosaic_pixel-image_width_Old*0.5+0.5;
                                #declare Y = my+ny*mosaic_pixel-image_height_Old*0.5+0.5;
                                #declare color_sum = 
                                        color_sum
                                        +(pig_map1(X,Y,0)                                       // terragen
                                        +(pig_map4(X,Y,0)-pig_map3(X,Y,0))*0.6)                 // + shadow obj on terragen render
                                        *(1-pig_map5(X,Y,0))+pig_map2(X,Y,0)*pig_map5(X,Y,0);   // + obj 
                                #declare my = my+1;
                        #end
                        #declare mx = mx+1;
                #end
                #declare pixel_col = color_sum/pixels;     
                #declare pixel_color = pixel_col;                               
                #if (pixelation_fac != 0)
                        #declare pixel_col = <pixel_color.x+(rand(rndx)-0.5)*pixelation,pixel_color.y+(rand(rndy)-0.5)*pixelation,pixel_color.z+(rand(rndz)-0.5)*pixelation*2>; 
                #end
                box {
                        0 1
                        pigment {color rgb <pixel_col.x,pixel_col.y,pixel_col.z>}
                        finish {ambient 1 diffuse 0}
                        translate <nx-image_width*0.5,ny-image_height*0.5,0>
                }
                #declare ny = ny+1;
        #end
        #declare nx = nx+1;
        #debug concat(str(nx,0,0)," columns processed \n")
#end