// ========================================
// Example 2 for the MadPipe macro
// by Gilles Tran (c) 2000
// This example is based on the pipe files used in Eve's morning
// ----------------------------------------
// Beware of the HIGH number of objects in the scene (44500)
// ----------------------------------------
#include "colors.inc" 
#include "transforms.inc"

camera {
        location <-50,2,-60>
        direction 1.5*z 
        right 4/3*x 
        look_at <0,0,0>
}

//-----------------------------------------
// Lamp
//-----------------------------------------
light_source{<-1,1,-1>*1000 color White*2.5}
//-----------------------------------------
// Texture
//-----------------------------------------
#declare colWall=color rgb<0.85,0.95,0.94>*0.6;
#declare colPipe=color rgb<0.95,0.9,0.8>*0.4;
#declare txtPipe1=texture{
        pigment{
                agate
                color_map{
                        [0 color colPipe]
                        [0.3 color colWall]
                        [1 color colWall]
                        }
                } 
        normal{agate 0.1}
        finish{diffuse 0.65 ambient 0.2}
        }

#declare txtPipe2=texture{
        pigment{
                agate
                color_map{
                        [0 color Copper*2]
                        [0.3 color Copper]
                        [1 color Bronze*2]
                        }
                } 
        normal{agate 0.1}
        finish{metallic brilliance 4 diffuse 0.65 ambient 0.2}
        }


//-----------------------------------------
// Decorations (must be declared before)
//-----------------------------------------
#declare nDeco=7;
#declare Deco=array[nDeco]
#include "pipedeco.inc"
//#include "pipedeco0.inc" // (test decorations = spheres)

//-----------------------------------------
// Pipes
//-----------------------------------------

#declare T_DEFAULT = 
texture {
	pigment {color rgb 0.5}  
}

#include "craneo_o.inc"

#declare head = object {P_SFT_mesh rotate <0,90,0>}

#declare dispobject = object {head scale 0.2}

#include "madpipe3.inc"

#declare box_hole=<0,0,0>;  // no hole = decorations everywhere
#declare dPipe=0; // 3D pipes (dPipe=1 = 2D pipes on the x-y plane)

#declare nPipe=5000;
#declare rPipe=0.06;
#declare lPipe=0.025; 
#declare container=<20,10,2>*100;  
#declare Pipe_1=object{MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,0,1,true,"wpipe_1.inc") }

#declare nPipe=6000;
#declare rPipe=0.1;
#declare lPipe=0.075; 
#declare container=<20,5,1>*100;  
#declare Pipe_3=object{MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,0,34570,true,"wpipe_3.inc") }

#declare nPipe=20000;
#declare rPipe=0.035;
#declare lPipe=0.025; 
#declare container=<20,15,2>*100;  
#declare Pipe_4=object{MadPipe(rPipe,lPipe,nPipe,dPipe,container,box_hole,2,276436,true,"wpipe_4.inc") }

//-----------------------------------------
// Pipe placement
// once the pipes are created, just include the files (no need to call the macro)
//-----------------------------------------
union{
        object{#include "WPipe_1.inc" texture{txtPipe1}}
        object{#include "WPipe_3.inc" texture{txtPipe2}}
        object{#include "WPipe_4.inc" texture{txtPipe1}}
        rotate <0,-120,0>
}

plane{z,376 texture{pigment{colWall} finish{diffuse 0.65 ambient 0}}}
