#version unofficial megapov 0.72;

#macro PageDepart(Nbx,Larg,Filename,Rigidite)

#fopen File Filename write
#local Nbz=2;
#local Dist=Larg/(Nbx-1);
#write(File,Nbx,",",Nbz,",",Dist,",",Rigidite,",\n")

#local i=0;
#while (i<Nbx)
	#write(File,i*Dist,",0,0,0,0,0,\n")
	#write(File,i*Dist,",0,",Dist,",0,0,0,\n")
	#local i=i+1;
#end
	#write(File,"0,0,0,0,\n")
	#write(File,"1,0,0,0,\n")
#fclose File

#end


/*
#declare isomoquette=off;


global_settings{
	ini_option "+QR"
	radiosity{
		count 300
		recursion_limit 1
		error_bound 0.1
		nearest_count 4
		brightness 0.9
	}
}

*/

#macro FallenBook(Larg,Long,Ep,NbPages,Haut,Loose,NbSeg)

#local st=seed(1342);
PageDepart(NbSeg,Larg,"Page0.cth",100)
#if (Loose<0) #local Loose=0;#end
#if (Loose>1) #local Loose=1;#end
#local Epf=Ep/NbPages;
#local Dist=Larg/(NbSeg-1);
#local i=0;

#local TexPage=texture{
		pigment{rgb <0.9,0.8,.6>}
		normal{granite .05 scale 0.05}
		finish{brilliance .7}
}

#while(i<NbPages/2)

	#local Env=plane{y, -Haut+(i*Epf)}

	simcloth{
		environment Env
		friction (1-pow(2*i/NbPages,0.3))
		gravity -0.5*y

		damping 0.9
		intervals 0.05
		iterations (1+Loose)*(100+150*(1-pow(2*i/NbPages,.4)))*Haut

		input "Page0.cth"
		mesh_output "Page0.msh"
		smooth_mesh on
		uv_mesh on
	}

	#local Page = mesh{
		#include "Page0.msh"
		uv_mapping
	}
	object{Page
		#if ((i+1)<NbPages/2)
			texture{TexPage}
			double_illuminate
		#else
			texture{
				pigment{image_map{tga "couv1" interpolate 2}}
				normal{granite .05 scale 0.05}
				finish{brilliance .7}
			}
		#end
		scale <1,1,Long/Dist> translate <i*Epf,0,.2*Epf*(2*rand(st)-1)>
		transform{Book_Transf}
	}
	object{Page
		#if ((i+1)<NbPages/2)
			texture{TexPage}
			double_illuminate
		#else
			texture{
				pigment{image_map{tga "couv2i" interpolate 2} scale <-1,1,1>}
				normal{granite .05 scale 0.05}
				finish{brilliance .7}
			}
		#end
		scale <-1,1,Long/Dist> translate <-i*Epf,0,.2*Epf*(2*rand(st)-1)>
		transform{Book_Transf}
	}

	#local i=i+1;
#end
	union{
		box{<-Ep/2,0,0>,<Ep/2,2*Epf,Long>}
		cylinder{0,Long*z,Epf translate -x*Ep/2+y*Epf}
		cylinder{0,Long*z,Epf translate  x*Ep/2+y*Epf}
		texture{
			pigment{image_map{tga "tranche" interpolate 2}}
			normal{bump_map{tga "tranche" interpolate 2}bump_size 2}
			translate -.5*x
			rotate x*90
			scale <Ep+2*Epf,1,Long>
		}
		transform{Book_Transf}
	}

#end



/*
#declare Book_Transf=transform{translate -.5*29.7*z rotate -y*20}

FallenBook(21,29.7,2,100,7,1,15)
*/


/*
camera{
	location <50,40,-70>
	angle 30
	look_at <0,-4,0>
}

light_source{ <-10,50,-50>, color rgb <1,1,.7>*.7
	area_light 7*x, 7*y, 5, 5
	circular orient jitter adaptive 1
} 

sky_sphere{
	pigment{rgb <.5,.6,.8>}
}


#declare Moquette = function {.15*(sin(x*.5*pi)^2) + .05*(cos(z*2.5*pi)^2)}

#if (isomoquette)

isosurface { 
	function {y + Moquette(x,y,z) }  
	threshold 0   
	contained_by {box{<-200, -1,-50>, <200, .01, 600>}}
	accuracy .001
	method 2
	eval
	pigment{rgb <.5,.6,.9>}
	scale 1
	translate y*(.2-7)
}



#else

plane{y,-7
	pigment{rgb <.5,.6,.9>}
	normal{function{Moquette(x,y,z)} .3 sine_wave}
}

#end
*/