#include "shapes.inc"
#include "shapes2.inc"
#include "glass.inc"
#include "metals.inc"
#include "colors.inc"

#local CWALL_LIGHT = color rgb <.95,.93,1>;
#local CWALL_DARK  = color rgb <0,.2,1>; 
#local F_SZYBA = finish { F_Glass8 };

#local TWALL = texture {
  pigment {
    planar
      color_map {
      [0  color CWALL_LIGHT]
      [.4 color CWALL_LIGHT]
      [.4 color CWALL_DARK ]
      [.5 color CWALL_DARK ]
      [.5 color CWALL_LIGHT]
      [.6 color CWALL_LIGHT]
      [.6 color CWALL_DARK ]    
      [.9 color CWALL_DARK ]
      [.9 color CWALL_LIGHT]
      [1  color CWALL_LIGHT] 
    } 
  }
  finish {
   ambient CWALL_LIGHT*0.14
   crand 0.05
   phong 0.5 phong_size 1
  }
}  

#local TDOOR =  texture {
  pigment { color CWALL_LIGHT }
  finish {
   ambient CWALL_LIGHT*0.14
   crand 0.05
   phong 0.5 phong_size 1
  }
  normal { bumps .08 scale .01 }
}   


#local TFLOOR = texture {
  pigment {
    cylindrical
      color_map {
      [0  color CWALL_LIGHT]
      [.4 color CWALL_LIGHT]
      [.4 color CWALL_DARK ]
      [.5 color CWALL_DARK ]
      [.5 color CWALL_LIGHT]
      [.6 color CWALL_LIGHT]
      [.6 color CWALL_DARK ]    
      [.9 color CWALL_DARK ]
      [.9 color CWALL_LIGHT]
      [1  color CWALL_LIGHT] 
    } 
   scale .5
   translate .5

  }
  finish {
   ambient CWALL_LIGHT*0.07
   crand 0.07
   phong 0.5 phong_size 1
  }  
}  

#local LEFT_WALL = union {
 box { 0, 1
  scale <.01,2.5,10>
  translate -z*4
  texture { TWALL }
 }
 text {
  ttf "verdanab.ttf" "VR LAB 3" .1, 0
  scale <.7,.7,1>
  rotate -y*90                      
  translate <.011,1,1>
  pigment { color CWALL_DARK }
 } 
}

#local RIGHT_WALL = object {
 box { 0, 1
  scale <.01,2.5,12>
  translate <8,0,-2>
  texture { TWALL }
 }
}

#local SHORT_WALL = object {
 box { 0, 1
  scale <.01,2.5,2>
  translate <6,0,6>
  texture { TWALL }
 }
}

#local ANGLE_WALL = union {
 box { 0, 1
  scale <.01,2.5,2*sqrt(2)>
  rotate y*45
  translate z*6
  texture { TWALL }
 }
}

#macro WINSHAPE ()
 prism {
  linear_sweep
  linear_spline
  -5, 5, 9
  #declare CUTOFF = CUTOFF/2;
  <0,CUTOFF>,
  <0,SIZEY-CUTOFF>,
  <CUTOFF,SIZEY>,
  <SIZEX-CUTOFF,SIZEY>,
  <SIZEX,SIZEY-CUTOFF>,
  <SIZEX,CUTOFF>,
  <SIZEX-CUTOFF,0>,
  <CUTOFF,0>,  
  <0,CUTOFF>
  rotate x*90
 }  
#end

#local FRONT_WALL = union {
 difference { 
  box { 0, 1 }
  #declare CUTOFF = .5;
  #local SIZEY = 1.5;
  #local SIZEX = 3.5;
  object { WINSHAPE() scale <.25714,.36,1> translate <.05,.9,0>}
  scale <4,2.5,.01>
  translate <2,0,8>
  texture { TWALL }
 }
#ifdef (FINAL_HQ)
 box { 0, 1
  scale <4,2.5,.009>
  translate <2,0,8.01>
  texture {
   pigment {Col_Glass_Bluish*1.1}
   finish { F_SZYBA }
  }
  interior { I_Glass_Caustics2 }
  photons {target refraction on reflection on /*collect off*/} 
 }
#end 
}


#local CORRIDOR_WALL = union {
 box { 0, 1
  scale <8,2.5,.01>
  translate z*10
  texture { TWALL }
 }
 
 text {
  ttf "verdanab.ttf" "VR LAB 1" .1, 0
  scale <.3,.3,1>
  translate <3.5,1.6,9.98>
  pigment { color CWALL_DARK }
 } 
 text {
  ttf "verdanab.ttf" "VR LAB 2" .1, 0
  scale <.3,.3,1>
  translate <3.5,1.2,9.98>
  pigment { color CWALL_DARK }
 } 
 text {
  ttf "webdings.ttf" "3" .1, 0
  scale <.4,.4,1>
  translate <3.3,1.6,9.98>
  pigment { color CWALL_DARK }
 } 
 text {
  ttf "webdings.ttf" "3" .1, 0
  scale <.4,.4,1>
  translate <3.3,1.2,9.98>
  pigment { color CWALL_DARK }
 } 

}

#macro PILE (v1,v2,r)
 sphere { v1,r }
 sphere { v2,r }
 cylinder { v1,v2,r }
#end 

#local DOOR_WALL = union {
 difference {
  box { 0, 1
   scale <2,2.5,.01>
   translate <6,0,6>
  }
  #declare CUTOFF = .5;
  #local SIZEY = 1.5;
  #local SIZEX = 1.5;
  object { WINSHAPE() scale <1.2,1,1> translate <6.1,1.95,6>}
  texture { TDOOR }
 }
#ifdef (FINAL_HQ) 
 box { 0, 1
  scale <2,2,.009>
  translate <6,0,6.01>
  texture {
   pigment {Col_Glass_Bluish*1.1}
   finish { F_SZYBA }
  }
  interior { I_Glass_Caustics2 }
  photons {target refraction on reflection on /*collect off*/ } 
 }
#end
 text {
  ttf "verdanab.ttf" "VR" .004, 0
  rotate y*180
  scale <.4,.4,1>
  translate <7.8,1.2,6.002>
  pigment { color CWALL_DARK }
 } 
 text {
  ttf "verdanab.ttf" "3" .004, 0
  rotate y*180
  scale <.6,.6,1>
  translate <6.75,1.1,6.002>
  pigment { color CWALL_DARK }
 } 
 union {
  box {0,1 scale <2,.4,.2> translate <6.01,0,5.99> }
  box {0,1 scale <2,.1,.2> translate <6.01,2,5.99> }
  box {0,1 scale <.1,2,.2> translate <7,0,5.99> }
  union { PILE(0,2.0*y,.1) translate <6,0,6> }
  union { PILE(0,2.0*y,.1) translate <7.99,0,6> }
  union { PILE(0,x*.5,.03) translate <7.2,1,5.95> }
  union { PILE(0,x*.5,.03) translate <6.3,1,5.95> }
  union { PILE(0,x*.5,.03) translate <7.2,1,6.2> }
  union { PILE(0,x*.5,.03) translate <6.3,1,6.2> }
  texture { T_Chrome_2B }
 } 
}

#declare ROOM = union {  
 box {-1000, 1000 hollow }
 #local LIGHT = <.4,.4,.41>*.75;
 plane { y,0   hollow texture { TDOOR } }
 plane { y,2.5 hollow texture { TDOOR } }
 box {0,1 texture { TFLOOR } scale <8,.00001,8> }
 
#ifdef (LIGHT_HQ)
 light_source { <7,2.45,9> color rgb LIGHT area_light x*.5,z*.3,5,3 adaptive 1 jitter fade_distance 6 fade_power 1 photons {reflection on refraction on} media_interaction off}
 light_source { <5,2.45,9> color rgb LIGHT area_light x*.5,z*.3,5,3 adaptive 1 jitter fade_distance 6 fade_power 1 photons {reflection on refraction on} media_interaction off}
 light_source { <3,2.45,9> color rgb LIGHT area_light x*.5,z*.3,5,3 adaptive 1 jitter fade_distance 6 fade_power 1 photons {reflection on refraction on} media_interaction off}
#else 
 light_source { <7,2.45,9> color rgb LIGHT jitter photons {reflection on refraction on} fade_distance 4 fade_power 1 /*looks_like {sphere {0,.1}}*/  media_interaction off}
 light_source { <5,2.45,9> color rgb LIGHT jitter photons {reflection on refraction on} fade_distance 4 fade_power 1 /*looks_like {sphere {0,.1}}*/  media_interaction off}
 light_source { <3,2.45,9> color rgb LIGHT jitter photons {reflection on refraction on} fade_distance 4 fade_power 1 /*looks_like {sphere {0,.1}}*/  media_interaction off}
#end 

 LEFT_WALL
 RIGHT_WALL
 SHORT_WALL
 object { SHORT_WALL scale <5,1,1> translate -x*.05 }
 ANGLE_WALL 
 FRONT_WALL
 DOOR_WALL
 CORRIDOR_WALL
}

