//ImageA40.pov for POV-Ray Megapatch 0.7: Little Green Man's Dream   (c) 2002 Ch. Gerber

#version unofficial MegaPov 0.7;

global_settings {assumed_gamma 2.6}

#include "mytextures.inc"

#declare Stars_on = 1;
#declare Figures_on = 1;
#declare Rocks_on = 1;
#declare Shrooms_on = 1;
#declare UFOs_on = 1;
#declare HQ = 1;

camera {
   location <0,11,-37.5>
   direction 1.2*z
   right 3/4*x
   look_at <0,16,0>
}   


//--- background stars, nebula and galaxy --- 

#if (Stars_on = 1)

// COMMON GALAXY OPTIONS 
#declare galaxy_colour1 = <1.4,1.3,0.9>; 
#declare galaxy_colour2 = <1.1,0.6,0.3>; 
#declare galaxy_rotate = <-15,0,0>; 

// GALAXY BACKGROUND 
#declare galaxy_bgstars = 2; 
#declare galaxy_bgnebula = 1; 
#declare galaxy_nebula_sphere = 5; 
#include "GALAXY.BG" 

// GALAXY OBJECTS 
#declare galaxy_object_name = "Nebula3" 
#declare galaxy_cluster_name = "Star4" 
#include "GALAXY.OBJ" 
#declare galaxy_object_name = "Comet2" 
#declare galaxy_cluster_name = "" 
#include "GALAXY.OBJ"

#declare galaxy_color1 = <1.1, 1.1, 1.1>;
#declare galaxy_color2 = <0.3, 0.6, 1>;
#declare galaxy_object_name = "Star4"
#declare S = seed(187653);
#declare C = 0;
#while (C < 30)
    #declare galaxy_object_scale = 0.4*rand(S)*<1, 1, 1>;
    #declare galaxy_object_position = <20-35*rand(S), -20+60*rand(S), 0>;
    #include "GALAXY.OBJ"
    #declare C = C + 1;
#end 

#declare star_count = 20000;
#declare star_type = 1;
#declare star_scale = 0.5;
#declare star_distribution = 0.25;
#declare star_color = color rgb 1.1;
#declare star_color_turb = 0.75;
#include "galaxy.sf"

#end //Stars_on


//--- light sources ---

light_source {
   15000*z
   color rgb <0.26, 0.24, 0.18>
   rotate <-15,0,0>
   #if (HQ=1)
    area_light <3000,0,0>,<0,3000,0>,5,5
    adaptive 1
    jitter
    orient
   #end 
} 

light_source {
   -10000*z 
   color rgb <1.4,1.3,1.2> 
   rotate <45,-30,0>
   #if (HQ=1)
    area_light <500,0,0>,<0,500,0>,5,5
    adaptive 1
    jitter
    orient
   #end
}


//--- main rock or asteroid ---

#include "flatrock.inc"

#declare Asteroid = object {
   FlatRock
   scale <8,8,20>  
   translate -7*x
   texture {RockTex scale 0.5}
}

object {Asteroid}


//--- figures ---

#if (Figures_on = 1)

#include "sexy.inc"
#include "gremlin.inc"
#include "gremlinrock.inc"

object {
   Sexy
   scale <-20,20,20>
   translate <0.5,7,-13>
}

#declare obj_pos = <-20*cigarette_tip.x,20*cigarette_tip.y,20*cigarette_tip.z> + <0.5,7,-13>;
#include "smokeparams.inc" 
#include "smokegen.inc" 

union {
   object {Gremlin}
   object {GremlinRock}
   scale <-10,10,10>
   rotate 30*y
   translate <-4,7,-15>
}

#end //Figures_on 


//--- big and small rocks ---

#if(Rocks_on = 1)

#declare VegeObject = object {Asteroid}
#declare SmallStone1 = object {#declare Seed = 222; #declare Splits = 3; #declare Rough = 0.2; #include "rock.inc" scale 0.075 translate 0.75/2*y texture {RockTex scale 0.5}} 
#declare SmallStone2 = object {#declare Seed = 444; #declare Splits = 3; #declare Rough = 0.2; #include "rock.inc" scale 0.050 translate 0.50/2*y texture {RockTex scale 0.5}} 
#declare SmallStone3 = object {#declare Seed = 666; #declare Splits = 3; #declare Rough = 0.2; #include "rock.inc" scale 0.025 translate 0.25/2*y texture {RockTex scale 0.5}} 
#declare Rock1 = mesh {#include "rock_mesh_1.inc"}
#declare Rock2 = mesh {#include "rock_mesh_2.inc"}

union {
  object {VegeObject}
  #declare VegeList = array[6] 
  #declare VegeList[0] = object {SmallStone1} 
  #declare VegeList[1] = object {SmallStone2} 
  #declare VegeList[2] = object {SmallStone3}
  #declare VegeList[3] = object {SmallStone3}
  #declare VegeList[4] = object {SmallStone2}
  #declare VegeList[5] = object {SmallStone1}   
  #declare VegeTypesGauss = 1;
  #declare VegeSeed = seed(1291);
  #declare VegeNumber = 50;
  #declare VegeWaterLevel =  2;
  #declare VegeTimberLine = 10;
  #declare VegeMaxSlope = 15;
  #declare VegeMaxScale = 1.1; 
  #declare VegeMinScale = 0.9;
  union {#include "vegetate.inc"}
}

object {Rock1 scale 4 texture {RockTex} rotate -30*y translate <2.3,7.8,15>}
object {Rock2 scale 8 texture {RockTex} rotate -30*y translate <-10,9.0,5>}
object {SmallStone2 translate <-5,6.8,-18.5>}

#end //Rocks_on


//--- mushrooms ---     

#if (Shrooms_on = 1)

#include "shrooms1.inc"
#include "shrooms2.inc"

object {Mushrooms1 scale 0.15 translate <-3,6.6,0>}
object {Mushrooms2 scale 1.05 rotate  60*y translate <-4.2,6.8,-17.5>}
object {Mushrooms2 scale 1.25 rotate 180*y translate <-1,6.7,-5>}

#end //Shrooms_on


//--- UFOs ---

#if (UFOs_on = 1)

#include "ufo.inc"

object {UFO scale 11 rotate < -90,0,-15> translate < -5, 20,250>}
object {UFO scale 10 rotate < -90,0,  5> translate < 85,100,500>}
object {UFO scale 10 rotate <-100,0, 15> translate <120,-30,450>}

#end //UFOs_on
