#declare m = 100;
#declare cm = 1;
#declare mm = 0.1;
/*
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <2*m, 2*m, -2*m>
}  

// perspective (default) camera
camera {
  location  <2*m, 1.5*m, -1.5*m>
  look_at   <50*cm, 50*cm,  0.0>
  right     x*image_width/image_height
} 

#include "colors.inc"
#include "shapes.inc" 
#include "finish.inc"
#include "textures.inc"
//background{White}
   */
    
#local leg =
difference {
    cylinder {<0,-5*mm,0> <0,5*mm,0> 53/2*cm}
    cylinder {<0,-6*mm,0> <0,6*mm,0> 52/2*cm}
    Wedge(-90)
    translate -53/2*cm*z
    translate 53/4*cm*x
    rotate 90*x   
    scale <1,1.5,1>  
    pigment{Sienna}
}   

#declare leg_pair = 
union {
    object{leg}
    object{leg rotate 180*y translate 1*cm*z} 
}

//table is 1.5*53/2*cm = 39.75*cm tall
#declare bed_side_table =
union{
    #local N = 6;
    #local i = 0;
        #while(i<=N)
        object{leg_pair translate i*3*cm*z}
        #local i=i+1;
    #end

    cylinder{<0,0,0> <0,0,21> 1*mm pigment{NavyBlue} translate <-53/4*cm,1.5*53/2*cm,0>}
    cylinder{<0,0,0> <0,0,21> 1*mm pigment{NavyBlue} translate < 53/4*cm,1.5*53/2*cm,0>}

    box{<-2*cm,0,-2*cm> <(53/2+2)*cm,5*mm,21*cm+2*cm> pigment{Silver filter 0.5} interior{ior 1.5} finish{Glossy} translate <-53/4*cm,(1.5*53/2*cm+1*mm),0>}
}//end bed side table union
//##################################################################

#local bed_leg =
box{<0,0,0> <3*cm,30*cm,3*cm>  }

#declare bed_base =
union {
    object{bed_leg}
    box{<0,0,0> <163*cm,15*cm,1.5*cm> translate <1.5*cm,13*cm,1.5*cm>}
    object{bed_leg translate <1.5*cm+163*cm,0,0> }
    box{<0,0,0> <1.5*cm,15*cm,215*cm>  translate <1.5*cm,13*cm,1.5*cm>}
    object{bed_leg translate <0,0,215*cm+1.5*cm> }
    box{<0,0,0> <163*cm,15*cm,1.5*cm>  translate <1.5*cm,13*cm,1.5*cm+215*cm>}
    object{bed_leg translate <1.5*cm+163*cm,0,215*cm+1.5*cm> }
    box{<0,0,0> <1.5*cm,15*cm,215*cm> translate <163*cm+1.5*cm,13*cm,1.5*cm>} 
    pigment{Sienna}
    normal {agate}
}   

#local bed_head_slat =
difference {
    cylinder {<0,-1*cm,0> <0,1*cm,0> 50*cm}
    cylinder {<0,-1.1*cm,0> <0,1.1*cm,0> 49*cm}
    Wedge(-90)
    translate 50*cm*x 
    rotate -90*x
    rotate -90*y
    scale <1,2,0.5>    
    pigment{Sienna} 
    normal{agate}
}

#declare bed_head = 
union{
    #declare N=40;
    #local i=0;
    #while(i<=N)
        object{bed_head_slat translate 4*cm*x*i}
        #local i=i+1;
    #end
}

#declare do_sleepy = true;
#if(do_sleepy)
#include "woman_sleep.inc"
#include "woman_sleep_hair.inc"
#declare woman_sleep_temp =
union {
    object{woman_sleep}  
    object{woman_sleep_hair} 
}
#declare MIN = min_extent(woman_sleep_temp);
#declare MAX = max_extent(woman_sleep_temp);
#declare Woman_sleep = object {woman_sleep_temp scale 140*cm/(MAX.z-MIN.z)}
#undef woman_sleep_temp
#undef woman_sleep
#undef woman_sleep_hair
#end 
#declare Bed = 
union{
    object{Round_Box(<0,0,0>,<158,12,210>,1*cm,no) translate <4*cm,25*cm,4*cm> pigment{White} }
    object{bed_head translate (215*cm+3*cm)*z translate 3*cm*x}
    object{bed_base}
    #if(do_sleepy)object{Woman_sleep rotate 30*y translate <105*cm,37*cm,135*cm>} #end
    superellipsoid {<1, 0.5>  scale <2,0.33,1> scale 17 rotate -10*y pigment{White} translate <45*cm,42*cm,194*cm>} 
    superellipsoid {<1, 0.5>  scale <2,0.33,1> scale 17 pigment{White} translate <125*cm,42*cm,195*cm>}

}//end bed union

//##################################################################
#macro Lamp(L)
union {
#local obj1 =
difference {
    sphere {<0,0,0> 0.5 scale <2,0.5,2> }
    box {-1,<1,0,1>} 
} 

object {obj1 pigment{Silver} finish {Shiny reflection 0.5}}

difference {
    cylinder {<0,0,0> <0,4,0> 0.1  }
    cylinder {<0,0,0> <0,0.5,0> 0.2 translate 3*y} 
    pigment{Silver}finish{Shiny reflection 0.5} 
}

difference{  
    object {obj1 }  
    object {obj1 translate -0.05*y}
    scale <1.5,2,1> translate 3.25*y 
    pigment {Silver filter 0.5}
    interior {ior 1.5} 
} 
#if(L) light_source {<0,3.25,0> colour White}#end
}  
#end
//##################################################################


//object{Bed}

//plane {y,0 pigment{Wheat } } 



