/*
// perspective (default) camera
camera {
  location  <0.0, 2.0, -5.0>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
}
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 40, -20>
}
#include "colors.inc"
   
 
background {SummerSky}
  */

//texture is 'stolen' from Gilles Tran's example files for the MakeGrass macro  
  
#declare Blanc1=rgb<0.90,0.81,0.81>;

#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
#declare Green1=rgb<0.4,1,0.3>*0.4;
#declare Green2=rgb<60,160,8>/255;

// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}

#declare txtGrass=texture {                  

                pigment {
                        gradient y
                        turbulence 0.2
                                pigment_map {                                
                                    [0.0 pigEarth]
                                    [0.3 pigGreen]
                                    [0.9 pigSpotted]
                                    [1.00 pigEarth]
                                }
                        }

        finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
        scale <0.001,1,0.001>
 
} 
#declare objectPatch=#include "fgrass2.inc"

#declare Grass =
union{ 
    difference {
        union {
            object {objectPatch }
            object {objectPatch rotate 90*y}
            object {objectPatch rotate 180*y} 
            object {objectPatch rotate 270*y}     
            texture {txtGrass finish{ambient 0.33}}
            translate <1.5,0,1.5>
        }//end union
        box{<0,0,0> <4,1,-1>}
        box{<0,0,0> <4,1,-1> rotate -90*y translate 3*x}
    } //end diff
    box {<0,0,0> <3,-0.01,3> pigment{Tan} } 
}//end Grass union   